/*
 * Decompiled with CFR 0.152.
 */
package com.pcr.pcr360.crystal;

import com.crystaldecisions.sdk.occa.report.application.DatabaseController;
import com.crystaldecisions.sdk.occa.report.application.ISubreportClientDocument;
import com.crystaldecisions.sdk.occa.report.application.ParameterFieldController;
import com.crystaldecisions.sdk.occa.report.application.ReportClientDocument;
import com.crystaldecisions.sdk.occa.report.data.ConnectionInfoKind;
import com.crystaldecisions.sdk.occa.report.data.Fields;
import com.crystaldecisions.sdk.occa.report.data.IConnectionInfo;
import com.crystaldecisions.sdk.occa.report.data.IParameterField;
import com.crystaldecisions.sdk.occa.report.data.IParameterFieldDiscreteValue;
import com.crystaldecisions.sdk.occa.report.data.ITable;
import com.crystaldecisions.sdk.occa.report.data.ParameterField;
import com.crystaldecisions.sdk.occa.report.data.ParameterFieldValue;
import com.crystaldecisions.sdk.occa.report.data.Tables;
import com.crystaldecisions.sdk.occa.report.data.Values;
import com.crystaldecisions.sdk.occa.report.document.IReportOptions;
import com.crystaldecisions.sdk.occa.report.document.ISummaryInfo;
import com.crystaldecisions.sdk.occa.report.exportoptions.CharacterSeparatedValuesExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.ExportOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.ICharacterSeparatedValuesExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.PDFExportFormatOptions;
import com.crystaldecisions.sdk.occa.report.exportoptions.ReportExportFormat;
import com.crystaldecisions.sdk.occa.report.lib.IStrings;
import com.crystaldecisions.sdk.occa.report.lib.PropertyBag;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class Crystal {
    public static void main(String[] args) {
        int i = 0;
        boolean debug = false;
        String rpt = "";
        String out = "";
        String fmt = "";
        String cmd = "";
        JSONObject params = new JSONObject();
        JSONObject db = new JSONObject();
        block34: while (i < args.length && args[i].startsWith("-")) {
            String arg;
            switch (arg = args[i++]) {
                case "-debug": 
                case "-d": {
                    debug = true;
                    break;
                }
                case "-rpt": {
                    if (i < args.length) {
                        rpt = args[i++];
                        break;
                    }
                    System.err.println("-rpt requires a filename");
                    break;
                }
                case "-out": {
                    if (i < args.length) {
                        out = args[i++];
                        break;
                    }
                    System.err.println("-out requires a filename");
                    break;
                }
                case "-fmt": {
                    if (i < args.length) {
                        fmt = args[i++];
                        HashSet<String> fmtOptions = new HashSet<String>(Arrays.asList("PDF", "MSWord", "MSExcel", "RTF", "text", "characterSeparatedValues", "tabSeparatedText", "XML", "crystalReports"));
                        if (fmtOptions.contains(fmt)) continue block34;
                        System.err.println("-fmt requires a valid format option [PDF,MSWord,MSExcel,RTF,text,characterSeparatedValues,tabSeparatedText,XML,crystalReports]");
                        break;
                    }
                    System.err.println("-fmt requires a valid format option [PDF,MSWord,MSExcel,RTF,text,characterSeparatedValues,tabSeparatedText,XML,crystalReports]");
                    break;
                }
                case "-p": 
                case "-params": {
                    if (i >= args.length) break;
                    try {
                        params = new JSONObject(args[i++]);
                    }
                    catch (JSONException ex) {
                        System.err.println("-params is not a valid JSON String");
                        System.err.println(ex);
                    }
                    break;
                }
                case "-db": {
                    if (i >= args.length) break;
                    try {
                        db = new JSONObject(args[i++]);
                    }
                    catch (JSONException ex) {
                        System.err.println("-db is not a valid JSON String");
                        System.err.println(ex);
                    }
                    break;
                }
                case "-getInfoAndParameters": {
                    cmd = "getInfoAndParameters";
                    break;
                }
                case "-convert": {
                    cmd = "convert";
                }
            }
        }
        if (i == args.length) {
            System.err.println("Usage: [-d|-debug] [-convert|-getInfoAndParameters] [-rpt report-file] [-fmt outputFormatType] [-out output-file] [-p|-params JSONParamString] [[-db JSONDatabaseString]]");
        }
        if (rpt.equals("")) {
            System.err.println("Report file not parameter not recognized");
        } else {
            ReportClientDocument report = Crystal.openReport(rpt);
            switch (cmd) {
                case "getInfoAndParameters": {
                    Crystal.getInfoAndParameters(report);
                    break;
                }
                case "convert": {
                    Crystal.convert(report, fmt, out, params, db);
                    break;
                }
                default: {
                    System.err.println("Command not recognized");
                }
            }
        }
    }

    private static ReportClientDocument openReport(String reportPath) {
        ReportClientDocument reportClientDoc = new ReportClientDocument();
        try {
            reportClientDoc.open((Object)reportPath, 524288);
        }
        catch (ReportSDKException ex) {
            System.out.println((Object)ex);
            ex.printStackTrace(System.out);
        }
        return reportClientDoc;
    }

    private static void getInfoAndParameters(ReportClientDocument report) {
        try {
            JSONObject json = new JSONObject();
            ISummaryInfo info = report.getReportDocument().getSummaryInfo();
            json.put("author", info.getAuthor());
            json.put("comments", info.getComments());
            json.put("subject", info.getSubject());
            json.put("title", info.getTitle());
            IReportOptions opts = report.getReportDocument().getReportOptions();
            json.put("savedWithData", opts.getEnableSaveDataWithReport());
            Fields flds = report.getDataDefController().getDataDefinition().getParameterFields();
            JSONObject[] params = new JSONObject[flds.size()];
            Iterator paramIter = flds.iterator();
            int i = 0;
            while (paramIter.hasNext()) {
                JSONObject param = new JSONObject();
                ParameterField fld = (ParameterField)paramIter.next();
                param.put("name", fld.getName());
                param.put("description", fld.getDescription());
                param.put("type", fld.getType().toString().replace("xsd:", ""));
                param.put("length", fld.getLength());
                param.put("allowMultiValue", fld.getAllowMultiValue());
                param.put("isOptionalPrompt", fld.getIsOptionalPrompt());
                param.put("editMask", fld.getEditMask());
                IParameterFieldDiscreteValue maxValue = fld.getMaximumValue();
                IParameterFieldDiscreteValue minValue = fld.getMinimumValue();
                SimpleDateFormat dtf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                switch (param.getString("type")) {
                    case "date": 
                    case "dateTime": {
                        param.put("maximumValue", maxValue == null ? null : dtf.format(maxValue.getValue()));
                        param.put("minimumValue", minValue == null ? null : dtf.format(minValue.getValue()));
                        break;
                    }
                    default: {
                        param.put("maximumValue", maxValue == null ? null : maxValue.getValue());
                        param.put("minimumValue", minValue == null ? null : minValue.getValue());
                    }
                }
                Values vals = fld.getDefaultValues();
                if (vals.size() > 0) {
                    JSONObject dvals = new JSONObject();
                    for (ParameterFieldValue v : vals) {
                        dvals.put(v.displayText(Locale.ENGLISH), v.getDescription());
                    }
                    param.put("values", dvals);
                }
                params[i++] = param;
            }
            json.put("parameters", params);
            System.out.println(json.toString());
        }
        catch (ReportSDKException | JSONException ex) {
            System.out.println(ex);
            ex.printStackTrace(System.out);
        }
    }

    private static void convert(ReportClientDocument report, String format, String outFile, JSONObject params, JSONObject db) {
        Object jsonParam = null;
        IParameterField fld = null;
        try {
            ByteArrayInputStream byteArrayInputStream;
            if (db.length() == 0) {
                report.getDatabaseController().removeConnection(null);
            } else {
                Crystal.switchTables(report.getDatabaseController(), db);
                IStrings subreportNames = report.getSubreportController().getSubreportNames();
                for (int i = 0; i < subreportNames.size(); ++i) {
                    ISubreportClientDocument subreportClientDoc = report.getSubreportController().getSubreport(subreportNames.getString(i));
                    Crystal.switchTables(subreportClientDoc.getDatabaseController(), db);
                }
            }
            if (params.length() > 0) {
                Fields flds = report.getDataDefinition().getParameterFields();
                SimpleDateFormat df = new SimpleDateFormat("MM/dd/yyyy");
                Object dtf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                SimpleDateFormat tf = new SimpleDateFormat("HH:mm:ss");
                ParameterFieldController paramFieldController = report.getDataDefController().getParameterFieldController();
                for (int i = 0; i < flds.size(); ++i) {
                    fld = (IParameterField)flds.getField(i);
                    String fldName = fld.getName();
                    if (params.has(fldName)) {
                        String fldType;
                        jsonParam = params.get(fldName);
                        switch (fldType = fld.getType().toString().replace("xsd:", "")) {
                            case "date": 
                            case "dateTime": 
                            case "time": {
                                if (jsonParam == JSONObject.NULL) {
                                    throw new Exception("NULL not permitted for Date/Time Parameter [" + fldName + "]");
                                }
                                paramFieldController.setCurrentValue("", fldName, (Object)((DateFormat)(fldType.equals("dateTime") ? dtf : (fldType.equals("date") ? df : tf))).parse(jsonParam.toString()));
                                break;
                            }
                            default: {
                                paramFieldController.setCurrentValue("", fldName, jsonParam);
                                break;
                            }
                        }
                        continue;
                    }
                    if (fld.getAllowNullValue()) {
                        paramFieldController.setCurrentValue("", fldName, null);
                        continue;
                    }
                    if (fld.getIsOptionalPrompt()) continue;
                    throw new Exception("Required parameter [" + fldName + "] is missing from submitted data.");
                }
            }
            fld = null;
            jsonParam = null;
            ExportOptions exportOptions = new ExportOptions();
            switch (format) {
                case "crystalReports": {
                    byteArrayInputStream = (ByteArrayInputStream)report.getPrintOutputController().export(ReportExportFormat.crystalReports);
                    break;
                }
                case "characterSeparatedValues": {
                    CharacterSeparatedValuesExportFormatOptions csvOptions = new CharacterSeparatedValuesExportFormatOptions();
                    csvOptions.setSeparator(",");
                    csvOptions.setDelimiter("\"");
                    csvOptions.setGroupSectionsOption(ICharacterSeparatedValuesExportFormatOptions.ExportSectionsOption.exportIsolated);
                    csvOptions.setReportSectionsOption(ICharacterSeparatedValuesExportFormatOptions.ExportSectionsOption.exportIsolated);
                    report.setSavedExportOptions(ReportExportFormat.characterSeparatedValues, (Object)csvOptions);
                    exportOptions.setExportFormatType(ReportExportFormat.characterSeparatedValues);
                    byteArrayInputStream = (ByteArrayInputStream)report.getPrintOutputController().export(ReportExportFormat.characterSeparatedValues);
                    break;
                }
                default: {
                    ReportExportFormat exportFormat = ReportExportFormat.from_string((String)format);
                    exportOptions.setExportFormatType(exportFormat);
                    if (format.equals("PDF")) {
                        PDFExportFormatOptions pdfOptions = new PDFExportFormatOptions();
                        pdfOptions.setCreateBookmarksFromGroupTree(true);
                        report.setSavedExportOptions(ReportExportFormat.PDF, (Object)pdfOptions);
                    }
                    byteArrayInputStream = (ByteArrayInputStream)report.getPrintOutputController().export(exportFormat);
                }
            }
            String exportOutput = outFile;
            Crystal.writeToFileSystem(byteArrayInputStream, exportOutput);
            report.close();
        }
        catch (Exception ex) {
            System.err.println("\nfld = " + (fld == null ? "null" : fld.getName() + " :: " + fld.getType()) + " / jsonParam = " + (jsonParam == null ? "null" : jsonParam.toString()) + "\n");
            ex.printStackTrace(System.out);
        }
    }

    private static void writeToFileSystem(ByteArrayInputStream byteArrayInputStream, String exportFile) throws Exception {
        byte[] byteArray = new byte[byteArrayInputStream.available()];
        File file = new File(exportFile);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);
             ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byteArrayInputStream.available());){
            int x = byteArrayInputStream.read(byteArray, 0, byteArrayInputStream.available());
            byteArrayOutputStream.write(byteArray, 0, x);
            byteArrayOutputStream.writeTo(fileOutputStream);
            byteArrayInputStream.close();
        }
    }

    private static void switchTables(DatabaseController databaseController, JSONObject params) throws ReportSDKException {
        String CONNECTION_STRING;
        String DBURI;
        String DATABASE_CLASS_NAME;
        String TABLE_NAME_QUALIFIER = "";
        String DATASOURCE_NAME = "";
        String HOSTNAME = params.getString("host");
        String PORT = params.getString("port");
        String DBUSERNAME = params.getString("username");
        String DBPASSWORD = params.getString("password");
        String SERVER_TYPE = "JDBC (JNDI)";
        String DATABASE_DLL = "crdb_jdbc.dll";
        switch (params.getString("type")) {
            case "mysql": {
                String DBNAME = params.getString("dbname");
                DATABASE_CLASS_NAME = "com.mysql.jdbc.Driver";
                DBURI = "!com.mysql.jdbc.Driver!jdbc:mysql://" + HOSTNAME + ":" + PORT + "/" + DBNAME + "!ServerType=29!QuoteChar=`";
                CONNECTION_STRING = "Use JDBC=b(true);Connection URL=s(" + DBURI + ");Database Class Name=s(" + DATABASE_CLASS_NAME + ");Server=s(" + HOSTNAME + ");User ID=s(" + DBUSERNAME + ");Password=;Trusted_Connection=b(false);JDBC Connection String=s(" + DBURI + ")";
                break;
            }
            default: {
                TABLE_NAME_QUALIFIER = params.getString("schema") + ".";
                DATASOURCE_NAME = params.getString("dsn");
                CONNECTION_STRING = "Use JDBC=b(true);Connection URL=s(jdbc:oracle:thin:@" + HOSTNAME + ":" + PORT + ":" + DATASOURCE_NAME + ");Database Class Name=s(oracle.jdbc.driver.OracleDriver);Server=s(" + HOSTNAME + ");User ID=s(" + DBUSERNAME + ");Password=;Trusted_Connection=b(false);JDBC Connection String=s(!oracle.jdbc.driver.OracleDriver!jdbc:oracle:thin:{userid}/{password}@" + HOSTNAME + ":" + PORT + ":" + DATASOURCE_NAME + ")";
                DATABASE_CLASS_NAME = "oracle.jdbc.driver.OracleDriver";
                DBURI = "!oracle.jdbc.driver.OracleDriver!jdbc:oracle:thin:{userid}/{password}@" + HOSTNAME + ":" + PORT + ":" + DATASOURCE_NAME;
            }
        }
        Tables tables = databaseController.getDatabase().getTables();
        for (int i = 0; i < tables.size(); ++i) {
            ITable table = tables.getTable(i);
            table.setName(table.getName());
            table.setAlias(table.getAlias());
            table.setQualifiedName(TABLE_NAME_QUALIFIER + table.getName());
            IConnectionInfo connectionInfo = table.getConnectionInfo();
            PropertyBag innerProp = connectionInfo.getAttributes();
            innerProp.clear();
            PropertyBag propertyBag = new PropertyBag();
            propertyBag.put((Object)"Trusted_Connection", (Object)"b(false)");
            propertyBag.put((Object)"Server Name", (Object)HOSTNAME);
            propertyBag.put((Object)"Connection String", (Object)CONNECTION_STRING);
            propertyBag.put((Object)"Server Type", (Object)SERVER_TYPE);
            propertyBag.put((Object)"JNDI Datasource Name", (Object)DATASOURCE_NAME);
            propertyBag.put((Object)"Database Class Name", (Object)DATABASE_CLASS_NAME);
            propertyBag.put((Object)"Use JDBC", (Object)"true");
            propertyBag.put((Object)"URI", (Object)DBURI);
            propertyBag.put((Object)"Database DLL", (Object)DATABASE_DLL);
            connectionInfo.setAttributes(propertyBag);
            connectionInfo.setUserName(DBUSERNAME);
            connectionInfo.setPassword(DBPASSWORD);
            connectionInfo.setKind(ConnectionInfoKind.SQL);
            table.setConnectionInfo(connectionInfo);
            databaseController.setTableLocation(table, tables.getTable(i));
        }
    }
}

