/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.sdk.occa.report.data;

import com.crystaldecisions12.client.helper.XMLSerializationHelper;
import com.crystaldecisions12.sdk.occa.report.data.ADOXMLData;
import com.crystaldecisions12.sdk.occa.report.data.ADOXMLElementType;
import com.crystaldecisions12.sdk.occa.report.data.ADOXMLRow;
import com.crystaldecisions12.sdk.occa.report.data.ADOXMLSchema;
import com.crystaldecisions12.sdk.occa.report.data.ADOXMLSerializableBase;
import com.crystaldecisions12.sdk.occa.report.data.IADOXMLSerializable;
import com.crystaldecisions12.sdk.occa.report.lib.ByteArray;
import com.crystaldecisions12.xml.serialization.XMLConverter;
import com.crystaldecisions12.xml.serialization.XMLSerializationContext;
import com.crystaldecisions12.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.TimeZone;
import org.xml.sax.Attributes;

final class ADOXMLSerializationHelper
extends ADOXMLSerializableBase {
    private ADOXMLSchema Cw = null;
    private ADOXMLData Cy = null;
    private static final String Cx = "ID";
    private static final String Cz = "RowsetSchema";
    private TimeZone Cv = null;

    public ADOXMLSerializationHelper(String string) {
        if (string != null) {
            this.Cv = TimeZone.getTimeZone(string);
        }
    }

    public String columnName(int n2) {
        if (this.Cw == null) {
            throw new NullPointerException();
        }
        return this.Cw.columnName(n2);
    }

    public String columnType(int n2) {
        if (this.Cw == null) {
            throw new NullPointerException();
        }
        return this.Cw.columnType(n2);
    }

    public static Object createADOXMLObject(String string, IADOXMLSerializable iADOXMLSerializable) {
        Object var2_2 = null;
        String string2 = null;
        string2 = XMLConverter.getClassNameFromXML(string);
        if (string2 != null) {
            try {
                Class<?> clazz = Class.forName(string2);
                var2_2 = clazz.newInstance();
                if (var2_2 != null && var2_2 instanceof IADOXMLSerializable) {
                    ((IADOXMLSerializable)var2_2).setHelper(iADOXMLSerializable);
                }
            }
            catch (MissingResourceException missingResourceException) {
                System.out.println(missingResourceException);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.out.println(classNotFoundException);
            }
        }
        return var2_2;
    }

    public Object createMember(String string, Attributes attributes, XMLSerializationContext xMLSerializationContext, Map map, boolean[] blArray) {
        Object object = null;
        if (ADOXMLSerializationHelper.J(string) && (object = ADOXMLSerializationHelper.createADOXMLObject(string, this)) != null) {
            if (string.equals("Schema")) {
                this.Cw = (ADOXMLSchema)object;
            } else if (string.equals("data")) {
                this.Cy = (ADOXMLData)object;
            }
        }
        return object;
    }

    public void endElement(String string, Map map) {
        if (!ADOXMLSerializationHelper.J(string) && string != null && string.length() > 0) {
            if (this.Cw != null) {
                this.Cw.endElement(string, map);
            }
            if (this.Cy != null) {
                this.Cy.endElement(string, map);
            }
        }
    }

    public static String formatDateTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setTimeZone(TimeZone.getDefault());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(calendar.get(1));
        stringBuilder.append('-');
        stringBuilder.append(calendar.get(2) + 1);
        stringBuilder.append('-');
        stringBuilder.append(calendar.get(5));
        stringBuilder.append('T');
        stringBuilder.append(calendar.get(11));
        stringBuilder.append(':');
        stringBuilder.append(calendar.get(12));
        stringBuilder.append(':');
        stringBuilder.append(calendar.get(13));
        stringBuilder.append('.');
        stringBuilder.append(calendar.get(14));
        return stringBuilder.toString();
    }

    public int getColumnCount() {
        if (this.Cw == null) {
            throw new NullPointerException();
        }
        return this.Cw.cI();
    }

    public ADOXMLRow getRow(int n2) {
        Object e10 = this.Cy.get(n2);
        if (!(e10 instanceof ADOXMLRow)) {
            throw new ClassCastException();
        }
        return (ADOXMLRow)e10;
    }

    public int getRowCount() {
        if (this.Cy == null) {
            return 0;
        }
        return this.Cy.size();
    }

    public ADOXMLElementType getSchemaDef() {
        if (this.Cw == null) {
            throw new NullPointerException();
        }
        return this.Cw.cH();
    }

    public static Properties getSchemaXMLAttributes() {
        Properties properties = new Properties();
        properties.setProperty(Cx, Cz);
        return properties;
    }

    static boolean J(String string) {
        if (string.equals("Schema")) {
            return true;
        }
        return string.equals("data");
    }

    public static Class nameToObjectType(String string) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("int") || string.equals("i1") || string.equals("ui1") || string.equals("i2") || string.equals("ui2") || string.equals("i4")) {
            return Integer.class;
        }
        if (string.equals("ui4")) {
            return Integer.class;
        }
        if (string.equals("float") || string.equals("r4")) {
            return Double.class;
        }
        if (string.equals("number") || string.equals("r8") || string.equals("i8") || string.equals("ui8")) {
            return Number.class;
        }
        if (string.equals("boolean")) {
            return Boolean.class;
        }
        if (string.equals("dateTime")) {
            return Calendar.class;
        }
        if (string.equals("string")) {
            return String.class;
        }
        if (string.equals("bin.hex")) {
            return ByteArray.class;
        }
        return null;
    }

    public Object parse(String string, String string2) {
        Object object = null;
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals("i1")) {
            object = new Byte(Byte.parseByte(string2));
        } else if (string.equals("boolean")) {
            object = XMLConverter.getBoolean(string2);
        } else if (string.equals("dateTime")) {
            object = XMLConverter.getDate(string2, this.Cv);
        } else if (string.equals("string")) {
            object = string2;
        } else if (string.equals("ui1") || string.equals("i2")) {
            object = new Short(Short.parseShort(string2));
        } else if (string.equals("int") || string.equals("ui2") || string.equals("i4")) {
            object = XMLConverter.getInteger(string2);
        } else if (string.equals("ui4") || string.equals("i8")) {
            object = new Long(Long.parseLong(string2));
        } else if (string.equals("number") || string.equals("float") || string.equals("r4") || string.equals("r8") || string.equals("ui8")) {
            object = XMLConverter.getDouble(string2);
        } else if (string.equals("bin.hex")) {
            object = new ByteArray();
            ((ByteArray)object).fromString(string2);
        }
        return object;
    }

    public void readElement(String string, String string2, Attributes attributes, Map map) {
    }

    public void reset() {
        this.Cw = null;
        this.Cy = null;
    }

    public void save(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        String string = "";
        Properties properties = XMLSerializationHelper.getHeaderAttributes(string);
        xMLWriter.writeStartElement("xml", properties);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement("xml");
    }

    public void save(XMLWriter xMLWriter, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
        throw new InternalError();
    }

    public void saveContents(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        if (this.Cw != null) {
            this.Cw.save(xMLWriter, xMLSerializationContext);
        }
        if (this.Cy != null) {
            this.Cy.save(xMLWriter, xMLSerializationContext);
        }
    }

    public void startElement(String string, Map map, Attributes attributes) {
        if (ADOXMLSerializationHelper.J(string)) {
            this.createMember(string, null, null, map, null);
        } else {
            if (this.Cw != null) {
                this.Cw.startElement(string, map, attributes);
            }
            if (this.Cy != null) {
                this.Cy.startElement(string, map, attributes);
            }
        }
    }
}

