/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions12.reports.common.filemanagement;

import com.crystaldecisions.jakarta.poi.poifs.filesystem.DirectoryEntry;
import com.crystaldecisions.jakarta.poi.poifs.filesystem.DocumentEntry;
import com.crystaldecisions.jakarta.poi.poifs.filesystem.DocumentInputStream;
import com.crystaldecisions.jakarta.poi.poifs.filesystem.DocumentNode;
import com.crystaldecisions.jakarta.poi.poifs.filesystem.Entry;
import com.crystaldecisions.jakarta.poi.poifs.filesystem.POIFSDocument;
import com.crystaldecisions.jakarta.rpoifs.RandomAccessPOIFSDocument;
import com.crystaldecisions12.reports.common.SaveLoadException;
import com.crystaldecisions12.reports.common.archive.ArchiveException;
import com.crystaldecisions12.reports.common.archive.ITslvInputRecordArchive;
import com.crystaldecisions12.reports.common.archive.ITslvOutputRecordArchive;
import com.crystaldecisions12.reports.common.archive.ReportFileTslvOutputRecordArchive;
import com.crystaldecisions12.reports.common.archive.TslvInputRecordArchive;
import com.crystaldecisions12.reports.common.asserts.CrystalAssert;
import com.crystaldecisions12.reports.common.encryption.EncryptionInfo;
import com.crystaldecisions12.reports.common.encryption.RijndaelDecryptionInputStream;
import com.crystaldecisions12.reports.common.encryption.RijndaelEncryptionOutputStream;
import com.crystaldecisions12.reports.common.filemanagement.BufferedRandomAccessFile;
import com.crystaldecisions12.reports.common.filemanagement.LEBufferedRandomAccessFile;
import com.crystaldecisions12.reports.common.filemanagement.LEDataInputStream;
import com.crystaldecisions12.reports.common.filemanagement.PmtStreamInfo;
import com.crystaldecisions12.reports.common.filemanagement.RandomAccessMemoryFile;
import com.crystaldecisions12.reports.common.filemanagement.RandomAccessPhysicalFile;
import com.crystaldecisions12.reports.common.filemanagement.SeekableDataOutput;
import com.crystaldecisions12.reports.common.filemanagement.TemporaryFile;
import java.io.BufferedInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class StreamBuilder {
    private static final short if = 31;
    private static final int a = 1024;

    public static DocumentInputStream do(DirectoryEntry directoryEntry, String string) throws IOException {
        DocumentEntry documentEntry = (DocumentEntry)directoryEntry.int(string);
        return new DocumentInputStream(documentEntry);
    }

    public static InputStream a(DirectoryEntry directoryEntry, String string, int n2, StreamOptions streamOptions) throws IOException {
        DocumentEntry documentEntry = (DocumentEntry)directoryEntry.int(string);
        InputStream inputStream = new DocumentInputStream(documentEntry);
        POIFSDocument pOIFSDocument = ((DocumentNode)documentEntry).Q();
        if (pOIFSDocument instanceof RandomAccessPOIFSDocument) {
            ((RandomAccessPOIFSDocument)pOIFSDocument).e(n2);
        } else {
            long l2 = ((InputStream)inputStream).skip(n2);
            if (l2 != (long)n2) {
                throw new IOException("Failed to skip forward to desired offset.");
            }
        }
        if (streamOptions.a.int) {
            inputStream = new RijndaelDecryptionInputStream(inputStream, streamOptions.a.new, streamOptions.a.if);
        }
        if (streamOptions.if) {
            inputStream = new InflaterInputStream(inputStream, new Inflater(), 2048);
        }
        return new BufferedInputStream(inputStream);
    }

    public static LEDataInputStream if(DirectoryEntry directoryEntry, String string, int n2, StreamOptions streamOptions) throws IOException {
        InputStream inputStream = StreamBuilder.a(directoryEntry, string, n2, streamOptions);
        return new LEDataInputStream(inputStream);
    }

    public static LEBufferedRandomAccessFile a(DirectoryEntry directoryEntry, String string, int n2, StreamOptions streamOptions, TemporaryFile temporaryFile) throws IOException {
        InputStream inputStream = StreamBuilder.a(directoryEntry, string, n2, streamOptions);
        DocumentEntry documentEntry = (DocumentEntry)directoryEntry.int(string);
        int n3 = documentEntry.H();
        BufferedRandomAccessFile bufferedRandomAccessFile = temporaryFile.a();
        byte[] byArray = new byte[1024];
        int n4 = 0;
        int n5 = 0;
        for (int i2 = n3; i2 > 0; i2 -= n5) {
            n4 = Math.min(i2, byArray.length);
            n5 = inputStream.read(byArray, 0, n4);
            bufferedRandomAccessFile.if(byArray, 0, n5);
        }
        int n6 = (int)bufferedRandomAccessFile.a();
        CrystalAssert.a(n3 == n6, "number of bytes written not equal to number of bytes read");
        bufferedRandomAccessFile.a(0L);
        return new LEBufferedRandomAccessFile(bufferedRandomAccessFile);
    }

    public static ITslvInputRecordArchive if(DirectoryEntry directoryEntry, String string, int n2, EncryptionInfo encryptionInfo) throws IOException, ArchiveException, SaveLoadException {
        DocumentInputStream documentInputStream = StreamBuilder.do(directoryEntry, string);
        StreamOptions streamOptions = new StreamOptions();
        streamOptions.a = encryptionInfo;
        return StreamBuilder.a(documentInputStream, n2, 1792, streamOptions);
    }

    public static ITslvInputRecordArchive a(InputStream inputStream, int n2, int n3, StreamOptions streamOptions) throws IOException, ArchiveException, SaveLoadException {
        TslvInputRecordArchive tslvInputRecordArchive;
        boolean bl2 = streamOptions == null ? true : streamOptions.if;
        EncryptionInfo encryptionInfo = new EncryptionInfo();
        if (bl2) {
            if (!(inputStream instanceof BufferedInputStream)) {
                inputStream = new BufferedInputStream(inputStream);
            }
            tslvInputRecordArchive = new TslvInputRecordArchive(inputStream, n2);
            encryptionInfo = tslvInputRecordArchive.for(n3);
            if (streamOptions != null && streamOptions.a != null) {
                streamOptions.a.a(encryptionInfo);
            }
        }
        InputStream inputStream2 = inputStream;
        if (encryptionInfo.int) {
            inputStream2 = new RijndaelDecryptionInputStream(inputStream2, encryptionInfo.new, encryptionInfo.if);
        }
        if (bl2) {
            inputStream2 = new InflaterInputStream(inputStream2, new Inflater(), 1024);
        }
        inputStream2 = new BufferedInputStream(inputStream2);
        tslvInputRecordArchive = new TslvInputRecordArchive(inputStream2, n2);
        return tslvInputRecordArchive;
    }

    public static ITslvInputRecordArchive a(DirectoryEntry directoryEntry, String string, int n2, boolean bl2) throws IOException, ArchiveException, SaveLoadException {
        DocumentInputStream documentInputStream = StreamBuilder.do(directoryEntry, string);
        StreamOptions streamOptions = new StreamOptions();
        streamOptions.if = bl2;
        streamOptions.a = null;
        return StreamBuilder.a(documentInputStream, n2, 1792, streamOptions);
    }

    public static ITslvInputRecordArchive a(InputStream inputStream, int n2, EncryptionInfo encryptionInfo) throws IOException, ArchiveException, SaveLoadException {
        StreamOptions streamOptions = new StreamOptions();
        streamOptions.a = encryptionInfo;
        return StreamBuilder.a(inputStream, n2, 1792, streamOptions);
    }

    public static ITslvOutputRecordArchive a(DirectoryEntry directoryEntry, String string, int n2, EncryptionInfo encryptionInfo) throws IOException, ArchiveException {
        return StreamBuilder.a(directoryEntry, string, n2, encryptionInfo, true);
    }

    public static ITslvOutputRecordArchive a(DirectoryEntry directoryEntry, String string, int n2, EncryptionInfo encryptionInfo, boolean bl2) throws IOException, ArchiveException {
        ReportFileTslvOutputRecordArchive reportFileTslvOutputRecordArchive = bl2 ? new ReportFileTslvOutputRecordArchive(n2, directoryEntry, string) : new ReportFileTslvOutputRecordArchive(n2, directoryEntry, string, new RandomAccessMemoryFile());
        EncryptionInfo encryptionInfo2 = reportFileTslvOutputRecordArchive.c();
        if (encryptionInfo2 != null) {
            encryptionInfo.a(encryptionInfo2);
        }
        return reportFileTslvOutputRecordArchive;
    }

    public static ITslvOutputRecordArchive a(DirectoryEntry directoryEntry, String string, int n2, boolean bl2, boolean bl3) throws IOException, ArchiveException {
        StreamOptions streamOptions = new StreamOptions();
        streamOptions.if = bl2;
        ReportFileTslvOutputRecordArchive reportFileTslvOutputRecordArchive = new ReportFileTslvOutputRecordArchive(n2, directoryEntry, string, streamOptions);
        reportFileTslvOutputRecordArchive.for(bl3);
        return reportFileTslvOutputRecordArchive;
    }

    public static long a(PmtStreamInfo pmtStreamInfo, DirectoryEntry directoryEntry, PmtStreamInfo pmtStreamInfo2, RandomAccessPhysicalFile randomAccessPhysicalFile) throws FileNotFoundException, IOException {
        long l2 = StreamBuilder.a(pmtStreamInfo.for(), pmtStreamInfo.do(), pmtStreamInfo.new(), directoryEntry, randomAccessPhysicalFile);
        pmtStreamInfo2.a((int)l2);
        return l2;
    }

    public static long a(String string, int n2, int n3, DirectoryEntry directoryEntry, RandomAccessPhysicalFile randomAccessPhysicalFile) throws FileNotFoundException, IOException {
        DocumentEntry documentEntry = (DocumentEntry)directoryEntry.int(string);
        DocumentInputStream documentInputStream = new DocumentInputStream(documentEntry);
        POIFSDocument pOIFSDocument = ((DocumentNode)documentEntry).Q();
        if (pOIFSDocument instanceof RandomAccessPOIFSDocument) {
            ((RandomAccessPOIFSDocument)pOIFSDocument).e(n2);
        } else {
            long l2 = ((InputStream)documentInputStream).skip(n2);
            if (l2 != (long)n2) {
                throw new IOException("Failed to skip forward to desired offset.");
            }
        }
        long l3 = randomAccessPhysicalFile.getFilePointer();
        byte[] byArray = new byte[4096];
        int n4 = 0;
        int n5 = 0;
        for (int i2 = n3; i2 > 0; i2 -= n5) {
            n4 = Math.min(i2, byArray.length);
            n5 = ((InputStream)documentInputStream).read(byArray, 0, n4);
            CrystalAssert.a(n5 >= 0 && n5 <= n4);
            randomAccessPhysicalFile.write(byArray, 0, n5);
        }
        int n6 = (int)(randomAccessPhysicalFile.getFilePointer() - l3);
        if (n3 != n6) {
            throw new IOException("number of bytes written not equal to number of bytes read");
        }
        return l3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int a(byte[] byArray, StreamOptions streamOptions, RandomAccessPhysicalFile randomAccessPhysicalFile) throws IOException {
        long l2 = randomAccessPhysicalFile.getFilePointer();
        OutputStream outputStream = randomAccessPhysicalFile.if();
        if (streamOptions.a.int) {
            outputStream = new RijndaelEncryptionOutputStream(outputStream, streamOptions.a.new, streamOptions.a.if);
        }
        Deflater deflater = null;
        DeflaterOutputStream deflaterOutputStream = null;
        if (streamOptions.if) {
            deflater = new Deflater();
            deflaterOutputStream = new DeflaterOutputStream(outputStream, deflater);
            outputStream = deflaterOutputStream;
        }
        try {
            outputStream.write(byArray);
        }
        finally {
            try {
                if (deflaterOutputStream != null) {
                    deflaterOutputStream.finish();
                }
                outputStream.flush();
            }
            finally {
                if (deflater != null) {
                    deflater.end();
                }
            }
        }
        int n2 = (int)(randomAccessPhysicalFile.getFilePointer() - l2);
        return n2;
    }

    public static int a(TemporaryFile temporaryFile, long l2, long l3, StreamOptions streamOptions, RandomAccessPhysicalFile randomAccessPhysicalFile) throws IOException {
        BufferedRandomAccessFile bufferedRandomAccessFile = temporaryFile.a();
        return StreamBuilder.a(bufferedRandomAccessFile, l2, l3, streamOptions, randomAccessPhysicalFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int a(BufferedRandomAccessFile bufferedRandomAccessFile, long l2, long l3, StreamOptions streamOptions, RandomAccessPhysicalFile randomAccessPhysicalFile) throws IOException {
        bufferedRandomAccessFile.a(l2);
        long l4 = randomAccessPhysicalFile.getFilePointer();
        OutputStream outputStream = randomAccessPhysicalFile.if();
        if (streamOptions.a.int) {
            outputStream = new RijndaelEncryptionOutputStream(outputStream, streamOptions.a.new, streamOptions.a.if);
        }
        Deflater deflater = null;
        DeflaterOutputStream deflaterOutputStream = null;
        if (streamOptions.if) {
            deflater = new Deflater();
            deflaterOutputStream = new DeflaterOutputStream(outputStream, deflater);
            outputStream = deflaterOutputStream;
        }
        byte[] byArray = new byte[4096];
        try {
            int n2 = 0;
            for (long i2 = l3; i2 > 0L; i2 -= (long)n2) {
                n2 = i2 > (long)byArray.length ? byArray.length : (int)i2;
                bufferedRandomAccessFile.a(byArray, 0, n2);
                outputStream.write(byArray, 0, n2);
            }
        }
        finally {
            try {
                if (deflaterOutputStream != null) {
                    deflaterOutputStream.finish();
                }
                outputStream.flush();
            }
            finally {
                if (deflater != null) {
                    deflater.end();
                }
            }
        }
        int n3 = (int)(randomAccessPhysicalFile.getFilePointer() - l4);
        return n3;
    }

    public static DocumentEntry a(DirectoryEntry directoryEntry, String string, InputStream inputStream) throws IOException {
        return directoryEntry.a(string, inputStream);
    }

    public static DocumentEntry a(DirectoryEntry directoryEntry, String string, SeekableDataOutput seekableDataOutput) throws IOException {
        return directoryEntry.a(string, seekableDataOutput.a());
    }

    public static String a(long l2, String string) {
        if (l2 < 0L) {
            return null;
        }
        String string2 = string;
        if (string2 == null) {
            string2 = "Binary Data";
        }
        String string3 = Long.toString(l2);
        String string4 = string2 + ' ' + string3 + 'l';
        if (string4.length() > 31) {
            return null;
        }
        return string4;
    }

    public static boolean a(DirectoryEntry directoryEntry, String string) {
        if (directoryEntry == null || string == null) {
            return false;
        }
        try {
            directoryEntry.int(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return false;
        }
        return true;
    }

    public static boolean a(DirectoryEntry directoryEntry, long l2, String string) throws IOException {
        String string2 = StreamBuilder.a(l2, string);
        if (string2 == null) {
            return false;
        }
        return StreamBuilder.if(directoryEntry, string2);
    }

    public static boolean if(DirectoryEntry directoryEntry, String string) throws IOException {
        if (directoryEntry == null) {
            return false;
        }
        Entry entry = directoryEntry.int(string);
        return StreamBuilder.a(entry);
    }

    public static boolean a(Entry entry) throws IOException {
        boolean bl2 = true;
        if (entry.F()) {
            DocumentEntry documentEntry = (DocumentEntry)entry;
            bl2 = documentEntry.C();
        } else if (entry.G()) {
            DirectoryEntry directoryEntry = (DirectoryEntry)entry;
            if (!directoryEntry.N()) {
                Entry entry2;
                ArrayList<String> arrayList = new ArrayList<String>();
                Iterator iterator = directoryEntry.O();
                while (iterator.hasNext()) {
                    entry2 = (Entry)iterator.next();
                    arrayList.add(entry2.D());
                }
                iterator = arrayList.iterator();
                while (iterator.hasNext() && bl2) {
                    entry2 = directoryEntry.int((String)iterator.next());
                    bl2 = StreamBuilder.a(entry2);
                }
            }
            if (bl2) {
                bl2 = directoryEntry.C();
            }
        }
        return bl2;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class StreamOptions {
        public boolean if = true;
        public EncryptionInfo a = new EncryptionInfo();
    }
}

