/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.lib;

import com.crystaldecisions.client.helper.SDKCommonResourceManager;
import com.crystaldecisions.sdk.occa.report.lib.ControllableHelper;
import com.crystaldecisions.sdk.occa.report.lib.IChange;
import com.crystaldecisions.sdk.occa.report.lib.IClone;
import com.crystaldecisions.sdk.occa.report.lib.IControllable;
import com.crystaldecisions.sdk.occa.report.lib.IControllerInterface;
import com.crystaldecisions.sdk.occa.report.lib.IMemberVisitor;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKException;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKMultipleParentsException;
import com.crystaldecisions.sdk.occa.report.lib.ReportSDKRuntimeException;

public class ControllableMixin {
    private IControllable m_current;
    private ControllableMixin m_parent;
    private IControllerInterface m_controllerInterface;

    public ControllableMixin(IControllable current) {
        this.m_current = current;
    }

    public IControllerInterface getControllerInterface() {
        return this.m_controllerInterface;
    }

    public Object getAncestor(int depth) {
        if (this.m_parent == null) {
            return null;
        }
        if (depth == 0) {
            return this.m_parent.m_current;
        }
        return this.m_parent.getAncestor(depth - 1);
    }

    private IControllable getContainer() {
        if (this.m_current.isDirectlyControllable()) {
            return this.m_current;
        }
        if (this.m_parent == null) {
            return null;
        }
        return this.m_parent.getContainer();
    }

    private void setParent(ControllableMixin parent) {
        if (this.m_controllerInterface != null && parent != null && this.m_parent != null && this.m_parent != parent) {
            String className = this.m_current.getClass().getName();
            int dotIndex = className.lastIndexOf(46);
            if (dotIndex != -1) {
                className = className.substring(dotIndex + 1);
            }
            String errString = SDKCommonResourceManager.getStringWithParams("Error_MultipleParents", this.getControllerInterface().getLocale(), new Object[]{className});
            throw new ReportSDKMultipleParentsException(errString);
        }
        this.m_parent = parent;
    }

    public void setControllerInterface(IControllerInterface controllerInterface) {
        this.m_controllerInterface = controllerInterface;
        this.m_current.enumerateMembers(new ControllerPropagatingVisitor());
    }

    public void propagateController(Object subObject) {
        if (subObject instanceof IControllable) {
            IControllable controllable = (IControllable)subObject;
            controllable.getControllableMixin().setParent(this);
            controllable.getControllableMixin().setControllerInterface(this.m_controllerInterface);
        }
    }

    public void makeChange(IChange change) {
        if (this.m_controllerInterface == null || !this.m_controllerInterface.isEnabled()) {
            change.run();
        } else if (this.m_current.isDirectlyControllable()) {
            this.directMakeChange(change);
        } else {
            this.delegatingMakeChange(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delegatingMakeChange(IChange change) {
        IClone oldShallowClone = (IClone)this.m_current.clone(false);
        boolean successfullyInvokedModify = false;
        try {
            this.getContainer().getControllableMixin().makeChange(change);
            successfullyInvokedModify = true;
        }
        finally {
            if (!successfullyInvokedModify) {
                this.m_controllerInterface.disable();
                oldShallowClone.copyTo(this.m_current, false);
                this.m_controllerInterface.enable();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void directMakeChange(IChange change) {
        IControllerInterface controllerInterface = this.m_controllerInterface;
        this.setControllerInterface(null);
        IControllable oldDeepClone = (IControllable)this.m_current.clone(true);
        ControllableHelper.copyToPreservingReferences(this.m_current, oldDeepClone, null);
        oldDeepClone.getControllableMixin().setControllerInterface(null);
        IControllable oldShallowClone = (IControllable)this.m_current.clone(false);
        change.run();
        IControllable newClone = (IControllable)this.m_current.clone(false);
        boolean successfullyResetController = false;
        boolean successfullyInvokedModify = false;
        try {
            this.setControllerInterface(controllerInterface);
            successfullyResetController = true;
            controllerInterface.disable();
            oldDeepClone.copyTo(this.m_current, false);
            controllerInterface.enable();
            try {
                this.m_current.doControllerModification(newClone);
            }
            catch (ReportSDKException e10) {
                throw new ReportSDKRuntimeException(e10);
            }
            successfullyInvokedModify = true;
            controllerInterface.disable();
            ControllableHelper.copyToPreservingReferences(this.m_current, newClone, null);
            newClone.copyTo(this.m_current, false);
            controllerInterface.enable();
        }
        finally {
            if (!successfullyInvokedModify) {
                controllerInterface.disable();
                if (successfullyResetController) {
                    newClone.copyTo(this.m_current, false);
                    this.setControllerInterface(null);
                }
                ControllableHelper.copyToPreservingReferences(oldDeepClone, oldShallowClone, null);
                oldShallowClone.copyTo(this.m_current, false);
                this.setControllerInterface(controllerInterface);
                controllerInterface.enable();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ControllerPropagatingVisitor
    implements IMemberVisitor {
        private ControllerPropagatingVisitor() {
        }

        @Override
        public <T extends IClone> T visit(T member, boolean isOwner) {
            if (isOwner) {
                ControllableMixin.this.propagateController(member);
            }
            return member;
        }
    }
}

