/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.sdk.occa.report.lib;

import com.crystaldecisions.sdk.occa.report.lib.IClone;
import com.crystaldecisions.sdk.occa.report.lib.IControllable;
import com.crystaldecisions.sdk.occa.report.lib.IControllerInterface;
import com.crystaldecisions.sdk.occa.report.lib.IMemberVisitor;
import java.util.ArrayList;
import java.util.IdentityHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ControllableHelper {
    private ControllableHelper() {
        assert (false);
    }

    private static void enumerateMembersInParallel(IControllable object, IControllable otherObject, final IParallelMemberVisitor parallelVisitor) {
        final ArrayList otherMembers = new ArrayList();
        otherObject.enumerateMembers(new IMemberVisitor(){

            @Override
            public <T extends IClone> T visit(T member, boolean isOwner) {
                otherMembers.add(member);
                return member;
            }
        });
        object.enumerateMembers(new IMemberVisitor(){
            private int i = 0;

            @Override
            public <T extends IClone> T visit(T member, boolean isOwner) {
                T result = parallelVisitor.visit(member, isOwner, (IClone)otherMembers.get(this.i));
                ++this.i;
                return result;
            }
        });
    }

    private static void copyReferences(Object srcObject, Object destObject, final IdentityHashMap<IClone, IClone> referenceMap) {
        if (srcObject instanceof IControllable) {
            assert (srcObject.getClass() == destObject.getClass()) : "oldObject and newObject must have the same type";
            IControllable oldControllable = (IControllable)srcObject;
            IControllable newControllable = (IControllable)destObject;
            ControllableHelper.enumerateMembersInParallel(newControllable, oldControllable, new IParallelMemberVisitor(){

                @Override
                public <T extends IClone> T visit(T member, boolean isOwner, IClone otherMember) {
                    if (isOwner) {
                        ControllableHelper.copyReferences(otherMember, member, referenceMap);
                        return member;
                    }
                    IClone replacementReference = referenceMap.containsKey(otherMember) ? (IClone)referenceMap.get(otherMember) : otherMember;
                    return (T)replacementReference;
                }
            });
        }
    }

    private static void extractReferenceMapping(IClone srcObject, IClone destObject, final IdentityHashMap<IClone, IClone> referenceMap) {
        if (srcObject instanceof IControllable) {
            assert (srcObject.getClass() == destObject.getClass()) : "oldObject and newObject must have the same type";
            referenceMap.put(srcObject, destObject);
            IControllable srcControllable = (IControllable)srcObject;
            IControllable destControllable = (IControllable)destObject;
            ControllableHelper.enumerateMembersInParallel(destControllable, srcControllable, new IParallelMemberVisitor(){

                @Override
                public <T extends IClone> T visit(T member, boolean isOwner, IClone otherMember) {
                    if (isOwner) {
                        ControllableHelper.extractReferenceMapping(otherMember, member, referenceMap);
                    }
                    return member;
                }
            });
        }
    }

    public static void copyToPreservingReferences(IClone srcObject, IClone destObject, IdentityHashMap<IClone, IClone> referenceMap) {
        srcObject.copyTo(destObject, true);
        if (referenceMap == null) {
            referenceMap = new IdentityHashMap();
        }
        ControllableHelper.extractReferenceMapping(srcObject, destObject, referenceMap);
        ControllableHelper.copyReferences(srcObject, destObject, referenceMap);
    }

    public static IControllerInterface getController(Object o2) {
        if (o2 instanceof IControllable) {
            IControllable controllable = (IControllable)o2;
            return controllable.getControllableMixin().getControllerInterface();
        }
        return null;
    }

    public static boolean hasEnabledController(Object o2) {
        IControllerInterface controller;
        return o2 instanceof IControllable && (controller = ControllableHelper.getController(o2)) != null && controller.isEnabled();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IParallelMemberVisitor {
        public <T extends IClone> T visit(T var1, boolean var2, IClone var3);
    }
}

