/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.common;

import com.crystaldecisions.reports.common.value.BooleanValue;
import com.crystaldecisions.reports.common.value.CurrencyValue;
import com.crystaldecisions.reports.common.value.DateTimeValue;
import com.crystaldecisions.reports.common.value.DateValue;
import com.crystaldecisions.reports.common.value.NumberValue;
import com.crystaldecisions.reports.common.value.TimeValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Utils {
    public static final int if = 65534;
    public static final int try = 131070;
    public static final int do = 46;
    private static final MessageFormat new = new MessageFormat("{0,number,0000}/{1,number,00}/{2,number,00} {3,number,00}:{4,number,00}:{5,number,00}.{6,number,00}");
    private static final MessageFormat for = new MessageFormat("{0,number,00}:{1,number,00}:{2,number,00}.{3,number,00}");
    private static final MessageFormat a = new MessageFormat("{0,number,0000}/{1,number,00}/{2,number,00}");

    private Utils() {
    }

    public static int a(ValueType valueType) {
        assert (valueType.isScalar());
        if (valueType.isNumber()) {
            return NumberValue.GetMaxEncodedSize((ValueType)valueType);
        }
        switch (valueType.value()) {
            case 7: {
                return CurrencyValue.GetMaxEncodedSize();
            }
            case 8: {
                return BooleanValue.GetMaxEncodedSize();
            }
            case 9: {
                return DateValue.GetMaxEncodedSize();
            }
            case 10: {
                return TimeValue.GetMaxEncodedSize();
            }
            case 15: {
                return DateTimeValue.GetMaxEncodedSize();
            }
            case 11: {
                return 0;
            }
            case 13: {
                return 131070;
            }
            case 14: {
                return Integer.MAX_VALUE;
            }
        }
        throw new IllegalArgumentException("Unexpected ValueType: ValueType=[" + valueType.value() + "]");
    }

    public static void a(List<?> list, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            list.add(null);
        }
    }

    public static String a(DateTimeValue dateTimeValue) {
        DateValue dateValue = dateTimeValue.getDateValue();
        TimeValue timeValue = dateTimeValue.getTimeValue();
        if (dateValue == null) {
            assert (timeValue != null);
            Object[] objectArray = new Object[]{timeValue.getHours(), timeValue.getMinutes(), timeValue.getWholeSeconds(), (int)(timeValue.getNanoseconds() * 100L / 1000000000L)};
            return for.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
        }
        if (timeValue == null) {
            Object[] objectArray = new Object[]{dateValue.getYear(), dateValue.getMonth(), dateValue.getDay()};
            return a.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
        }
        Object[] objectArray = new Object[]{dateValue.getYear(), dateValue.getMonth(), dateValue.getDay(), timeValue.getHours(), timeValue.getMinutes(), timeValue.getWholeSeconds(), (int)(timeValue.getNanoseconds() * 100L / 1000000000L)};
        return new.format(objectArray, new StringBuffer(), (FieldPosition)null).toString();
    }

    public static int a(ValueType valueType, int n2) {
        int n3 = Utils.a(valueType);
        if (n3 > 0) {
            return n3;
        }
        n3 = n2;
        if (n3 > 131070) {
            n3 = 131070;
        }
        return n3;
    }
}

