/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.sdk.erom.remoteagent.commands;

import com.businessobjects.sdk.erom.remoteagent.Command;
import com.businessobjects.sdk.erom.remoteagent.commands.a;
import com.crystaldecisions.sdk.occa.report.data.ConnectionInfo;
import com.crystaldecisions.sdk.occa.report.data.ConnectionInfoKind;
import com.crystaldecisions.sdk.occa.report.data.IConnectionInfo;
import com.crystaldecisions.sdk.occa.report.lib.PropertyBag;

public class SetDBCredentialCommand
extends a {
    public static final String CMD_IN_CONNID = "CID";
    public static final String CMD_IN_SERVERNAME = "SVR";
    public static final String CMD_IN_DBNAME = "DBN";
    public static final String CMD_IN_USERNAME = "USR";
    public static final String CMD_IN_PASSWORD = "PWD";

    public SetDBCredentialCommand(Command command) {
        super(command);
    }

    public SetDBCredentialCommand(PropertyBag propertyBag) {
        super(1002, propertyBag != null ? propertyBag : new PropertyBag());
    }

    public SetDBCredentialCommand() {
        this(new PropertyBag());
    }

    public SetDBCredentialCommand(IConnectionInfo iConnectionInfo) {
        this();
        if (iConnectionInfo != null) {
            this.if(CMD_IN_SERVERNAME, SetDBCredentialCommand.getServerName(iConnectionInfo));
            this.if(CMD_IN_DBNAME, SetDBCredentialCommand.getDBName(iConnectionInfo));
            this.if(CMD_IN_USERNAME, iConnectionInfo.getUserName());
            this.if(CMD_IN_PASSWORD, iConnectionInfo.getPassword());
        }
    }

    public String getServerName() {
        return (String)this.if(CMD_IN_SERVERNAME);
    }

    public String getDBName() {
        return (String)this.if(CMD_IN_DBNAME);
    }

    public String getConnectionID() {
        return (String)this.if(CMD_IN_CONNID);
    }

    public String getUsername() {
        return (String)this.if(CMD_IN_USERNAME);
    }

    public String getPassword() {
        return (String)this.if(CMD_IN_PASSWORD);
    }

    public IConnectionInfo getConnectionInfo() {
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setKind(ConnectionInfoKind.SQL);
        PropertyBag propertyBag = new PropertyBag();
        propertyBag.putStringValue("Server Name", this.getServerName());
        propertyBag.putStringValue("Database Name", this.getDBName());
        connectionInfo.setAttributes(propertyBag);
        connectionInfo.setUserName(this.getUsername());
        connectionInfo.setPassword(this.getPassword());
        return connectionInfo;
    }

    public static String getServerName(IConnectionInfo iConnectionInfo) {
        if (iConnectionInfo != null) {
            PropertyBag propertyBag = iConnectionInfo.getAttributes();
            ConnectionInfoKind connectionInfoKind = iConnectionInfo.getKind();
            if (propertyBag != null && connectionInfoKind != null) {
                if (connectionInfoKind.value() == 5) {
                    return propertyBag.getStringValue("QE_ServerDescription");
                }
                return propertyBag.getStringValue("Server Name");
            }
        }
        return null;
    }

    public static String getDBName(IConnectionInfo iConnectionInfo) {
        if (iConnectionInfo != null) {
            PropertyBag propertyBag = iConnectionInfo.getAttributes();
            ConnectionInfoKind connectionInfoKind = iConnectionInfo.getKind();
            if (propertyBag != null && connectionInfoKind != null) {
                if (connectionInfoKind.value() == 5) {
                    return propertyBag.getStringValue("QE_DatabaseName");
                }
                return propertyBag.getStringValue("Database Name");
            }
        }
        return null;
    }
}

