/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.prompting.exceptions;

import com.businessobjects.prompting.exceptions.PromptingResources;
import com.businessobjects.prompting.exceptions.PromptingResourcesFactory;
import com.businessobjects.prompting.objectmodel.common.IPrompt;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PromptingException
extends Exception {
    protected final PromptingResourcesFactory resourcesFactory;
    protected final String resourceKey;
    protected final Object substitutionStrings;
    protected final String rootCauseID;
    protected final String debugString;

    public PromptingException(String string, String string2, PromptingResourcesFactory promptingResourcesFactory, String string3, Object object) {
        this.resourcesFactory = promptingResourcesFactory;
        this.resourceKey = string3;
        this.substitutionStrings = object;
        this.rootCauseID = string;
        this.debugString = string2;
    }

    public PromptingException(String string, String string2, PromptingResourcesFactory promptingResourcesFactory, String string3, Object object, Throwable throwable) {
        super(throwable);
        this.resourcesFactory = promptingResourcesFactory;
        this.resourceKey = string3;
        this.substitutionStrings = object;
        this.rootCauseID = string;
        this.debugString = string2;
    }

    public PromptingException(String string, String string2, PromptingResourcesFactory promptingResourcesFactory, String string3) {
        this(string, string2, promptingResourcesFactory, string3, null, null);
    }

    public PromptingException(String string, String string2, PromptingResourcesFactory promptingResourcesFactory, String string3, Throwable throwable) {
        this(string, string2, promptingResourcesFactory, string3, null, throwable);
    }

    public PromptingException(String string, String string2, PromptingException promptingException) {
        this(string, string2, promptingException.resourcesFactory, promptingException.resourceKey, promptingException.substitutionStrings, promptingException);
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public String getRootCauseIdentifier() {
        return this.rootCauseID;
    }

    @Override
    public String getMessage() {
        return this.getLocalizedMessage(Locale.getDefault());
    }

    public String getLocalizedMessage(Locale locale) {
        String string = null;
        if (this.resourcesFactory != null) {
            string = this.resourcesFactory.getLocalizedMessage(locale, this.resourceKey, this.substitutionStrings);
        }
        if (string == null) {
            string = this.resourceKey;
        }
        return string;
    }

    public <T extends Throwable> boolean isCausedByA(Class<T> clazz) {
        return this.findCause(clazz) != null;
    }

    public <T extends Throwable> T findCause(Class<T> clazz) {
        for (Throwable throwable = this; throwable != null; throwable = throwable.getCause()) {
            if (!clazz.isInstance(throwable)) continue;
            return (T)((Throwable)clazz.cast(throwable));
        }
        return null;
    }

    public static class FetchLOVException
    extends PromptingException {
        public FetchLOVException(String string, String string2, Throwable throwable) {
            super(string, string2, PromptingResources.getFactory(), "FetchLOVException", throwable);
        }
    }

    public static class ExceededMaxNSavedDataRecordsForLOVException
    extends PromptingException {
        public ExceededMaxNSavedDataRecordsForLOVException(String string) {
            super(string, "", PromptingResources.getFactory(), "ExceededMaxNSavedDataRecordsForLOV");
        }
    }

    public static class NoAppropriateSavedDataException
    extends PromptingException {
        public NoAppropriateSavedDataException(String string) {
            super(string, "", PromptingResources.getFactory(), "NoAppropriateSavedData");
        }
    }

    public static class DependentPromptMissingValueException
    extends PromptingException {
        public DependentPromptMissingValueException(String string, IPrompt iPrompt) {
            super(string, "", PromptingResources.getFactory(), "DependentPromptMissingValue", iPrompt.getName());
        }
    }

    public static class DBConnectionInfoRequired
    extends PromptingException {
        public DBConnectionInfoRequired(String string) {
            super(string, "DBInfoRequired", PromptingResources.getFactory(), "DBInfoRequired");
        }
    }

    public static class InvalidNetworkException
    extends PromptingException {
        public InvalidNetworkException(String string, String string2) {
            super(string, string2, PromptingResources.getFactory(), "InvalidLOVInfo");
        }
    }
}

