/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.lov;

import com.businessobjects.lov.ILOVContext;
import com.businessobjects.lov.ILOVDataSource;
import com.businessobjects.lov.ILOVField;
import com.businessobjects.lov.ILOVObject;
import com.businessobjects.lov.ILOVRowset;
import com.businessobjects.lov.SortOrder;
import com.businessobjects.prompting.exceptions.PromptingException;
import com.businessobjects.prompting.internal.LocaleID;
import com.businessobjects.prompting.objectmodel.common.IPrompt;
import com.businessobjects.prompting.objectmodel.common.IPromptValue;
import com.businessobjects.prompting.objectmodel.common.PromptObjectType;
import com.businessobjects.prompting.objectmodel.common.PromptValueType;
import com.crystaldecisions.client.helper.CloneUtil;
import com.crystaldecisions.sdk.occa.report.lib.ClonableList;
import com.crystaldecisions.sdk.occa.report.lib.IRepositoryObjectInternal;
import com.crystaldecisions.xml.serialization.ClassFactory;
import com.crystaldecisions.xml.serialization.SerializationHelper;
import com.crystaldecisions.xml.serialization.XMLConverter;
import com.crystaldecisions.xml.serialization.XMLSerializationContext;
import com.crystaldecisions.xml.serialization.XMLWriter;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class LOVDataSource
implements ILOVDataSource,
IRepositoryObjectInternal {
    private static final String do = "LOVDataSource";
    private static final String byte = "Name";
    private static final String try = "LOVObjects";
    private static final String a = "Locale";
    private static final String if = "AdditionalInfo";
    private static final String new = "CUID";
    private static final String case = "EnterpriseURI";
    private static final String for = "Version";
    protected String m_lovdsName = "";
    protected ClonableList<ILOVObject> m_lovObjects = new ClonableList();
    protected Locale m_locale = Locale.US;
    protected String m_additionalInfo = "";
    protected String m_enterpriseToken = "";
    protected String m_objectTypeName = "LOVDataSource";
    protected UUID m_uuid = UUID.randomUUID();
    protected String m_enterpriseURI;
    private int int = 0;

    public PromptObjectType getObjectType() {
        return PromptObjectType.LovDS;
    }

    @Override
    public String getName() {
        return this.m_lovdsName;
    }

    @Override
    public UUID getUUID() {
        return this.m_uuid;
    }

    public void setUUID(UUID uUID) {
        this.m_uuid = uUID;
    }

    @Override
    public void setName(String string) {
        this.m_lovdsName = string;
    }

    @Override
    public ClonableList<ILOVObject> getLOVObjects() {
        return this.m_lovObjects;
    }

    public void putLOVObjects(ClonableList<ILOVObject> clonableList) {
        this.m_lovObjects = clonableList;
    }

    @Override
    public ILOVObject getLOVObject(UUID uUID) {
        for (ILOVObject iLOVObject : this.m_lovObjects) {
            if (!uUID.equals(iLOVObject.getUUID())) continue;
            return iLOVObject;
        }
        return null;
    }

    @Override
    public abstract ILOVRowset getLOVRowset(ILOVContext var1) throws PromptingException;

    public void validateContext(ILOVContext iLOVContext) {
        List<IPrompt.ISort> list;
        if (iLOVContext == null) {
            throw new IllegalArgumentException("ILOVContext cannot be null");
        }
        ILOVObject iLOVObject = this.getLOVObject(iLOVContext.getFetchLOVUUID());
        if (iLOVObject == null) {
            throw new IllegalArgumentException("Could not find LOV Object requested in context");
        }
        ILOVContext.ILOVFilterExpression iLOVFilterExpression = iLOVContext.getLOVFilterExpression();
        if (iLOVFilterExpression != null) {
            this.a(iLOVFilterExpression);
        }
        if ((list = iLOVContext.getLOVSorts()) != null && list.size() > 0) {
            this.validateSorts(list, iLOVObject);
        }
    }

    protected void validateSorts(List<IPrompt.ISort> list, ILOVObject iLOVObject) {
        for (IPrompt.ISort iSort : list) {
            if (iSort == null) {
                throw new IllegalArgumentException("ISort cannot be null");
            }
            int n2 = iSort.getSortIndex();
            if (n2 < 0 || n2 >= iLOVObject.getFields().size()) {
                throw new IllegalArgumentException("Sort Index is invalid");
            }
            SortOrder sortOrder = iSort.getSortOrder();
            if (sortOrder != null) continue;
            throw new IllegalArgumentException("SortOrder cannot be null");
        }
    }

    private void a(ILOVContext.ILOVFilterExpression iLOVFilterExpression) {
        if (iLOVFilterExpression == null) {
            throw new IllegalArgumentException("ILOVFilterExpression cannot be null");
        }
        if (iLOVFilterExpression instanceof ILOVContext.ILOVFilter) {
            this.a((ILOVContext.ILOVFilter)iLOVFilterExpression);
        } else if (iLOVFilterExpression instanceof ILOVContext.ILOVCompoundFilter) {
            this.a((ILOVContext.ILOVCompoundFilter)iLOVFilterExpression);
        } else {
            throw new IllegalArgumentException("Invalid instanceof ILOVFilterExpression");
        }
    }

    private void a(ILOVContext.ILOVFilter iLOVFilter) {
        if (iLOVFilter == null) {
            throw new IllegalArgumentException("ILOVFilter cannot be null");
        }
        ILOVContext.FilterType filterType = iLOVFilter.getFilterType();
        if (filterType == null) {
            throw new IllegalArgumentException("A filter's FilterType cannot be null");
        }
        IPromptValue.IPromptValueList iPromptValueList = iLOVFilter.getFilterValues();
        if (iPromptValueList == null || iPromptValueList.isEmpty()) {
            throw new IllegalArgumentException("A filter must have at least one value");
        }
        for (IPromptValue iPromptValue : iPromptValueList) {
            if (iPromptValue == null) {
                throw new IllegalArgumentException("A filter value cannot be null");
            }
            if (!iPromptValue.isNull() || filterType == ILOVContext.FilterType.EQUAL_TO || filterType == ILOVContext.FilterType.NOT_EQUAL_TO) continue;
            throw new IllegalArgumentException("A null filter value cannot be used with this FilterType");
        }
        if (iPromptValueList.size() > 1 && filterType != ILOVContext.FilterType.EQUAL_TO && filterType != ILOVContext.FilterType.NOT_EQUAL_TO) {
            throw new IllegalArgumentException("A filter's FilterType cannot be used with more than one field value");
        }
        ILOVField iLOVField = iLOVFilter.getFilterField();
        if (iLOVField == null) {
            throw new IllegalArgumentException("A filter's field cannot be null");
        }
        if (!this.a(iLOVField)) {
            throw new IllegalArgumentException("Could not find LOV Field specified in filter");
        }
        if ((filterType == ILOVContext.FilterType.STARTSWITH || filterType == ILOVContext.FilterType.LIKE) && ((IPromptValue)iPromptValueList.get(0)).getPromptValueType() != PromptValueType.string) {
            throw new IllegalArgumentException("A String Value is required");
        }
    }

    private void a(ILOVContext.ILOVCompoundFilter iLOVCompoundFilter) {
        if (iLOVCompoundFilter == null) {
            throw new IllegalArgumentException("ILOVCompoundFilter cannot be null");
        }
        List<ILOVContext.ILOVFilterExpression> list = iLOVCompoundFilter.getFilterExpressions();
        if (list == null || list.isEmpty()) {
            throw new IllegalArgumentException("A compound filter must have at least one filter expression");
        }
        ILOVContext.CompoundFilterType compoundFilterType = iLOVCompoundFilter.getCompoundFilterType();
        if (compoundFilterType == null) {
            throw new IllegalArgumentException("A compound filter's CompoundFilterType cannot be null");
        }
        int n2 = list.size();
        if (compoundFilterType == ILOVContext.CompoundFilterType.NOT && n2 != 1) {
            throw new IllegalArgumentException("A NOT compound filter must have exactly one filter expression");
        }
        if (compoundFilterType == ILOVContext.CompoundFilterType.AND && n2 < 2) {
            throw new IllegalArgumentException("An AND compound filter must have at least 2 filter expressions");
        }
        if (compoundFilterType == ILOVContext.CompoundFilterType.OR && n2 < 2) {
            throw new IllegalArgumentException("An OR compound filter must have at least 2 filter expressions");
        }
        for (ILOVContext.ILOVFilterExpression iLOVFilterExpression : list) {
            this.a(iLOVFilterExpression);
        }
    }

    private boolean a(ILOVField iLOVField) {
        for (ILOVObject iLOVObject : this.m_lovObjects) {
            for (ILOVField iLOVField2 : iLOVObject.getFields()) {
                if (iLOVField2 != iLOVField) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    @Override
    public void setEnterpriseToken(String string) {
        this.m_enterpriseToken = string;
    }

    @Override
    public String getEnterpriseURI() {
        return this.m_enterpriseURI;
    }

    @Override
    public void setEnterpriseURI(String string) {
        this.m_enterpriseURI = string;
    }

    @Override
    public Object createMember(String string, Attributes attributes, XMLSerializationContext xMLSerializationContext, Map<Object, Object> map, boolean[] blArray) {
        Object object = ClassFactory.createObject(attributes, xMLSerializationContext, blArray);
        if (string.equals(try)) {
            this.m_lovObjects.add((ILOVObject)object);
        }
        return object;
    }

    @Override
    public void endElement(String string, Map<Object, Object> map) {
    }

    @Override
    public void readElement(String string, String string2, Attributes attributes, Map<Object, Object> map) {
        if (string.equals(byte)) {
            this.m_lovdsName = string2;
        } else if (string.equals(a)) {
            LocaleID localeID = LocaleID.from_int(XMLConverter.getInt(string2));
            this.m_locale = localeID.toLocale();
        } else if (string.equals(if)) {
            this.m_additionalInfo = string2;
        } else if (string.equals(do)) {
            this.m_objectTypeName = string2;
        } else if (string.equals(new)) {
            this.m_uuid = UUID.fromString(string2);
        } else if (string.equals(case)) {
            this.m_enterpriseURI = string2;
        } else if (string.equals(for)) {
            this.int = XMLConverter.getInt(string2);
        }
    }

    @Override
    public void save(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        String string = XMLConverter.getXMLFromClassName(this.getClass().getName());
        Properties properties = SerializationHelper.getHeaderAttributes(string);
        xMLWriter.writeStartElement(this.m_objectTypeName, properties);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(this.m_objectTypeName);
    }

    @Override
    public void save(XMLWriter xMLWriter, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeStartObjectElement(string, "2", this, xMLSerializationContext);
        this.saveContents(xMLWriter, xMLSerializationContext);
        xMLWriter.writeEndElement(string);
    }

    @Override
    public void saveContents(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
        xMLWriter.writeTextElement(byte, this.m_lovdsName, null);
        for (ILOVObject iLOVObject : this.m_lovObjects) {
            iLOVObject.save(xMLWriter, try, xMLSerializationContext);
        }
        LocaleID localeID = new LocaleID(this.m_locale);
        xMLWriter.writeIntElement(a, localeID.value(), null);
        xMLWriter.writeTextElement(if, this.m_additionalInfo, null);
        xMLWriter.writeTextElement(do, this.m_objectTypeName, null);
        xMLWriter.writeTextElement(new, this.m_uuid.toString(), null);
        xMLWriter.writeTextElement(case, this.m_enterpriseURI, null);
        xMLWriter.writeIntElement(for, this.int, null);
    }

    @Override
    public void startElement(String string, Map<Object, Object> map, Attributes attributes) {
    }

    @Override
    public void copyTo(Object object, boolean bl2) {
        LOVDataSource lOVDataSource = (LOVDataSource)object;
        lOVDataSource.m_lovdsName = this.m_lovdsName;
        if (this.m_lovObjects != null && bl2) {
            if (CloneUtil.canCopyTo(this.m_lovObjects, lOVDataSource.m_lovObjects)) {
                this.m_lovObjects.copyTo(lOVDataSource.m_lovObjects, bl2);
            } else {
                lOVDataSource.m_lovObjects = (ClonableList)this.m_lovObjects.clone(bl2);
            }
        } else {
            lOVDataSource.m_lovObjects = this.m_lovObjects;
        }
        lOVDataSource.m_locale = this.m_locale;
        lOVDataSource.m_additionalInfo = this.m_additionalInfo;
        lOVDataSource.m_enterpriseToken = this.m_enterpriseToken;
        lOVDataSource.m_objectTypeName = this.m_objectTypeName;
        lOVDataSource.m_uuid = this.m_uuid;
        lOVDataSource.m_enterpriseURI = this.m_enterpriseURI;
        lOVDataSource.int = this.int;
    }

    @Override
    public boolean hasContent(Object object) {
        if (!(object instanceof LOVDataSource)) {
            return false;
        }
        LOVDataSource lOVDataSource = (LOVDataSource)object;
        if (!CloneUtil.equalStrings(this.m_lovdsName, lOVDataSource.m_lovdsName)) {
            return false;
        }
        if (!CloneUtil.hasContent(this.m_lovObjects, lOVDataSource.m_lovObjects)) {
            return false;
        }
        if (!CloneUtil.equalObjects(this.m_locale, lOVDataSource.m_locale)) {
            return false;
        }
        if (!CloneUtil.equalStrings(this.m_additionalInfo, lOVDataSource.m_additionalInfo)) {
            return false;
        }
        if (!CloneUtil.equalStrings(this.m_enterpriseToken, lOVDataSource.m_enterpriseToken)) {
            return false;
        }
        if (!CloneUtil.equalStrings(this.m_objectTypeName, lOVDataSource.m_objectTypeName)) {
            return false;
        }
        if (!CloneUtil.equalObjects(this.m_uuid, lOVDataSource.m_uuid)) {
            return false;
        }
        if (!CloneUtil.equalStrings(this.m_enterpriseURI, lOVDataSource.m_enterpriseURI)) {
            return false;
        }
        return this.int == lOVDataSource.int;
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return this.m_enterpriseURI != null && this.m_enterpriseURI.trim().length() != 0;
    }

    @Override
    public void refresh() {
    }

    @Override
    public String getLinkedURI() {
        return this.getEnterpriseURI();
    }

    @Override
    public int getVersion() {
        return this.int;
    }

    @Override
    public void setLinkedURI(String string) {
        this.setEnterpriseURI(string);
    }

    @Override
    public void setVersion(int n2) {
        this.int = n2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NullLOVDataSource
    extends LOVDataSource {
        public NullLOVDataSource() {
            this.m_objectTypeName = "NullLOV";
        }

        @Override
        public ILOVRowset getLOVRowset(ILOVContext iLOVContext) {
            return null;
        }

        @Override
        public Object clone(boolean bl2) {
            NullLOVDataSource nullLOVDataSource = new NullLOVDataSource();
            return nullLOVDataSource;
        }

        @Override
        public ClonableList<ILOVObject> getLOVObjects() {
            return null;
        }

        @Override
        public void putLOVObjects(ClonableList<ILOVObject> clonableList) {
        }

        @Override
        public void save(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
            throw new IOException("Cannot Serialize NullLOVObj");
        }

        @Override
        public void save(XMLWriter xMLWriter, String string, XMLSerializationContext xMLSerializationContext) throws IOException {
            throw new IOException("Cannot Serialize NullLOVObj");
        }

        @Override
        public void saveContents(XMLWriter xMLWriter, XMLSerializationContext xMLSerializationContext) throws IOException {
            throw new IOException("Cannot Serialize NullLOVObj");
        }
    }
}

