/*
 * Decompiled with CFR 0.152.
 */
package com.crystaldecisions.reports.queryengine.driverImpl.jdbc;

import com.businessobjects.reports.jdbinterface.common.FieldKind;
import com.businessobjects.reports.jdbinterface.common.ParameterInfo;
import com.businessobjects.reports.jdbinterface.connection.LogonOptions;
import com.businessobjects.reports.jdbinterface.connection.LogonProperty;
import com.crystaldecisions.reports.common.value.CrystalValue;
import com.crystaldecisions.reports.common.value.StringValue;
import com.crystaldecisions.reports.common.value.ValueType;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class JDBCLogonInfo {
    public static final String DATABASE_PLACE_HOLDER = "{database}";
    public static final String USER_ID_PLACE_HOLDER = "{userid}";
    public static final String PASSWORD_PLACE_HOLDER = "{password}";
    public static final String USE_JDBC = "Use JDBC";
    public static final String USE_JNDI = "Use JNDI";
    public static final String USE_JDBC_DSN = "Use JDBC DSN";
    public static final String DSN = "dsn";
    public static final String DATA_SOURCE = "data source";
    public static final String SERVER = "Server";
    public static final String DATABASE = "Database";
    public static final String USER_ID = "User ID";
    public static final String PASSWORD = "Password";
    public static final String JDBC_SUBCONTEXT_PREFIX = "java:comp/env/jdbc/";
    public static final String DATABASE_DLL = "DatabaseDll";
    public static final String JDBC_CONNECTION_STRING = "JDBC Connection String";
    public static final String JDBC_CONNECTION_URL = "Connection URL";
    public static final String INITIAL_CONTEXT_FACTORY = "Initial Context Factory";
    public static final String JNDI_PROVIDER_URL = "JNDI Provider URL";
    public static final String JNDI_USER_NAME = "JNDI User Name";
    public static final String JNDI_USER_NAME2 = "JNDI Username";
    public static final String JNDI_PASSWORD = "JNDI Password";
    public static final String INITIAL_CONTEXT = "Initial Context";
    public static final String JNDI_DATA_SOURCE_NAME = "JNDI Data Source Name";
    public static final String JNDI_DATA_SOURCE_NAME2 = "JNDI DataSource Name";
    public static final String CONNECTION_NAME = "Connection Name";
    public static final String PreQEServerName = "PreQEServerName";
    public static final String JDBC_DSN_LIST = "JDBC DSN List";
    public static final String JDBC_DATABASE_CLASSNAME = "Database Class Name";
    public static final String OracleJDBCSignature = "oracle.jdbc";
    public static final String SQLJDBCClassName = "com.microsoft.jdbc.sqlserver.SQLServerDriver";
    public static final String JNDI_CONNECTION_STRING = "JNDI Connection String";
    public static final String TRUSTED_CONNECTION = "Trusted_Connection";
    public static final String CONNECTION_STRING = "Connection String";
    public static final String PreQEServerType = "PreQEServerType";
    public static final String DRIVER_JAR_FILES = "DriverJarFiles";
    static final String[] if = new String[]{"JNDI Data Source Name", "JNDI DataSource Name", "Connection Name", "Initial Context Factory", "Connection URL", "JDBC Connection String", "JDBC DSN List", "PreQEServerName", "dsn", "Database", "DatabaseDll", "data source", "Database Class Name", "Initial Context", "JNDI Provider URL", "JNDI User Name", "JNDI Username", "JNDI Password", "Trusted_Connection", "User ID", "Password", "Use JDBC", "Use JDBC DSN", "Use JNDI", "Server", "DriverJarFiles"};
    List<ParameterInfo> a = new ArrayList<ParameterInfo>();
    public String jndiName = null;
    public String connectionURL = null;
    public String jdbcConnectionString = null;
    public String database = null;
    public String userID = "";
    public String password = "";
    public String databaseDLL = null;
    public String connectionString = null;
    public String initialContext = null;
    public String jndiUserName = null;
    public String jdbcClassName = null;
    public String jdbcURL = null;
    public boolean validClassNameAndURL = true;
    public String driverClassName = null;
    public String urlFromParsedConnectionString = null;
    public boolean useConnectionName = false;

    public List<ParameterInfo> getLogonProperties(LogonOptions logonOptions) {
        List<ParameterInfo> list = null;
        if (logonOptions == LogonOptions.ForLogon) {
            list = this.getLogonPropertiesForLogon();
        } else if (logonOptions == LogonOptions.ForSave) {
            list = this.getLogonPropertiesForSave();
        }
        return list;
    }

    public List<ParameterInfo> getCurrentLogonProperties() {
        return this.a;
    }

    public List<ParameterInfo> getLogonPropertiesForLogon() {
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        int n = if.length;
        for (int i = 0; i < n; ++i) {
            ParameterInfo parameterInfo = new ParameterInfo();
            parameterInfo.m_Name = if[i];
            parameterInfo.fieldKind = FieldKind.parameter;
            arrayList.add(parameterInfo);
        }
        return arrayList;
    }

    public List<ParameterInfo> getLogonPropertiesForSave() {
        ParameterInfo parameterInfo;
        ArrayList<ParameterInfo> arrayList = new ArrayList<ParameterInfo>();
        boolean bl = false;
        String string = null;
        ParameterInfo parameterInfo2 = null;
        for (ParameterInfo parameterInfo3 : this.a) {
            String string2 = parameterInfo3.m_Name;
            if (string2.compareToIgnoreCase(CONNECTION_STRING) == 0 || string2.compareToIgnoreCase(PreQEServerType) == 0) continue;
            CrystalValue crystalValue = parameterInfo3.currentValue;
            if (string2.compareToIgnoreCase(PreQEServerName) == 0) {
                string = crystalValue.toString();
                if (!string.startsWith("s(") || !string.endsWith(")")) continue;
                string = string.substring(2, string.length() - 1);
                continue;
            }
            ParameterInfo parameterInfo4 = new ParameterInfo();
            if (string2.compareToIgnoreCase(CONNECTION_NAME) == 0 || string2.compareToIgnoreCase(JNDI_DATA_SOURCE_NAME) == 0 || string2.compareToIgnoreCase(JNDI_DATA_SOURCE_NAME2) == 0) {
                parameterInfo2 = parameterInfo4;
            }
            if (parameterInfo2 == null && this.a(string2, LogonProperty.ServerNamePseudonyms)) {
                parameterInfo2 = parameterInfo4;
            }
            parameterInfo4.m_Name = string2;
            parameterInfo4.dataType = parameterInfo3.dataType;
            if (this.a(string2, LogonProperty.JDBCConnStringPseudonyms)) {
                this.jdbcConnectionString = JDBCLogonInfo.clearPasswordInConnectionString(this.connectionString, true);
                if (this.jdbcConnectionString == null) {
                    this.jdbcConnectionString = "";
                }
                crystalValue = StringValue.fromString((String)this.jdbcConnectionString);
                bl = true;
            } else if (this.a(string2, LogonProperty.ServerPseudonyms)) {
                this.connectionURL = JDBCLogonInfo.clearPasswordInConnectionString(this.jdbcURL, false);
                crystalValue = StringValue.fromString((String)this.connectionURL);
            }
            parameterInfo4.currentValue = crystalValue;
            parameterInfo4.m_Attributes = parameterInfo3.m_Attributes;
            arrayList.add(parameterInfo4);
        }
        if (!bl && !this.useConnectionName && this.connectionString != null && this.connectionString.length() > 0) {
            parameterInfo = new ParameterInfo();
            parameterInfo.m_Name = JDBC_CONNECTION_STRING;
            parameterInfo.dataType = ValueType.string;
            this.jdbcConnectionString = JDBCLogonInfo.clearPasswordInConnectionString(this.connectionString, true);
            parameterInfo.currentValue = StringValue.fromString((String)this.jdbcConnectionString);
            arrayList.add(parameterInfo);
        }
        if (string != null && parameterInfo2 != null) {
            arrayList.remove(parameterInfo2);
            parameterInfo = new ParameterInfo();
            parameterInfo.m_Name = parameterInfo2.m_Name;
            parameterInfo.dataType = ValueType.string;
            parameterInfo.currentValue = StringValue.fromString(string);
            parameterInfo.m_Attributes = parameterInfo2.m_Attributes;
            arrayList.add(parameterInfo);
        } else if (string != null) {
            parameterInfo = new ParameterInfo();
            parameterInfo.m_Name = SERVER;
            parameterInfo.dataType = ValueType.string;
            parameterInfo.currentValue = StringValue.fromString(string);
            arrayList.add(parameterInfo);
        }
        return arrayList;
    }

    public void setLogonProperties(List<ParameterInfo> list) {
        this.a.clear();
        for (ParameterInfo parameterInfo : list) {
            this.a.add(parameterInfo);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void processLogonInfo() {
        String string;
        Object object;
        ArrayList<PropertyToken> arrayList = new ArrayList<PropertyToken>();
        boolean bl = false;
        for (ParameterInfo object3 : this.a) {
            String string2 = object3.m_Name.toUpperCase();
            object = object3.currentValue;
            if (object == null) continue;
            if (string2.indexOf("PASSWORD") < 0) {
                if (!(object instanceof StringValue)) continue;
                string = (StringValue)object;
                PropertyToken propertyToken = new PropertyToken(string2, string.getString());
                arrayList.add(propertyToken);
                continue;
            }
            bl = true;
            if (!(object instanceof StringValue)) continue;
            string = (StringValue)object;
            this.password = string.getString();
        }
        if (!bl) {
            arrayList.add(new PropertyToken(TRUSTED_CONNECTION, "true"));
        }
        Object object4 = null;
        for (PropertyToken propertyToken : arrayList) {
            object = propertyToken.name;
            string = propertyToken.value;
            if (((String)object).compareToIgnoreCase(JNDI_DATA_SOURCE_NAME) == 0 || ((String)object).compareToIgnoreCase(JNDI_DATA_SOURCE_NAME2) == 0 || ((String)object).compareToIgnoreCase(CONNECTION_NAME) == 0) {
                this.useConnectionName = true;
                object4 = string;
                continue;
            }
            if (((String)object).compareToIgnoreCase(USE_JDBC_DSN) == 0 && string.compareToIgnoreCase("true") == 0) {
                this.useConnectionName = true;
                continue;
            }
            if (((String)object).compareToIgnoreCase(JDBC_DSN_LIST) == 0) {
                object4 = string;
                continue;
            }
            if (this.a((String)object, LogonProperty.ServerNamePseudonyms) || ((String)object).compareToIgnoreCase(PreQEServerName) == 0) {
                if (((String)object).compareToIgnoreCase(PreQEServerName) == 0 && string.startsWith("jdbc:")) {
                    this.jdbcURL = string;
                    continue;
                }
                this.jndiName = string;
                continue;
            }
            if (this.a((String)object, LogonProperty.DatabaseNamePseudonyms)) {
                this.database = string;
                continue;
            }
            if (this.a((String)object, LogonProperty.UserIdPseudonyms)) {
                this.userID = string;
                continue;
            }
            if (this.a((String)object, LogonProperty.DatabaseDLLPseudonyms)) {
                this.databaseDLL = string;
                continue;
            }
            if (this.a((String)object, LogonProperty.JDBCConnStringPseudonyms)) {
                this.connectionString = string;
                continue;
            }
            if (((String)object).compareToIgnoreCase(INITIAL_CONTEXT) == 0) {
                this.initialContext = string;
                continue;
            }
            if (((String)object).compareToIgnoreCase(JNDI_USER_NAME) == 0 || ((String)object).compareToIgnoreCase(JNDI_USER_NAME2) == 0) {
                this.jndiUserName = string;
                continue;
            }
            if (((String)object).compareToIgnoreCase(JDBC_DATABASE_CLASSNAME) == 0) {
                this.jdbcClassName = string;
                continue;
            }
            if (!this.a((String)object, LogonProperty.ServerPseudonyms)) continue;
            this.jdbcURL = string;
        }
        if (this.useConnectionName && object4 != null && ((String)object4).length() != 0) {
            this.jndiName = object4;
        }
        if (this.jdbcClassName != null && this.jdbcClassName.length() > 0 && this.jdbcURL != null && this.jdbcURL.length() > 0) {
            void var4_21;
            void var5_29;
            void var4_13;
            String string3 = "!" + this.jdbcClassName + "!";
            String string4 = ";";
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (this.jdbcClassName.indexOf(OracleJDBCSignature) >= 0) {
                String string5 = JDBCLogonInfo.a(this.jdbcURL, true);
                String string6 = string3 + string5;
                if (string5.length() == 0) {
                    this.validClassNameAndURL = false;
                }
            } else if (this.jdbcClassName.compareToIgnoreCase(SQLJDBCClassName) == 0) {
                String string7 = string3 + this.jdbcURL;
                String string8 = ";";
                if (this.jdbcURL.toLowerCase().indexOf("databasename=") < 0) {
                    bl2 = true;
                }
                if (this.jdbcURL.toLowerCase().indexOf("user=") < 0) {
                    bl3 = true;
                }
                if (this.jdbcURL.toLowerCase().indexOf("password=") < 0) {
                    bl4 = true;
                }
            } else if (this.jdbcClassName.toLowerCase().startsWith("com.mysql") || this.jdbcClassName.toLowerCase().startsWith("org.gjt.mm.mysql")) {
                String string9 = string3 + this.jdbcURL;
                String string10 = "&";
                if (this.jdbcURL.toLowerCase().indexOf("user=") == -1) {
                    String string11 = string9 + "?user={userid}";
                }
                if (this.jdbcURL.toLowerCase().indexOf("password=") == -1) {
                    bl4 = true;
                }
            } else {
                String string12 = string3 + this.jdbcURL;
                String string13 = "!";
                if (this.jdbcURL.toLowerCase().indexOf("user=") == -1) {
                    bl3 = true;
                }
                if (this.jdbcURL.toLowerCase().indexOf("password=") == -1) {
                    bl4 = true;
                }
            }
            if (var4_13.endsWith((String)var5_29)) {
                String string14 = var4_13.substring(0, var4_13.length() - 1);
            }
            if (bl2) {
                void var4_15;
                String string15 = (String)var4_15 + (String)var5_29 + "DatabaseName=" + DATABASE_PLACE_HOLDER;
            }
            if (bl3) {
                void var4_17;
                String string16 = (String)var4_17 + (String)var5_29 + "user=" + USER_ID_PLACE_HOLDER;
            }
            if (bl4) {
                void var4_19;
                String string17 = (String)var4_19 + (String)var5_29 + "password=" + PASSWORD_PLACE_HOLDER;
            }
            this.connectionString = var4_21;
        }
    }

    private static String a(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return "";
        }
        String string2 = "";
        if (bl) {
            string2 = "{userid}/{password}";
        }
        String string3 = "jdbc:oracle:thin:";
        int n = string.indexOf(string3);
        int n2 = string.lastIndexOf(64);
        if (n == -1) {
            string3 = "jdbc:oracle:oci:";
            n = string.indexOf(string3);
        }
        string = n != -1 && n2 != -1 ? string.substring(0, n) + string3 + string2 + string.substring(n2, string.length()) : "";
        return string;
    }

    public static String clearPasswordInConnectionString(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (string.toLowerCase().indexOf("jdbc:oracle") >= 0 && string.toLowerCase().indexOf(USER_ID_PLACE_HOLDER) < 0 && string.toLowerCase().indexOf(PASSWORD_PLACE_HOLDER) < 0) {
            string = JDBCLogonInfo.a(string, bl);
        }
        String[] stringArray = new String[]{"password=", "pwd="};
        String string2 = string.toLowerCase();
        int n = string.length();
        int n2 = -1;
        block0: for (int i = 0; i < stringArray.length; ++i) {
            int n3 = 0;
            while (n3 != -1) {
                if ((n3 = string2.indexOf(stringArray[i], n3)) == -1) continue;
                if (!string2.substring(n3 + stringArray[i].length()).startsWith(PASSWORD_PLACE_HOLDER) && n > n3) {
                    n = n3;
                    n2 = i;
                    continue block0;
                }
                ++n3;
            }
        }
        String string3 = string.substring(0, n);
        if (n2 != -1) {
            string3 = string3 + stringArray[n2] + PASSWORD_PLACE_HOLDER;
        }
        return string3;
    }

    public void parseJDBCConnectionString(String string, String string2, String string3, String string4, Properties properties) {
        if (string == null || string.length() < 2 || properties == null) {
            return;
        }
        String string5 = String.valueOf(string.charAt(0));
        string = string.substring(1);
        this.driverClassName = null;
        String string6 = null;
        properties.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string5);
        if (stringTokenizer.hasMoreTokens()) {
            this.driverClassName = stringTokenizer.nextToken();
        }
        while (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
            if ((string6 = this.a(string6, string2, string3, string4)) == null || string6.toUpperCase().indexOf("JDBC:") < 0) continue;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string7 = stringTokenizer.nextToken();
            int n = string7.indexOf(61);
            if (n == -1) continue;
            String string8 = string7.substring(0, n);
            String string9 = string7.substring(n + 1);
            string9 = this.a(string9, string2, string3, string4);
            properties.setProperty(string8, string9);
        }
        this.urlFromParsedConnectionString = string6;
    }

    private String a(String string, String string2, String string3, String string4) {
        if (string == null) {
            return null;
        }
        String string5 = string;
        if (string2 == null) {
            string2 = "";
        }
        string5 = this.a(string5, DATABASE_PLACE_HOLDER, string2);
        if (string3 != null) {
            string5 = this.a(string5, USER_ID_PLACE_HOLDER, string3);
        }
        if (string4 != null) {
            string5 = this.a(string5, PASSWORD_PLACE_HOLDER, string4);
        }
        return string5;
    }

    private String a(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        int n = string.toUpperCase().indexOf(string2.toUpperCase());
        if (n < 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.replace(n, n + string2.length(), string3);
        return stringBuffer.toString();
    }

    private boolean a(String string, String[] stringArray) {
        if (null == stringArray || null == string) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private class PropertyToken {
        public String name;
        public String value;

        public PropertyToken(String string, String string2) {
            this.name = string;
            this.value = string2;
        }
    }
}

