/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.sql.AttributeDescriptor;
import oracle.sql.TypeDescriptor;

class Kotad {
    static final int KOTADSIG = -1365573631;
    static final int KOTPDSIG = -1365442559;
    static final int KOTRDSIG = -1365377023;
    static final int KOTCDSIG = -1365311487;
    static final int KOTODSIG = -1365307391;
    static final int KOTADXSIG = -1365303295;
    static final int KOTADPRV = 1;
    static final int KOTADPUB = 2;
    static final int KOTADCNT = 4;
    static final int KOTADCFM = 248;
    static final int KOTADSUB = 256;
    static final int KOTADPTR = 16384;
    static final int KOTADREF = 32768;
    static final int KOTADCNN = 65536;
    static final int KOTADCFN = 131072;
    static final int KOTADCVN = 262144;
    static final int KOTADTRN = 512;
    static final int KOTADCPT = 4096;
    static final int KOTADIN = 256;
    static final int KOTADOUT = 512;
    static final int KOTADCBR = 1024;
    static final int KOTADREQ = 2048;
    static final int KOTADNCP = 0x100000;
    private int kotadkvn;
    private byte[] kotadnam;
    private byte[] kotadtrf;
    private short kotadtvn;
    private short kotadid;
    private byte[] kotadprf;
    private short kotadpvn;
    private int kotadflg;
    private long kotadpre;
    private int kotadcid;
    private byte kotadscl;
    private int kotadcne;
    private byte[] kotaddft;
    private long kotadtyp;
    private byte[] kotadadd;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    private Kotad() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Kotad unpickleKotad(PickleContext context) throws SQLException {
        Kotad kotad;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(context));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Kotad kotad2 = new Kotad();
            context.skipBytes(2);
            long length = context.readLength(true) - 2;
            context.skipBytes(1);
            kotad2.kotadkvn = (int)context.readUB4();
            kotad2.kotadnam = context.readDataValue();
            kotad2.kotadtrf = context.readDataValue();
            context.skipBytes(1);
            kotad2.kotadtvn = (short)context.readUB2();
            context.skipBytes(1);
            kotad2.kotadid = (short)context.readUB2();
            kotad2.kotadprf = context.readDataValue();
            context.skipBytes(1);
            kotad2.kotadpvn = (short)context.readUB2();
            context.skipBytes(1);
            kotad2.kotadflg = (int)context.readUB4();
            context.skipBytes(1);
            kotad2.kotadpre = context.readUB4();
            context.skipBytes(1);
            kotad2.kotadcid = context.readUB2();
            context.skipBytes(1);
            kotad2.kotadscl = context.readByte();
            context.skipBytes(1);
            kotad2.kotadcne = (int)context.readUB4();
            kotad2.kotaddft = context.readDataValue();
            context.skipBytes(1);
            kotad2.kotadtyp = context.readUB4();
            kotad2.kotadadd = context.readDataValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Return: " + kotad2);
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            kotad = kotad2;
            Object var7_10 = null;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Exit");
                    Object var9_14 = null;
                }
                catch (Throwable throwable2) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                Kotad.logger().log(Level.FINER, "         Exit");
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return kotad;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final TypeDescriptor unpickleTypeDescriptorImage(PickleContext context) throws SQLException {
        TypeDescriptor typeDescriptor;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(context));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Kotad kotad = Kotad.unpickleKotad(context);
            if (kotad.kotadkvn != -1365311487) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(OracleLog.TRACE_20, "         Debug: Kotad.unpickleTypeDescriptorImage: encountered a non-collection type description for what a predefined type.");
                        Object var4_5 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_6 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 179");
                        Object var6_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_10 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 179);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            TypeDescriptor td = Kotad.constructPredefinedTypeDescriptor(kotad);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Return: " + td);
                    Object var8_12 = null;
                }
                catch (Throwable throwable) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            typeDescriptor = td;
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Exit");
                    Object var12_19 = null;
                }
                catch (Throwable throwable2) {
                    Object var12_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                Kotad.logger().log(Level.FINER, "         Exit");
                Object var12_17 = null;
            }
            catch (Throwable throwable) {
                Object var12_18 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return typeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    static final AttributeDescriptor unpickleAttributeImage(boolean isPredefined, PickleContext context) throws SQLException {
        AttributeDescriptor attributeDescriptor;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(isPredefined) + ", " + OracleLog.argument(context));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Kotad kotad = Kotad.unpickleKotad(context);
            if (kotad.kotadkvn != -1365573631) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(OracleLog.TRACE_20, "         Debug: Kotad.unpickleAttributeImage: the type isn't an attribute.");
                        Object var5_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 179");
                        Object var7_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 179);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            TypeDescriptor td = null;
            if (isPredefined) {
                td = Kotad.constructPredefinedTypeDescriptor(kotad);
            }
            AttributeDescriptor ret = new AttributeDescriptor(new String(kotad.kotadnam), kotad.kotadid, kotad.kotadflg, td);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Return: " + ret);
                    Object var9_14 = null;
                }
                catch (Throwable throwable) {
                    Object var9_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            attributeDescriptor = ret;
            Object var11_17 = null;
        }
        catch (Throwable throwable) {
            Object var11_18 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Exit");
                    Object var13_21 = null;
                }
                catch (Throwable throwable2) {
                    Object var13_22 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                Kotad.logger().log(Level.FINER, "         Exit");
                Object var13_19 = null;
            }
            catch (Throwable throwable) {
                Object var13_20 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return attributeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final TypeDescriptor constructPredefinedTypeDescriptor(Kotad kotad) throws SQLException {
        TypeDescriptor typeDescriptor;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Enter: " + OracleLog.argument(kotad));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (kotad.kotadtrf.length != 36) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(OracleLog.TRACE_20, "         Debug: kotadtrf is malformed");
                        Object var4_6 = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_7 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 180");
                        Object var6_10 = null;
                    }
                    catch (Throwable throwable) {
                        Object var6_11 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 180);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            for (int i2 = 4; i2 < 18; ++i2) {
                if (kotad.kotadtrf[i2] == 0) continue;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(OracleLog.TRACE_20, "         Debug: this CREF isn't for a predefined type.");
                        Object var8_13 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_14 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        Kotad.logger().log(Level.SEVERE, "         Throwing SQLException: 180");
                        Object var10_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                SQLException __ex__ = DatabaseError.createSqlException(null, 180);
                __ex__.fillInStackTrace();
                throw __ex__;
            }
            short rdbmsTypeCode = TypeDescriptor.OID_TO_TYPECODE[kotad.kotadtrf[19]];
            TypeDescriptor td = new TypeDescriptor(rdbmsTypeCode);
            td.setPrecision(kotad.kotadpre);
            td.setScale(kotad.kotadscl);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Return: " + td);
                    Object var12_19 = null;
                }
                catch (Throwable throwable) {
                    Object var12_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            typeDescriptor = td;
            Object var14_22 = null;
        }
        catch (Throwable throwable) {
            Object var14_23 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, "         Exit");
                    Object var16_26 = null;
                }
                catch (Throwable throwable2) {
                    Object var16_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                Kotad.logger().log(Level.FINER, "         Exit");
                Object var16_24 = null;
            }
            catch (Throwable throwable) {
                Object var16_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return typeDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected OracleConnection getConnectionDuringExceptionHandling() {
        OracleConnection oracleConnection;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + null);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            oracleConnection = null;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    Kotad.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                Kotad.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return oracleConnection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.Kotad"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

