/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import javax.net.ssl.SSLSocket;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;

public class TcpsConfigure {
    static final boolean DEBUG = false;
    public static final String[] VALID_SSL_VERSION_STRINGS = new String[]{"0", "undetermined", "2", "2.0", "version 2", "3", "3.0", "version 3 only", "1", "1.0", "version 1 only", "1 or 3", "1.0 or 3.0", "version 1 or version 3"};
    public static final String[][] TABLE_ENABLED_SSL_PROTOCOLS = new String[][]{{"TLSv1", "SSLv3", "SSLv2Hello"}, {"SSLv2Hello"}, {"SSLv3"}, {"TLSv1"}, {"TLSv1", "SSLv3"}};
    public static final int[] VALID_SSL_STRING_TO_PROTOCOLS_MAP = new int[]{0, 0, 1, 1, 1, 2, 2, 2, 3, 3, 3, 4, 4, 4};

    private TcpsConfigure() {
    }

    public static void configureVersion(SSLSocket sslSocket, String sslVersionString) throws NetException, IOException {
        if (sslVersionString == null) {
            sslVersionString = System.getProperty("oracle.net.ssl_version");
        }
        int validSSLVersionIndex = 0;
        if (sslVersionString != null) {
            sslVersionString = sslVersionString.startsWith("(") && sslVersionString.endsWith(")") ? "(ssl_version=" + sslVersionString.substring(1) : "(ssl_version=" + sslVersionString + ")";
            try {
                NVPair nvpVersion = new NVFactory().createNVPair(sslVersionString);
                String sslVersion = nvpVersion.getAtom();
                for (int i2 = 0; i2 < VALID_SSL_VERSION_STRINGS.length; ++i2) {
                    if (!sslVersion.equalsIgnoreCase(VALID_SSL_VERSION_STRINGS[i2])) continue;
                    validSSLVersionIndex = i2;
                    break;
                }
            }
            catch (NLException ex) {
                throw (NetException)new NetException(400, sslVersionString).initCause(ex);
            }
        }
        if (validSSLVersionIndex >= VALID_SSL_VERSION_STRINGS.length) {
            throw new NetException(400);
        }
        String[] enabledProtocols = TABLE_ENABLED_SSL_PROTOCOLS[VALID_SSL_STRING_TO_PROTOCOLS_MAP[validSSLVersionIndex]];
        try {
            sslSocket.setEnabledProtocols(enabledProtocols);
        }
        catch (IllegalArgumentException ex) {
            throw (NetException)new NetException(401).initCause(ex);
        }
    }

    public static void configureCipherSuites(SSLSocket sslSocket, String cipherSuitesString) throws NetException, IOException {
        if (cipherSuitesString == null) {
            cipherSuitesString = System.getProperty("oracle.net.ssl_cipher_suites");
        }
        if (cipherSuitesString == null) {
            return;
        }
        cipherSuitesString = cipherSuitesString.startsWith("(") && cipherSuitesString.endsWith(")") ? "(cipher_suites=" + cipherSuitesString + ")" : "(cipher_suites=(" + cipherSuitesString + "))";
        try {
            NVPair nvpCipher = new NVFactory().createNVPair(cipherSuitesString);
            String[] listCipherSuites = new String[nvpCipher.getListSize()];
            if (nvpCipher.getRHSType() == NVPair.LIST_COMMASEP || nvpCipher.getRHSType() == NVPair.RHS_LIST) {
                for (int i2 = 0; i2 < nvpCipher.getListSize(); ++i2) {
                    listCipherSuites[i2] = nvpCipher.getListElement(i2).getName();
                }
            } else {
                throw new NetException(403, cipherSuitesString);
            }
            sslSocket.setEnabledCipherSuites(listCipherSuites);
        }
        catch (NLException ex) {
            throw new NetException(403, cipherSuitesString);
        }
        catch (IllegalArgumentException ex) {
            throw (NetException)new NetException(404).initCause(ex);
        }
    }

    public static boolean matchServerDN(String serverDN, String userDN, boolean fullMatch) {
        if ((serverDN = TcpsConfigure.normalizeDN(serverDN)) == null) {
            return false;
        }
        if (fullMatch) {
            if ((userDN = TcpsConfigure.normalizeDN(userDN)) == null) {
                return false;
            }
            if (userDN.equals(serverDN)) {
                return true;
            }
            return userDN.equals(serverDN = TcpsConfigure.reverseDN(serverDN));
        }
        int startIndex = serverDN.indexOf("CN=");
        return startIndex != -1 && userDN.equals(serverDN = serverDN.indexOf(44, startIndex) != -1 ? serverDN.substring(startIndex, serverDN.indexOf(44, startIndex)) : serverDN.substring(startIndex));
    }

    public static String normalizeDN(String dn) {
        StringBuffer normalizedDN = new StringBuffer();
        String attribute = null;
        String value = null;
        int currentIndex = 0;
        int prevIndex = 0;
        dn = dn.trim();
        while ((currentIndex = dn.indexOf(61, currentIndex)) != -1) {
            attribute = dn.substring(prevIndex, currentIndex);
            attribute = attribute.trim();
            normalizedDN.append(attribute.toUpperCase());
            normalizedDN.append('=');
            prevIndex = currentIndex;
            if (prevIndex >= dn.length() - 1) {
                return null;
            }
            if ((currentIndex = dn.indexOf(44, currentIndex)) == -1) {
                value = dn.substring(prevIndex + 1);
                normalizedDN.append(value.trim());
                break;
            }
            value = dn.substring(prevIndex + 1, currentIndex);
            normalizedDN.append(value.trim());
            normalizedDN.append(',');
            if (currentIndex >= dn.length() - 1) {
                return null;
            }
            prevIndex = currentIndex + 1;
        }
        return normalizedDN.toString();
    }

    public static String reverseDN(String dn) {
        int currentIndex;
        StringBuffer reversedDN = new StringBuffer();
        String pair = null;
        int prevIndex = currentIndex = dn.length();
        do {
            if ((currentIndex = dn.lastIndexOf(44, currentIndex)) == -1) {
                reversedDN.append(dn.substring(0, prevIndex));
                break;
            }
            pair = dn.substring(currentIndex + 1, prevIndex);
            reversedDN.append(pair);
            reversedDN.append(',');
            prevIndex = currentIndex--;
        } while (currentIndex != -1);
        return reversedDN.toString();
    }
}

