/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.OracleLog;

public class OracleMultiPhaseArgs {
    int action = 0;
    int nsites = 0;
    Vector dbLinks = null;
    Vector xids = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleMultiPhaseArgs(int _action, int _nsites, Vector _xids, Vector _dbLinks) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(_action) + ", " + OracleLog.argument(_nsites) + ", " + OracleLog.argument(_xids) + ", " + OracleLog.argument(_dbLinks));
                    Object var6_5 = null;
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (_nsites <= 1) {
                this.action = 0;
                this.nsites = 0;
                this.dbLinks = null;
                this.xids = null;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleMultiPhaseArgs(_, _nsites, _, _): _nsites <= 1");
                        Object var8_8 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            } else if (_xids.isEmpty() || _dbLinks.isEmpty() || _dbLinks.size() != _nsites || _xids.size() != 3 * _nsites) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleMultiPhaseArgs(_, _, _, _): invalid parameters");
                        Object var10_11 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_12 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
            } else {
                this.action = _action;
                this.nsites = _nsites;
                this.xids = _xids;
                this.dbLinks = _dbLinks;
            }
            Object var12_14 = null;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var14_18 = null;
                }
                catch (Throwable throwable2) {
                    Object var14_19 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var14_16 = null;
            }
            catch (Throwable throwable) {
                Object var14_17 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public OracleMultiPhaseArgs(byte[] inBytes) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(inBytes));
                    Object var3_2 = null;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "OracleMultiPhaseArgs(inBytes.length = " + inBytes.length + ")");
                    Object var5_6 = null;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            ByteArrayInputStream byteArrayIS = new ByteArrayInputStream(inBytes);
            DataInputStream dataIS = new DataInputStream(byteArrayIS);
            this.xids = new Vector();
            this.dbLinks = new Vector();
            try {
                this.action = dataIS.readInt();
                this.nsites = dataIS.readInt();
                int fmtid = dataIS.readInt();
                int gtridLen = dataIS.readInt();
                byte[] gtrid = new byte[gtridLen];
                int gtridRead = dataIS.read(gtrid, 0, gtridLen);
                for (int i2 = 0; i2 < this.nsites; ++i2) {
                    int bqualLen = dataIS.readInt();
                    byte[] bqual = new byte[bqualLen];
                    int bqualRead = dataIS.read(bqual, 0, bqualLen);
                    this.xids.addElement(fmtid);
                    this.xids.addElement(gtrid);
                    this.xids.addElement(bqual);
                    String dblink = dataIS.readUTF();
                    this.dbLinks.addElement(dblink);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    this.printMPArgs();
                    Object var14_19 = null;
                }
                catch (Throwable throwable) {
                    Object var14_20 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var16_22 = null;
        }
        catch (Throwable throwable) {
            Object var16_23 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var18_26 = null;
                }
                catch (Throwable throwable2) {
                    Object var18_27 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var18_24 = null;
            }
            catch (Throwable throwable) {
                Object var18_25 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] toByteArray() {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    byArray = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byte[] __result__ = this.toByteArrayOS().toByteArray();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + __result__);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byArray = __result__;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteArrayOutputStream toByteArrayOS() {
        ByteArrayOutputStream byteArrayOutputStream;
        byte[] gtridCommon = null;
        int fmtidCommon = 0;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            ByteArrayOutputStream byteArrayOS = new ByteArrayOutputStream();
            DataOutputStream dataOS = new DataOutputStream(byteArrayOS);
            try {
                dataOS.writeInt(this.action);
                dataOS.writeInt(this.nsites);
                for (int i2 = 0; i2 < this.nsites; ++i2) {
                    String dblink = (String)this.dbLinks.elementAt(i2);
                    int fmtid = (Integer)this.xids.elementAt(i2 * 3);
                    byte[] gtrid = (byte[])this.xids.elementAt(i2 * 3 + 1);
                    byte[] bqual = (byte[])this.xids.elementAt(i2 * 3 + 2);
                    if (i2 == 0) {
                        fmtidCommon = fmtid;
                        gtridCommon = gtrid;
                        dataOS.writeInt(fmtid);
                        dataOS.writeInt(gtrid.length);
                        dataOS.write(gtrid, 0, gtrid.length);
                    }
                    dataOS.writeInt(bqual.length);
                    dataOS.write(bqual, 0, bqual.length);
                    dataOS.writeUTF(dblink);
                }
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    this.printMPArgs();
                    Object var11_14 = null;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byteArrayOS);
                    Object var13_17 = null;
                }
                catch (Throwable throwable) {
                    Object var13_18 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            byteArrayOutputStream = byteArrayOS;
            Object var15_20 = null;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var17_24 = null;
                }
                catch (Throwable throwable2) {
                    Object var17_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var17_22 = null;
            }
            catch (Throwable throwable) {
                Object var17_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return byteArrayOutputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getAction() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.action);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.action;
            Object var6_8 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getnsite() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.nsites);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            n2 = this.nsites;
            Object var6_8 = null;
            if (!TRACE) return n2;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (!TRACE || !OracleLog.recursiveEnter()) throw throwable;
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_12 = null;
            }
            catch (Throwable throwable2) {
                Object var8_13 = null;
                OracleLog.recursiveExit();
                throw throwable2;
            }
            OracleLog.recursiveExit();
            {
                throw throwable;
            }
        }
        if (!OracleLog.recursiveEnter()) return n2;
        try {
            OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            Object var8_10 = null;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            OracleLog.recursiveExit();
            throw throwable;
        }
        OracleLog.recursiveExit();
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getdbLinks() {
        Vector vector;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.dbLinks);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            vector = this.dbLinks;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector getXids() {
        try {
            if (OracleMultiPhaseArgs.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.enter() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    var2_1 = null;
                }
                catch (Throwable var1_3) {
                    var2_2 = null;
                    OracleLog.recursiveExit();
                    throw var1_3;
                }
                OracleLog.recursiveExit();
            }
            if (OracleMultiPhaseArgs.TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.isPublic() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.xids);
                    var4_5 = null;
                }
                catch (Throwable var3_7) {
                    var4_6 = null;
                    OracleLog.recursiveExit();
                    throw var3_7;
                }
                OracleLog.recursiveExit();
            }
            var1_4 = this.xids;
            var6_8 = null;
            if (OracleMultiPhaseArgs.TRACE == false) return var1_4;
            ** GOTO lbl46
        }
        catch (Throwable var5_16) {
            var6_9 = null;
            if (OracleMultiPhaseArgs.TRACE == false) throw var5_16;
            if (OracleLog.recursiveEnter() == false) throw var5_16;
            try {
                OracleMultiPhaseArgs.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                var8_12 = null;
            }
            catch (Throwable var7_15) {
                var8_13 = null;
                OracleLog.recursiveExit();
                throw var7_15;
            }
lbl46:
            // 1 sources

            if (OracleLog.recursiveEnter() == false) return var1_4;
            try {}
            catch (Throwable var7_14) {
                var8_11 = null;
                OracleLog.recursiveExit();
                throw var7_14;
            }
            OracleMultiPhaseArgs.logger().log(OracleLog.exit() != false ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            var8_10 = null;
            OracleLog.recursiveExit();
            return var1_4;
            OracleLog.recursiveExit();
            throw var5_16;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printMPArgs() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "-------printMPArgs entry-------");
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  action = " + this.action);
                    Object var6_9 = null;
                }
                catch (Throwable throwable) {
                    Object var6_10 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  nsites = " + this.nsites);
                    Object var8_13 = null;
                }
                catch (Throwable throwable) {
                    Object var8_14 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            for (int i2 = 0; i2 < this.nsites; ++i2) {
                Object var16_16;
                String dblink = (String)this.dbLinks.elementAt(i2);
                int fmtid = (Integer)this.xids.elementAt(i2 * 3);
                byte[] gtrid = (byte[])this.xids.elementAt(i2 * 3 + 1);
                byte[] bqual = (byte[])this.xids.elementAt(i2 * 3 + 2);
                if (TRACE && OracleLog.recursiveEnter()) {
                    Object var10_17;
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  fmtid  [" + i2 + "] = " + fmtid);
                        var10_17 = null;
                    }
                    catch (Throwable throwable) {
                        var10_17 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    Object var12_18;
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  gtrid  [" + i2 + "] = ");
                        var12_18 = null;
                    }
                    catch (Throwable throwable) {
                        var12_18 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                this.printByteArray(gtrid);
                if (TRACE && OracleLog.recursiveEnter()) {
                    Object var14_19;
                    try {
                        OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  bqual  [" + i2 + "] = ");
                        var14_19 = null;
                    }
                    catch (Throwable throwable) {
                        var14_19 = null;
                        OracleLog.recursiveExit();
                        throw throwable;
                    }
                    OracleLog.recursiveExit();
                    {
                    }
                }
                this.printByteArray(bqual);
                if (!TRACE || !OracleLog.recursiveEnter()) continue;
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "  dblink [" + i2 + "] = " + dblink);
                    var16_16 = null;
                }
                catch (Throwable throwable) {
                    var16_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                    continue;
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(OracleLog.TRACE_20, Integer.toHexString(this.hashCode()).toUpperCase() + " Debug: " + "-------printMPArgs return-------");
                    Object var18_24 = null;
                }
                catch (Throwable throwable) {
                    Object var18_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Object var20_27 = null;
        }
        catch (Throwable throwable) {
            Object var20_28 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleMultiPhaseArgs.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var22_31 = null;
                }
                catch (Throwable throwable2) {
                    Object var22_32 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleMultiPhaseArgs.logger().log(Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var22_29 = null;
            }
            catch (Throwable throwable) {
                Object var22_30 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    private void printByteArray(byte[] bArray) {
        StringBuffer _buf = new StringBuffer();
        for (int i2 = 0; i2 < bArray.length; ++i2) {
            _buf.append(bArray[i2] + " ");
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.OracleMultiPhaseArgs"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

