/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.logging.Logger;
import oracle.jdbc.driver.Binder;
import oracle.jdbc.driver.DateCommonBinder;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OraclePreparedStatementReadOnly;

class TimestampBinder
extends DateCommonBinder {
    Binder theTimestampCopyingBinder = OraclePreparedStatementReadOnly.theStaticTimestampCopyingBinder;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void init(Binder x) {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampBinder.logger().log(OracleLog.TRACE_30, "         Enter: " + OracleLog.argument(x));
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            x.type = (short)180;
            x.bytelen = 11;
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampBinder.logger().log(OracleLog.TRACE_30, "         Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TimestampBinder() {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            TimestampBinder.init(this);
            Object var4_4 = null;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var6_8 = null;
                }
                catch (Throwable throwable2) {
                    Object var6_9 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Binder copyingBinder() {
        Binder binder;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument());
                    Object var2_1 = null;
                }
                catch (Throwable throwable) {
                    Object var2_2 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.theTimestampCopyingBinder);
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            binder = this.theTimestampCopyingBinder;
            Object var6_8 = null;
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var8_12 = null;
                }
                catch (Throwable throwable2) {
                    Object var8_13 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var8_10 = null;
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
        return binder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bind(OraclePreparedStatement stmt, int bindPosition, int rankInBuffer, int rank, byte[] bindBytes, char[] bindChars, short[] bindIndicators, int bytePitch, int charPitch, int byteoffset, int charoffset, int lenoffset, int indoffset, boolean clearPriorBindValues) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Enter: " + OracleLog.argument(stmt) + ", " + OracleLog.argument(bindPosition) + ", " + OracleLog.argument(rankInBuffer) + ", " + OracleLog.argument(rank) + ", " + OracleLog.argument(bindBytes) + ", " + OracleLog.argument(bindChars) + ", " + OracleLog.argument(bindIndicators) + ", " + OracleLog.argument(bytePitch) + ", " + OracleLog.argument(charPitch) + ", " + OracleLog.argument(byteoffset) + ", " + OracleLog.argument(charoffset) + ", " + OracleLog.argument(lenoffset) + ", " + OracleLog.argument(indoffset) + ", " + OracleLog.argument(clearPriorBindValues));
                    Object var16_15 = null;
                }
                catch (Throwable throwable) {
                    Object var16_16 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            Timestamp[] timestamps = stmt.parameterTimestamp[rank];
            Timestamp value = timestamps[bindPosition];
            if (clearPriorBindValues) {
                timestamps[bindPosition] = null;
            }
            if (value == null) {
                bindIndicators[indoffset] = -1;
            } else {
                bindIndicators[indoffset] = 0;
                TimestampBinder.setOracleHMS(TimestampBinder.setOracleCYMD(value.getTime(), bindBytes, byteoffset, stmt), bindBytes, byteoffset);
                int nanos = value.getNanos();
                if (nanos != 0) {
                    TimestampBinder.setOracleNanos(nanos, bindBytes, byteoffset);
                    bindIndicators[lenoffset] = (short)bytePitch;
                } else {
                    bindIndicators[lenoffset] = 7;
                }
            }
            Object var19_20 = null;
        }
        catch (Throwable throwable) {
            Object var19_21 = null;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    TimestampBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    Object var21_24 = null;
                }
                catch (Throwable throwable2) {
                    Object var21_25 = null;
                    OracleLog.recursiveExit();
                    throw throwable2;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                TimestampBinder.logger().log(OracleLog.TRACE_30, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                Object var21_22 = null;
            }
            catch (Throwable throwable) {
                Object var21_23 = null;
                OracleLog.recursiveExit();
                throw throwable;
            }
            OracleLog.recursiveExit();
            {
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.TimestampBinder"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

