/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleInputStream;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.T4CConnection;

class T4CInputStream
extends OracleInputStream {
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CInputStream(OracleStatement stmt, int index, Accessor a2) {
        super(stmt, index, a2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isNull() throws IOException {
        if (!this.statement.connection.useFetchSizeWithLongColumn) {
            return super.isNull();
        }
        boolean result = false;
        try {
            int currentRow = this.statement.currentRow;
            if (currentRow < 0) {
                currentRow = 0;
            }
            if (currentRow >= this.statement.validRows) {
                return true;
            }
            result = this.accessor.isNull(currentRow);
        }
        catch (SQLException exc) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CInputStream.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing IOException: " + exc);
                    Object var4_4 = null;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    OracleLog.recursiveExit();
                    throw throwable;
                }
                OracleLog.recursiveExit();
                {
                }
            }
            IOException __ex__ = DatabaseError.createIOException(exc);
            __ex__.fillInStackTrace();
            throw __ex__;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBytes(int ignore) throws IOException {
        PhysicalConnection physicalConnection = this.statement.connection;
        synchronized (physicalConnection) {
            int ret = -1;
            try {
                if (this.statement.connection.lifecycle == 1 || this.statement.connection.lifecycle == 2) {
                    ret = this.accessor.readStream(this.resizableBuffer, this.initialBufferSize);
                }
            }
            catch (SQLException e2) {
                throw new IOException(e2.getMessage());
            }
            catch (IOException ea) {
                try {
                    ((T4CConnection)this.statement.connection).handleIOException(ea);
                }
                catch (SQLException eb) {
                    // empty catch block
                }
                throw ea;
            }
            return ret;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CInputStream"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

