/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.KeywordValueLongI;
import oracle.jdbc.driver.NTFAQEvent;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CMAREngine;
import oracle.jdbc.internal.KeywordValueLong;
import oracle.jdbc.internal.XSEvent;

class NTFXSEvent
extends XSEvent {
    private final byte[] sid_kpuzxsss;
    private final KeywordValueLongI[] sess_kpuzxsss;
    private final int flg_kpuzxsss;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static boolean TRACE = false;
    private static Logger LOGGER;

    NTFXSEvent(T4CConnection conn) throws SQLException, IOException {
        super(conn);
        T4CMAREngine meg = conn.getMarshalEngine();
        this.sid_kpuzxsss = meg.unmarshalDALC();
        int sessn_kpuzxsss = (int)meg.unmarshalUB4();
        byte lengthOfDty = (byte)meg.unmarshalUB1();
        this.sess_kpuzxsss = new KeywordValueLongI[sessn_kpuzxsss];
        for (int i2 = 0; i2 < sessn_kpuzxsss; ++i2) {
            this.sess_kpuzxsss[i2] = KeywordValueLongI.unmarshal(meg);
        }
        this.flg_kpuzxsss = (int)meg.unmarshalUB4();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSessionId() {
        byte[] byArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.sid_kpuzxsss);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byArray = this.sid_kpuzxsss;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFXSEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeywordValueLong[] getDetails() {
        KeywordValueLong[] keywordValueLongArray;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + (KeywordValueLong[])this.sess_kpuzxsss);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            keywordValueLongArray = this.sess_kpuzxsss;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFXSEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return keywordValueLongArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFlags() {
        int n2;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.flg_kpuzxsss);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            n2 = this.flg_kpuzxsss;
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFXSEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String string;
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.enter() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            StringBuffer sb = new StringBuffer();
            sb.append("sid_kpuzxsss  : " + NTFAQEvent.byteBufferToHexString(this.sid_kpuzxsss, 50) + "\n");
            sb.append("sess_kpuzxsss : \n");
            sb.append("  size : " + this.sess_kpuzxsss.length + "\n");
            for (int i2 = 0; i2 < this.sess_kpuzxsss.length; ++i2) {
                sb.append("  sess_kpuzxsss #" + i2 + " : \n");
                if (this.sess_kpuzxsss[i2] == null) {
                    sb.append("null\n");
                    continue;
                }
                sb.append(this.sess_kpuzxsss[i2].toString());
            }
            sb.append("flg_kpuzxsss  : " + this.flg_kpuzxsss + "\n");
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.isPublic() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sb.toString());
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            string = sb.toString();
        }
        catch (Throwable throwable) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFXSEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            throw throwable;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                NTFXSEvent.logger().log(OracleLog.exit() ? Level.FINE : Level.FINER, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        return string;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFXSEvent"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

