/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.settings;

import com.businessobjects.visualization.GraphicInstance;
import com.businessobjects.visualization.graphic.IGraphic;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuDouble;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuState;
import com.businessobjects.visualization.graphic.VisuString;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AutoNumberFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PFJDateFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PFJDecimalFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PredefinedNumberFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.ScaledNumberFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Matrix3d;
import com.businessobjects.visualization.pfjgraphics.settings.CVOMid;
import com.businessobjects.visualization.pfjgraphics.settings.SettingsTransform;
import java.awt.Rectangle;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.util.Locale;

public class CVOMHelper {
    public GraphicInstance context;
    public IGraphic graphSettings;
    private static final VisuString emptyVisuString = new VisuString("");
    private static final VisuState shortState = new VisuState("short");
    private static final VisuState mediumState = new VisuState("medium");
    private static final VisuState longState = new VisuState("long");
    private static final VisuState fullState = new VisuState("full");
    private static final VisuState dateState = new VisuState("date");
    private static final VisuState timeState = new VisuState("time");
    private static final VisuState dateTimeState = new VisuState("datetime");
    private static final VisuState customDateState = new VisuState("customdate");
    private static final VisuState numberState = new VisuState("number");
    private static final VisuState scaledNumberState = new VisuState("scalednumber");
    private static final VisuState autoNumberState = new VisuState("autonumber");
    private static final VisuState predefinedState = new VisuState("predefined");

    public CVOMHelper(GraphicInstance context) {
        this.context = context;
        this.graphSettings = context.getGraphic();
    }

    public Object getProperty(CVOMid id) {
        switch (id.valueType) {
            case RECT: {
                return this.getRect(id);
            }
            case MATRIX3D: {
                return this.getMatrix3d(id);
            }
            case NUMBERFORMAT: {
                return this.getNumberFormat(id);
            }
        }
        return id.transform.toPFJ(this.getProperty(id.region, id.property));
    }

    public VisuObject getProperty(String region, String property) {
        return this.graphSettings.getPropertyValue(region, property);
    }

    public void setProperty(CVOMid id, Object value) {
        switch (id.valueType) {
            case RECT: {
                this.setRect(id, (Rectangle)value);
                break;
            }
            case MATRIX3D: {
                this.setMatrix3d(id, (Matrix3d)value);
                break;
            }
            case NUMBERFORMAT: {
                this.setNumberFormat(id, (Format)value);
                break;
            }
            default: {
                this.setProperty(id.region, id.property, value, id.valueType, id.transform);
            }
        }
    }

    public void setProperty(String region, String property, VisuObject vObj) {
        this.graphSettings.setPropertyValue(region, property, vObj);
    }

    void setProperty(String region, String property, Object value, CVOMid.vType valueType, SettingsTransform transform) {
        this.setProperty(region, property, transform.toCVOM(value, valueType));
    }

    Rectangle getRect(CVOMid id) {
        Integer x = (Integer)id.transform.toPFJ(this.getProperty(id.region, id.property + "/x"));
        Integer y = (Integer)id.transform.toPFJ(this.getProperty(id.region, id.property + "/y"));
        Integer width = (Integer)id.transform.toPFJ(this.getProperty(id.region, id.property + "/width"));
        Integer height = (Integer)id.transform.toPFJ(this.getProperty(id.region, id.property + "/height"));
        return new Rectangle(x, y, width, height);
    }

    void setRect(CVOMid id, Rectangle r) {
        this.setProperty(id.region, id.property + "/x", id.transform.toCVOM(r.x, id.valueType));
        this.setProperty(id.region, id.property + "/y", id.transform.toCVOM(r.y, id.valueType));
        this.setProperty(id.region, id.property + "/width", id.transform.toCVOM(r.width, id.valueType));
        this.setProperty(id.region, id.property + "/height", id.transform.toCVOM(r.height, id.valueType));
    }

    Matrix3d getMatrix3d(CVOMid id) {
        Double m00 = (Double)id.transform.toPFJ(this.getProperty(id.region, id.property + "/m00"));
        Double m01 = (Double)id.transform.toPFJ(this.getProperty(id.region, id.property + "/m01"));
        Double m02 = (Double)id.transform.toPFJ(this.getProperty(id.region, id.property + "/m02"));
        Double m10 = (Double)id.transform.toPFJ(this.getProperty(id.region, id.property + "/m10"));
        Double m11 = (Double)id.transform.toPFJ(this.getProperty(id.region, id.property + "/m11"));
        Double m12 = (Double)id.transform.toPFJ(this.getProperty(id.region, id.property + "/m12"));
        Double m20 = (Double)id.transform.toPFJ(this.getProperty(id.region, id.property + "/m20"));
        Double m21 = (Double)id.transform.toPFJ(this.getProperty(id.region, id.property + "/m21"));
        Double m22 = (Double)id.transform.toPFJ(this.getProperty(id.region, id.property + "/m22"));
        return new Matrix3d(m00, m01, m02, m10, m11, m12, m20, m21, m22);
    }

    void setMatrix3d(CVOMid id, Matrix3d m) {
        this.setProperty(id.region, id.property + "/m00", id.transform.toCVOM(m.m00, id.valueType));
        this.setProperty(id.region, id.property + "/m01", id.transform.toCVOM(m.m01, id.valueType));
        this.setProperty(id.region, id.property + "/m02", id.transform.toCVOM(m.m02, id.valueType));
        this.setProperty(id.region, id.property + "/m10", id.transform.toCVOM(m.m10, id.valueType));
        this.setProperty(id.region, id.property + "/m11", id.transform.toCVOM(m.m11, id.valueType));
        this.setProperty(id.region, id.property + "/m12", id.transform.toCVOM(m.m12, id.valueType));
        this.setProperty(id.region, id.property + "/m20", id.transform.toCVOM(m.m20, id.valueType));
        this.setProperty(id.region, id.property + "/m21", id.transform.toCVOM(m.m21, id.valueType));
        this.setProperty(id.region, id.property + "/m22", id.transform.toCVOM(m.m22, id.valueType));
    }

    Format getNumberFormat(CVOMid id) {
        VisuState formatType = (VisuState)this.getProperty(id.region, id.property + "/formattype");
        String pattern = ((VisuString)this.getProperty(id.region, id.property + "/pattern")).toString();
        VisuState dateStyle = (VisuState)this.getProperty(id.region, id.property + "/datestyle");
        VisuState timeStyle = (VisuState)this.getProperty(id.region, id.property + "/timestyle");
        VisuState predefinedType = (VisuState)this.getProperty(id.region, id.property + "/predefined");
        Locale locale = this.context.getLocalizedEngine().getLocale();
        if (formatType.equals((Object)dateState)) {
            return PFJDateFormat.getDateInstance(this.convertToDateFormatStyle(dateStyle), locale);
        }
        if (formatType.equals((Object)timeState)) {
            return PFJDateFormat.getTimeInstance(this.convertToDateFormatStyle(timeStyle), locale);
        }
        if (formatType.equals((Object)dateTimeState)) {
            return PFJDateFormat.getDateTimeInstance(this.convertToDateFormatStyle(dateStyle), this.convertToDateFormatStyle(timeStyle), locale);
        }
        if (formatType.equals((Object)customDateState)) {
            return PFJDateFormat.getCustomInstance(pattern, locale);
        }
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(locale);
        if (formatType.equals((Object)predefinedState)) {
            assert (false);
            return PredefinedNumberFormat.createPredefinedNumberFormat(predefinedType.getId(), symbols);
        }
        boolean alwaysLocalized = ((VisuBool)this.getProperty(id.region, id.property + "/alwayslocalized")).booleanValue();
        if (!alwaysLocalized) {
            symbols.setDecimalSeparator(((VisuString)this.getProperty(id.region, id.property + "/decimalseparator")).toString().charAt(0));
            symbols.setGroupingSeparator(((VisuString)this.getProperty(id.region, id.property + "/groupingseparator")).toString().charAt(0));
            symbols.setMonetaryDecimalSeparator(((VisuString)this.getProperty(id.region, id.property + "/groupingseparator")).toString().charAt(0));
            symbols.setCurrencySymbol(((VisuString)this.getProperty(id.region, id.property + "/currencysymbol")).toString());
        }
        if (formatType.equals((Object)scaledNumberState)) {
            double scaleFactor = ((VisuDouble)this.getProperty(id.region, id.property + "/scalefactor")).doubleValue();
            return new ScaledNumberFormat(pattern, symbols, scaleFactor);
        }
        if (formatType.equals((Object)autoNumberState)) {
            return new AutoNumberFormat(symbols);
        }
        assert (formatType.equals((Object)numberState));
        return new PFJDecimalFormat(pattern, symbols);
    }

    private VisuState convertFromDateFormatStyle(int dateStyle) {
        switch (dateStyle) {
            default: {
                return shortState;
            }
            case 2: {
                return mediumState;
            }
            case 1: {
                return longState;
            }
            case 0: 
        }
        return fullState;
    }

    private int convertToDateFormatStyle(VisuState dateStyleState) {
        if (dateStyleState.equals((Object)mediumState)) {
            return 2;
        }
        if (dateStyleState.equals((Object)longState)) {
            return 1;
        }
        if (dateStyleState.equals((Object)fullState)) {
            return 0;
        }
        assert (dateStyleState.equals((Object)shortState));
        return 3;
    }

    void setNumberFormat(CVOMid id, Format format) {
        VisuState formatType;
        VisuString pattern = emptyVisuString;
        VisuDouble scaleFactor = new VisuDouble(1.0);
        VisuString decimalSeparator = emptyVisuString;
        VisuString groupingSeparator = emptyVisuString;
        VisuString monetaryDecimalSeparator = emptyVisuString;
        VisuString currencySymbol = emptyVisuString;
        VisuState dateStyle = shortState;
        VisuState timeStyle = shortState;
        if (format instanceof PFJDateFormat) {
            PFJDateFormat dateFormat = (PFJDateFormat)format;
            switch (dateFormat.dateType) {
                default: {
                    assert (false);
                }
                case DATE: {
                    formatType = dateState;
                    dateStyle = this.convertFromDateFormatStyle(dateFormat.dateStyle);
                    break;
                }
                case TIME: {
                    formatType = timeState;
                    timeStyle = this.convertFromDateFormatStyle(dateFormat.timeStyle);
                    break;
                }
                case DATETIME: {
                    formatType = dateTimeState;
                    dateStyle = this.convertFromDateFormatStyle(dateFormat.dateStyle);
                    timeStyle = this.convertFromDateFormatStyle(dateFormat.timeStyle);
                    break;
                }
                case CUSTOM: {
                    formatType = customDateState;
                    pattern = new VisuString(dateFormat.customPattern);
                    break;
                }
            }
        } else if (format instanceof PFJDecimalFormat) {
            PFJDecimalFormat df = (PFJDecimalFormat)format;
            pattern = new VisuString(df.toPattern());
            if (format instanceof AutoNumberFormat) {
                formatType = autoNumberState;
            } else if (format instanceof PredefinedNumberFormat) {
                assert (false);
                formatType = predefinedState;
                VisuState predefinedType = new VisuState(((PredefinedNumberFormat)format).getPredefinedType());
                this.setProperty(id.region, id.property + "/predefined", (VisuObject)predefinedType);
                scaleFactor = new VisuDouble(((ScaledNumberFormat)format).getScaleFactor());
            } else if (format instanceof ScaledNumberFormat) {
                formatType = scaledNumberState;
                scaleFactor = new VisuDouble(((ScaledNumberFormat)format).getScaleFactor());
            } else {
                formatType = numberState;
            }
            DecimalFormatSymbols symbols = df.getDecimalFormatSymbols();
            decimalSeparator = new VisuString(String.valueOf(symbols.getDecimalSeparator()));
            groupingSeparator = new VisuString(String.valueOf(symbols.getGroupingSeparator()));
            monetaryDecimalSeparator = new VisuString(String.valueOf(symbols.getMonetaryDecimalSeparator()));
            currencySymbol = new VisuString(symbols.getCurrencySymbol());
        } else {
            assert (false);
            formatType = numberState;
            pattern = new VisuString("");
        }
        this.setProperty(id.region, id.property + "/formattype", (VisuObject)formatType);
        this.setProperty(id.region, id.property + "/pattern", (VisuObject)pattern);
        this.setProperty(id.region, id.property + "/scalefactor", (VisuObject)scaleFactor);
        this.setProperty(id.region, id.property + "/decimalseparator", (VisuObject)decimalSeparator);
        this.setProperty(id.region, id.property + "/groupingseparator", (VisuObject)groupingSeparator);
        this.setProperty(id.region, id.property + "/monetarydecimalseparator", (VisuObject)monetaryDecimalSeparator);
        this.setProperty(id.region, id.property + "/currencysymbol", (VisuObject)currencySymbol);
        this.setProperty(id.region, id.property + "/datestyle", (VisuObject)dateStyle);
        this.setProperty(id.region, id.property + "/timestyle", (VisuObject)timeStyle);
    }

    public boolean hasZAxis() {
        String id = this.context.getPublicGraphicId();
        return id.endsWith("3dbar") || id.endsWith("3dsurface");
    }
}

