/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.utility;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ShapeUtility {
    public static String shapeToString(Shape shape) {
        if (shape == null) {
            return "null";
        }
        if (ShapeUtility.isEmpty(shape)) {
            return "empty shape";
        }
        ArrayList<Point2D.Double> list = new ArrayList<Point2D.Double>();
        if (ShapeUtility.isDiscrete(shape, list)) {
            return "Discrete list: " + list;
        }
        PathIterator it = shape.getPathIterator(null);
        double[] p = new double[6];
        int nType = 0;
        StringBuffer buf = new StringBuffer().append(shape.getClass().toString()).append('\n');
        double temp0 = 0.0;
        double temp1 = 0.0;
        while (!it.isDone()) {
            nType = it.currentSegment(p);
            switch (nType) {
                case 0: {
                    buf.append("MOVE ").append(p[0]).append(',').append('\t').append(p[1]).append('\n');
                    temp0 = p[0];
                    temp1 = p[1];
                    break;
                }
                case 1: {
                    buf.append("LINE ").append(p[0]).append(',').append('\t').append(p[1]).append('\n');
                    break;
                }
                case 2: {
                    buf.append("QUAD ").append(p[2]).append(',').append('\t').append(p[3]).append('\n');
                    break;
                }
                case 3: {
                    buf.append("CUB_ ").append(p[4]).append(',').append('\t').append(p[5]).append('\n');
                    break;
                }
                case 4: {
                    buf.append("END_ ").append(temp0).append(',').append('\t').append(temp1).append('\n');
                }
            }
            it.next();
        }
        return buf.toString();
    }

    public static void write(Shape shape) {
        System.out.println(ShapeUtility.shapeToString(shape));
    }

    public static boolean isEmpty(Shape shape) {
        if (shape == null) {
            return true;
        }
        PathIterator it = shape.getPathIterator(null);
        return it.isDone();
    }

    public static boolean isDiscrete(Shape shape, List<Point2D.Double> returnList) {
        boolean isDiscrete = true;
        PathIterator it = shape.getPathIterator(null);
        double[] p = new double[6];
        int nType = 0;
        while (!it.isDone()) {
            nType = it.currentSegment(p);
            if (nType == 0) {
                if (returnList != null) {
                    returnList.add(new Point2D.Double(p[0], p[1]));
                }
            } else {
                isDiscrete = false;
            }
            it.next();
        }
        return isDiscrete;
    }

    public static void getPoints(PathIterator it, List<Point2D.Double> returnList) {
        int nType = 0;
        double[] p = new double[6];
        Point2D.Double point = null;
        Point2D.Double lastPoint = null;
        while (!it.isDone()) {
            block13: {
                try {
                    nType = it.currentSegment(p);
                    System.out.println("ShapeUtility : " + nType);
                }
                catch (Exception ex) {
                    System.out.println("ShapeUtility : " + ex);
                    nType = 4;
                    if ($assertionsDisabled) break block13;
                    throw new AssertionError();
                }
            }
            if (nType == 0 || nType == 1) {
                point = new Point2D.Double(p[0], p[1]);
            } else if (nType == 2) {
                point = new Point2D.Double(p[2], p[3]);
            } else if (nType == 3) {
                point = new Point2D.Double(p[4], p[5]);
            } else if (nType == 4) {
                point = null;
            } else if (nType == 4) {
                point = null;
            }
            if (point == null || !point.equals(lastPoint)) {
                returnList.add(point);
            }
            lastPoint = point;
            it.next();
        }
    }

    public static final void createLinearPath(GeneralPath path, List list, int nLen, boolean isClosed) {
        Object[] array = list.toArray();
        ShapeUtility.createLinearPath(path, array, nLen, isClosed);
    }

    public static final void createLinearPath(GeneralPath path, Object[] points, int nLen, boolean isClosed) {
        boolean bDraw;
        if (path == null) {
            throw new RuntimeException("Path is null");
        }
        path.reset();
        Point2D point = (Point2D)points[0];
        boolean bl = bDraw = point != null;
        if (point != null) {
            path.moveTo((float)point.getX(), (float)point.getY());
        } else {
            isClosed = false;
        }
        for (int i = 1; i < nLen; ++i) {
            if (points[i] != null) {
                point = (Point2D)points[i];
                if (bDraw) {
                    path.lineTo((float)point.getX(), (float)point.getY());
                    continue;
                }
                bDraw = true;
                path.moveTo((float)point.getX(), (float)point.getY());
                continue;
            }
            bDraw = false;
        }
        if (isClosed) {
            path.closePath();
        }
    }
}

