/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.sun;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.sun.Anchor;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;

public class Position {
    public static final Position TOP_LEFT = new Position(Anchor.TOP_LEFT);
    public static final Position TOP = new Position(Anchor.TOP);
    public static final Position TOP_RIGHT = new Position(Anchor.TOP_RIGHT);
    public static final Position RIGHT = new Position(Anchor.RIGHT);
    public static final Position BOTTOM_RIGHT = new Position(Anchor.BOTTOM_RIGHT);
    public static final Position BOTTOM = new Position(Anchor.BOTTOM);
    public static final Position BOTTOM_LEFT = new Position(Anchor.BOTTOM_LEFT);
    public static final Position LEFT = new Position(Anchor.LEFT);
    public static final Position CENTER = new Position(Anchor.CENTER);
    private Anchor anchor = Anchor.CENTER;
    private double hAdjust;
    private double vAdjust;
    private AffineTransform transform = new AffineTransform();
    private boolean placeBeforeTransform = true;

    public Position() {
        this(Anchor.CENTER);
    }

    public Position(Anchor anchor) {
        this(anchor, 0.0, 0.0);
    }

    public Position(Anchor anchor, double hAdjust, double vAdjust) {
        this(anchor, hAdjust, vAdjust, null);
    }

    public Position(Anchor anchor, double hAdjust, double vAdjust, AffineTransform transform) {
        this(anchor, hAdjust, vAdjust, transform, true);
    }

    public Position(Anchor anchor, double hAdjust, double vAdjust, AffineTransform transform, boolean placeThenTransform) {
        if (anchor == null) {
            anchor = Anchor.CENTER;
        }
        this.anchor = anchor;
        this.hAdjust = hAdjust;
        this.vAdjust = vAdjust;
        if (transform != null) {
            this.transform = (AffineTransform)transform.clone();
        }
        this.placeBeforeTransform = placeThenTransform;
    }

    public Shape createTransformedShape(Shape shape, Rectangle2D rect) {
        AffineTransform t = this.getTransform(shape, rect);
        return t.createTransformedShape(shape);
    }

    public AffineTransform getTransform(Shape shape, Rectangle2D rect) {
        AffineTransform t = null;
        Rectangle2D bounds = shape.getBounds2D();
        if (this.placeBeforeTransform) {
            t = this.getAnchorPlacementTransform(bounds, rect);
            t.translate(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
            t.concatenate(this.transform);
            t.translate(-bounds.getX() - bounds.getWidth() / 2.0, -bounds.getY() - bounds.getHeight() / 2.0);
        } else {
            t = new AffineTransform();
            t.translate(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
            t.concatenate(this.transform);
            t.translate(-bounds.getX() - bounds.getWidth() / 2.0, -bounds.getY() - bounds.getHeight() / 2.0);
            bounds = t.createTransformedShape(shape).getBounds();
            AffineTransform tmp = this.getAnchorPlacementTransform(bounds, rect);
            t.preConcatenate(tmp);
        }
        return t;
    }

    private AffineTransform getAnchorPlacementTransform(Rectangle2D bounds, Rectangle2D rect) {
        double w = rect.getWidth();
        double h = rect.getHeight();
        AffineTransform t = new AffineTransform();
        switch (this.anchor.toInt()) {
            case 0: {
                t.setToTranslation(this.hAdjust, this.vAdjust);
                break;
            }
            case 1: {
                t.setToTranslation(-bounds.getWidth() / 2.0 + w / 2.0, this.vAdjust);
                break;
            }
            case 2: {
                t.setToTranslation(w - bounds.getWidth() - this.hAdjust, this.vAdjust);
                break;
            }
            case 3: {
                t.setToTranslation(w - bounds.getWidth() - this.hAdjust, -bounds.getHeight() / 2.0 + h / 2.0);
                break;
            }
            case 4: {
                t.setToTranslation(w - bounds.getWidth() - this.hAdjust, h - bounds.getHeight() - this.vAdjust);
                break;
            }
            case 5: {
                t.setToTranslation(-bounds.getWidth() / 2.0 + w / 2.0, h - bounds.getHeight() - this.vAdjust);
                break;
            }
            case 6: {
                t.setToTranslation(this.hAdjust, h - bounds.getHeight() - this.vAdjust);
                break;
            }
            case 7: {
                t.setToTranslation(this.hAdjust, -bounds.getHeight() / 2.0 + h / 2.0);
                break;
            }
            case 8: {
                t.setToTranslation(-bounds.getWidth() / 2.0 + w / 2.0, -bounds.getHeight() / 2.0 + h / 2.0);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid anchor value: " + this.anchor);
            }
        }
        t.translate(rect.getX() - bounds.getX(), rect.getY() - bounds.getY());
        return t;
    }
}

