/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.AngularGradientPaintExtContext;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint.PaintExt;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;

public class AngularGradientPaintExt
implements PaintExt {
    Rectangle2D gradientBounds;
    Point2D gradientCenter;
    double startX;
    double endX;
    private double[] I;
    private Color[] colors;
    private int transparency;
    static double DEFAULT_START = -1.0;
    static double DEFAULT_END = 1.0;

    public Color[] getColors() {
        Color[] colors = new Color[this.colors.length];
        System.arraycopy(this.colors, 0, colors, 0, this.colors.length);
        return colors;
    }

    public double[] getIntervals() {
        double[] I = new double[this.I.length];
        System.arraycopy(this.I, 0, I, 0, this.I.length);
        return I;
    }

    public Rectangle2D getBounds() {
        return (Rectangle2D)this.gradientBounds.clone();
    }

    public Point2D.Float getCenter() {
        return (Point2D.Float)this.gradientCenter.clone();
    }

    double getStartX() {
        return this.startX;
    }

    double getEndX() {
        return this.endX;
    }

    public AngularGradientPaintExt(Rectangle2D bounds, double[] I, Color[] colors) {
        this(bounds, I, colors, new Point2D.Double(bounds.getCenterX(), bounds.getCenterY()), DEFAULT_START, DEFAULT_END);
    }

    public AngularGradientPaintExt(Rectangle2D bounds, double[] I, Color[] colors, Point2D center, double startX, double endX) {
        if (bounds == null) {
            throw new IllegalArgumentException();
        }
        this.startX = startX;
        this.endX = endX;
        this.gradientCenter = center;
        this.gradientBounds = bounds;
        this.setIntervalsColors(I, colors);
    }

    public void setIntervalsColors(double[] I, Color[] colors) {
        int i;
        if (I == null || colors == null || I.length != colors.length - 1 || colors.length < 2) {
            throw new IllegalArgumentException();
        }
        double[] temp = new double[I.length];
        System.arraycopy(I, 0, temp, 0, I.length);
        I = temp;
        double sum = 0.0;
        for (i = 0; i < I.length; ++i) {
            if (I[i] < 0.0) {
                String str = "AngularGradientPant cannot use negative  interval: " + I[i];
                System.out.println(str);
                I[i] = -I[i];
            }
            sum += I[i];
        }
        if (sum <= 0.0) {
            throw new IllegalArgumentException("AngularGradientPant cannot use negative sum of  intervals ");
        }
        i = 0;
        while (i < I.length) {
            int n = i++;
            I[n] = I[n] / sum;
        }
        this.I = I;
        this.colors = new Color[colors.length];
        System.arraycopy(colors, 0, this.colors, 0, colors.length);
        boolean opaque = true;
        for (int i2 = 0; i2 < colors.length; ++i2) {
            opaque = opaque && colors[i2].getAlpha() == 255;
        }
        this.transparency = opaque ? 1 : 3;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform transform, RenderingHints hints) {
        try {
            return new AngularGradientPaintExtContext(this.gradientBounds, this.I, this.colors, this.gradientCenter, this.startX, this.endX, transform);
        }
        catch (NoninvertibleTransformException e) {
            throw new IllegalArgumentException("transform should be invertible");
        }
    }

    public int getTransparency() {
        return this.transparency;
    }

    public static double renorm(double angle) {
        if (angle > -Math.PI && angle <= Math.PI) {
            return angle;
        }
        int n = (int)Math.floor(angle / (Math.PI * 2));
        double returnAngle = angle - (double)n * (Math.PI * 2);
        if (returnAngle > Math.PI) {
            returnAngle -= Math.PI * 2;
        }
        return returnAngle;
    }
}

