/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.paint;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;

abstract class AbstractPaintContext
implements PaintContext {
    private static final ColorModel xrgbmodel = new DirectColorModel(24, 0xFF0000, 65280, 255);
    private double[] invMatrix;
    private int[] gradient = null;
    private Raster saved;
    private ColorModel model;
    private Rectangle bounds;

    public abstract double calcGradientValue(double var1, double var3);

    private AbstractPaintContext(Rectangle2D boundRect, AffineTransform t) throws NoninvertibleTransformException {
        this.bounds = t.createTransformedShape(boundRect).getBounds();
        this.invMatrix = new double[6];
        AffineTransform tInv = t.createInverse();
        tInv.getMatrix(this.invMatrix);
    }

    public AbstractPaintContext(Rectangle2D boundRect, Color color1, Color color2, AffineTransform trans) throws NoninvertibleTransformException {
        this(boundRect, trans);
        this.createGradients(color1, color2);
    }

    public AbstractPaintContext(Rectangle2D boundRect, double[] I, Color[] colors, AffineTransform trans) throws NoninvertibleTransformException {
        this(boundRect, trans);
        this.createGradients(I, colors);
    }

    public void createGradients(Color color1, Color color2) {
        int rgb1 = color1.getRGB();
        int rgb2 = color2.getRGB();
        int a1 = rgb1 >> 24 & 0xFF;
        int r1 = rgb1 >> 16 & 0xFF;
        int g1 = rgb1 >> 8 & 0xFF;
        int b1 = rgb1 & 0xFF;
        int da = (rgb2 >> 24 & 0xFF) - a1;
        int dr = (rgb2 >> 16 & 0xFF) - r1;
        int dg = (rgb2 >> 8 & 0xFF) - g1;
        int db = (rgb2 & 0xFF) - b1;
        this.model = (rgb1 & rgb2) >>> 24 == 255 ? xrgbmodel : ColorModel.getRGBdefault();
        this.gradient = new int[256];
        int rgb = 0;
        for (int i = 0; i <= 255; ++i) {
            double rel = (float)i / 255.0f;
            this.gradient[i] = rgb = (int)((double)a1 + (double)da * rel) << 24 | (int)((double)r1 + (double)dr * rel) << 16 | (int)((double)g1 + (double)dg * rel) << 8 | (int)((double)b1 + (double)db * rel);
        }
    }

    public void createGradients(double[] I, Color[] colors) {
        int n = I.length;
        double Imin = 1.0;
        double len = 0.0;
        for (int i = 0; i < n; ++i) {
            len = I[i];
            if (len == 0.0) continue;
            Imin = Imin > len ? len : Imin;
        }
        int transparencyTest = -16777216;
        int[][] gradients = new int[n][];
        int gradientsTot = 1;
        int rgb1 = 0;
        int rgb2 = 0;
        for (int i = 0; i < n; ++i) {
            len = I[i];
            if (len == 0.0) {
                gradients[i] = new int[0];
                continue;
            }
            int nGradients = (int)(len / Imin * 255.0);
            gradientsTot += nGradients;
            gradients[i] = new int[nGradients];
            double stepSize = 1.0 / (double)nGradients;
            rgb1 = colors[i].getRGB();
            rgb2 = colors[i + 1].getRGB();
            int a1 = rgb1 >> 24 & 0xFF;
            int r1 = rgb1 >> 16 & 0xFF;
            int g1 = rgb1 >> 8 & 0xFF;
            int b1 = rgb1 & 0xFF;
            int da = (rgb2 >> 24 & 0xFF) - a1;
            int dr = (rgb2 >> 16 & 0xFF) - r1;
            int dg = (rgb2 >> 8 & 0xFF) - g1;
            int db = (rgb2 & 0xFF) - b1;
            transparencyTest &= rgb1;
            transparencyTest &= rgb2;
            for (int j = 0; j < nGradients; ++j) {
                int rgb;
                gradients[i][j] = rgb = (int)((double)a1 + (double)(j * da) * stepSize) << 24 | (int)((double)r1 + (double)(j * dr) * stepSize) << 16 | (int)((double)g1 + (double)(j * dg) * stepSize) << 8 | (int)((double)b1 + (double)(j * db) * stepSize);
            }
        }
        this.gradient = new int[gradientsTot];
        int curOffset = 0;
        for (int i = 0; i < n; ++i) {
            System.arraycopy(gradients[i], 0, this.gradient, curOffset, gradients[i].length);
            curOffset += gradients[i].length;
        }
        this.gradient[this.gradient.length - 1] = colors[colors.length - 1].getRGB();
        this.model = transparencyTest >>> 24 == 255 ? xrgbmodel : ColorModel.getRGBdefault();
    }

    public void dispose() {
        this.saved = null;
    }

    public ColorModel getColorModel() {
        return this.model;
    }

    public Raster getRaster(int x, int y, int w, int h) {
        if (this.saved == null || this.saved.getWidth() < w || this.saved.getHeight() < h) {
            this.saved = this.getColorModel().createCompatibleWritableRaster(w, h);
        }
        Raster raster = this.saved;
        DataBufferInt rasterDB = (DataBufferInt)raster.getDataBuffer();
        int[] pixels = rasterDB.getBankData()[0];
        int off = rasterDB.getOffset();
        int scanlineStride = ((SinglePixelPackedSampleModel)raster.getSampleModel()).getScanlineStride();
        int adjust = scanlineStride - w;
        this.fillRaster1(pixels, off, adjust, x, y, w, h);
        return raster;
    }

    void fillRaster1(int[] pixels, int off, int adjust, int x, int y, int w, int h) {
        int rgb = 0;
        int x2 = this.bounds.x + this.bounds.width;
        int y2 = this.bounds.y + this.bounds.height;
        int rowLimit = x + w;
        int lLimit = 0;
        int rLimit = 0;
        int startOff = 0;
        double fGradientValue = 1.0;
        int j = 0;
        double X = 0.0;
        double Y = 0.0;
        double a00 = this.invMatrix[0];
        double a10 = this.invMatrix[1];
        double a01 = this.invMatrix[2];
        double a11 = this.invMatrix[3];
        double a02 = this.invMatrix[4];
        double a12 = this.invMatrix[5];
        int maxGradientIndex = this.gradient.length - 1;
        for (int i = 0; i < h; ++i) {
            rowLimit = off + w;
            if (i + y < this.bounds.y || i + y > y2 || x + w < this.bounds.x || x > x2) {
                rgb = this.gradient[maxGradientIndex];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            } else {
                startOff = off;
                rgb = this.gradient[maxGradientIndex];
                lLimit = off + this.bounds.x - x;
                rLimit = lLimit + this.bounds.width;
                int n = rLimit = rLimit > rowLimit ? rowLimit : rLimit;
                while (off < lLimit) {
                    pixels[off++] = rgb;
                }
                j = x + off - startOff;
                X = a00 * (double)j + a01 * (double)(y + i) + a02;
                Y = a10 * (double)j + a11 * (double)(y + i) + a12;
                while (off < rLimit) {
                    fGradientValue = this.calcGradientValue(X, Y);
                    assert (fGradientValue >= 0.0);
                    assert (fGradientValue <= 1.0);
                    pixels[off++] = this.gradient[(int)(fGradientValue * (double)maxGradientIndex)];
                    X += a00;
                    Y += a10;
                }
                rgb = this.gradient[maxGradientIndex];
                while (off < rowLimit) {
                    pixels[off++] = rgb;
                }
            }
            off += adjust;
        }
    }
}

