/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Patch {
    protected static int s_nMaxCountOfDivisions = 1;
    protected static String s_tab = "";
    protected int m_nIndex = 1;
    protected Point3d[][] m_pp = new Point3d[4][4];

    public Patch(double x, double y, double z) {
        this.m_pp[0][0] = new Point3d(x, y, z);
    }

    public Patch(Point3d[][] p, boolean isTransposed) {
        if (isTransposed) {
            Patch.transpose(p);
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                this.m_pp[i][j] = p[i][j];
            }
        }
    }

    public static final void transpose(Point3d[][] pp) {
        for (int i = 0; i < 4; ++i) {
            Patch.transpose(pp[i][i]);
            for (int j = 0; j < i; ++j) {
                Point3d temp = pp[i][j];
                pp[i][j] = Patch.transpose(pp[j][i]);
                pp[j][i] = Patch.transpose(temp);
            }
        }
    }

    public final void translate(Point3d shift) {
        if (shift == null) {
            return;
        }
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (this.m_pp[i][j] == null) continue;
                this.m_pp[i][j].plusPlus(shift);
            }
        }
    }

    public static final Point3d transpose(Point3d p) {
        double temp = p.x;
        p.x = p.z;
        p.z = temp;
        return p;
    }

    protected final Point3d[] getCorners() {
        Point3d[] cc = new Point3d[]{this.m_pp[0][3], this.m_pp[0][0], this.m_pp[3][0], this.m_pp[3][3]};
        return cc;
    }

    public Point3d getLocation() {
        return new Point3d(this.m_pp[0][0]);
    }

    protected final void setNextHorizontalPatch(Patch next) {
        for (int i = 0; i < 3; ++i) {
            this.m_pp[3][i] = next.m_pp[0][i];
        }
    }

    protected final void setNextVerticalPatch(Patch next) {
        for (int i = 0; i < 3; ++i) {
            this.m_pp[i][3] = next.m_pp[i][0];
        }
    }

    protected final void setNextCorner(Patch next) {
        this.m_pp[3][3] = next.m_pp[0][0];
    }

    protected final void setHorizontalCoordinates(float[] coors) {
        double locZ = this.m_pp[0][0].z;
        this.m_pp[0][1] = new Point3d(coors[0], coors[1], locZ);
        this.m_pp[0][2] = new Point3d(coors[2], coors[3], locZ);
    }

    protected final void setVerticalCoordinates(float[] coors) {
        double locX = this.m_pp[0][0].x;
        this.m_pp[1][0] = new Point3d(locX, coors[1], coors[0]);
        this.m_pp[2][0] = new Point3d(locX, coors[3], coors[2]);
    }

    protected final void updateMatrix() {
        int[] nCorner = new int[4];
        nCorner[1] = 0;
        nCorner[0] = 0;
        nCorner[3] = 3;
        nCorner[2] = 3;
        for (int i = 1; i <= 2; ++i) {
            for (int j = 1; j <= 2; ++j) {
                Point3d a = this.m_pp[i][nCorner[j]];
                Point3d b = this.m_pp[nCorner[i]][j];
                Point3d c = this.m_pp[nCorner[i]][nCorner[j]];
                if (a == null || b == null || c == null) {
                    throw new RuntimeException("Not defined a = " + a + ", b = " + b + ", c = " + c);
                }
                double x = a.x + b.x - c.x;
                double y = a.y + b.y - c.y;
                double z = a.z + b.z - c.z;
                this.m_pp[i][j] = new Point3d(x, y, z);
            }
        }
    }

    public static final Point3d calcInterPoint(int i, int j, double t1, double t2, Point3d[][] b) {
        Point3d b1 = new Point3d(b[i][j - 1]);
        Point3d b2 = new Point3d(b[i + 1][j - 1]);
        b1.multMult(t1).plusPlus(b2.multMult(t2));
        return b1;
    }

    public static void subdivisionDeCasteljau(Point3d[] given, Point3d[] left, Point3d[] right, double t1) {
        int i;
        Point3d[][] b = new Point3d[4][4];
        double t2 = 1.0 - t1;
        for (i = 0; i < 4; ++i) {
            b[i][0] = given[i];
        }
        b[0][1] = Patch.calcInterPoint(0, 1, t1, t2, b);
        b[1][1] = Patch.calcInterPoint(1, 1, t1, t2, b);
        b[2][1] = Patch.calcInterPoint(2, 1, t1, t2, b);
        b[0][2] = Patch.calcInterPoint(0, 2, t1, t2, b);
        b[1][2] = Patch.calcInterPoint(1, 2, t1, t2, b);
        b[0][3] = Patch.calcInterPoint(0, 3, t1, t2, b);
        for (i = 0; i < 4; ++i) {
            left[i] = b[0][i];
            right[i] = b[i][3 - i];
        }
    }

    public void subdivision(List<Patch> list, int nMaxCountOfDivisions) {
        s_nMaxCountOfDivisions = nMaxCountOfDivisions;
        this.subdivision(new Patch[2], list, 1);
    }

    private void subdivision(Patch[] pair, List<Patch> list, int nTimes) {
        Point3d[][] d0 = new Point3d[4][4];
        Point3d[][] d1 = new Point3d[4][4];
        for (int i = 0; i < 4; ++i) {
            d0[i] = new Point3d[4];
            d1[i] = new Point3d[4];
            Patch.subdivisionDeCasteljau(this.m_pp[i], d0[i], d1[i], 0.5);
        }
        boolean isTransposed = true;
        pair[0] = new Patch(d0, isTransposed);
        pair[1] = new Patch(d1, isTransposed);
        if (list == null) {
            return;
        }
        Patch[][] quarterPatch = new Patch[2][2];
        pair[0].subdivision(quarterPatch[0], null, -1);
        pair[1].subdivision(quarterPatch[1], null, -1);
        boolean bStopRecurence = nTimes > s_nMaxCountOfDivisions || this.isAcceptable();
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                Patch patch = quarterPatch[i][j];
                patch.setIndex(this.getIndex() * 4 + 2 * i + j);
                if (bStopRecurence) {
                    list.add(patch);
                    continue;
                }
                patch.subdivision(pair, list, nTimes + 1);
            }
        }
    }

    public int getIndex() {
        return this.m_nIndex;
    }

    public int getParentIndex() {
        return this.m_nIndex / 4;
    }

    protected void setIndex(int n) {
        this.m_nIndex = n;
    }

    public Patch createPatchForConnected(double[] d, Point3d heightVect, boolean isConnectedGroup) {
        Point3d point = null;
        Point3d vect = null;
        Patch newPatch = new Patch(0.0, 0.0, 0.0);
        for (int row = 0; row < 4; ++row) {
            point = this.m_pp[row][0];
            vect = this.m_pp[row][3].minus(point);
            vect.y = 0.0;
            newPatch.m_pp[row][0] = point.plus(d[0], vect);
            newPatch.m_pp[row][1] = point.plus(d[1], vect);
            newPatch.m_pp[row][1].plusPlus(heightVect);
            newPatch.m_pp[row][2] = point.plus(d[2], vect);
            newPatch.m_pp[row][1].plusPlus(heightVect);
            newPatch.m_pp[row][3] = point.plus(d[3], vect);
        }
        return newPatch;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer().append("Patch:\n");
        buf.append(Patch.write(this.m_pp));
        return buf.toString();
    }

    public boolean isCompleted() {
        for (int i = 1; i <= 2; ++i) {
            for (int j = 1; j <= 2; ++j) {
                if (this.m_pp[i][j] != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isAcceptable() {
        return false;
    }

    public static void test1() {
        Object[][] net = new Point3d[4][4];
        Object p = null;
        Patch.generateNet(net, -1.0, 1.0, -1.0, 1.0);
        System.out.println(Patch.write((Point3d[][])net).toString());
        for (int i = 0; i < 4; i += 3) {
            for (int j = 0; j < 4; j += 3) {
                p = net[i][j];
                Patch.checkPoint((Point3d)p);
            }
        }
        Patch patch = new Patch((Point3d[][])net, false);
        ArrayList<Patch> list = new ArrayList<Patch>();
        Patch[] pair = new Patch[2];
        patch.subdivision(pair, list, 0);
        for (Patch obj : list) {
            if (obj instanceof Integer) {
                System.out.print("\n " + obj + ">\t");
                continue;
            }
            p = (Point3d)((Object)obj);
            Patch.checkPoint((Point3d)p);
        }
        System.out.println();
    }

    static Point3d pP(double x, double y, double z) {
        return new Point3d(x, y, z);
    }

    public static StringBuffer write(Point3d p) {
        StringBuffer buf = new StringBuffer().append('\t').append('[');
        if (p == null) {
            buf.append("NULL");
        } else {
            buf.append(Math.floor(p.x * 100.0) / 100.0).append(',');
            buf.append(Math.floor(p.y * 100.0) / 100.0).append(',');
            buf.append(Math.floor(p.z * 100.0) / 100.0);
        }
        return buf.append(']');
    }

    public static StringBuffer writeXZ(Point3d p) {
        StringBuffer buf = new StringBuffer().append(' ').append('[');
        if (p == null) {
            buf.append("NULL");
        } else {
            buf.append((int)p.x / 100).append(',');
            buf.append((int)p.z / 100);
        }
        return buf.append(']');
    }

    public static StringBuffer write(double[] p) {
        StringBuffer buf = new StringBuffer().append('\t').append('[');
        if (p == null) {
            buf.append("NULL");
        } else {
            for (int i = 0; i < p.length; ++i) {
                if (i > 0) {
                    buf.append(',');
                }
                buf.append(Math.floor(p[i] * 100.0) / 100.0);
            }
        }
        return buf.append(']');
    }

    private static StringBuffer write(Point3d[][] net) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                buf.append(", ").append(Patch.write(net[i][j]));
            }
            buf.append('\n');
        }
        return buf;
    }

    private static void checkPoint(Point3d p) {
        double dError = p.y - Patch.monkeySaddleValue(p.x, p.z);
        System.out.println("checkPoint " + Patch.write(p) + "\tError = " + dError);
    }

    static Point3d monkeySaddle(double u, double v) {
        return new Point3d(u, Patch.monkeySaddleValue(u, v), v);
    }

    static double monkeySaddleValue(double u, double v) {
        return u * u * u - 3.0 * u * v * v;
    }

    public static Point3d monkeySaddleTriForm(double u1, double u2, double u3, double v1, double v2, double v3) {
        Point3d p = new Point3d();
        p.x = (u1 + u2 + u3) / 3.0;
        p.y = u1 * u2 * u3 - (u1 + u2 + u3) * (v1 * v2 + v1 * v3 + v2 * v3) / 3.0;
        p.z = (v1 + v2 + v3) / 3.0;
        return p;
    }

    public static void generateNet(Object[][] b, double r1, double s1, double r2, double s2) {
        double[][] x = new double[3][3];
        for (int i = 0; i < 4; ++i) {
            x[0][0] = i < 3 ? r1 : s1;
            x[0][1] = i < 2 ? r1 : s1;
            x[0][2] = i < 1 ? r1 : s1;
            for (int j = 0; j < 4; ++j) {
                x[1][0] = j < 3 ? r2 : s2;
                x[1][1] = j < 2 ? r2 : s2;
                x[1][2] = j < 1 ? r2 : s2;
                b[i][j] = Patch.monkeySaddleTriForm(x[0][0], x[0][1], x[0][2], x[1][0], x[1][1], x[1][2]);
            }
        }
    }
}

