/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.my2D.model3d;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.Interpolation2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.Arrays;

class GridlineView {
    private JChart_3D m_chart;
    private Point3d m_size;
    private Point3d[] m_vertices;
    private Point3d[] m_points;

    GridlineView(JChart_3D chart, boolean isConstantZ, Point3d[] points, Point3d size) {
        this.m_chart = chart;
        this.m_size = new Point3d(size);
        this.m_points = new Point3d[points.length];
        for (int i = 0; i < points.length; ++i) {
            this.m_points[i] = new Point3d(points[i]);
        }
    }

    public Point3d[] getPoints() {
        Point3d[] points = new Point3d[this.m_points.length];
        for (int i = 0; i < this.m_points.length; ++i) {
            points[i] = new Point3d(points[i]);
        }
        return points;
    }

    public static Point3d[] calcVertices(JChart_3D chart, Point3d[] points) {
        int nLen = points.length;
        Point3d[] vertices = new Point3d[nLen];
        for (int i = 0; i < vertices.length; ++i) {
            Point3d vertex = new Point3d();
            chart.getMatrix().transformPoint3d(points[i], vertex);
            vertices[i] = vertex;
        }
        return vertices;
    }

    Shape getShape() {
        if (this.m_vertices == null) {
            this.m_vertices = GridlineView.calcVertices(this.m_chart, this.m_points);
        }
        int nLen = this.m_vertices.length;
        Point2D.Double[] points2D = new Point2D.Double[nLen];
        for (int i = 0; i < nLen; ++i) {
            points2D[i] = this.m_chart.projectPoint3dInDouble(this.m_vertices[i]);
        }
        boolean isClosed = false;
        GeneralPath path = new GeneralPath();
        Interpolation2D.createSmoothPath(path, Arrays.asList(points2D), isClosed);
        return path;
    }

    public final JChart_3D getChart() {
        return this.m_chart;
    }

    public Point3d getSize() {
        return new Point3d(this.m_size);
    }

    public double getMinZ() {
        if (this.m_vertices == null) {
            this.m_vertices = GridlineView.calcVertices(this.m_chart, this.m_points);
        }
        double dMinZ = Double.MAX_VALUE;
        for (int i = 0; i < this.m_vertices.length; ++i) {
            double fZ = this.m_vertices[i].z;
            if (!(fZ > dMinZ)) continue;
            dMinZ = fZ;
        }
        return dMinZ;
    }
}

