/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.math;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.Interpolation2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.Jet_2D;
import java.awt.Polygon;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ListIterator;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SplineQuantizer2D {
    private static final Logger logger = Logger.getLogger((String)"com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.SplineQuantizer2D");
    public static boolean DEBUG = false;
    public static final double X_AXIS = 0.0;
    public static final double Y_AXIS = 1.0;
    public static final float SMALL_FLOAT = 1.0E-5f;
    private static final Comparator s_comparator = new Comparator(){

        public int compare(Object obj1, Object obj2) {
            double d2;
            Point2D p1 = (Point2D)obj1;
            Point2D p2 = (Point2D)obj2;
            double d1 = p1.getX();
            if (d1 < (d2 = p2.getX())) {
                return -1;
            }
            if (d2 > d1) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }
    };

    private SplineQuantizer2D() {
    }

    public static List<Point2D> calcListOfPoint2DFloat(List<Point2D> list, int nSegments, GeneralPath path) {
        GeneralPath path1 = null;
        path1 = path != null && path.getCurrentPoint() == null ? path : new GeneralPath();
        Interpolation2D.createSmoothPath(path1, list, false);
        return SplineQuantizer2D.quantize(path1, nSegments, false);
    }

    public static List<Point2D.Float> calcListOfJet_2D_fast(List<Point2D> list, double dFlatness, GeneralPath path) {
        GeneralPath path1 = null;
        path1 = path != null && path.getCurrentPoint() == null ? path : new GeneralPath();
        Interpolation2D.createSmoothPath(path1, list, false);
        return SplineQuantizer2D.quantize_fast(path1, dFlatness, true);
    }

    public static List<Point2D> calcListOfJet_2D(List<Point2D> list, int nSegments, GeneralPath path) {
        GeneralPath path1 = null;
        path1 = path != null && path.getCurrentPoint() == null ? path : new GeneralPath();
        Interpolation2D.createSmoothPath(path1, list, false);
        return SplineQuantizer2D.quantize(path1, nSegments, true);
    }

    public static List<Point2D.Float> quantize_fast(GeneralPath path, double dFlatness, boolean bSlopeInfo) {
        ArrayList<Point2D.Float> listOfCrossings = new ArrayList<Point2D.Float>();
        PathIterator pi = path.getPathIterator(null, dFlatness);
        float[] seg = new float[6];
        float fX = 0.0f;
        float fY = 0.0f;
        while (!pi.isDone()) {
            int segType = pi.currentSegment(seg);
            switch (segType) {
                case 0: 
                case 1: {
                    fX = seg[0];
                    fY = seg[1];
                    listOfCrossings.add(new Point2D.Float(fX, fY));
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal seg type : " + segType);
                }
            }
            pi.next();
        }
        if (bSlopeInfo) {
            ListIterator<Jet_2D> it1 = listOfCrossings.listIterator();
            Point2D.Float ptLast = (Point2D.Float)it1.next();
            Point2D.Float pt = (Point2D.Float)listOfCrossings.get(1);
            Point2D.Float vect = new Point2D.Float(ptLast.x - pt.x, ptLast.y - pt.y);
            pt = ptLast;
            it1.set(new Jet_2D(pt, vect));
            while (it1.hasNext()) {
                ptLast = pt;
                pt = (Point2D.Float)it1.next();
                vect = new Point2D.Float(ptLast.x - pt.x, ptLast.y - pt.y);
                it1.set(new Jet_2D(pt, vect));
            }
        }
        return listOfCrossings;
    }

    public static List<Point2D> quantize(GeneralPath path, int nSegments, boolean bSlopeInfo) {
        float fLastX;
        int nLast;
        ArrayList<Point2D> listOfCrossings = new ArrayList<Point2D>();
        Rectangle2D rect = path.getBounds2D();
        float fWidth = (float)rect.getWidth();
        float fXMin = (float)rect.getX();
        float fXMax = fXMin + fWidth - 1.0E-5f;
        float delta = (fWidth - 1.0E-5f) / (float)nSegments;
        PathIterator pathIt = path.getPathIterator(null);
        float[] currentPoint = new float[2];
        for (float fX = fXMin; fX < fXMax; fX += delta) {
            SplineQuantizer2D.crossingsForPath(currentPoint, pathIt, fX, listOfCrossings, bSlopeInfo);
        }
        if (fXMax - (fX -= delta) > 1.0E-5f) {
            SplineQuantizer2D.crossingsForPath(currentPoint, pathIt, fXMax, listOfCrossings, bSlopeInfo);
        }
        Collections.sort(listOfCrossings, s_comparator);
        if (bSlopeInfo && listOfCrossings.size() > 1) {
            Jet_2D first = (Jet_2D)listOfCrossings.get(0);
            Jet_2D second = (Jet_2D)listOfCrossings.get(1);
            first.setSlopeTan(second.getSlopeTan());
        }
        if (DEBUG && (nLast = listOfCrossings.size() - 1) >= 0 && FP.nonzero((fLastX = ((Point2D.Float)listOfCrossings.get((int)nLast)).x) - fXMax)) {
            System.out.println("SplineQuantizer2D#calcListOfPoint2DFloat fMaxX not reached.");
        }
        return listOfCrossings;
    }

    public static int crossingsForPath(float[] currentPoint, PathIterator pi, float xx, List<Point2D> list, boolean bSlopeInfo) {
        float curx = currentPoint[0];
        float cury = currentPoint[1];
        float newx = 0.0f;
        float newy = 0.0f;
        int cross = 0;
        float[] coords = new float[6];
        while (!pi.isDone()) {
            int nType = pi.currentSegment(coords);
            switch (nType) {
                case 0: {
                    curx = newx = coords[0];
                    cury = newy = coords[1];
                    Point2D.Float point = new Point2D.Float(curx, cury);
                    if (bSlopeInfo) {
                        Point2D.Float tangent = new Point2D.Float(1.0f, 0.0f);
                        list.add(new Jet_2D(point, tangent));
                    } else {
                        list.add(point);
                    }
                    cross = 0;
                    break;
                }
                case 1: {
                    newx = coords[0];
                    newy = coords[1];
                    if (!(xx >= curx) || !(xx < newx)) break;
                    cross += SplineQuantizer2D.crossingsForLine(xx, curx, cury, newx, newy, list, bSlopeInfo);
                    break;
                }
                case 2: {
                    newx = coords[2];
                    newy = coords[3];
                    if (!(xx > curx) || !(xx <= newx)) break;
                    cross += SplineQuantizer2D.crossingsForQuad(xx, curx, cury, coords, list, bSlopeInfo);
                    break;
                }
                case 3: {
                    newx = coords[4];
                    newy = coords[5];
                    if (!(xx > curx) || !(xx <= newx)) break;
                    cross += SplineQuantizer2D.crossingsForCubic(xx, curx, cury, coords, list, bSlopeInfo);
                    break;
                }
            }
            if (xx >= newx) {
                curx = newx;
                cury = newy;
                pi.next();
                continue;
            }
            currentPoint[0] = curx;
            currentPoint[1] = cury;
            return cross;
        }
        return cross;
    }

    public static int crossingsForCubic(float xx, float curx, float cury, float[] coords, List<Point2D> list, boolean bSlopeInfo) {
        double[] eqnX = new double[4];
        double[] eqnY = new double[4];
        double[] res = new double[3];
        SplineQuantizer2D.oder3_getEqn(eqnX, curx, coords[0], coords[2], coords[4]);
        eqnX[0] = eqnX[0] - (double)xx;
        int nRoots = CubicCurve2D.solveCubic(eqnX, res);
        double t = 0.0;
        float yy = 0.0f;
        int nProperRoots = 0;
        for (int i = 0; i < nRoots; ++i) {
            float yy2;
            float yy1;
            t = res[i];
            if (!(t >= 0.0) || !(t <= 1.0)) continue;
            SplineQuantizer2D.oder3_getEqn(eqnY, cury, coords[1], coords[3], coords[5]);
            if (++nProperRoots == 1) {
                yy = (float)SplineQuantizer2D.cubicValue(eqnY, t);
                Point2D.Float point = new Point2D.Float(xx, yy);
                if (bSlopeInfo) {
                    Point2D.Float tangent = new Point2D.Float(SplineQuantizer2D.cubicDerivative(eqnX, t), SplineQuantizer2D.cubicDerivative(eqnY, t));
                    list.add(new Jet_2D(point, tangent));
                } else {
                    list.add(point);
                }
            }
            if (!DEBUG) continue;
            yy = (float)SplineQuantizer2D.cubicValue(eqnY, t);
            System.out.println("\nSplineQuantizer2D   solution  at  x = " + xx + "  after cur = [" + curx + "," + cury + "]");
            float xx1 = (float)SplineQuantizer2D.cubicValue(eqnX, t);
            if (FP.nonzero(xx1)) {
                System.out.println("ERROR 0 != " + xx1);
            }
            if (FP.nonzero((yy1 = (float)SplineQuantizer2D.cubicValue(eqnY, 0.0)) - cury)) {
                System.out.println("ERROR cury != " + yy1);
            }
            if (FP.nonzero((yy2 = (float)SplineQuantizer2D.cubicValue(eqnY, 1.0)) - coords[5])) {
                System.out.println("ERROR newy != " + yy1);
            }
            System.out.println("No " + nProperRoots + "\tt=" + t + "\ty = " + yy + " for  y  from " + yy1 + " to " + yy2);
        }
        if (DEBUG && nProperRoots == 0) {
            System.out.println("\nSplineQuantizer2D NO SOLUTIONS at  x = " + xx + "  after cur = [" + curx + "," + cury + "]");
        }
        return nRoots;
    }

    public static int crossingsForQuad(float xx, float curx, float cury, float[] coords, List<Point2D> list, boolean bSlopeInfo) {
        double[] eqnX = new double[3];
        double[] eqnY = new double[3];
        double[] res = new double[2];
        SplineQuantizer2D.oder2_getEqn(eqnX, curx, coords[0], coords[2]);
        eqnX[0] = eqnX[0] - (double)xx;
        int nRoots = CubicCurve2D.solveCubic(eqnX, res);
        if (nRoots > 0) {
            double t = res[0];
            if (t < 0.0 || t > 1.0) {
                throw new RuntimeException(" Bad root " + t);
            }
            SplineQuantizer2D.oder2_getEqn(eqnY, cury, coords[1], coords[3]);
            float yy = (float)SplineQuantizer2D.quadraticValue(eqnY, t);
            Point2D.Float point = new Point2D.Float(xx, yy);
            if (bSlopeInfo) {
                Point2D.Float tangent = new Point2D.Float(SplineQuantizer2D.quadraticDerivative(eqnX, t), SplineQuantizer2D.quadraticDerivative(eqnY, t));
                list.add(new Jet_2D(point, tangent));
            } else {
                list.add(point);
            }
            if (DEBUG && nRoots > 1) {
                String str = "SplineQuantizer2D Solution no ";
                for (int i = 0; i < nRoots; ++i) {
                    t = res[i];
                    yy = (float)SplineQuantizer2D.quadraticValue(eqnX, t);
                    System.out.println(str + (i + 1) + " at x = " + xx + " is  y = " + yy);
                }
            }
        } else if (DEBUG) {
            System.out.println("SplineQuantizer2D No solutions for x = " + xx);
        }
        return nRoots;
    }

    public static int crossingsForLine(float xx, float curx, float cury, float tox, float toy, List<Point2D> list, boolean bSlopeInfo) {
        double delta = tox - curx;
        if (delta <= 0.0 || xx < curx || xx > tox) {
            if (DEBUG) {
                System.out.println("SplineQuantizer2D  bad order of  start = " + curx + ",x = " + xx + ",end = " + tox);
            }
            return 0;
        }
        double t = (double)(xx - curx) / delta;
        float yy = (float)((double)cury + t * (double)(toy - cury));
        Point2D.Float point = new Point2D.Float(xx, yy);
        if (bSlopeInfo) {
            Point2D.Float tangent = new Point2D.Float(tox - curx, toy - cury);
            list.add(new Jet_2D(point, tangent));
        } else {
            list.add(point);
        }
        return 1;
    }

    public static double cubicValue(double[] eqn, double t) {
        double dValue = ((eqn[3] * t + eqn[2]) * t + eqn[1]) * t + eqn[0];
        return dValue;
    }

    public static double quadraticValue(double[] eqn, double t) {
        double dValue = (eqn[2] * t + eqn[1]) * t + eqn[0];
        return dValue;
    }

    public static float cubicDerivative(double[] eqn, double t) {
        double eqnPrim2 = 3.0 * eqn[3];
        double eqnPrim1 = 2.0 * eqn[2];
        double dValue = (eqnPrim2 * t + eqnPrim1) * t + eqnPrim2;
        return (float)dValue;
    }

    public static float quadraticDerivative(double[] eqn, double t) {
        double eqnPrim1 = 2.0 * eqn[2];
        double eqnPrim0 = eqn[1];
        double dValue = eqnPrim1 * t + eqnPrim0;
        return (float)dValue;
    }

    public static void oder3_getEqn(double[] eqn, double c0, double cp0, double cp1, double c1) {
        logger.error((Object)"re-implement me.");
    }

    public static void oder2_getEqn(double[] eqn, double c0, double cp, double c1) {
        logger.error((Object)"re-implement me.");
    }

    public static Polygon createPolygon(List<Point2D> list) {
        assert (list != null);
        Polygon polygon = new Polygon();
        boolean isFirstPoint = true;
        int x = 0;
        int y = 0;
        for (Point2D obj : list) {
            if (!(obj instanceof Point2D)) continue;
            x = (int)obj.getX();
            y = (int)obj.getY();
            if (isFirstPoint) {
                polygon.addPoint(x, 0);
                isFirstPoint = false;
            }
            polygon.addPoint(x, y);
        }
        polygon.addPoint(x, 0);
        return polygon;
    }
}

