/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.export;

import com.businessobjects.visualization.pfjgraphics.rendering.converter.AdvFormatStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.converter.UniversalPictureStruct;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.export.AxisInfo;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.export.Format3TFExc;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.export.PerspectiveHandler;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.export.Tag3TF;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.export.Tags3TF;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Attr;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Color;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.Format;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class Export3TF {
    private static final boolean DEBUG_RECORDSIZE = true;
    private static final boolean ACTIVATE_RECORD_TERMINATOR = false;
    private static final short CURRENT_VDM_VERSION = 3;
    public static final int CURRENT_MAJOR_REVISION = 2;
    public static final int CURRENT_MINOR_REVISION = 100;
    private static final byte BYTE_FORMAT = 0;
    private static final byte BYTE_ALIGN = 0;
    private static final Logger log = Logger.getLogger((String)"com.businessobjects.visualization.pfjgraphics.rendering.pfj.export.Export3TF");
    private final DataOutputStream m_outStream;
    private final PerspectiveHandler m_ph;
    private int m_tagCount = 0;
    private int m_lastTag = -1;
    private int m_requestedWriteByteSize;
    private int m_startingByteCounter;
    private byte m_byteOrder;
    private short m_request;
    private short m_encoding;
    private String m_stringConv;
    private int m_bytesPerChar;
    private boolean m_useVirtualCoordiantes = true;
    private final boolean ADD_TERMINATOR = true;
    private final boolean SIZE_IN_BYTES = true;
    private final boolean SIZE_IN_CHARS = false;
    private final short debug = 0;
    List<FontEntry> fonts = new ArrayList<FontEntry>();

    public Export3TF(DataOutputStream outStream, Perspective p) {
        this(outStream, p, 1, 2);
    }

    public Export3TF(DataOutputStream outStream, Perspective p, short encoding, byte byteorder) {
        this.m_outStream = outStream;
        this.m_ph = p == null ? null : new PerspectiveHandler(p);
        this.m_encoding = encoding;
        this.m_byteOrder = byteorder;
        switch (encoding) {
            case 2: {
                this.m_bytesPerChar = 2;
                if (byteorder == 1) {
                    this.m_stringConv = "UTF-16BE";
                    break;
                }
                this.m_stringConv = "UTF-16LE";
                break;
            }
            default: {
                this.m_bytesPerChar = 1;
                this.m_stringConv = "UTF-8";
            }
        }
    }

    public Export3TF(DataOutputStream outStream, byte byteorder) {
        this(outStream, null, 2, byteorder);
    }

    public void writeTIFF(short nTag, short nSize) throws IOException {
        this.writeTIFF(nTag, nSize, "???");
    }

    public void writeTIFF(Tag3TF tag) throws IOException, Format3TFExc {
        this.writeTIFF(tag.getId(), tag.getSize(), tag.getName());
    }

    public void writeTIFF(Tag3TF tag, short nSize) throws IOException, Format3TFExc {
        this.writeTIFF(tag.getId(), nSize, tag.getName());
    }

    public void writeTIFF(short nTag, short nSize, String sTagName) throws IOException {
        if (this.m_lastTag != -1) {
            this.checkRecordSize();
        }
        if (nSize < 0 && log.isDebugEnabled()) {
            log.error((Object)("will be writing " + sTagName + " (" + nTag + ")" + " of NEGATIVE size " + nSize));
        }
        ++this.m_tagCount;
        if (log.isDebugEnabled()) {
            log.debug((Object)("writing " + sTagName + " (" + nTag + ")" + " of size " + nSize + " at " + this.m_outStream.size()));
        }
        this.writeShort(nTag);
        this.writeShort(nSize);
        this.m_lastTag = nTag;
        this.m_requestedWriteByteSize = nSize;
        this.m_startingByteCounter = this.m_outStream.size();
    }

    private void checkRecordSize() {
        int endingByteCounter = this.m_outStream.size();
        int byteSizeActuallyWritten = endingByteCounter - this.m_startingByteCounter;
        if (this.m_requestedWriteByteSize != byteSizeActuallyWritten) {
            this.printRecordSizeBad(this.m_lastTag, this.m_requestedWriteByteSize, byteSizeActuallyWritten);
        }
    }

    public void writeByte(byte data) throws IOException {
        this.m_outStream.writeByte(data);
    }

    public void writeShort(short data) throws IOException {
        if (this.m_byteOrder == 1) {
            this.m_outStream.writeShort(data);
        } else {
            short reversed = (short)(data >> 8 & 0xFF | data << 8 & 0xFF00);
            this.m_outStream.writeShort(reversed);
        }
    }

    public void writeRGB(Color c) throws IOException {
        this.writeShort(this.color16bit(c.getRed()));
        this.writeShort(this.color16bit(c.getGreen()));
        this.writeShort(this.color16bit(c.getBlue()));
    }

    public void writeRectangle(Rectangle rect) throws IOException {
        double new_xULC = 1.0239375 * (double)rect.x;
        double new_yLRC = 1.0239375 * (double)rect.y;
        double new_xLRC = new_xULC + 1.0239375 * (double)rect.width;
        double new_yULC = new_yLRC + 1.0239375 * (double)rect.height;
        this.writeShort((short)Math.round(new_xULC));
        this.writeShort((short)Math.round(new_yULC));
        this.writeShort((short)Math.round(new_xLRC));
        this.writeShort((short)Math.round(new_yLRC));
    }

    public void writeRectangleTLBR(Rectangle rect) throws IOException {
        double new_xULC = 1.0239375 * (double)rect.x;
        double new_yLRC = 1.0239375 * (double)rect.y;
        double new_xLRC = new_xULC + 1.0239375 * (double)rect.width;
        double new_yULC = new_yLRC + 1.0239375 * (double)rect.height;
        this.writeShort((short)Math.round(new_yULC));
        this.writeShort((short)Math.round(new_xULC));
        this.writeShort((short)Math.round(new_yLRC));
        this.writeShort((short)Math.round(new_xLRC));
    }

    public void writePointYX(Point p) throws IOException {
        this.writePointXY(p.y, p.x);
    }

    public void writePointYX(int x, int y) throws IOException {
        this.writePointXY(y, x);
    }

    public void writePointXY(Point p) throws IOException {
        this.writePointXY(p.x, p.y);
    }

    public void writePointXY(int x, int y) throws IOException {
        double new_x = 1.0239375 * (double)x;
        double new_y = 1.0239375 * (double)y;
        this.writeShort((short)Math.round(new_x));
        this.writeShort((short)Math.round(new_y));
    }

    public void writeInt(int data) throws IOException {
        if (this.m_byteOrder == 1) {
            this.m_outStream.writeInt(data);
        } else {
            int reversed = data >> 24 & 0xFF | data >> 8 & 0xFF00 | data << 8 & 0xFF0000 | data << 24 & 0xFF000000;
            this.m_outStream.writeInt(reversed);
        }
    }

    public void writeDouble(double data) throws IOException {
        if (this.m_byteOrder == 1) {
            this.m_outStream.writeDouble(data);
        } else {
            long ldata = Double.doubleToLongBits(data);
            long reversed = ldata >> 56 & 0xFFL | ldata >> 40 & 0xFF00L | ldata >> 24 & 0xFF0000L | ldata >> 8 & 0xFF000000L | ldata << 8 & 0xFF00000000L | ldata << 24 & 0xFF0000000000L | ldata << 40 & 0xFF000000000000L | ldata << 56 & 0xFF00000000000000L;
            this.m_outStream.writeLong(reversed);
        }
    }

    public void writeArrayOfShort(short[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.writeShort(data[i]);
        }
    }

    public void writeArrayOfInt(int[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.writeInt(data[i]);
        }
    }

    public void writeArrayOfDouble(double[] data) throws IOException {
        for (int i = 0; i < data.length; ++i) {
            this.writeDouble(data[i]);
        }
    }

    public void writeTextBytes(byte[] data, boolean wantTerminator) throws IOException {
        this.writeBytes(data);
        if (wantTerminator) {
            for (int i = 0; i < this.m_bytesPerChar; ++i) {
                this.writeByte((byte)0);
            }
        }
    }

    public void writeBytes(byte[] data) throws IOException {
        this.m_outStream.write(data, 0, data.length);
    }

    public void writeBytes(byte[] data, int off, int len) throws IOException {
        this.m_outStream.write(data, off, len);
    }

    public void writeNBytes(byte[] data, int space, boolean inBytes) throws IOException {
        int byteSpace = space * (!inBytes ? this.m_bytesPerChar : 1);
        if (data.length <= byteSpace) {
            this.m_outStream.write(data, 0, data.length);
            int fill = byteSpace - data.length;
            while (fill-- > 0) {
                this.m_outStream.writeByte(0);
            }
        } else {
            this.m_outStream.write(data, 0, byteSpace);
        }
    }

    public void writeRecordTerm() throws IOException {
    }

    public void save_VDMCell(int nPage, int nRow, int nCol, double data) throws IOException {
        this.writeTIFF(Tags3TF.TAG_VDM_REALCELL);
        this.writeShort((short)nPage);
        this.writeShort((short)nRow);
        this.writeShort((short)nCol);
        this.writeByte((byte)0);
        this.writeByte((byte)0);
        this.writeDouble(data);
    }

    private int getTextLen(byte[] text, boolean wantTerminator, boolean inBytes) {
        int len = text.length;
        if (wantTerminator) {
            len += this.m_bytesPerChar;
        }
        if (!inBytes) {
            len /= this.m_bytesPerChar;
        }
        return len;
    }

    public void save_VDMCell(int nPage, int nRow, int nCol, String data) throws IOException {
        byte[] text = data.getBytes(this.m_stringConv);
        int textlen = this.getTextLen(text, true, true);
        this.writeTIFF(Tags3TF.TAG_VDM_TEXTCELL, (short)(8 + textlen));
        this.writeShort((short)nPage);
        this.writeShort((short)nRow);
        this.writeShort((short)nCol);
        this.writeByte((byte)-1);
        this.writeByte((byte)-1);
        this.writeTextBytes(text, true);
    }

    public void saveStruct_dPoint3D(Point3d dPoint3D, short nIndex, short nDestID) throws IOException {
        if (dPoint3D != null) {
            this.writeTIFF(Tags3TF.TAG_DPOINT3D);
            this.writeShort(nIndex);
            this.writeShort(nDestID);
            int x = (int)dPoint3D.x;
            int y = (int)dPoint3D.y;
            int z = (int)dPoint3D.z;
            this.writeInt(x);
            this.writeInt(y);
            this.writeInt(z);
        }
    }

    public void saveStruct_AreaInstRec(IdentObj id, short nIndex, short nDestID) throws IOException {
        short pattern = this.m_ph.getPattern(id);
        Color pcolor = new Color(0, 0, 0);
        if (pattern != 0) {
            pcolor = this.m_ph.getPatternColor(id);
        }
        this.writeTIFF(Tags3TF.TAG_STDDRAW_AREAINSTREC);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(pattern);
        this.writeRGB(pcolor);
        this.saveStruct_ColorInstRec(this.m_ph.getFillColor(id), this.m_ph.getTransparentFillColor(id), id, nIndex, nDestID);
    }

    public void saveStruct_LineInstRec(IdentObj id, short nIndex, short nDestID) throws IOException {
        boolean transparent = this.m_ph.getTransparentBorderColor(id);
        if (id.equals(this.m_ph.getCubeRiserGridY()) && !this.m_ph.getDisplay(id)) {
            transparent = true;
        }
        this.writeTIFF(Tags3TF.TAG_STDDRAW_LINEINSTREC);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)(this.m_ph.getLineWidthInPoints(id) * 150.0));
        this.writeShort(this.m_ph.getLineStyle(id));
        this.writeShort((short)(this.m_ph.getLineWidthInPoints(id) * 100.0));
        this.writeShort((short)0);
        this.saveStruct_ColorInstRec(this.m_ph.getBorderColor(id), transparent, IdentObj.GLOBAL, nIndex, nDestID);
        this.saveStruct_GlowInstRec(id, nIndex, nDestID);
    }

    public void save_FontMaster(short nIndex, short nDestID) throws IOException {
        Iterator<FontEntry> fontIter = this.fonts.iterator();
        short n = 0;
        while (fontIter.hasNext()) {
            FontEntry f = fontIter.next();
            this.writeTIFF(Tags3TF.TAG_STDDRAW_FONTNAMEINFO);
            this.writeShort(n);
            this.writeShort(nDestID);
            this.writeNBytes(f.fontName.getBytes(this.m_stringConv), 32, false);
            this.writeByte((byte)f.pitchAndFamily);
            this.writeByte((byte)f.charSet);
            this.writeShort(f.nFlags);
            n = (short)(n + 1);
        }
    }

    public void saveStruct_FontInstRec(IdentObj id, short nIndex, short nDestID) throws IOException {
        IdentObj textBoxID = this.m_ph.getTextBoxID(id);
        short flags = this.m_ph.getTextRotation(id);
        FontEntry f = new FontEntry(this.m_ph.getFontName(id), 0, 0, flags);
        int fontIndex = this.fonts.indexOf(f);
        if (fontIndex == -1) {
            this.fonts.add(f);
            fontIndex = this.fonts.size() - 1;
        }
        Color bgcolor = this.m_ph.getUseTextBackgroundColor(id) ? this.m_ph.getTextBackgroundColor(id) : Color.black;
        this.writeTIFF(Tags3TF.TAG_STDDRAW_FONTINSTREC_6);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)fontIndex);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getFontSizeVC(id));
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getTextJustHoriz(id));
        this.writeShort(this.m_ph.getTextJustVert(id));
        this.writeShort((short)0);
        this.writeShort((short)(100.0f * this.m_ph.getFontSizeInPixels(id)));
        this.writeShort(this.m_ph.getTextFace(id));
        this.writeShort((short)0);
        this.writeShort(f.nFlags);
        this.writeShort(f.pitchAndFamily);
        this.writeShort(f.charSet);
        this.writeShort((short)0);
        this.writeRGB(bgcolor);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getFancyBoxStyle(textBoxID));
        this.writeShort((short)(100.0f * this.m_ph.getFontSizeInPoints(id)));
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeTIFF(Tags3TF.TAG_STDDRAW_FONTINSTREC_7);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getFontSizeVC(id));
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getTextJustHoriz(id));
        this.writeShort(this.m_ph.getTextJustVert(id));
        this.writeShort((short)0);
        this.writeShort((short)(100.0f * this.m_ph.getFontSizeInPixels(id)));
        this.writeShort(this.m_ph.getTextFace(id));
        this.writeShort((short)0);
        this.writeShort(f.nFlags);
        this.writeShort(f.pitchAndFamily);
        this.writeShort(f.charSet);
        this.writeShort((short)0);
        this.writeRGB(bgcolor);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getFancyBoxStyle(textBoxID));
        this.writeShort((short)(100.0f * this.m_ph.getFontSizeInPoints(id)));
        this.writeShort((short)0);
        this.writeNBytes(f.fontName.getBytes(this.m_stringConv), 32, false);
        this.writeNBytes("".getBytes(this.m_stringConv), 32, false);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.saveStruct_ColorInstRec(this.m_ph.getFillColor(id), this.m_ph.getTransparentFillColor(id), id, nIndex, nDestID);
        if (textBoxID != null) {
            this.saveStruct_AreaInstRec(textBoxID, nIndex, this.m_ph.getFancyBoxAreaDestID(nDestID));
            this.saveStruct_LineInstRec(textBoxID, nIndex, this.m_ph.getFancyBoxLineDestID(nDestID));
        }
    }

    public void saveStruct_Font3DStruct(IdentObj id, short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_FONT3DSTRUCT);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)20);
        this.writeShort((short)100);
        this.writeShort((short)10);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getFont3DDisplay(id, nIndex));
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.saveStruct_FontInstRec(id, nIndex, nDestID);
    }

    public void saveStruct_GlowInstRec(IdentObj id, short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_STDDRAW_GLOWINSTREC);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
    }

    public void saveStruct_ColorInstRec(Color c, boolean transparent, IdentObj id, short nIndex, short nDestID) throws IOException {
        short effectType = this.m_ph.getEffectType(id);
        this.writeTIFF(Tags3TF.TAG_STDDRAW_COLORINSTREC);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(this.m_ph.toShort(effectType != 0));
        this.writeShort((short)-1);
        this.writeShort(transparent || c.getAlpha() == 0 ? (short)9999 : 0);
        this.writeRGB(c);
        this.writeTIFF(Tags3TF.TAG_STDDRAW_COLORINSTREC_3);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)c.getAlpha());
        if (effectType != 0) {
            this.saveStruct_SFXRecord(id, nIndex, nDestID);
        }
    }

    private void saveStruct_PieLookClass(short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_PIELOOKCLASS_002);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(this.m_ph.getPieTilt());
        this.writeShort(this.m_ph.getPieRotate());
        this.writeShort(this.m_ph.getPieDepth());
        this.writeShort(this.m_ph.getPiesPerRow());
        this.writeShort((short)0);
        this.writeShort((short)1);
        this.writeShort(this.m_ph.getPieRingSize());
        this.writeShort(this.m_ph.toShort(this.m_ph.getDisplay(this.m_ph.getPieLabel())));
        this.writeShort(this.m_ph.getPieRingTotalDisplay());
        this.writeShort((short)1);
        this.writeShort(this.m_ph.getPlaceValueLabel());
        this.writeShort(this.m_ph.getPlaceDataLabel());
        this.writeTIFF(Tags3TF.TAG_PIELOOKCLASS_003);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(this.m_ph.getPieTilt());
        this.writeShort(this.m_ph.getPieRotate());
        this.writeShort(this.m_ph.getPieDepth());
        this.writeShort(this.m_ph.getPiesPerRow());
        this.writeShort((short)0);
        this.writeShort((short)1);
        this.writeShort(this.m_ph.getPieRingSize());
        this.writeShort(this.m_ph.toShort(this.m_ph.getDisplay(this.m_ph.getPieLabel())));
        this.writeShort(this.m_ph.getPieRingTotalDisplay());
        this.writeShort((short)1);
        this.writeShort(this.m_ph.getPlaceValueLabel());
        this.writeShort(this.m_ph.getPlaceDataLabel());
        this.writeShort((short)0);
        Insets pieInsets = this.m_ph.getInsets(this.m_ph.getFrame());
        this.saveStruct_ConTextType(this.m_ph.getFrame(), false, (short)-1, (short)2143, (short)pieInsets.bottom, (short)pieInsets.top, (short)pieInsets.left, (short)pieInsets.right);
        this.saveStruct_ConTextType(this.m_ph.getPieLabel(), (short)-1, (short)2144);
    }

    private void saveStruct_BarLookClass(short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_BARLOOKCLASS);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(this.m_ph.getDisplayBarAsPictograph());
    }

    private void saveStruct_GanttLookClass(short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_GANTTLOOKCLASS);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)0);
        this.writeShort((short)0);
    }

    private void saveStruct_BLADepthLookClass(short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_BLADEPTHCLASS);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        short depth = this.m_ph.getBLADepth();
        this.writeShort(this.m_ph.toShort(depth != 0));
        this.writeShort(this.m_ph.getBLADepthAngle());
        this.writeShort(depth);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeInt(15000);
        this.writeInt(5000);
        this.writeShort((short)0);
    }

    private void saveStruct_BubbleLookClass(short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_BUBBLELOOKCLASS);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(this.m_ph.getMinBubbleSize());
        this.writeShort(this.m_ph.getMaxBubbleSize());
        this.writeShort((short)1);
    }

    private void saveStruct_PolarLookClass(short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_POLARLOOKCLASS);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)2);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeTIFF(Tags3TF.TAG_POLARLOOKCLASS_2);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeTIFF(Tags3TF.TAG_POLARLOOKCLASS_MORE);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
    }

    private void saveStruct_StockMktLookClass(short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_STOCKMKTLOOKCLASS);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(this.m_ph.getStockRiserWidth());
        this.writeShort(this.m_ph.getStockTickHeight());
        this.writeShort(this.m_ph.getStockTickWidth());
        this.writeShort(this.m_ph.getStockOpenTicksDisplay());
        this.writeShort(this.m_ph.getStockCloseTicksDisplay());
        this.writeShort(this.m_ph.getDTXTItem());
        this.writeShort((short)0);
    }

    public void saveHeader() throws IOException {
        this.writeNBytes("TIFFGRAPH".getBytes("ASCII"), 10, true);
        this.writeNBytes(String.valueOf(2).getBytes("ASCII"), 4, true);
        this.writeNBytes(String.valueOf(100).getBytes("ASCII"), 4, true);
        this.writeNBytes(String.valueOf(this.m_byteOrder).getBytes("ASCII"), 4, true);
        this.writeNBytes("1".getBytes("ASCII"), 4, true);
        this.writeNBytes("0".getBytes("ASCII"), 4, true);
        this.writeNBytes("1247".getBytes("ASCII"), 4, true);
        this.writeNBytes("1".getBytes("ASCII"), 8, true);
        this.writeNBytes("0".getBytes("ASCII"), 8, true);
        this.writeNBytes("future use 206 bytes".getBytes("ASCII"), 206, true);
    }

    private void writeTag(Tag3TF tag, short value) throws IOException, Format3TFExc {
        if (tag.getSize() != 2) {
            throw new Format3TFExc("Got <short> value, for tag " + tag.getName() + " of size " + tag.getSize());
        }
        this.writeTIFF(tag.getId(), tag.getSize(), tag.getName());
        this.writeShort(value);
    }

    private void writeTag(Tag3TF tag, int value) throws IOException, Format3TFExc {
        if (tag.getSize() != 4) {
            throw new Format3TFExc("Got <int> value, for tag " + tag.getName() + " of size " + tag.getSize());
        }
        this.writeTIFF(tag.getId(), tag.getSize(), tag.getName());
        this.writeInt(value);
    }

    private void writeTag(Tag3TF tag, String value, boolean inBytes) throws IOException, Format3TFExc {
        short byteSize = (short)(tag.getSize() * (inBytes ? 1 : this.m_bytesPerChar));
        this.writeTIFF(tag.getId(), byteSize, tag.getName());
        this.writeNBytes(value.getBytes(this.m_stringConv), tag.getSize(), inBytes);
    }

    private void save_ShowWall() throws IOException {
        this.writeTIFF(Tags3TF.TAG_LOOK_SHOWWALL);
        this.writeShort(this.m_ph.getDisplay3DLeftWall());
        this.writeShort(this.m_ph.getDisplay3DFloor());
        this.writeShort(this.m_ph.getDisplay3DRightWall());
    }

    private void save_Grid3D() throws IOException {
        this.writeTIFF(Tags3TF.TAG_LOOK_GRID3D);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getGrid3DLeftWallDisplayY());
        this.writeShort(this.m_ph.getGrid3DLeftWallDisplayZ());
        this.writeShort(this.m_ph.getGrid3DFloorDisplayX());
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getGrid3DFloorDisplayZ());
        this.writeShort(this.m_ph.getGrid3DRightWallDisplayX());
        this.writeShort(this.m_ph.getGrid3DRightWallDisplayY());
        this.writeShort((short)0);
    }

    private void saveLook() throws IOException {
        short i;
        short nIdx;
        short s = this.m_ph.getSeriesLooping();
        this.writeTag(Tags3TF.TAG_LOOK_ND, this.m_ph.getND());
        this.writeTag(Tags3TF.TAG_LOOK_NGRAPHTYPE, this.m_ph.getGraphType());
        this.writeTag(Tags3TF.TAG_LOOK_SZTYPE, this.m_ph.getGraphName(), false);
        this.writeTag(Tags3TF.TAG_LOOK_SUBTYPE, this.m_ph.getGraphSubType());
        this.writeTag(Tags3TF.TAG_LOOK_BISDUALY, this.m_ph.getBISDUALY());
        this.writeTag(Tags3TF.TAG_LOOK_BISBIPOLAR, this.m_ph.getBISBIPOLAR());
        this.writeTag(Tags3TF.TAG_LOOK_NAREA, (short)44);
        for (nIdx = 0; nIdx < 44; nIdx = (short)(nIdx + 1)) {
            this.saveStruct_AreaInstRec(this.m_ph.getArea2DObject(nIdx), nIdx, (short)2007);
        }
        this.writeTag(Tags3TF.TAG_LOOK_NLINE, (short)44);
        for (nIdx = 0; nIdx < 44; nIdx = (short)(nIdx + 1)) {
            this.saveStruct_LineInstRec(this.m_ph.getLine2DObject(nIdx), nIdx, (short)2011);
        }
        this.saveStruct_BoxInstRec(this.m_ph.getRect(this.m_ph.getTitleID()), (short)-1, (short)2012);
        this.saveStruct_BoxInstRec(this.m_ph.getRect(this.m_ph.getSubTitleID()), (short)-1, (short)2013);
        this.saveStruct_BoxInstRec(this.m_ph.getRect(this.m_ph.getFootnoteID()), (short)-1, (short)2014);
        this.saveStruct_FontInstRec(this.m_ph.getTitleID(), (short)-1, (short)2015);
        this.saveStruct_FontInstRec(this.m_ph.getSubTitleID(), (short)-1, (short)2016);
        this.saveStruct_FontInstRec(this.m_ph.getHeader1Font(), (short)-1, (short)2017);
        this.saveStruct_FontInstRec(this.m_ph.getHeader2Font(), (short)-1, (short)2018);
        this.saveStruct_FontInstRec(this.m_ph.getHeader3Font(), (short)-1, (short)2019);
        this.saveStruct_FontInstRec(this.m_ph.getHeader4Font(), (short)-1, (short)2020);
        this.saveStruct_FontInstRec(this.m_ph.getO1orX1TitleID(), (short)-1, (short)2021);
        this.saveStruct_FontInstRec(this.m_ph.getY1TitleID(), (short)-1, (short)2022);
        this.saveStruct_FontInstRec(this.m_ph.getY2TitleID(), (short)-1, (short)2023);
        this.saveStruct_FontInstRec(this.m_ph.getLabel1Font(), (short)-1, (short)2024);
        this.saveStruct_FontInstRec(this.m_ph.getLabel2Font(), (short)-1, (short)2025);
        this.saveStruct_FontInstRec(this.m_ph.getLabel3Font(), (short)-1, (short)2026);
        this.saveStruct_FontInstRec(this.m_ph.getFootnoteID(), (short)-1, (short)2027);
        this.saveStruct_BoxInstRec(this.m_ph.getShiftedRect(this.m_ph.getFrame()), (short)-1, (short)2028);
        this.writeTag(Tags3TF.TAG_LOOK_BLEGENDWANTED, this.m_ph.getBLEGENDWANTED());
        this.saveStruct_ConTextType(this.m_ph.getY2LabelID(), (short)-1, (short)2031);
        this.saveStruct_ConTextType(IdentObj.GLOBAL, this.m_ph.getSquareMarkers(), (short)-1, (short)2032, (short)0, (short)0, (short)0, (short)0);
        this.saveStruct_BoxInstRec(this.m_ph.getRect(this.m_ph.getLegendArea()), (short)-1, (short)2033);
        this.writeTag(Tags3TF.TAG_LOOK_NLEGENDELEMENTS, this.m_ph.getNLEGENDELEMENTS());
        this.writeTag(Tags3TF.TAG_LOOK_NLEGENDLAYOUT, this.m_ph.getNLEGENDLAYOUT());
        this.writeTag(Tags3TF.TAG_LOOK_BCOLORBYROW, this.m_ph.getBCOLORBYROW());
        this.saveStruct_BoxInstRec(this.unrotateAxisTitle(this.m_ph.getX1TitleID()), (short)-1, (short)2040);
        this.saveStruct_BoxInstRec(this.unrotateAxisTitle(this.m_ph.getY1TitleID()), (short)-1, (short)2041);
        this.saveStruct_BoxInstRec(this.unrotateAxisTitle(this.m_ph.getY2TitleID()), (short)-1, (short)2042);
        this.saveStruct_BoxInstRec(this.unrotateAxisTitle(this.m_ph.getO1TitleID()), (short)-1, (short)2043);
        this.saveStruct_BoxInstRec(this.unrotateAxisTitle(this.m_ph.getO2TitleID()), (short)-1, (short)2044);
        this.saveStruct_BoxInstRec(this.unrotateAxisTitle(this.m_ph.getY1TitleID()), (short)-1, (short)2045);
        this.saveStruct_BoxInstRec(this.unrotateAxisTitle(this.m_ph.getY2TitleID()), (short)-1, (short)2046);
        this.saveStruct_BoxInstRec(this.unrotateAxisTitle(this.m_ph.getY3TitleID()), (short)-1, (short)4036);
        this.saveStruct_BoxInstRec(this.unrotateAxisTitle(this.m_ph.getY4TitleID()), (short)-1, (short)4046);
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWTITLE, this.m_ph.getDisplayVal(this.m_ph.getTitleID()));
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWSUBTITLE, this.m_ph.getDisplayVal(this.m_ph.getSubTitleID()));
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWFOOTNOTE, this.m_ph.getDisplayVal(this.m_ph.getFootnoteID()));
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWXAXISTITLE, this.m_ph.getDisplayVal(this.m_ph.getX1TitleID()));
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWY1AXISTITLE, this.m_ph.getDisplayVal(this.m_ph.getY1TitleID()));
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWY2AXISTITLE, this.m_ph.getDisplayVal(this.m_ph.getY2TitleID()));
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWY3AXISTITLE, this.m_ph.getDisplayVal(this.m_ph.getY3TitleID()));
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWY4AXISTITLE, this.m_ph.getDisplayVal(this.m_ph.getY4TitleID()));
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWSERIESTITLE, this.m_ph.getDisplayVal(this.m_ph.getLegendTitleID()));
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWGROUPSTITLE, this.m_ph.getDisplayVal(this.m_ph.getO1LabelID()));
        this.writeTag(Tags3TF.TAG_LOOK_ERISERSHAPE, this.m_ph.getERISERSHAPE());
        this.writeTIFF(Tags3TF.TAG_LOOK_NRISERTHICK);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeTag(Tags3TF.TAG_LOOK_NINTERGRPTHICK, this.m_ph.getRiserBarGroupSpacing());
        this.writeTag(Tags3TF.TAG_LOOK_NINTRAGRPTHICK, this.m_ph.getIntraGrpThick());
        this.writeTag(Tags3TF.TAG_LOOK_NENDGRPTHICK, this.m_ph.getNENDGRPTHICK());
        this.writeTag(Tags3TF.TAG_LOOK_NMARKERSIZE, this.m_ph.getNMARKERSIZE());
        this.saveStruct_AxisLookClass(this.m_ph.getY1AxisID(), (short)-1, (short)2061);
        this.saveStruct_AxisLookClass(this.m_ph.getY2AxisID(), (short)-1, (short)2062);
        this.saveStruct_AxisLookClass(this.m_ph.getY3AxisID(), (short)-1, (short)4035);
        this.saveStruct_AxisLookClass(this.m_ph.getY4AxisID(), (short)-1, (short)4045);
        this.saveStruct_AxisLookClass(this.m_ph.getX1AxisID(), (short)-1, (short)2063);
        this.saveStruct_AxisLookClass(this.m_ph.getO1AxisID(), (short)-1, (short)2064);
        this.saveStruct_AxisLookClass(this.m_ph.getO2AxisID(), (short)-1, (short)2065);
        this.saveStruct_AxisLookClass(this.m_ph.getO1AxisID(), (short)-1, (short)2066);
        boolean shouldSwapMajorMinorGridlines = this.m_ph.shouldSwapMajorMinorGridlines(this.m_ph.getO1MajorGridID());
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getY1MajorGridID()), this.m_ph.getGridStyle(this.m_ph.getY1MajorGridID()), (short)-1, (short)2149);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getY2MajorGridID()), this.m_ph.getGridStyle(this.m_ph.getY2MajorGridID()), (short)-1, (short)2150);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getY3MajorGridID()), this.m_ph.getGridStyle(this.m_ph.getY3MajorGridID()), (short)-1, (short)4037);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getY4MajorGridID()), this.m_ph.getGridStyle(this.m_ph.getY4MajorGridID()), (short)-1, (short)4047);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getX1MajorGridID()), this.m_ph.getGridStyle(this.m_ph.getX1MajorGridID()), (short)-1, (short)2151);
        this.saveStruct_HashInst(this.m_ph.getDisplay(shouldSwapMajorMinorGridlines ? this.m_ph.getO1MinorGridID() : this.m_ph.getO1MajorGridID()), this.m_ph.getGridStyle(shouldSwapMajorMinorGridlines ? this.m_ph.getO1MinorGridID() : this.m_ph.getO1MajorGridID()), (short)-1, (short)2152);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getO2MajorGridID()), this.m_ph.getGridStyle(this.m_ph.getO2MajorGridID()), (short)-1, (short)2153);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getY1MinorGridID()), this.m_ph.getGridStyle(this.m_ph.getY1MinorGridID()), (short)-1, (short)2155);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getY2MinorGridID()), this.m_ph.getGridStyle(this.m_ph.getY2MinorGridID()), (short)-1, (short)2156);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getY3MinorGridID()), this.m_ph.getGridStyle(this.m_ph.getY3MinorGridID()), (short)-1, (short)4038);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getY4MinorGridID()), this.m_ph.getGridStyle(this.m_ph.getY4MinorGridID()), (short)-1, (short)4048);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getX1MinorGridID()), this.m_ph.getGridStyle(this.m_ph.getX1MinorGridID()), (short)-1, (short)2157);
        this.saveStruct_HashInst(this.m_ph.getDisplay(shouldSwapMajorMinorGridlines ? this.m_ph.getO1MajorGridID() : this.m_ph.getO1MinorGridID()), this.m_ph.getGridStyle(shouldSwapMajorMinorGridlines ? this.m_ph.getO1MajorGridID() : this.m_ph.getO1MinorGridID()), (short)-1, (short)2158);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getO2MinorGridID()), this.m_ph.getGridStyle(this.m_ph.getO2MinorGridID()), (short)-1, (short)2159);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getCubeRiserGridY()), this.m_ph.getDisplay(this.m_ph.getCubeRiserGridY()) ? (short)1 : 0, (short)-1, (short)2201);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getCubeRiserGridX()), this.m_ph.getDisplay(this.m_ph.getCubeRiserGridX()) ? (short)1 : 0, (short)-1, (short)2203);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getCubeRiserGridX()), this.m_ph.getDisplay(this.m_ph.getCubeRiserGridX()) ? (short)1 : 0, (short)-1, (short)2204);
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getCubeRiserGridZ()), this.m_ph.getDisplay(this.m_ph.getCubeRiserGridZ()) ? (short)1 : 0, (short)-1, (short)2206);
        this.saveStruct_HashInst(false, (short)0, (short)-1, (short)2207);
        this.saveStruct_HashInst(false, (short)0, (short)-1, (short)2208);
        this.saveStruct_HashInst(false, (short)0, (short)-1, (short)2209);
        this.saveStruct_HashInst(false, (short)0, (short)-1, (short)2210);
        this.saveStruct_HashInst(false, (short)0, (short)-1, (short)2211);
        this.saveStruct_PieLookClass((short)-1, (short)2070);
        this.saveStruct_BarLookClass((short)-1, (short)2071);
        this.saveStruct_GanttLookClass((short)-1, (short)2072);
        this.saveStruct_BLADepthLookClass((short)-1, (short)2073);
        this.saveStruct_BubbleLookClass((short)-1, (short)2074);
        this.saveStruct_PolarLookClass((short)-1, (short)2081);
        this.saveStruct_StockMktLookClass((short)-1, (short)2082);
        this.writeTag(Tags3TF.TAG_LOOK_NFRAMETABLELOW, this.m_ph.getNFRAMETABLELOW());
        this.writeTag(Tags3TF.TAG_LOOK_NFRAMETABLEHIGH, this.m_ph.getNFRAMETABLEHIGH());
        this.saveStruct_HashInst(this.m_ph.getDisplay(this.m_ph.getFrameSeparator()), this.m_ph.getGridStyle(this.m_ph.getFrameSeparator()), (short)-1, (short)2086);
        this.writeTag(Tags3TF.TAG_LOOK_RISERDROPNESS, this.m_ph.getRISERDROPNESS());
        this.writeTag(Tags3TF.TAG_LOOK_MISCHIGH, this.m_ph.getMISCHIGH());
        this.writeTag(Tags3TF.TAG_LOOK_DRAWBASE, this.m_ph.getScaleFromZero());
        this.writeTag(Tags3TF.TAG_LOOK_NCURVESMOOTH, this.m_ph.getNCURVESMOOTH());
        this.writeTag(Tags3TF.TAG_LOOK_NCURVEMOVING, this.m_ph.getNCURVEMOVING());
        this.writeTag(Tags3TF.TAG_LOOK_NCURVEVERT, this.m_ph.getNCURVEVERT());
        this.writeTag(Tags3TF.TAG_LOOK_BCURVECOLORASSERIES, this.m_ph.getBCURVECOLORASSERIES());
        this.writeTag(Tags3TF.TAG_LOOK_BSICMOVAVG, this.m_ph.getBSICMOVAVG());
        this.writeTag(Tags3TF.TAG_LOOK_BFROMZERO, this.m_ph.getBFROMZERO());
        this.saveStruct_dPoint3D(this.m_ph.get3DViewerPoint(), (short)-1, (short)2097);
        this.saveStruct_fMatrixType((short)-1, (short)2098);
        this.saveStruct_dPoint3D(this.m_ph.getCubeSize(), (short)-1, (short)2099);
        this.saveStruct_dPoint3D(this.m_ph.getCubeWallThickness(), (short)-1, (short)2100);
        this.save_ShowWall();
        this.writeTag(Tags3TF.TAG_LOOK_WIREFRAME, this.m_ph.getWIREFRAME());
        if (this.m_ph.is3DChart()) {
            this.save_Grid3D();
        }
        this.writeTag(Tags3TF.TAG_LOOK_XPAN, this.m_ph.getXPAN());
        this.writeTag(Tags3TF.TAG_LOOK_YPAN, this.m_ph.getYPAN());
        for (short nIdx2 = 0; nIdx2 < 8; nIdx2 = (short)(nIdx2 + 1)) {
            this.saveStruct_Font3DStruct(this.m_ph.getFont3DObject(nIdx2), nIdx2, (short)2107);
        }
        this.writeTag(Tags3TF.TAG_LOOK_ISSAFEANGLE, this.m_ph.getISSAFEANGLE());
        this.writeTag(Tags3TF.TAG_LOOK_GRAPHBYWHAT, this.m_ph.getGRAPHBYWHAT());
        this.writeTag(Tags3TF.TAG_LOOK_TEXTQUALITY, this.m_ph.getTEXTQUALITY());
        this.writeTag(Tags3TF.TAG_LOOK_WANTAUTOFIT, this.m_ph.getWANTAUTOFIT());
        this.writeTag(Tags3TF.TAG_LOOK_PICTQUALITY, this.m_ph.getPICTQUALITY());
        this.writeTag(Tags3TF.TAG_LOOK_BAUTOSHADECUBE, this.m_ph.getAutoshading());
        this.writeTag(Tags3TF.TAG_LOOK_BAUTOSHADERISERS, this.m_ph.getAutoshading());
        this.saveStruct_ColorModelStruct((short)-1, (short)2127);
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWERRORBARS, this.m_ph.getBSHOWERRORBARS());
        this.writeTag(Tags3TF.TAG_LOOK_BSHOWERRORBARS_X, this.m_ph.getBSHOWERRORBARS_X());
        this.writeTag(Tags3TF.TAG_LOOK_NERRORBARSIZE, this.m_ph.getNERRORBARSIZE());
        this.writeTag(Tags3TF.TAG_LOOK_NSHOWQDRLABELS, this.m_ph.getNSHOWQDRLABELS());
        this.writeTag(Tags3TF.TAG_LOOK_NAUTOFITQDRLABELS, (short)0);
        for (i = 0; i < s; i = (short)(i + 1)) {
            this.saveStruct_AreaInstRec(this.m_ph.getSeriesID(i), i, (short)2132);
        }
        for (i = 0; i < s; i = (short)(i + 1)) {
            if (i == 0) {
                this.saveStruct_LineInstRec(this.m_ph.getSeriesID(i), i, (short)2133);
            }
            this.saveStruct_LineInstRec(this.m_ph.getSeriesID(i), (short)(i + 1), (short)2133);
        }
        this.writeTIFF(Tags3TF.TAG_VARARRAYINT16, (short)(4 + s * 2));
        this.writeShort((short)-1);
        this.writeShort((short)2134);
        for (i = 0; i < s; i = (short)(i + 1)) {
            this.writeShort(this.m_ph.getRiserShape(i));
        }
        this.writeTag(Tags3TF.TAG_LOOK_NCURCOLOR, this.m_ph.getNCURCOLOR());
        this.writeTag(Tags3TF.TAG_LOOK_BUNIFORMRISERBORDERS, this.m_ph.getBUNIFORMRISERBORDERS());
        this.writeTag(Tags3TF.TAG_LOOK_BUNIFORMRISERSHAPES, this.m_ph.getBUNIFORMRISERSHAPES());
        Object slwd = Attr.SeriesLineWidthDefault.getDefault();
        Attr.SeriesLineWidthDefault.setDefault(new Integer(1));
        this.saveStruct_VarArraySerDepLookClass((short)-1, (short)2139, (short)2146, (short)2147, (short)2213);
        Attr.SeriesLineWidthDefault.setDefault(slwd);
        this.writeTag(Tags3TF.TAG_LOOK_AUTOPLACEMENTMASK, this.m_ph.getAutoPlacementMask());
        this.writeTag(Tags3TF.TAG_LOOK_NULLBEHAVIORMASK, this.m_ph.getNullBehaviorMask());
    }

    private Rectangle unrotateAxisTitle(IdentObj id) {
        Rectangle r = this.m_ph.getRect(id);
        switch (this.m_ph.getTextRotation(id)) {
            case 8: 
            case 32: {
                Point2D.Double center = new Point2D.Double(r.getCenterX(), r.getCenterY());
                return new Rectangle((int)(((Point2D)center).getX() - (double)(r.height / 2)), (int)(((Point2D)center).getY() - (double)(r.width / 2)), r.height, r.width);
            }
        }
        return r;
    }

    public void saveDataLook() throws IOException {
        this.writeTag(Tags3TF.TAG_DLOOK_BCOMPLEXDATARANGE, (short)0);
        Rectangle dataRange = this.m_ph.getDataRange();
        if (dataRange != null && !dataRange.isEmpty()) {
            this.writeTIFF(Tags3TF.TAG_SSBOXINST);
            this.writeShort((short)-1);
            this.writeShort((short)3003);
            this.writeShort((short)(3 + dataRange.x));
            this.writeShort((short)(5 + dataRange.y));
            this.writeShort((short)(3 + (dataRange.x + dataRange.width - 1)));
            this.writeShort((short)(5 + (dataRange.y + dataRange.height - 1)));
        }
        for (short series = 0; series < 1; series = (short)((short)(series + 1))) {
            dataRange = this.m_ph.getDataRange();
            if (dataRange == null || dataRange.isEmpty()) continue;
            this.writeTIFF(Tags3TF.TAG_DATASERIES);
            this.writeShort(series);
            this.writeShort((short)3001);
            this.writeShort((short)1);
            this.writeShort((short)(5 + dataRange.y));
            this.writeShort((short)(3 + dataRange.x));
            this.writeShort((short)(5 + (dataRange.y + dataRange.height - 1)));
            this.writeShort((short)(3 + (dataRange.x + dataRange.width - 1)));
        }
        this.writeTag(Tags3TF.TAG_DLOOK_RTITLE, (short)1);
        this.writeTag(Tags3TF.TAG_DLOOK_CTITLE, (short)1);
        this.writeTag(Tags3TF.TAG_DLOOK_RSUBTITLE, (short)2);
        this.writeTag(Tags3TF.TAG_DLOOK_CSUBTITLE, (short)1);
        this.writeTag(Tags3TF.TAG_DLOOK_RFOOTNOTE, (short)3);
        this.writeTag(Tags3TF.TAG_DLOOK_CFOOTNOTE, (short)1);
        this.writeTag(Tags3TF.TAG_DLOOK_RSERIESTITLE, (short)5);
        this.writeTag(Tags3TF.TAG_DLOOK_CSERIESTITLE, (short)1);
        this.writeTag(Tags3TF.TAG_DLOOK_RGROUPSTITLE, (short)4);
        this.writeTag(Tags3TF.TAG_DLOOK_CGROUPSTITLE, (short)2);
        this.writeTag(Tags3TF.TAG_DLOOK_RY1TITLE, (short)2);
        this.writeTag(Tags3TF.TAG_DLOOK_CY1TITLE, (short)2);
        this.writeTag(Tags3TF.TAG_DLOOK_RY2TITLE, (short)3);
        this.writeTag(Tags3TF.TAG_DLOOK_CY2TITLE, (short)2);
        this.writeTag(Tags3TF.TAG_DLOOK_RY3TITLE, (short)2);
        this.writeTag(Tags3TF.TAG_DLOOK_CY3TITLE, (short)3);
        this.writeTag(Tags3TF.TAG_DLOOK_RY4TITLE, (short)3);
        this.writeTag(Tags3TF.TAG_DLOOK_CY4TITLE, (short)3);
        this.writeTag(Tags3TF.TAG_DLOOK_RSERIESHEADER, (short)5);
        this.writeTag(Tags3TF.TAG_DLOOK_CSERIESHEADER, (short)2);
        this.writeTag(Tags3TF.TAG_DLOOK_RGROUPSHEADER, (short)4);
        this.writeTag(Tags3TF.TAG_DLOOK_CGROUPSHEADER, (short)3);
        this.writeTag(Tags3TF.TAG_DLOOK_BAXISSWAP, this.m_ph.getAxisSwap());
        this.writeTag(Tags3TF.TAG_DLOOK_BROWREVERSE, this.m_ph.getReverseSeries());
        this.writeTag(Tags3TF.TAG_DLOOK_BCOLREVERSE, this.m_ph.getReverseGroups());
        this.writeTag(Tags3TF.TAG_DLOOK_NSTDFORMATSUM, this.m_ph.getLabelStdFormat(this.m_ph.getPieRingLabel()));
        this.saveStruct_AdvFormatStruct(this.m_ph.getTextFormat(this.m_ph.getPieRingLabel()), (short)-1, (short)6051);
        this.writeTag(Tags3TF.TAG_DLOOK_NSTDFORMATLBL, (short)0);
        this.writeTag(Tags3TF.TAG_DLOOK_NDATAFORMATID, this.m_ph.getDataFormatID());
        this.saveStruct_DataAxisClass(this.m_ph.getX1AxisID(), (short)-1, (short)3027);
        this.saveStruct_DataAxisClass(this.m_ph.getY1AxisID(), (short)-1, (short)3028);
        this.saveStruct_DataAxisClass(this.m_ph.getY2AxisID(), (short)-1, (short)3029);
        this.saveStruct_DataAxisClass(this.m_ph.getY3AxisID(), (short)-1, (short)4053);
        this.saveStruct_DataAxisClass(this.m_ph.getY4AxisID(), (short)-1, (short)4054);
        this.writeTag(Tags3TF.TAG_DLOOK_BVERTFORMAT, this.m_ph.getIsVerticalDataFormat());
        this.saveStruct_VarArraySerDepDataClass((short)-1, (short)3032);
        this.writeTag(Tags3TF.TAG_DLOOK_BXYY, (short)0);
    }

    public void saveGraphMainPart() throws IOException {
        this.writeTag(Tags3TF.TAG_GRAPH_NERRORID, (short)0);
        this.writeTag(Tags3TF.TAG_GRAPH_NERRORCLASS, (short)0);
        this.saveStruct_AnodeMasterRec();
        this.saveStruct_AreaInstRec(IdentObj.GLOBAL, (short)-1, (short)1017);
        this.saveStruct_LineInstRec(this.m_ph.getDefaultLine(), (short)-1, (short)1018);
        this.saveStruct_FontInstRec(this.m_ph.getDefaultFont(), (short)-1, (short)1019);
        this.save_FontMaster((short)-1, (short)1021);
        this.saveStruct_FancyBoxRec(this.m_ph.getLegendArea(), (short)2186);
        this.writeTag(Tags3TF.TAG_GRAPH_BAUTOCOLORBYROW, this.m_ph.getGRAPH_BAUTOCOLORBYROW());
        this.writeTag(Tags3TF.TAG_GRAPH_BCONNECTSTACKBARS, this.m_ph.getGRAPH_BCONNECTSTACKBARS());
        this.writeTag(Tags3TF.TAG_SPLITY_POSITION, this.m_ph.getDualAxisSplitPosition());
        for (short i = 0; i < 4; i = (short)(i + 1)) {
            this.SaveStruct_UserLineInfo(i, (short)12135);
        }
        this.writeTag(Tags3TF.TAG_LOCKEDSIZE, this.m_ph.toShort(!this.m_useVirtualCoordiantes));
        this.writeTag(Tags3TF.TAG_LEGEND_MARKER_ORIENTATION, this.m_ph.getLegendMarkerPosition());
        this.writeTag(Tags3TF.TAG_DEFAULT_LEGEND_POSITION, this.m_ph.getPlacePosition(this.m_ph.getLegendArea()));
        this.saveStruct_TimeAxisRec();
        this.saveStruct_GaugeObjectRec();
        this.writeTag(Tags3TF.TAG_3TF_CREATION_REVISION, this.m_ph.get3TFCreationRevision());
        this.writeTag(Tags3TF.TAG_3TF_CREATION_SUB_REVISION, this.m_ph.get3TFCreationSubRevision());
        this.writeTag(Tags3TF.TAG_FRAME_RESIZE, this.m_ph.getFrameResize());
    }

    private void SaveStruct_UserLineInfo(short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_USERLINE_INFO);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        IdentObj id = this.m_ph.getUserLine(nIndex);
        this.writeDouble(this.m_ph.getUserLineValue(id));
        this.writeShort(this.m_ph.toShort(this.m_ph.getDisplay(id)));
        this.writeShort(this.m_ph.getUserLineAxis(id));
        this.saveStruct_LineInstRec(id, nIndex, nDestID);
    }

    public void saveVDMData() throws IOException {
        if ((this.m_request & 0x20) == 0) {
            return;
        }
        this.writeTIFF(Tags3TF.TAG_VDM_VERSION);
        this.writeShort((short)3);
        this.writeTIFF(Tags3TF.TAG_VDM_NPAGECOUNT);
        this.writeShort((short)1);
        this.save_VDMCell(1, 1, 1, this.m_ph.getTitle());
        this.save_VDMCell(1, 2, 1, this.m_ph.getSubTitle());
        if (this.m_ph.getAxisSwap() == 0) {
            this.save_VDMCell(1, 4, 2, this.m_ph.getO1Title());
        } else {
            this.save_VDMCell(1, 4, 2, this.m_ph.getO2Title());
        }
        this.save_VDMCell(1, 2, 2, this.m_ph.getY1Title());
        this.save_VDMCell(1, 3, 2, this.m_ph.getY2Title());
        this.save_VDMCell(1, 2, 3, this.m_ph.getY3Title());
        this.save_VDMCell(1, 3, 3, this.m_ph.getY4Title());
        this.save_VDMCell(1, 3, 1, this.m_ph.getFootnote());
        Rectangle dr = this.m_ph.getDataRange();
        for (int iPage = 0; iPage < 1; ++iPage) {
            int iRow;
            int iCol;
            if (this.m_ph.getAxisSwap() == 0) {
                for (iCol = dr.x; iCol < dr.x + dr.width; ++iCol) {
                    this.save_VDMCell(iPage + 1, 4, iCol + 3, this.m_ph.getGroupLabel(iPage, iCol));
                }
                for (iRow = dr.y; iRow < dr.y + dr.height; ++iRow) {
                    this.save_VDMCell(iPage + 1, iRow + 5, 2, this.m_ph.getSeriesLabel(iPage, iRow));
                }
            } else {
                for (iCol = dr.x; iCol < dr.x + dr.height; ++iCol) {
                    this.save_VDMCell(iPage + 1, 4, iCol + 3, this.m_ph.getSeriesLabel(iPage, iCol));
                }
                for (iRow = dr.y; iRow < dr.y + dr.width; ++iRow) {
                    this.save_VDMCell(iPage + 1, iRow + 5, 2, this.m_ph.getGroupLabel(iPage, iRow));
                }
            }
            for (iCol = dr.x; iCol < dr.x + dr.width; ++iCol) {
                for (int iRow2 = dr.y; iRow2 < dr.y + dr.height; ++iRow2) {
                    double data = this.m_ph.getDataValue(iPage, iRow2, iCol);
                    this.save_VDMCell(iPage + 1, iRow2 + 5, iCol + 3, data);
                }
            }
            this.writeTIFF(Tags3TF.TAG_VDM_NEWPAGE);
        }
    }

    public void saveVDMLinkedLists() throws IOException {
        if ((this.m_request & 0x20) == 0) {
            return;
        }
    }

    public void saveTableChartLook() throws IOException {
    }

    public void saveStruct_VarArraySerDepLookClass(short nIndex, short nDestID, short nDestID_line, short nDestID_font, short nDestID_errorabar_line) throws IOException {
        int numSeries = this.m_ph.getSeriesLooping();
        for (int series = 0; series < numSeries; ++series) {
            IdentObj idSeries = new IdentObj(-3, series);
            this.writeTIFF(Tags3TF.TAG_SERDEPLOOKCLASS_002);
            this.writeShort((short)series);
            this.writeShort(nDestID);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort(this.m_ph.getDataLineType(series));
            this.writeDouble(0.0);
            this.writeDouble(0.0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeDouble(0.0);
            this.writeDouble(0.0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.saveStruct_LineInstRec(new IdentObj(41, series), (short)series, nDestID_line);
            this.saveStruct_FontInstRec(new IdentObj(42, series), (short)series, nDestID_font);
            this.saveStruct_ConTextType(idSeries, (short)series, nDestID);
            this.saveStruct_LineInstRec(new IdentObj(503, series), (short)series, nDestID_errorabar_line);
        }
    }

    public static void saveTo3TF(Perspective p, int nRequest, boolean bTerminator, String strFilename, boolean bWantTrim) throws IOException {
        File f = new File(strFilename);
        FileOutputStream fos = new FileOutputStream(f);
        DataOutputStream dos = new DataOutputStream(fos);
        Export3TF.saveTo3TF(p, nRequest, bTerminator, dos, bWantTrim);
        dos.close();
        fos.close();
    }

    public static void saveTo3TF(Perspective p, int nRequest, boolean bTerminator, DataOutputStream dos, boolean bWantTrim) throws IOException {
        Export3TF e3tf = new Export3TF(dos, p, 2, 2);
        if (nRequest == 0) {
            e3tf.m_request = (short)1247;
        }
        e3tf.saveHeader();
        e3tf.writeTag(Tags3TF.TAG_STRING_ENCODING, e3tf.m_encoding);
        e3tf.saveLook();
        e3tf.saveDataLook();
        e3tf.saveGraphMainPart();
        e3tf.saveVDMData();
        e3tf.saveVDMLinkedLists();
        e3tf.savePictures();
        e3tf.writeTIFF(Tags3TF.TAG_TERMINATE_FILE);
    }

    private void savePictures() throws Format3TFExc, IOException {
        Iterator<UniversalPictureStruct> i = this.m_ph.getPicturesIterator();
        while (i.hasNext()) {
            UniversalPictureStruct upc = i.next();
            if (!upc.isMetafile) {
                this.saveUniversalPictureStruct(upc);
                continue;
            }
            this.savePictureStruct(upc);
        }
    }

    private void savePictureStruct(UniversalPictureStruct upc) throws Format3TFExc, IOException {
        if (upc.isMetafile) {
            this.writeTIFF(Tags3TF.TAG_PICTURES_PICTURESTRUCT, (short)130);
            this.writeNBytes(upc.filename.getBytes(this.m_stringConv), 128, false);
            this.writeInt(upc.rawData.length);
            this.writeBytes(upc.rawData);
        }
    }

    private void saveUniversalPictureStruct(UniversalPictureStruct upc) throws Format3TFExc, IOException {
        this.writeTIFF(Tags3TF.TAG_PICTURES_PICTUREUNIVERSALSTRUCT, (short)(upc.rawData.length + 256 + 16));
        this.writeNBytes(upc.filename.getBytes(this.m_stringConv), 128, false);
        this.writeInt(upc.nCompressSize);
        this.writeShort((short)upc.nCompressionType);
        this.writeInt(upc.nUnCompressSize);
        this.writeShort((short)upc.nTIFFImageType);
        this.writeInt(upc.nImageFlags);
        this.writeBytes(upc.rawData);
    }

    private void saveStruct_ColorModelStruct(short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_COLORMODELSTRUCT);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        short nColorModel = this.m_ph.getColorMode();
        this.writeShort(nColorModel);
        this.writeShort((short)0);
        Color begin = this.m_ph.getGradientPinRightColor(this.m_ph.getColorByHeight(), 0);
        Color end = this.m_ph.getGradientPinLeftColor(this.m_ph.getColorByHeight(), 1);
        this.writeRGB(begin);
        this.writeRGB(end);
    }

    short color16bit(int color) {
        return (short)(color << 8);
    }

    private void saveStruct_AxisLookClass(IdentObj id, short nIndex, short nDestID) throws IOException {
        AxisInfo ainfo = AxisInfo.getAxisInfo(this.m_ph, id);
        boolean shouldSwapMajorMinorGridlines = this.m_ph.shouldSwapMajorMinorGridlines(ainfo.getMajorGrid());
        short labelSkip = this.m_ph.getSkipCount(id, ainfo);
        if (labelSkip > 0) {
            labelSkip = (short)(labelSkip + 1);
        }
        short labelSkipBegin = this.m_ph.getSkipBegin(ainfo.getLabel());
        this.writeTIFF(Tags3TF.TAG_AXISLOOKCLASS_5);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        int nShowStatus = 0;
        if (this.m_ph.getDisplay(ainfo.getLine())) {
            ++nShowStatus;
        }
        if (this.m_ph.getDisplay(ainfo.getLabel())) {
            nShowStatus += 2;
        }
        if (id.equals(this.m_ph.getY1AxisID()) && this.m_ph.isGaugeType()) {
            if (this.m_ph.getDisplay(this.m_ph.getGaugeMajorTick())) {
                nShowStatus += 4;
            }
            if (this.m_ph.getDisplay(this.m_ph.getGaugeMinorTick())) {
                nShowStatus += 8;
            }
        } else {
            if (this.m_ph.getDisplay(shouldSwapMajorMinorGridlines ? ainfo.getMinorGrid() : ainfo.getMajorGrid())) {
                nShowStatus += 4;
            }
            if (this.m_ph.getDisplay(shouldSwapMajorMinorGridlines ? ainfo.getMajorGrid() : ainfo.getMinorGrid())) {
                nShowStatus += 8;
            }
        }
        this.writeInt(nShowStatus);
        this.writeShort((short)0);
        double range = this.m_ph.getScaleMax(id) - this.m_ph.getScaleMin(id);
        double majorStep = this.m_ph.getGridStep(ainfo.getMajorGrid());
        short majorHash = (short)(range / majorStep);
        if ((double)majorHash * majorStep == range) {
            majorHash = (short)(majorHash - 1);
        }
        short minorHash = this.m_ph.getGridCount(ainfo.getMinorGrid());
        this.writeShort(majorHash);
        this.writeShort((short)0);
        this.writeShort(minorHash);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeDouble(majorStep);
        this.writeDouble(0.0);
        this.writeDouble(0.0);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getAxisSide(id));
        this.writeShort(this.m_ph.getAxisDescending(id));
        this.writeDouble(this.m_ph.getScaleMin(id));
        this.writeDouble(this.m_ph.getScaleMax(id));
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)this.m_ph.getLabelStagger(ainfo.getLabel()));
        this.writeDouble(this.m_ph.getScaleMin(id));
        this.writeDouble(this.m_ph.getScaleMax(id));
        this.writeShort(this.m_ph.getDataTextPosition(id));
        this.writeShort(this.m_ph.getScaleEnd(ainfo.getLabel()));
        this.writeShort(labelSkip);
        this.writeShort(labelSkipBegin);
        this.writeShort((short)0);
        this.writeNBytes("".getBytes(this.m_stringConv), 6, false);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getOrdLabelMode(ainfo.getLabel()));
        this.writeShort(this.m_ph.getOrdSpace());
        this.writeShort((short)0);
        this.writeShort((short)1);
        this.writeDouble(majorStep);
        this.writeShort(this.m_ph.toShort(!this.m_ph.getGridStepAuto(ainfo.getMajorGrid())));
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeDouble(0.0);
        this.writeShort((short)1);
        this.writeShort((short)1);
        this.writeShort((short)0);
        this.writeTIFF(Tags3TF.TAG_AXISLOOKCLASS_2);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeInt(nShowStatus);
        this.writeShort((short)0);
        this.writeShort(majorHash);
        this.writeShort((short)0);
        this.writeShort(minorHash);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeDouble(majorStep);
        this.writeDouble(0.0);
        this.writeDouble(0.0);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getAxisSide(id));
        this.writeShort(this.m_ph.getAxisDescending(id));
        this.writeDouble(this.m_ph.getScaleMin(id));
        this.writeDouble(this.m_ph.getScaleMax(id));
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)this.m_ph.getLabelStagger(ainfo.getLabel()));
        this.writeDouble(this.m_ph.getScaleMin(id));
        this.writeDouble(this.m_ph.getScaleMax(id));
        this.writeShort(this.m_ph.getDataTextPosition(id));
        this.writeShort(this.m_ph.getScaleEnd(ainfo.getLabel()));
        this.writeShort(labelSkip);
        this.writeShort(labelSkipBegin);
        this.writeShort((short)0);
        this.writeNBytes("".getBytes(this.m_stringConv), 6, false);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getOrdLabelMode(ainfo.getLabel()));
        this.writeShort(this.m_ph.getOrdSpace());
        this.writeShort((short)0);
        this.writeShort((short)1);
        this.writeDouble(majorStep);
        this.writeShort(this.m_ph.toShort(!this.m_ph.getGridStepAuto(ainfo.getMajorGrid())));
        this.saveStruct_ConTextType(id, nIndex, nDestID);
        this.saveStruct_HashInst(this.m_ph.getDisplay(ainfo.getZeroLine()), this.m_ph.getGridStyle(ainfo.getZeroLine()), nIndex, nDestID);
    }

    private void saveStruct_DataAxisClass(IdentObj id, short nIndex, short nDestID) throws IOException {
        AxisInfo ainfo = AxisInfo.getAxisInfo(this.m_ph, id);
        this.writeTIFF(Tags3TF.TAG_DATAAXISCLASS);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(this.m_ph.getManualScale(id));
        this.writeDouble(this.m_ph.getScaleMin(id));
        this.writeDouble(this.m_ph.getScaleMax(id));
        double range = this.m_ph.getScaleMax(id) - this.m_ph.getScaleMin(id);
        double majorStep = this.m_ph.getGridStep(ainfo.getMajorGrid());
        short majorHash = (short)(range / majorStep);
        if ((double)majorHash * majorStep == range) {
            majorHash = (short)(majorHash - 1);
        }
        short minorHash = this.m_ph.getGridCount(ainfo.getMinorGrid());
        this.writeShort((short)0);
        this.writeShort(majorHash);
        this.writeShort(this.m_ph.toShort(!this.m_ph.getGridStepAuto(ainfo.getMinorGrid())));
        this.writeShort(minorHash);
        this.writeShort(this.m_ph.toShort(this.m_ph.getLogScale(id)));
        this.writeDouble(this.m_ph.getScaleMin(id));
        this.writeDouble(this.m_ph.getScaleMax(id));
        this.writeShort(this.m_ph.getLabelStdFormat(ainfo.getLabel()));
        this.writeShort(this.m_ph.getLabelStdFormat(this.m_ph.getDataText()));
        this.writeShort(this.m_ph.getShowOffScale(id));
        this.writeShort(this.m_ph.getAutoExcludeZero(id));
        if (ainfo.getAdvFormatDestID() != -1) {
            this.saveStruct_AdvFormatStruct(this.m_ph.getTextFormat(ainfo.getLabel()), nIndex, ainfo.getAdvFormatDestID());
        }
        if (ainfo.getAdvFormatDTXTDestID() != -1) {
            IdentObj axis = this.m_ph.isBubble() && ainfo.getAxis().equals(Identity.Y1Axis) ? Identity.Z1Axis : ainfo.getAxis();
            this.saveStruct_AdvFormatStruct(this.m_ph.getDataTextFormat(axis), (short)-1, ainfo.getAdvFormatDTXTDestID());
            if (this.m_ph.isStockType() && ainfo.getAxis().equals(Identity.Y2Axis)) {
                this.saveStruct_AdvFormatStruct(this.m_ph.getDataTextFormat(Identity.Y1Axis), nIndex, ainfo.getAdvFormatDTXTDestID());
            }
        }
    }

    private void saveStruct_AnodeMasterRec() throws IOException {
        short arrayIndex = -1;
        block9: for (int nIdx = this.m_ph.getNumAnnotations() - 1; nIdx >= 0; --nIdx) {
            IdentObj annot = this.m_ph.getAnnotation(nIdx);
            short nodeType = this.m_ph.getAnnotationNodeType(annot);
            if (nodeType != 5 && nodeType != 18 && nodeType != 3 && nodeType != 7 && nodeType != 6 && nodeType != 17 && nodeType != 2 && nodeType != 9 && nodeType != 10 && nodeType != 0) continue;
            arrayIndex = (short)(arrayIndex + 1);
            this.writeTIFF(Tags3TF.TAG_ANODEINFOREC);
            this.writeShort(arrayIndex);
            this.writeShort((short)1014);
            this.writeShort(nodeType);
            this.writeShort((short)0);
            this.writeRectangleTLBR(this.m_ph.getRect(annot));
            this.writeShort(this.m_ph.getAnnotationOrder(annot));
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.saveStruct_AreaInstRec(annot, arrayIndex, (short)1042);
            this.saveStruct_FontInstRec(annot, arrayIndex, (short)1044);
            this.saveStruct_LineInstRec(annot, arrayIndex, (short)1043);
            switch (nodeType) {
                case 5: {
                    this.saveStruct_AnaLineInfoRec(annot, arrayIndex, (short)1014);
                    continue block9;
                }
                case 3: 
                case 18: {
                    this.saveStruct_PolygonInfoRec(annot, false, arrayIndex, (short)1014);
                    continue block9;
                }
                case 6: 
                case 7: {
                    this.saveStruct_PolygonInfoRec(annot, true, arrayIndex, (short)1014);
                    continue block9;
                }
                case 2: 
                case 17: {
                    this.saveStruct_WedgeInfoRec(annot, arrayIndex, (short)1014);
                    continue block9;
                }
                case 8: {
                    continue block9;
                }
                case 9: 
                case 10: {
                    this.saveStruct_GTextInfoRec(annot, arrayIndex, (short)1014);
                    continue block9;
                }
                case 0: {
                    this.saveStruct_ArrowInfoRec(annot, arrayIndex, (short)1014);
                    continue block9;
                }
            }
        }
    }

    private void saveStruct_PolygonInfoRec(IdentObj annot, boolean closed, short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_POLYGONINFOREC);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(this.m_ph.toShort(closed));
        Object firstObject = this.m_ph.getAnnotationObject(annot, 0);
        if (firstObject != null && firstObject.getClass() == Polygon.class) {
            this.saveStruct_Polygon((Polygon)firstObject, nIndex, nDestID);
        } else {
            this.saveStruct_PolygonOfPoints(annot, nIndex, nDestID);
        }
    }

    private void saveStruct_Polygon(Polygon poly, short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_POLY, (short)(14 + 4 * poly.npoints));
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)(poly.npoints * 8 + 20));
        this.writeRectangleTLBR(poly.getBounds());
        for (int i = 0; i < poly.npoints; ++i) {
            this.writePointYX(poly.xpoints[i], poly.ypoints[i]);
        }
    }

    private void saveStruct_PolygonOfPoints(IdentObj annot, short nIndex, short nDestID) throws IOException {
        Object o;
        int i;
        int nObjects = this.m_ph.getNumAnnotationObjects(annot);
        int nPoints = 4;
        Point min = null;
        Point max = null;
        for (i = 0; i < nObjects; ++i) {
            o = this.m_ph.getAnnotationObject(annot, i);
            if (o.getClass() != Point.class) continue;
            Point p = (Point)o;
            if (min == null) {
                min = new Point(p);
                max = new Point(p);
                nPoints = 1;
                continue;
            }
            if (p.x < min.x) {
                min.x = p.x;
            }
            if (p.y < min.y) {
                min.y = p.y;
            }
            if (p.x > max.x) {
                max.x = p.x;
            }
            if (p.y > max.y) {
                max.y = p.y;
            }
            ++nPoints;
        }
        this.writeTIFF(Tags3TF.TAG_POLY, (short)(14 + 4 * nPoints));
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)(nPoints * 8 + 20));
        if (min != null) {
            this.writeRectangleTLBR(new Rectangle(min.x, min.y, max.x - min.x, max.y - min.y));
            for (i = 0; i < nObjects; ++i) {
                o = this.m_ph.getAnnotationObject(annot, i);
                if (o.getClass() != Point.class) continue;
                this.writePointYX((Point)o);
            }
        } else {
            Rectangle rect = this.m_ph.getRect(annot);
            this.writeRectangleTLBR(rect);
            this.writePointYX(rect.x, rect.y);
            this.writePointYX(rect.x + rect.width, rect.y);
            this.writePointYX(rect.x + rect.width, rect.y + rect.height);
            this.writePointYX(rect.x, rect.y + rect.height);
        }
    }

    private void saveStruct_WedgeInfoRec(IdentObj annot, short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_WEDGEINFOREC);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeDouble(0.0);
        this.writeDouble(0.0);
        this.writeShort((short)0);
        this.writeShort((short)0);
    }

    private void saveStruct_ArrowInfoRec(IdentObj annot, short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_ARROWINFOREC);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writePointYX((Point)this.m_ph.getAnnotationObject(annot, 0));
        this.writePointYX((Point)this.m_ph.getAnnotationObject(annot, 1));
        this.writeDouble(500.0);
        this.writeShort(this.m_ph.getArrowHeadLength(annot));
        this.writeShort((short)0);
        this.writeShort((short)100);
        this.writeShort((short)0);
        this.writeShort((short)100);
    }

    private void saveStruct_AnaLineInfoRec(IdentObj annot, short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_ANALINEINFOREC);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writePointYX((Point)this.m_ph.getAnnotationObject(annot, 0));
        this.writePointYX((Point)this.m_ph.getAnnotationObject(annot, 1));
        this.writeShort((short)(this.m_ph.getLineWidthInPoints(annot) * 150.0));
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
    }

    private void saveStruct_GTextInfoRec(IdentObj annot, short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_GTEXTINFOREC);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.saveStruct_HandleToText(nIndex, nDestID, this.m_ph.getTextString(annot));
        this.saveStruct_AreaInstRec(annot, nIndex, (short)1041);
        this.saveStruct_LineInstRec(annot, nIndex, (short)1041);
    }

    private void saveStruct_HandleToText(short nIndex, short nDestID, String value) throws IOException {
        byte[] text = value.getBytes(this.m_stringConv);
        int textlen = this.getTextLen(text, true, true);
        this.writeTIFF(Tags3TF.TAG_TEXT, (short)(4 + textlen));
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeTextBytes(text, true);
    }

    private void saveStruct_ConTextType(IdentObj id, short nIndex, short nDestID) throws IOException {
        this.saveStruct_ConTextType(id, this.m_ph.getAutofit(id), nIndex, nDestID, (short)0, (short)0, (short)0, (short)0);
    }

    private void saveStruct_ConTextType(IdentObj id, boolean bAutoFit, short nIndex, short nDestID, short nFracParaLow, short nFracParaHigh, short nFracOrthLow, short nFracOrthHigh) throws IOException {
        this.writeTIFF(Tags3TF.TAG_GRAPH_CONTEXTTYPE);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(this.m_ph.toShort(bAutoFit));
        this.writeShort(nFracParaLow);
        this.writeShort(nFracParaHigh);
        this.writeShort(nFracOrthLow);
        this.writeShort(nFracOrthHigh);
    }

    private void saveStruct_BoxInstRec(Rectangle rect, short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_STDDRAW_BOXINSTREC);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeRectangle(rect);
    }

    private void saveStruct_VarArraySerDepDataClass(short nIndex, short nDestID) throws IOException {
        int numSeries = this.m_ph.getSeriesLooping();
        for (int series = 0; series < numSeries; ++series) {
            Set<Integer> seriesCurveSet = this.m_ph.getSeriesCurveSet(series);
            this.writeTIFF(Tags3TF.TAG_SERDEPDATACLASS_2);
            this.writeShort((short)series);
            this.writeShort(nDestID);
            IdentObj idSeries = this.m_ph.getSeries(series);
            this.writeShort(this.toShort(seriesCurveSet.contains(TrendlineType.FIT_SMOOTH.ordinal())));
            this.writeShort(this.toShort(seriesCurveSet.contains(TrendlineType.FIT_LINEAR.ordinal())));
            this.writeShort(this.toShort(seriesCurveSet.contains(TrendlineType.FIT_MOVINGAVG.ordinal())));
            this.writeShort(this.toShort(seriesCurveSet.contains(TrendlineType.FIT_CONNECTED.ordinal())));
            this.writeShort(this.toShort(seriesCurveSet.contains(TrendlineType.FIT_MEAN.ordinal())));
            this.writeShort(this.toShort(seriesCurveSet.contains(TrendlineType.FIT_STDDEV.ordinal())));
            this.writeShort(this.m_ph.getRiserType(series));
            this.writeShort((short)0);
            this.writeShort(this.m_ph.getMarkerSize(series));
            this.writeShort(this.m_ph.getRiserType3D(series));
            this.writeShort(this.m_ph.getAxisAssignment(series));
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort(this.m_ph.getDummy3(series));
            this.writeShort(this.toShort(seriesCurveSet.contains(TrendlineType.FIT_LOGARITHMIC.ordinal())));
            this.writeShort(this.toShort(seriesCurveSet.contains(TrendlineType.FIT_GEOMETRIC.ordinal())));
            this.writeShort(this.toShort(seriesCurveSet.contains(TrendlineType.FIT_EXPONENTIAL.ordinal())));
            this.writeShort(this.toShort(seriesCurveSet.contains(TrendlineType.FIT_POLYNOMIAL.ordinal())));
            this.writeShort(this.m_ph.getCurveFitPolynomialOrder(series));
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort(this.m_ph.getConnectScatterMarkers());
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort(this.m_ph.getLabelStdFormat(idSeries));
            this.writeShort(this.m_ph.getDummy5(seriesCurveSet));
            this.writeShort(this.m_ph.getShowCorr(series));
            this.writeShort(this.m_ph.getCurveFitEquationDisplay(series));
            this.writeShort(this.m_ph.getDeleted(idSeries));
            this.saveStruct_BoxInstRec(this.m_ph.getBICurveText(series), (short)series, nDestID);
            this.saveStruct_PieSerDepData((short)series, nDestID);
            this.saveStruct_AdvFormatStruct(this.m_ph.getDataTextFormat(idSeries), (short)series, nDestID);
        }
    }

    private void saveStruct_PieSerDepData(short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_PIESERDEPDATACLASS);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(this.m_ph.getShowPieLabel(nIndex));
        this.writeShort(this.m_ph.getPieDisplayFeelers(nIndex));
        this.writeShort((short)0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeInt(this.m_ph.getPieSliceDetach(nIndex));
        this.writeInt(0);
    }

    private void saveStruct_HashInst(boolean isWanted, short style, short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_HASHINST);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        this.writeShort(this.m_ph.toShort(isWanted));
        this.writeShort(style);
    }

    private void saveStruct_fMatrixType(short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_FMATRIXTYPE);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        double[][] m = this.m_ph.get3DTransformMatrix();
        assert (m.length == 4);
        assert (m[0].length == 3);
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 3; ++y) {
                this.writeDouble(m[x][y]);
            }
        }
    }

    private void saveStruct_SFXRecord(IdentObj id, short nIndex, short nDestID) throws IOException {
        this.writeTIFF(Tags3TF.TAG_SFX_SFXRECORD);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        short layerCount = 1;
        this.writeShort((short)0);
        this.writeShort(layerCount);
        block5: for (short layerIdx = 0; layerIdx < layerCount; layerIdx = (short)(layerIdx + 1)) {
            short effectType = this.m_ph.getEffectType(id);
            this.writeTIFF(Tags3TF.TAG_SFX_LAYERSTRUCT);
            this.writeShort(nIndex);
            this.writeShort(nDestID);
            this.writeShort(layerIdx);
            this.writeShort(effectType);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            this.writeShort((short)0);
            switch (effectType) {
                case 14: {
                    this.writeTIFF(Tags3TF.TAG_SFX_ADVWASHRECORD);
                    this.writeShort(nIndex);
                    this.writeShort(nDestID);
                    this.writeShort(layerIdx);
                    this.writeRGB(this.m_ph.getWashColor(id, 0));
                    this.writeRGB(this.m_ph.getWashColor(id, 1));
                    this.writeShort(this.m_ph.getGradientOffsetX(id));
                    this.writeShort(this.m_ph.getGradientOffsetY(id));
                    this.writeShort(this.m_ph.getGradientAngle(id));
                    this.writeShort((short)0);
                    this.writeShort((short)0);
                    this.writeShort(this.m_ph.getGradientAdvWashType(id));
                    continue block5;
                }
                case 3: {
                    this.writeTIFF(Tags3TF.TAG_SFX_WASHRECORD);
                    this.writeShort(nIndex);
                    this.writeShort(nDestID);
                    this.writeShort(layerIdx);
                    this.writeRGB(this.m_ph.getGradientPinRightColor(id, 0));
                    this.writeRGB(this.m_ph.getGradientPinLeftColor(id, 1));
                    this.writeShort((short)0);
                    this.writeShort((short)0);
                    this.writeShort(this.m_ph.getWashType(id));
                    this.writeShort(this.m_ph.getWashDir(id));
                    this.writeShort((short)0);
                    continue block5;
                }
                case 4: {
                    this.writeTIFF(Tags3TF.TAG_SFX_PICTURERECORD);
                    this.writeShort(nIndex);
                    this.writeShort(nDestID);
                    this.writeShort(layerIdx);
                    this.writeShort(this.m_ph.getPictScale(id));
                    this.writeShort(this.m_ph.getPictFlip(id));
                    this.writeShort((short)0);
                    this.writeShort((short)0);
                    this.writeNBytes(this.m_ph.getTextureName(id).getBytes(this.m_stringConv), 64, false);
                    this.writeNBytes("".getBytes(this.m_stringConv), 64, false);
                    this.writeShort((short)0);
                    continue block5;
                }
            }
        }
    }

    public short toShort(boolean val) {
        return (short)(val ? 1 : 0);
    }

    private void saveStruct_AdvFormatStruct(Format fmt, short nIndex, short nDestID) throws IOException {
        AdvFormatStruct nf = this.m_ph.getAdvFormat(fmt);
        this.writeTIFF(Tags3TF.TAG_ADVFORMATSTRUCT, (short)956);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        char[] empty = new char[]{};
        this.writeInt(nf != null ? nf.formatType : 0);
        this.writeInt(nf != null ? nf.iLZero : 0);
        this.writeInt(nf != null ? nf.iDigits : 0);
        this.writeInt(nf != null ? nf.iGrouping : 0);
        this.writeInt(nf != null ? nf.iNegNumber : 1);
        this.writeNBytes(new String(nf != null ? nf.szScientificSymbol : empty).getBytes(this.m_stringConv), 3, false);
        this.writeNBytes(new String(nf != null ? nf.szDecimal : empty).getBytes(this.m_stringConv), 5, false);
        this.writeNBytes(new String(nf != null ? nf.szThousand : empty).getBytes(this.m_stringConv), 5, false);
        this.writeInt(nf != null ? nf.iCurrDigits : 0);
        this.writeInt(nf != null ? nf.iMonGrouping : 0);
        this.writeInt(nf != null ? nf.iNegCurr : 0);
        this.writeInt(nf != null ? nf.iPosCurr : 0);
        this.writeNBytes(new String(nf != null ? nf.szCurrency : empty).getBytes(this.m_stringConv), 5, false);
        this.writeNBytes(new String(nf != null ? nf.szMonDecimalSep : empty).getBytes(this.m_stringConv), 5, false);
        this.writeNBytes(new String(nf != null ? nf.szMonThousandSep : empty).getBytes(this.m_stringConv), 5, false);
        this.writeNBytes(new String(nf != null ? nf.szTimeFormat : empty).getBytes(this.m_stringConv), 32, false);
        this.writeNBytes(new String(nf != null ? nf.szDateFormat : empty).getBytes(this.m_stringConv), 32, false);
        this.writeNBytes(new String(nf != null ? nf.szPrefixText : empty).getBytes(this.m_stringConv), 20, false);
        this.writeNBytes(new String(nf != null ? nf.szPostfixText : empty).getBytes(this.m_stringConv), 20, false);
        this.writeNBytes(new String(empty).getBytes(this.m_stringConv), 20, false);
        this.writeNBytes(new String(empty).getBytes(this.m_stringConv), 20, false);
        this.writeNBytes(new String(empty).getBytes(this.m_stringConv), 20, false);
        this.writeInt(nf != null ? nf.bPrefixPercentSymbol : (short)0);
        this.writeDouble(nf != null ? nf.dScaleFactor : 0.0);
        this.writeInt(0);
        this.writeInt(0);
        this.writeNBytes(new String(empty).getBytes(this.m_stringConv), 256, false);
    }

    public void saveStruct_TimeAxisRec() throws IOException {
        int nIndex = -1;
        int nDestID = 13100;
        AxisInfo axisInfo = this.m_ph.getTimeAxisInfo();
        this.writeTIFF(Tags3TF.TAG_STRUCT_TIMEAXISREC);
        this.writeShort((short)-1);
        this.writeShort((short)13100);
        this.writeShort(this.m_ph.getUseTimeScaleAxis());
        this.writeDouble(this.m_ph.getTimeAxisMinimum(axisInfo.getAxis()));
        this.writeDouble(this.m_ph.getTimeAxisMaximum(axisInfo.getAxis()));
        this.writeShort(this.m_ph.getLevelInterval(0));
        this.writeShort(this.m_ph.getMajorInterval(axisInfo.getMajorGrid()));
        this.writeShort(this.m_ph.getMajorGridTickInterval(axisInfo.getMajorGrid()));
        this.writeShort(this.m_ph.getMinorInterval(axisInfo.getMinorGrid()));
        this.writeShort(this.m_ph.getMinorGridTickInterval(axisInfo.getMinorGrid()));
        this.writeShort(this.m_ph.getAutomaticMinimum(axisInfo.getAxis()));
        this.writeShort(this.m_ph.getAutomaticMaximum(axisInfo.getAxis()));
        this.writeShort((short)1);
        this.writeShort(this.m_ph.getMajorUnitAuto(axisInfo.getMajorGrid()));
        this.writeShort(this.m_ph.getMinorUnitAuto(axisInfo.getMinorGrid()));
        this.writeShort(this.m_ph.getXYData());
    }

    public void saveStruct_FancyBoxRec(IdentObj id, short nDestID) throws IOException {
        int nIndex = -1;
        this.writeTIFF(Tags3TF.TAG_FANCYBOX);
        this.writeShort((short)-1);
        this.writeShort(nDestID);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getFancyBoxStyle(id));
    }

    public void saveStruct_GaugeObjectRec() throws IOException {
        int nIndex = -1;
        int nDestID = 12173;
        this.writeTIFF(Tags3TF.TAG_STRUCT_GAUGEOBJECTREC2);
        this.writeShort((short)-1);
        this.writeShort((short)12173);
        this.writeShort(this.m_ph.getGaugeStopAngle());
        this.writeShort(this.m_ph.getGaugeStartAngle());
        this.writeShort((short)1);
        this.writeShort((short)0);
        this.writeShort(this.m_ph.getGaugeThickness());
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.writeShort((short)0);
        this.saveStruct_AreaInstRec(this.m_ph.getGaugeBackground(), (short)0, (short)12169);
        this.saveStruct_LineInstRec(this.m_ph.getGaugeBackground(), (short)0, (short)12167);
        this.saveStruct_FancyBoxRec(this.m_ph.getSubFrame(), (short)3055);
        for (int i = 0; i < 5; ++i) {
            this.saveStruct_GaugeRangeRec((short)i, (short)0);
        }
    }

    private void saveStruct_GaugeRangeRec(short nIndex, short nDestID) throws IOException {
        IdentObj band = this.m_ph.getGaugeBand(nIndex);
        this.writeTIFF(Tags3TF.TAG_STRUCT_GAUGERANGEREC);
        this.writeShort(nIndex);
        this.writeShort(nDestID);
        double min = this.m_ph.getGaugeBandMin(band);
        double max = this.m_ph.getGaugeBandMax(band);
        this.writeShort(this.m_ph.toShort(min != 0.0 || max != 0.0));
        this.writeDouble(min);
        this.writeDouble(max);
        this.saveStruct_AreaInstRec(band, nIndex, (short)12172);
    }

    public void printRecordSizeBad(int nTag, int requestedWriteByteSize, int byteSizeActuallyWritten) {
    }

    class FontEntry {
        String fontName;
        short pitchAndFamily;
        short charSet;
        short nFlags;

        FontEntry(String fontName, short pitchAndFamily, short charSet, short nFlags) {
            this.fontName = fontName;
            this.pitchAndFamily = pitchAndFamily;
            this.charSet = charSet;
            this.nFlags = nFlags;
        }

        public boolean equals(Object o) {
            FontEntry fe = (FontEntry)o;
            return this.fontName.equals(fe.fontName) && this.pitchAndFamily == fe.pitchAndFamily && this.charSet == fe.charSet && this.nFlags == fe.nFlags;
        }
    }
}

