/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IDataProcessor;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.ITrendlineEngine2;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StdDevEngine
implements ITrendlineEngine2 {
    private double mean;
    private double deviation;
    private boolean isValid = false;
    private IDataProcessor dataProc;
    private int series;

    StdDevEngine() {
    }

    @Override
    public void processDataValues(List<Point2D> data) {
        double sum = 0.0;
        int validDataCount = 0;
        for (Point2D pt : data) {
            if (pt == null) continue;
            sum += pt.getY();
            ++validDataCount;
        }
        if (validDataCount == 0) {
            return;
        }
        this.isValid = true;
        this.mean = sum / (double)validDataCount;
        double total = 0.0;
        for (Point2D pt : data) {
            if (pt == null) continue;
            double v = pt.getY() - this.mean;
            total += v * v;
        }
        this.deviation = Math.sqrt(total / (double)validDataCount);
    }

    @Override
    public List<Point> generateCurve(int seriesId, IDataProcessor dataProcessor) {
        if (!this.isValid) {
            return Collections.EMPTY_LIST;
        }
        this.dataProc = dataProcessor;
        this.series = seriesId;
        return this.createCurve(this.mean + this.deviation);
    }

    @Override
    public List<Point> generateExtraCurve() {
        if (!this.isValid) {
            return Collections.EMPTY_LIST;
        }
        return this.createCurve(this.mean - this.deviation);
    }

    private List<Point> createCurve(double yValue) {
        if (!this.dataProc.isYValueWithinAxis(this.series, yValue)) {
            return Collections.EMPTY_LIST;
        }
        int y = this.dataProc.getYAxisCoord(this.series, yValue);
        int x1 = this.dataProc.getXAxisMinCoord();
        int x2 = this.dataProc.getXAxisMaxCoord();
        ArrayList<Point> vcPts = new ArrayList<Point>();
        vcPts.add(new Point(x1, y));
        vcPts.add(new Point(x2, y));
        return vcPts;
    }

    @Override
    public String getCorrelationText(Format format) {
        return "";
    }

    @Override
    public String getEquationText(Format format) {
        return "";
    }

    @Override
    public void setSmoothingFactor(int smoothFactor) {
    }
}

