/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.Interval;
import java.util.Calendar;
import java.util.GregorianCalendar;

public final class DateUtils {
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    public static final long HOUR = 3600000L;
    public static final long DAY = 86400000L;
    public static final long WEEK = 604800000L;
    public static final long MILLISECONDS_PER_DAY = 86400000L;
    public static final long MILLISECONDS_PER_WEEK = 604800000L;
    public static final int FORMAT_SHORT = 0;
    public static final int FORMAT_MEDIUM = 1;
    public static final int FORMAT_LONG = 2;
    public static final String[] QUARTERS_SHORT = new String[]{"Q1", "Q2", "Q3", "Q4"};
    public static final String[] QUARTERS_MEDIUM = new String[]{"Qtr 1", "Qtr 2", "Qtr 3", "Qtr 4"};
    public static final String[] QUARTERS_LONG = new String[]{"Quarter 1", "Quarter 2", "Quarter 3", "Quarter 4"};
    public static final String[] MONTHS_MEDIUM = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    public static final String[] MONTHS_LONG = new String[]{"January", "Febuary", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final String SECOND_STR = "Second";
    public static final String SECOND_SHORT_STR = "Sec";
    public static final String MINUTE_STR = "Minute";
    public static final String MINUTE_SHORT_STR = "Min";
    public static final String HOUR_STR = "Hour";
    public static final String DAY_STR = "Day";
    public static final String WEEK_STR = "Week";

    private DateUtils() {
    }

    public static final void throwIfStartBeforeEnd(Calendar start, Calendar end) {
        if (start.after(end)) {
            throw new IllegalArgumentException("\n\nEnd date[" + end.getTime() + "] proceeds start date[" + start.getTime() + "].\n");
        }
    }

    public static final String arrayToString(int[] o) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < o.length; ++i) {
            sb.append("" + o[i] + " ");
        }
        return sb.toString();
    }

    public static final String[] getYearLabelArray(int[] a, int format) {
        int count = a.length;
        String[] array = new String[count];
        for (int i = 0; i < count; ++i) {
            if (format == 0) {
                array[i] = "" + a[i];
                array[i] = array[i].substring(2, array[i].length());
                continue;
            }
            array[i] = "" + a[i];
        }
        return array;
    }

    public static final int[] getYearArray(Calendar start, Calendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int first = start.get(1);
        int last = end.get(1);
        int count = DateUtils.getYearCount(start, end);
        int[] array = new int[count];
        array[0] = first;
        for (int i = 1; i < count; ++i) {
            array[i] = ++first;
        }
        array[count - 1] = last;
        return array;
    }

    public static final int getYearCount(Calendar start, Calendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int first = start.get(1);
        int last = end.get(1);
        return last - first + 1;
    }

    public static final String[] getQuarterLabelArray(int[] a, int format) {
        int count = a.length;
        String[] array = new String[count];
        for (int i = 0; i < count; ++i) {
            if (format == 0) {
                array[i] = "" + a[i];
                continue;
            }
            if (format == 1) {
                array[i] = "Q" + a[i];
                continue;
            }
            if (format != 2) continue;
            array[i] = "Quarter " + a[i];
        }
        return array;
    }

    public static final int[] getQuarterArray(Calendar start, Calendar end, int q1StartMonth) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int[] months = DateUtils.getMonthArray(start, end);
        int monthCount = months.length;
        int quarterCount = DateUtils.getQuarterCount(start, end, q1StartMonth);
        int[] array = new int[quarterCount];
        int count = 0;
        int lastQuarter = -1;
        for (int i = 0; i < monthCount; ++i) {
            int currQuarter = DateUtils.monthToQuarter(months[i], q1StartMonth);
            if (currQuarter == lastQuarter) continue;
            array[count] = currQuarter;
            ++count;
            lastQuarter = currQuarter;
        }
        return array;
    }

    public static final int monthToQuarter(int month, int q1StartMonth) {
        int quarter = 0;
        if (month < q1StartMonth) {
            month += 12;
        }
        month = Math.abs(month - q1StartMonth) + 1;
        quarter = (month - 1) / 3 + 1;
        return quarter;
    }

    public static final int getQuarterCount(Calendar start, Calendar end, int q1StartMonth) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int[] months = DateUtils.getMonthArray(start, end);
        int monthCount = months.length;
        int count = 0;
        int lastQuarter = -1;
        for (int i = 0; i < monthCount; ++i) {
            int currQuarter = DateUtils.monthToQuarter(months[i], q1StartMonth);
            if (currQuarter == lastQuarter) continue;
            ++count;
            lastQuarter = currQuarter;
        }
        return count;
    }

    public static final long getNextQuarterStart(Calendar start, int q1StartMonth) {
        int firstMonthQtr;
        int firstMonth = start.get(2) + 1;
        int qtrIterator = firstMonthQtr = DateUtils.monthToQuarter(firstMonth, q1StartMonth);
        GregorianCalendar startIterator = new GregorianCalendar();
        startIterator.setTime(start.getTime());
        while (qtrIterator == firstMonthQtr) {
            startIterator.add(2, 1);
            int month = startIterator.get(2) + 1;
            qtrIterator = DateUtils.monthToQuarter(month, q1StartMonth);
        }
        startIterator.set(5, 1);
        startIterator.set(11, 0);
        startIterator.set(12, 0);
        startIterator.set(13, 0);
        startIterator.set(14, 0);
        long nextQtrMs = startIterator.getTimeInMillis();
        return nextQtrMs;
    }

    public static final long getQuarterStart(Calendar start, int q1StartMonth) {
        int thisQtr;
        int firstMonth = start.get(2) + 1;
        int qtrIterator = thisQtr = DateUtils.monthToQuarter(firstMonth, q1StartMonth);
        GregorianCalendar startIterator = new GregorianCalendar();
        startIterator.setTime(start.getTime());
        while (qtrIterator == thisQtr) {
            startIterator.add(2, -1);
            int month = startIterator.get(2) + 1;
            qtrIterator = DateUtils.monthToQuarter(month, q1StartMonth);
        }
        startIterator.add(2, 1);
        startIterator.set(5, 1);
        startIterator.set(11, 0);
        startIterator.set(12, 0);
        startIterator.set(13, 0);
        startIterator.set(14, 0);
        long nextQtrMs = startIterator.getTimeInMillis();
        return nextQtrMs;
    }

    public static final String[] getMonthLabelArray(int[] a, int format) {
        int count = a.length;
        String[] array = new String[count];
        for (int i = 0; i < count; ++i) {
            if (format == 0) {
                array[i] = "" + a[i];
                continue;
            }
            if (format == 1) {
                array[i] = MONTHS_MEDIUM[a[i] - 1];
                continue;
            }
            if (format != 2) continue;
            array[i] = MONTHS_LONG[a[i] - 1];
        }
        return array;
    }

    public static final int[] getMonthArray(Calendar start, Calendar end) {
        int i;
        DateUtils.throwIfStartBeforeEnd(start, end);
        int first = start.get(2);
        int last = end.get(2);
        int count = DateUtils.getMonthCount(start, end);
        int[] array = new int[count];
        array[0] = first;
        for (i = 1; i < count; ++i) {
            array[i] = ++first % 12;
        }
        array[count - 1] = last;
        i = 0;
        while (i < count) {
            int n = i++;
            array[n] = array[n] + 1;
        }
        return array;
    }

    public static final int getMonthCount(Calendar start, Calendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int first = start.get(2);
        int last = end.get(2);
        int count = 12 * (DateUtils.getYearCount(start, end) - 1) + last - first + 1;
        return count;
    }

    public static final String[] getWeekLabelArray(int[] a, int format) {
        int count = a.length;
        String[] array = new String[count];
        for (int i = 0; i < count; ++i) {
            array[i] = format == 0 ? "" + a[i] : "Week " + a[i];
        }
        return array;
    }

    public static final int[] getWeekArray(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int first = start.get(3);
        int last = end.get(3);
        int count = DateUtils.getWeekCount(start, end);
        int[] array = new int[count];
        array[0] = first;
        for (int i = 1; i < count; ++i) {
            array[i] = ++first % 52;
            if (0 != array[i]) continue;
            array[i] = 52;
        }
        array[count - 1] = last;
        return array;
    }

    public static final int getWeekCount(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int startDayOfWeek = start.get(7);
        int numDaysTillNextWeek = 8 - startDayOfWeek;
        int count = 1;
        boolean cycled = false;
        GregorianCalendar startIterator = new GregorianCalendar();
        startIterator.setTime(start.getTime());
        startIterator.add(6, numDaysTillNextWeek);
        startIterator.set(10, end.get(11));
        startIterator.set(12, end.get(12));
        startIterator.set(13, end.get(13));
        startIterator.set(14, 999);
        while (startIterator.getTimeInMillis() < end.getTimeInMillis()) {
            ++count;
            startIterator.add(3, 1);
            cycled = true;
        }
        double diff = end.getTimeInMillis() - start.getTimeInMillis();
        double weeks = diff / 6.048E8;
        int first = start.get(3);
        int last = end.get(3);
        if (weeks < 1.0 && first != last && !cycled) {
            ++count;
        }
        return count;
    }

    public static final int getWeekCountXXX(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int first = start.get(3);
        int last = end.get(3);
        int days = DateUtils.getDayCount(start, end);
        int yearWeeks = 0;
        int weekCount = 0;
        if (last == 1 && end.get(2) == 11 && days > 31) {
            last = 52;
        }
        if (days > 364) {
            yearWeeks = days / 365 * 52;
        }
        weekCount = first > last ? 52 - first + last + yearWeeks : last - first + 1 + yearWeeks;
        return weekCount;
    }

    public static final String[] getDayLabelArray(int[] a, int format) {
        int count = a.length;
        String[] array = new String[count];
        for (int i = 0; i < count; ++i) {
            array[i] = format == 0 ? "" + a[i] : "Day " + a[i];
        }
        return array;
    }

    public static final long[] getDayDateArray(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int count = DateUtils.getDayCount(start, end);
        long[] array = new long[count];
        GregorianCalendar gc = new GregorianCalendar();
        GregorianCalendar startIterator = new GregorianCalendar();
        startIterator.setTime(start.getTime());
        for (int i = 0; i < count; ++i) {
            array[i] = startIterator.getTimeInMillis();
            startIterator.add(5, 1);
            gc.setTimeInMillis(array[i]);
        }
        return array;
    }

    public static final int[] getDayArray(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int count = DateUtils.getDayCount(start, end);
        int[] array = new int[count];
        GregorianCalendar startIterator = new GregorianCalendar();
        startIterator.setTime(start.getTime());
        for (int i = 0; i < count; ++i) {
            array[i] = startIterator.get(5);
            startIterator.add(5, 1);
        }
        return array;
    }

    public static final int getDayCount(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        long diff = end.getTimeInMillis() - start.getTimeInMillis();
        double days = diff / 86400000L + 1L;
        int first = start.get(6);
        int last = end.get(6);
        if (first != last && days <= 1.0) {
            days += 1.0;
        }
        return (int)Math.ceil(days);
    }

    public static final String[] getHourLabelArray(int[] a, int format) {
        int count = a.length;
        String[] array = new String[count];
        for (int i = 0; i < count; ++i) {
            array[i] = format == 0 ? "" + (a[i] + 1) : "Hour " + (a[i] + 1);
        }
        return array;
    }

    public static final int[] getHourArray(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int count = DateUtils.getHourCount(start, end);
        int[] array = new int[count];
        array[0] = start.get(11) - 1;
        GregorianCalendar startIterator = new GregorianCalendar();
        startIterator.setTime(start.getTime());
        for (int i = 1; i < count - 1; ++i) {
            startIterator.add(11, 1);
            array[i] = startIterator.get(11) - 1;
        }
        array[count - 1] = end.get(11) - 1;
        return array;
    }

    public static final int getHourCount(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        double diff = end.getTimeInMillis() - start.getTimeInMillis();
        double hours = diff / 3600000.0;
        int first = start.get(11);
        int last = end.get(11);
        if (hours < 1.0 && first != last && hours < 1.0) {
            hours += 1.0;
        }
        return (int)Math.ceil(hours);
    }

    public static final String[] getMinuteLabelArray(int[] a, int format) {
        int count = a.length;
        String[] array = new String[count];
        for (int i = 0; i < count; ++i) {
            if (format == 0) {
                array[i] = "" + (a[i] + 0);
            }
            array[i] = format == 1 ? "Min " + (a[i] + 0) : "Minute " + (a[i] + 0);
        }
        return array;
    }

    public static final int[] getMinuteArray(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int count = DateUtils.getMinuteCount(start, end);
        int[] array = new int[count];
        array[0] = start.get(12);
        GregorianCalendar startIterator = new GregorianCalendar();
        startIterator.setTime(start.getTime());
        for (int i = 1; i < count - 1; ++i) {
            startIterator.add(12, 1);
            array[i] = startIterator.get(12);
        }
        array[count - 1] = end.get(12);
        return array;
    }

    public static final int getMinuteCount(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        double diff = end.getTimeInMillis() - start.getTimeInMillis();
        double minutes = diff / 60000.0;
        int first = start.get(11);
        int last = end.get(11);
        if (first != last && minutes < 1.0) {
            minutes += 1.0;
        }
        return (int)Math.ceil(minutes);
    }

    public static final String[] getSecondLabelArray(int[] a, int format) {
        int count = a.length;
        String[] array = new String[count];
        for (int i = 0; i < count; ++i) {
            array[i] = format == 0 ? "" + (a[i] + 0) : (format == 1 ? "Sec " + (a[i] + 0) : "Second " + (a[i] + 0));
        }
        return array;
    }

    public static final int[] getSecondArray(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        int count = DateUtils.getSecondCount(start, end);
        int[] array = new int[count];
        GregorianCalendar startIterator = new GregorianCalendar();
        startIterator.setTime(start.getTime());
        for (int i = 0; i < count; ++i) {
            array[i] = startIterator.get(13);
            startIterator.add(13, 1);
        }
        return array;
    }

    public static final int getSecondCount(GregorianCalendar start, GregorianCalendar end) {
        DateUtils.throwIfStartBeforeEnd(start, end);
        long diff = end.getTimeInMillis() - start.getTimeInMillis();
        double seconds = diff / 1000L;
        return (int)Math.ceil(seconds);
    }

    public static final GregorianCalendar getDateTime(int year, int month, int date, int hour, int minute, int second) {
        return new GregorianCalendar(year, month - 1, date, hour, minute, second);
    }

    public static final long getDateTimeMillis(int year, int month, int date, int hour, int minute, int second) {
        GregorianCalendar d = new GregorianCalendar(year, month - 1, date, hour, minute, second);
        return d.getTimeInMillis();
    }

    public static final void main(String[] args) {
        new DateUtils();
    }

    public static long add(long timeInMillis, int unit, int step) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(timeInMillis);
        calendar.add(Interval.toJavaCalendarInterval(unit), step);
        return calendar.getTimeInMillis();
    }

    public static long diff(long fromDateMillis, long toDateMillis, int unit) {
        switch (unit) {
            case 4: {
                return (toDateMillis - fromDateMillis) / 86400000L;
            }
            case 5: {
                return (toDateMillis - fromDateMillis) / 604800000L;
            }
        }
        throw new RuntimeException("DateUtils.diff() : Not implemented!");
    }
}

