/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.Access;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis3D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.RelativeAxisObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.FP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.model3d.Point3d;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Axis3DObj
extends RelativeAxisObj
implements IOrdinalAxis,
IAxis3D {
    private static final int ANGLE_HORZ = 1;
    private static final int ANGLE_VERT = 2;
    private static final int ANGLE_QUAD_1_A = 3;
    private static final int ANGLE_QUAD_1_B = 4;
    private static final int ANGLE_QUAD_2_A = 5;
    private static final int ANGLE_QUAD_2_B = 6;
    private static final int LABEL_DISTANCE = 300;
    private JChart_3D m_chart;
    protected boolean m_bVertScale;
    protected int m_axisLengthVC;
    protected int m_axisOrgVC;
    private List<Double> m_majorGridPos;
    private List<Double> m_minorGridPos;
    private IBlackBox m_minorGridBB;
    private IBlackBox m_majorGridBB;
    private IdentObj m_majorGridId;
    private IdentObj m_minorGridId;
    private Rectangle m_rTitleFrame;
    private Point[] m_pt2dLabelPositions;
    private int m_maxLabelIndex = 0;

    Axis3DObj(JChart_3D chart, Perspective perspective, Access access, AxisTemplate id, int nAxisType, int orient, boolean bAscending, int nAxisOriginVC, int nAxisLengthVC) {
        this(chart, perspective, access, id, nAxisType, orient, bAscending, 0, 100, nAxisOriginVC, nAxisLengthVC);
    }

    private Axis3DObj(JChart_3D chart, Perspective perspective, Access access, AxisTemplate id, int nAxisType, int orient, boolean bAscending, int nAxisOffset, int nAxisSize, int nAxisOriginVC, int nAxisLengthVC) {
        super(perspective, access, id, nAxisType, bAscending, nAxisOffset, nAxisSize);
        this.m_axisLengthVC = nAxisLengthVC;
        this.m_axisOrgVC = nAxisOriginVC;
        this.m_chart = chart;
        this.m_rTitleFrame = null;
        this.m_bVertScale = false;
        this.m_bDelayCalcLabels = true;
    }

    Axis3DObj(JChart_3D chart, Perspective perspective, Access access, AxisTemplate id, MinMaxObj minMax, int orient, boolean bAscending, int nAxisOffset, int nAxisSize, int nAxisOriginVC, int nAxisLengthVC) {
        super(perspective, access, id, minMax, bAscending, nAxisOffset, nAxisSize);
        this.m_axisLengthVC = nAxisLengthVC;
        this.m_axisOrgVC = nAxisOriginVC;
        this.m_chart = chart;
        this.m_rTitleFrame = null;
        this.m_bDelayCalcLabels = true;
    }

    @Override
    protected void adjustTitlePosPass1(int nSide, List<Rectangle> rLabels, Rectangle rTitle) {
    }

    @Override
    protected void adjustTitlePosPass2(IdentObj id, int nSide, Rectangle rTitle, Dimension labelDim) {
        switch (id.getObjectID()) {
            case 8: {
                rTitle.x += rTitle.width - labelDim.width;
                rTitle.width = labelDim.width;
                rTitle.height = labelDim.height;
                break;
            }
            case 9: {
                rTitle.width = labelDim.width;
                rTitle.height = labelDim.height;
                break;
            }
            case 6: {
                if (nSide == 0) {
                    rTitle.width = labelDim.width;
                    rTitle.y += rTitle.height - labelDim.height;
                    rTitle.height = labelDim.height;
                    break;
                }
                rTitle.x += rTitle.width - labelDim.width;
                rTitle.width = labelDim.width;
                rTitle.y += rTitle.height - labelDim.height;
                rTitle.height = labelDim.height;
            }
        }
    }

    @Override
    public void calc() {
        this.m_majorGridPos = new ArrayList<Double>(1);
        this.m_minorGridPos = new ArrayList<Double>(1);
        super.calc();
    }

    @Override
    public void calcLabels() {
        if (!this.m_bDelayCalcLabels) {
            throw new RuntimeException("call calcLabels only is the calclabel has been delayed (3D charts)");
        }
        super.calcLabels();
    }

    @Override
    protected void calcMajorGridLine(IdentObj id, double fRelPos, IBlackBox blackBox) {
        this.m_majorGridPos.add(new Double((double)this.m_axisOrgVC + fRelPos * (double)this.m_axisLengthVC));
        this.m_majorGridBB = blackBox;
        this.m_majorGridId = id;
    }

    @Override
    protected void calcMinorGridLine(IdentObj id, double fRelPos, IBlackBox blackBox) {
        if (FP.between(fRelPos, 0.0, 1.0)) {
            this.m_minorGridPos.add(new Double((double)this.m_axisOrgVC + fRelPos * (double)this.m_axisLengthVC));
            this.m_minorGridBB = blackBox;
            this.m_minorGridId = id;
        }
    }

    @Override
    protected void calcMajorTickLine(double fRelPos) {
    }

    @Override
    protected void calcMinorTickLine(double fRelPos) {
    }

    @Override
    protected boolean doDisplayOnCalc() {
        return true;
    }

    @Override
    public void setDisplayOnCalc(boolean bDoNothing) {
    }

    @Override
    public boolean isVertical() {
        return this.m_bVertScale;
    }

    private int getAxis() {
        int nAxis = 0;
        switch (this.m_template.getAxisObjID()) {
            case 5: {
                nAxis = 2;
                break;
            }
            case 6: {
                nAxis = 0;
                break;
            }
            case 0: {
                nAxis = 1;
            }
        }
        return nAxis;
    }

    private int getAxisAngle(int nSide, int nAxis) {
        int angle;
        Point pt1 = this.getPointPosition(nSide, nAxis, 0.0);
        Point pt2 = this.getPointPosition(nSide, nAxis, 1.0);
        double x = pt2.x - pt1.x;
        double y = pt2.y - pt1.y;
        for (angle = FP.round(Math.atan2(y, x) * 57.29577951308232); angle < 180; angle += 180) {
        }
        while (angle > 180) {
            angle -= 180;
        }
        return angle;
    }

    private int getAxisPseudoQuadrant(int angle, boolean bRotate) {
        int nAlign = angle < 10 || angle > 170 ? 1 : (angle > 80 && angle < 100 ? 2 : (angle < (bRotate ? 80 : 20) ? 3 : (angle < 90 ? 4 : (angle < (bRotate ? 99 : 170) ? 5 : 6))));
        return nAlign;
    }

    @Override
    public int getAxisSide() {
        switch (this.getAxis()) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.m_Perspective.getAxisSide(this.m_template.getAxis());
            }
            case 2: {
                return 1;
            }
        }
        return 0;
    }

    @Override
    protected boolean isAxisLabelVisible(int nSide) {
        return this.m_chart.isAxisVisible(this.getAxis(), nSide);
    }

    private int getAxisToWallAngle(int nSide, int nAxis, Point wallCenter) {
        Point p1 = this.getPointPosition(nSide, nAxis, 0.0);
        Point p2 = this.getPointPosition(nSide, nAxis, 1.0);
        Point axisCenter = new Point(Math.min(p2.x, p1.x) + Math.abs(p2.x - p1.x) / 2, Math.min(p2.y, p1.y) + Math.abs(p2.y - p1.y) / 2);
        int x = wallCenter.x - axisCenter.x;
        int y = wallCenter.y - axisCenter.y;
        int axisToWallAngle = FP.round(Math.atan(y / x) * 57.29577951308232);
        if (x < 0 && y > 0) {
            axisToWallAngle += 180;
        } else if (x < 0 && y < 0) {
            axisToWallAngle += 180;
        } else if (x > 0 && y < 0) {
            axisToWallAngle += 360;
        }
        return axisToWallAngle;
    }

    @Override
    public double getBaseCoord() {
        assert (this.isNumericAxis());
        return (double)this.m_axisOrgVC + this.getBaseRelCoord() * (double)this.m_axisLengthVC;
    }

    @Override
    public double getCenterCoord(int g) {
        if (!this.isNumericAxis()) {
            return (double)this.m_axisOrgVC + this.getCenterRelCoord(g) * (double)this.m_axisLengthVC;
        }
        throw new RuntimeException("Numerical method called by ordinal axis");
    }

    @Override
    public int getGroupAboveCoord(int nCoord) {
        if (!this.isNumericAxis()) {
            return this.getGroupAboveRelCoord(((double)nCoord - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
        }
        throw new RuntimeException("Ordinal Axis method call on numerical axis");
    }

    @Override
    public int getGroupBelowCoord(int nCoord) {
        if (!this.isNumericAxis()) {
            return this.getGroupBelowRelCoord(((double)nCoord - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
        }
        throw new RuntimeException("Ordinal Axis method call on numerical axis");
    }

    @Override
    public double getHighCoord(int s, int g) {
        if (!this.isNumericAxis()) {
            return (double)this.m_axisOrgVC + this.getHighRelCoord(s, g) * (double)this.m_axisLengthVC;
        }
        throw new RuntimeException("Numerical method called by ordinal axis");
    }

    @Override
    public Point[] get2DLabelPositions() {
        return this.m_pt2dLabelPositions;
    }

    @Override
    public int getMaxWidthLabelIndex() {
        return this.m_maxLabelIndex;
    }

    @Override
    protected void getLabelAndTitlePos(int nSide, int nLabels, List<Rectangle> rLabels, List<Double> fRelPos, List<Integer> align, Rectangle rTitle, boolean bRotate, int nAutoSkip, int nLabelBegin, int nSkipFactor, ITextStyle textStyleLabel) {
        int labelWidth;
        int labelHeight;
        int nAxis = this.getAxis();
        Point[] pt2d = this.getLabelPosition2d(nSide, nAxis, nLabels, fRelPos);
        this.m_pt2dLabelPositions = new Point[pt2d.length];
        System.arraycopy(pt2d, 0, this.m_pt2dLabelPositions, 0, pt2d.length);
        switch (nAxis) {
            case 0: {
                this.m_maxLabelSize = 16000 + pt2d[0].x;
                break;
            }
            case 1: {
                this.m_maxLabelSize = 16000 + pt2d[pt2d.length - 1].x;
                break;
            }
            case 2: {
                this.m_maxLabelSize = 16000 - pt2d[pt2d.length - 1].x;
            }
        }
        int axisAngle = this.getAxisAngle(nSide, nAxis);
        Point wallCenter = this.getWallCenter(nAxis, this.m_chart.getCubeSize());
        int axisToWallAngle = this.getAxisToWallAngle(nSide, nAxis, wallCenter);
        int nPseudoQuadrant = this.getAxisPseudoQuadrant(axisAngle, bRotate);
        int nAlign = 0;
        switch (nPseudoQuadrant) {
            case 1: {
                if (axisToWallAngle > axisAngle && axisAngle > 90 || axisToWallAngle < axisAngle && axisAngle < 90) {
                    nAlign = 7;
                    break;
                }
                nAlign = 3;
                break;
            }
            case 2: {
                if (axisToWallAngle < axisAngle || axisToWallAngle > axisAngle + 180) {
                    nAlign = 5;
                    break;
                }
                nAlign = 1;
                break;
            }
            case 3: 
            case 4: {
                if (axisToWallAngle < axisAngle || axisToWallAngle > axisAngle + 180) {
                    nAlign = 6;
                    break;
                }
                nAlign = 2;
                break;
            }
            case 5: 
            case 6: {
                nAlign = axisToWallAngle < axisAngle || axisToWallAngle > axisAngle + 180 ? 4 : 8;
            }
        }
        Dimension rVirtDim = this.m_Perspective.getVC().getVirtDimension();
        int left = -rVirtDim.width / 2;
        int right = rVirtDim.width / 2;
        int top = rVirtDim.height / 2;
        int bottom = -rVirtDim.height / 2;
        if (nLabels > 1) {
            labelHeight = Math.abs((pt2d[nLabels - 1].y - pt2d[0].y) / (nLabels - 1));
            labelWidth = Math.abs((pt2d[nLabels - 1].x - pt2d[0].x) / (nLabels - 1));
        } else {
            Point pt1 = this.getPointPosition(nSide, nAxis, 0.0);
            Point pt2 = this.getPointPosition(nSide, nAxis, 1.0);
            labelHeight = Math.abs(pt2.y - pt1.y);
            labelWidth = Math.abs(pt2.x - pt1.x);
        }
        Rectangle rLabel = null;
        int maxLabelWidth = 0;
        for (int iLabel = 0; iLabel < nLabels; ++iLabel) {
            switch (nPseudoQuadrant) {
                case 1: {
                    if (nAlign == 3) {
                        rLabel = new Rectangle(pt2d[iLabel].x - labelWidth / 2, bottom, labelWidth, pt2d[iLabel].y - bottom - 300);
                        break;
                    }
                    rLabel = new Rectangle(pt2d[iLabel].x - labelWidth / 2, pt2d[iLabel].y + 300, labelWidth, top - pt2d[iLabel].y - 300);
                    break;
                }
                case 2: {
                    if (nAlign == 1) {
                        rLabel = new Rectangle(pt2d[iLabel].x + 300, pt2d[iLabel].y - labelHeight / 2, right - pt2d[iLabel].x - 300, labelHeight);
                        break;
                    }
                    rLabel = new Rectangle(left, pt2d[iLabel].y - labelHeight / 2, pt2d[iLabel].x - left - 300, labelHeight);
                    break;
                }
                case 3: {
                    if (nAlign == 2) {
                        rLabel = new Rectangle(pt2d[iLabel].x, bottom, labelWidth, pt2d[iLabel].y - bottom);
                        break;
                    }
                    rLabel = new Rectangle(pt2d[iLabel].x - labelWidth, pt2d[iLabel].y, labelWidth, top - pt2d[iLabel].y);
                    break;
                }
                case 4: {
                    if (nAlign == 2) {
                        rLabel = new Rectangle(pt2d[iLabel].x, pt2d[iLabel].y - labelHeight, right - pt2d[iLabel].x, labelHeight);
                        break;
                    }
                    rLabel = new Rectangle(left, pt2d[iLabel].y, pt2d[iLabel].x - left, labelHeight);
                    break;
                }
                case 5: {
                    if (nAlign == 4) {
                        rLabel = new Rectangle(left, pt2d[iLabel].y - labelHeight, pt2d[iLabel].x - left, labelHeight);
                        break;
                    }
                    rLabel = new Rectangle(pt2d[iLabel].x, pt2d[iLabel].y, right - pt2d[iLabel].x, labelHeight);
                    break;
                }
                case 6: {
                    rLabel = nAlign == 4 ? new Rectangle(pt2d[iLabel].x - labelWidth, bottom, labelWidth, pt2d[iLabel].y - bottom) : new Rectangle(pt2d[iLabel].x, pt2d[iLabel].y, labelWidth, top - pt2d[iLabel].y);
                }
            }
            if (rLabel == null) {
                throw new RuntimeException("Internal error: rLabel null");
            }
            rLabels.add(iLabel, rLabel);
            align.add(iLabel, new Integer(nAlign));
            if (maxLabelWidth >= rLabel.width) continue;
            this.m_maxLabelIndex = iLabel;
            maxLabelWidth = rLabel.width;
        }
        if (rTitle != null && this.m_rTitleFrame != null) {
            rTitle.x = this.m_rTitleFrame.x;
            rTitle.y = this.m_rTitleFrame.y;
            rTitle.width = this.m_rTitleFrame.width;
            rTitle.height = this.m_rTitleFrame.height;
        }
    }

    private Point[] getLabelPosition2d(int nSide, int nAxis, int nLabels, List<Double> fRelPos) {
        Point[] pt2d = new Point[nLabels];
        for (int i = 0; i < nLabels; ++i) {
            pt2d[i] = this.getPointPosition(nSide, nAxis, fRelPos.get(i));
        }
        return pt2d;
    }

    @Override
    public List<String> getLabels() {
        if (this.isNumericAxis()) {
            return this.getNumericLabels();
        }
        int nLabels = this.getNumLabels();
        ArrayList<String> szLabels = new ArrayList<String>(nLabels);
        if (this.m_template.getAxisObjID() == 5) {
            GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.m_Access);
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_Access.getNumTotalGroups());
                szLabels.add(this.m_Perspective.getGroupLabel(g).trim());
            }
        } else {
            SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Access);
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                assert (s >= 0 && s < this.m_Access.getNumTotalSeries());
                szLabels.add(this.m_Perspective.getSeriesLabel(s).trim());
            }
        }
        return szLabels;
    }

    @Override
    protected List<IdentObj> getLabelIdents() {
        ArrayList<IdentObj> idents;
        block6: {
            idents = null;
            if (this.isNumericAxis()) break block6;
            int nLabels = this.getNumLabels();
            idents = new ArrayList<IdentObj>(nLabels);
            if (this.m_template.getAxisObjID() == 5) {
                GroupsEnumerator gEnum = GroupsEnumerator.getReverseIterator(this.m_Perspective, this.m_Access);
                while (gEnum.hasNext()) {
                    int g = gEnum.next();
                    assert (g >= 0 && g < this.m_Access.getNumTotalGroups());
                    idents.add(new IdentObj(-3, -3, g));
                }
            } else {
                SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Access);
                while (sEnum.hasNext()) {
                    int s = sEnum.next();
                    assert (s >= 0 && s < this.m_Access.getNumTotalSeries());
                    idents.add(new IdentObj(-3, s));
                }
            }
        }
        return idents;
    }

    @Override
    public double getLowCoord(int s, int g) {
        if (!this.isNumericAxis()) {
            return (double)this.m_axisOrgVC + this.getLowRelCoord(s, g) * (double)this.m_axisLengthVC;
        }
        throw new RuntimeException("Numerical method called by ordinal axis");
    }

    @Override
    public IBlackBox getMajorGridBlackBox() {
        return this.m_majorGridBB;
    }

    @Override
    protected boolean getMajorTickDisplay(AxisTemplate axisID) {
        return false;
    }

    @Override
    protected boolean getMinorTickDisplay(AxisTemplate axisID) {
        return false;
    }

    @Override
    public boolean getMajorGridDisplay(AxisTemplate axisID) {
        switch (axisID.getAxisObjID()) {
            case 0: {
                return this.m_Perspective.getGrid3DLeftWallDisplayY() || this.m_Perspective.getGrid3DRightWallDisplayY() || this.m_Perspective.getGrid3DRiserDisplayY();
            }
            case 5: {
                return this.m_Perspective.getGrid3DFloorDisplayZ() || this.m_Perspective.getGrid3DLeftWallDisplayZ() || this.m_Perspective.getGrid3DRiserDisplayZ();
            }
            case 6: {
                return this.m_Perspective.getGrid3DFloorDisplayX() || this.m_Perspective.getGrid3DRightWallDisplayX() || this.m_Perspective.getGrid3DRiserDisplayX();
            }
        }
        throw new RuntimeException("Axis3D::getMajorGridDisplay not implemented for this axis");
    }

    @Override
    public IdentObj getMajorGridId() {
        return this.m_majorGridId;
    }

    @Override
    public List<Double> getMajorGridPositions() {
        return this.m_majorGridPos;
    }

    @Override
    public IBlackBox getMinorGridBlackBox() {
        return this.m_minorGridBB;
    }

    @Override
    protected boolean getMinorGridDisplay(AxisTemplate axisID) {
        return false;
    }

    @Override
    public IdentObj getMinorGridId() {
        return this.m_minorGridId;
    }

    @Override
    public List<Double> getMinorGridPositions() {
        return this.m_minorGridPos;
    }

    private Point getPointPosition(int nSide, int nAxis, double fRelPos) {
        Point3d size = this.m_chart.getCubeSize();
        Point3d pt3d = null;
        switch (nAxis) {
            case 0: {
                pt3d = new Point3d((int)((double)this.m_axisOrgVC + fRelPos * (double)this.m_axisLengthVC), 0.0, size.z);
                break;
            }
            case 1: {
                if (nSide == 0) {
                    pt3d = new Point3d(0.0, (int)((double)this.m_axisOrgVC + fRelPos * (double)this.m_axisLengthVC), size.z);
                    break;
                }
                pt3d = new Point3d(size.x, (int)((double)this.m_axisOrgVC + fRelPos * (double)this.m_axisLengthVC), 0.0);
                break;
            }
            case 2: {
                double rp = this.m_gt.is3DSurface() ? fRelPos : 1.0 - fRelPos;
                pt3d = new Point3d(size.x, 0.0, (int)((double)this.m_axisOrgVC + rp * (double)this.m_axisLengthVC));
            }
        }
        this.m_chart.transformPoint3d(pt3d);
        return this.m_chart.projectPoint3d(pt3d);
    }

    @Override
    protected int getTitleRotation(AxisTemplate template, int nSide) {
        return 0;
    }

    @Override
    public double getValueCoord(double fValue) {
        assert (this.isNumericAxis());
        return (double)this.m_axisOrgVC + this.getValueRelCoord(fValue) * (double)this.m_axisLengthVC;
    }

    @Override
    public double getValueFromCoord(int fCoord) {
        assert (this.isNumericAxis());
        return this.getValueFromRelCoord(((double)fCoord - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC);
    }

    @Override
    public final double getRatioFromCoord(double dCoord) {
        double dRatio = (dCoord - (double)this.m_axisOrgVC) / (double)this.m_axisLengthVC;
        if (dRatio < 0.0) {
            return 0.0;
        }
        if (dRatio > 1.0) {
            return 1.0;
        }
        return dRatio;
    }

    @Override
    public final double getCoordFromRatio(double dRatio) {
        return dRatio * (double)this.m_axisLengthVC + (double)this.m_axisOrgVC;
    }

    private Point getWallCenter(int nAxis, Point3d cubeSize) {
        Point3d wallCenter3d = null;
        switch (nAxis) {
            case 0: {
                wallCenter3d = new Point3d(cubeSize.x / 2.0, 0.0, 0.0);
                break;
            }
            case 1: {
                wallCenter3d = new Point3d(0.0, cubeSize.y / 2.0, 0.0);
                break;
            }
            case 2: {
                wallCenter3d = new Point3d(0.0, 0.0, cubeSize.z / 2.0);
            }
        }
        this.m_chart.transformPoint3d(wallCenter3d);
        return this.m_chart.projectPoint3d(wallCenter3d);
    }

    @Override
    public void calcAxisBody() {
    }

    @Override
    public void setTitleRect(Rectangle rTitleFrame) {
        this.m_rTitleFrame = rTitleFrame;
    }
}

