/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IAxisScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;

public class OrdinalScale
implements IAxisScale {
    public static final int SERIES_SIDE_BY_SIDE = 0;
    public static final int ONE_SERIES_PER_GROUP = 1;
    public static final int CENTERED_ON_GROUP = 2;
    public static final int TWO_SERIES_PER_GROUP = 3;
    public static final int CONNECTED_SERIES = 4;
    public static final int CONNECTED_GROUPS = 5;
    public static final int DATA_TOUCH_BORDER = 6;
    public static final int GROUP_3D = 7;
    public static final int SERIES_3D = 8;
    public static final int CIRCULAR = 9;
    public static final int TWO_SERIES_PER_GROUP_DUAL_STACKED_BAR_EXCEPTION = 11;
    public static final int TWO_SERIES_PER_GROUP_DUAL_STACKED_LINE_EXCEPTION = 12;
    private int m_nOrdinalAxisType;
    private double m_nSpaceBetGroups;
    private double m_nLeftPosFirstGroup;
    private double m_nSpaceBetSeries;
    private double m_nOffsetBetGroupPosAndFirstSeries;
    private double m_fRiserWidth;
    private final int[] m_nSeriesTypes;
    private final int m_nBaseRiserType;
    private boolean m_bIsComboChart;
    private final Perspective m_Perspective;
    private final int m_nNumSeries;
    private final int m_nNumGroups;
    private int m_nNumLabels;
    private final boolean m_bAscending;
    private final double m_fAxisLengthRel;
    private final double m_fAxisPositionRel;
    private final int m_nNumTotalGroups;
    private final AxisTemplate m_axisTemplate;
    private int m_nMultiBarAlignSeriesCount = 0;

    public OrdinalScale(Perspective perspective, int nOrdinalAxisType, int nNumSeries, int nNumGroups, double fAxisLengthRel, double fAxisPositionRel, boolean bAscending, int nNumTotalGroups, AxisTemplate axisTemplate) {
        this.m_Perspective = perspective;
        this.m_nNumSeries = nNumSeries;
        this.m_nNumGroups = nNumGroups;
        this.m_nNumTotalGroups = nNumTotalGroups;
        this.m_bAscending = bAscending;
        this.m_fAxisLengthRel = fAxisLengthRel;
        this.m_fAxisPositionRel = fAxisPositionRel;
        this.m_axisTemplate = axisTemplate;
        if (nOrdinalAxisType < 0 || nOrdinalAxisType > 12) {
            throw new RuntimeException("RelativeAxisObj Constructor: Invalid parameter passed for OrdinalAxisType");
        }
        this.m_nOrdinalAxisType = nOrdinalAxisType;
        this.m_nSeriesTypes = this.m_Perspective.getSeriesTypes();
        this.m_nBaseRiserType = this.m_Perspective.getBaseRiserType();
        this.initSeriesTypes();
    }

    public void calcOrdinalScale() {
        this.calcOrdinalScaleGroupSpacing();
        this.calcOrdinalScaleRiserSpacing();
    }

    private void calcOrdinalScaleRiserSpacing() {
        switch (this.m_nOrdinalAxisType) {
            case 0: {
                this.calcOrdinalScaleRiserSpacingSideBySide();
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / 100.0;
                this.m_nSpaceBetSeries = 0.0;
                this.m_nOffsetBetGroupPosAndFirstSeries = (this.m_nSpaceBetGroups - this.m_fRiserWidth) / 2.0;
                break;
            }
            case 11: {
                double fMaxRiserWidth = this.m_nSpaceBetGroups;
                double fRiserWidth = fMaxRiserWidth * (double)this.m_Perspective.getRiserWidth() / 100.0;
                double fMaxRiserGap = this.m_nSpaceBetGroups - fRiserWidth;
                double fRiserGap = fMaxRiserGap * (double)this.m_Perspective.getRiserBarGroupSpacing() / 100.0;
                this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / 100.0;
                this.m_nSpaceBetSeries = fRiserWidth + fRiserGap;
                this.m_nOffsetBetGroupPosAndFirstSeries = (this.m_nSpaceBetGroups - fRiserWidth - fRiserGap) / 2.0;
                break;
            }
            case 12: {
                this.m_fRiserWidth = 0.0;
                this.m_nSpaceBetSeries = 0.0;
                this.m_nOffsetBetGroupPosAndFirstSeries = 0.0;
                break;
            }
            case 3: {
                double fMaxRiserWidth = this.m_nSpaceBetGroups / 2.0;
                double fRiserWidth = fMaxRiserWidth * (double)this.m_Perspective.getRiserWidth() / 100.0;
                double fMaxRiserGap = this.m_nSpaceBetGroups - 2.0 * fRiserWidth;
                double fRiserGap = fMaxRiserGap * (double)this.m_Perspective.getRiserBarGroupSpacing() / 100.0;
                this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / 100.0 / 2.0;
                this.m_nSpaceBetSeries = fRiserWidth + fRiserGap;
                this.m_nOffsetBetGroupPosAndFirstSeries = (this.m_nSpaceBetGroups - 2.0 * fRiserWidth - fRiserGap) / 2.0;
                break;
            }
            case 4: 
            case 5: 
            case 9: {
                this.m_fRiserWidth = this.m_nSpaceBetGroups;
                this.m_nSpaceBetSeries = 0.0;
                this.m_nOffsetBetGroupPosAndFirstSeries = this.m_nSpaceBetGroups / 2.0;
                this.m_nLeftPosFirstGroup = 0.25;
            }
        }
    }

    private void calcOrdinalScaleRiserSpacingSideBySide() {
        int nComboAdjustedNumSeries = this.getComboAdjustedNumSeries();
        if (this.m_Perspective.getAlignMultiYBars() && this.m_nMultiBarAlignSeriesCount != 0) {
            nComboAdjustedNumSeries = this.m_nMultiBarAlignSeriesCount;
        }
        this.m_fRiserWidth = this.m_nSpaceBetGroups * (double)this.m_Perspective.getRiserWidth() / 100.0 / (double)nComboAdjustedNumSeries;
        double fMaxRiserWidth = this.m_nSpaceBetGroups / (double)nComboAdjustedNumSeries;
        double fRiserWidth = fMaxRiserWidth * (double)this.m_Perspective.getRiserWidth() / 100.0;
        double fMaxRiserGap = this.m_nNumSeries > 1 ? (nComboAdjustedNumSeries == 1 ? 0.2 : (this.m_nSpaceBetGroups - fRiserWidth) / (double)(nComboAdjustedNumSeries - 1) - fRiserWidth) : this.m_nSpaceBetGroups - fRiserWidth;
        double fRiserGap = fMaxRiserGap * (double)this.m_Perspective.getRiserBarGroupSpacing() / 100.0;
        if (this.m_Perspective.getRiserBarGroupSpacing() < 0) {
            fRiserGap = fRiserWidth * (double)this.m_Perspective.getRiserBarGroupSpacing() / 100.0;
        }
        this.m_nSpaceBetSeries = fRiserWidth + fRiserGap;
        this.m_nOffsetBetGroupPosAndFirstSeries = this.m_nNumSeries > 1 ? (this.m_nSeriesTypes == null ? (this.m_nSpaceBetGroups - (double)nComboAdjustedNumSeries * fRiserWidth - (double)(nComboAdjustedNumSeries - 1) * fRiserGap) / 2.0 : (this.m_nSpaceBetGroups - (double)nComboAdjustedNumSeries * fRiserWidth - (double)(nComboAdjustedNumSeries - 1) * fRiserGap) / 2.0) : (this.m_nSpaceBetGroups - fRiserWidth) / 2.0;
    }

    protected int getComboAdjustedNumSeries() {
        int nComboAdjustedNumSeries = this.m_nNumSeries;
        if (this.m_nNumSeries > 1 && this.m_nSeriesTypes != null) {
            int nNumNonBaseRiserTypes = 0;
            for (int nSeries = 0; nSeries < this.m_nNumSeries; ++nSeries) {
                if (this.m_nSeriesTypes[nSeries] == this.m_nBaseRiserType) continue;
                ++nNumNonBaseRiserTypes;
            }
            nComboAdjustedNumSeries = this.m_nNumSeries - nNumNonBaseRiserTypes;
        }
        return nComboAdjustedNumSeries;
    }

    private void calcOrdinalScaleGroupSpacing() {
        this.m_nLeftPosFirstGroup = 0.0;
        if (this.m_nOrdinalAxisType == 6) {
            if (this.m_nNumGroups > 1) {
                this.m_nSpaceBetGroups = this.m_fAxisLengthRel / (double)(this.m_nNumGroups - 1);
                this.m_nLeftPosFirstGroup = -this.m_nSpaceBetGroups / 2.0;
            } else {
                this.m_nSpaceBetGroups = 0.5;
                this.m_nLeftPosFirstGroup = 0.5;
            }
        } else {
            this.m_nSpaceBetGroups = this.useSeriesLabels() ? this.m_fAxisLengthRel / (double)this.m_nNumSeries : this.m_fAxisLengthRel / (double)this.m_nNumGroups;
        }
    }

    protected double adjustLowRelForComboCharts(int s, int g) {
        double fGroupBegin;
        double fLowRelCoord = fGroupBegin = (double)g * this.m_nSpaceBetGroups + this.m_nOffsetBetGroupPosAndFirstSeries;
        if (this.m_bIsComboChart && this.m_nSeriesTypes != null) {
            for (int nSeries = 0; nSeries < s; ++nSeries) {
                if (this.m_nSeriesTypes[nSeries] != this.m_nBaseRiserType) continue;
                fLowRelCoord += this.m_nSpaceBetSeries;
            }
        } else {
            fLowRelCoord = fGroupBegin + (double)s * this.m_nSpaceBetSeries;
        }
        return fLowRelCoord;
    }

    public void setMultiBarAlignOverrideSeriesCount(int nMultiBarAlignSeriesCount) {
        this.m_nMultiBarAlignSeriesCount = nMultiBarAlignSeriesCount;
    }

    public double getCenterRelCoord(int g) {
        double offset = this.m_nLeftPosFirstGroup + (double)g * this.m_nSpaceBetGroups + this.m_nSpaceBetGroups / 2.0;
        if (this.m_bAscending) {
            return this.m_fAxisPositionRel + offset;
        }
        return this.m_fAxisPositionRel + this.m_fAxisLengthRel - offset;
    }

    public double getCenterRelCoord(double g) {
        int nGroup = (int)g;
        double fResult = this.getCenterRelCoord(nGroup);
        return fResult;
    }

    public int getGroupAboveRelCoord(double fCoord) {
        int nGroup;
        if (this.m_bAscending) {
            double fGroup = (fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
            nGroup = (int)Math.ceil(fGroup - this.m_nSpaceBetGroups * 1.0E-4);
        } else {
            double fGroup = (1.0 - fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
            nGroup = (int)Math.floor(fGroup + this.m_nSpaceBetGroups * 1.0E-4);
        }
        if (nGroup < 0) {
            nGroup = 0;
        } else if (nGroup >= this.m_nNumTotalGroups) {
            nGroup = this.m_nNumTotalGroups - 1;
        }
        return nGroup;
    }

    public int getGroupBelowRelCoord(double fCoord) {
        int nGroup;
        if (this.m_bAscending) {
            double fGroup = (fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
            nGroup = (int)Math.floor(fGroup + this.m_nSpaceBetGroups * 1.0E-4);
        } else {
            double fGroup = (1.0 - fCoord - this.m_nLeftPosFirstGroup - this.m_nSpaceBetGroups / 2.0) / this.m_nSpaceBetGroups;
            nGroup = (int)Math.ceil(fGroup - this.m_nSpaceBetGroups * 1.0E-4);
        }
        if (nGroup < 0) {
            nGroup = 0;
        } else if (nGroup >= this.m_nNumTotalGroups) {
            nGroup = this.m_nNumTotalGroups - 1;
        }
        return nGroup;
    }

    public double getHighRelCoord(int s, int g) {
        return this.getLowRelCoord(s, g) + this.m_fRiserWidth;
    }

    public double getLowRelCoord(int s, int g) {
        double fLowRelCoord = 0.0;
        assert (this.m_nSeriesTypes != null);
        fLowRelCoord = this.m_nSeriesTypes[s] == this.m_nBaseRiserType ? this.getLowRelCoordBaseType(s, g) : this.getLowRelCoordNonBaseType(s, g);
        return fLowRelCoord;
    }

    private double getLowRelCoordNonBaseType(int s, int g) {
        double fLowRelCoord = 0.0;
        JGraphType graphType = this.m_Perspective.getJGraphType();
        switch (graphType.getIntegerGraphType()) {
            case 20: 
            case 27: {
                fLowRelCoord = this.getCenterRelCoord(g);
                break;
            }
            default: {
                fLowRelCoord = this.getCenterRelCoord(g) - this.m_fRiserWidth / 2.0;
            }
        }
        if (this.m_nOrdinalAxisType == 2) {
            fLowRelCoord -= this.m_fRiserWidth / 2.0;
        }
        if (this.m_bAscending) {
            fLowRelCoord = this.m_fAxisPositionRel + fLowRelCoord;
        }
        return fLowRelCoord;
    }

    private double getLowRelCoordBaseType(int s, int g) {
        double fLowRelCoord = 0.0;
        fLowRelCoord = this.adjustLowRelForComboCharts(s, g);
        if (this.m_nOrdinalAxisType == 2) {
            fLowRelCoord -= this.m_fRiserWidth / 2.0;
        }
        fLowRelCoord = this.m_bAscending ? this.m_fAxisPositionRel + fLowRelCoord : this.m_fAxisPositionRel + this.m_fAxisLengthRel - fLowRelCoord - this.m_fRiserWidth;
        return fLowRelCoord;
    }

    protected void initSeriesTypes() {
        this.m_bIsComboChart = false;
        for (int nSeries = 0; nSeries < this.m_Perspective.getNumTotalSeries(); ++nSeries) {
            if (this.m_nSeriesTypes[nSeries] == this.m_nBaseRiserType) continue;
            this.m_bIsComboChart = true;
        }
    }

    public boolean useSeriesLabels() {
        boolean bUseSeries = this.m_nOrdinalAxisType == 8 || this.m_nOrdinalAxisType == 4;
        return bUseSeries;
    }

    public double getMajorGridPos(int nIndex) {
        if (this.m_nOrdinalAxisType == 6 || this.m_nOrdinalAxisType == 9) {
            return this.getCenterRelCoord(nIndex);
        }
        double fPos = this.getCenterRelCoord(nIndex - 1);
        double fDelta = 0.0;
        fDelta = this.m_nOrdinalAxisType == 2 ? this.m_nSpaceBetGroups : this.m_nSpaceBetGroups / 2.0;
        fPos = this.m_bAscending ? (fPos += fDelta) : (fPos -= fDelta);
        return fPos;
    }

    public int getNumMajorGrids() {
        if (this.m_nOrdinalAxisType == 0) {
            return this.m_nNumLabels + 1;
        }
        return this.m_nNumLabels;
    }

    public double getMinorGridPos(int nMajorIndex, int nMinorIndex) {
        double minorStep = this.m_nSpaceBetGroups / (double)(this.getNumMinorGrids() + 1);
        double fPos = this.getMajorGridPos(nMajorIndex) + minorStep * (double)(nMinorIndex + 1);
        return fPos;
    }

    public int calcNumLabels() {
        this.m_nNumLabels = !this.useSeriesLabels() ? this.m_nNumGroups : this.m_nNumSeries;
        return this.m_nNumLabels;
    }

    public int getNumLabels() {
        return this.m_nNumLabels;
    }

    public int getNumMinorGrids() {
        int nNumMinorGrids = this.m_Perspective.getGridCount(this.m_axisTemplate.getMinor());
        return nNumMinorGrids;
    }
}

