/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

public class MinMaxObj {
    static final double DEFAULT_MIN = Double.MAX_VALUE;
    static final double DEFAULT_MAX = -1.7976931348623157E308;
    double m_rawMin;
    double m_rawMax;
    double m_adjMin;
    double m_adjMax;
    private boolean m_bDataDerived;

    MinMaxObj() {
        this(false, Double.MAX_VALUE, -1.7976931348623157E308);
    }

    MinMaxObj(double rawMin, double rawMax) {
        this(false, rawMin, rawMax);
    }

    MinMaxObj(boolean bMustIncludeZero) {
        this(bMustIncludeZero, Double.MAX_VALUE, -1.7976931348623157E308);
    }

    MinMaxObj(boolean bMustIncludeZero, double rawMin, double rawMax) {
        this.m_rawMin = rawMin;
        this.m_rawMax = rawMax;
        if (bMustIncludeZero) {
            this.m_adjMin = Math.min(0.0, rawMin);
            this.m_adjMax = Math.max(0.0, rawMax);
        } else {
            this.m_adjMin = rawMin;
            this.m_adjMax = rawMax;
        }
        this.m_bDataDerived = true;
    }

    public double getAdjMax() {
        return this.m_adjMax;
    }

    public double getAdjMin() {
        return this.m_adjMin;
    }

    public double getRawMax() {
        return this.m_rawMax;
    }

    public double getRawMin() {
        return this.m_rawMin;
    }

    public boolean isDataDerived() {
        return this.m_bDataDerived;
    }

    public boolean isValid() {
        return this.m_rawMin != Double.MAX_VALUE && this.m_rawMax != -1.7976931348623157E308;
    }

    void setDataDerived(boolean bNewValue) {
        this.m_bDataDerived = bNewValue;
    }

    public void testRawValue(double value) {
        if (value < this.m_rawMin) {
            this.m_rawMin = value;
        }
        if (value > this.m_rawMax) {
            this.m_rawMax = value;
        }
        if (value < this.m_adjMin) {
            this.m_adjMin = value;
        }
        if (value > this.m_adjMax) {
            this.m_adjMax = value;
        }
    }

    public void testRawValueMin(double value) {
        if (value < this.m_rawMin) {
            this.m_rawMin = value;
        }
        if (value < this.m_adjMin) {
            this.m_adjMin = value;
        }
    }

    public void testRawValueMax(double value) {
        if (value > this.m_rawMax) {
            this.m_rawMax = value;
        }
        if (value > this.m_adjMax) {
            this.m_adjMax = value;
        }
    }

    public String toString() {
        return "[raw: (" + this.m_rawMin + ", " + this.m_rawMax + ")  adj: (" + this.m_adjMin + ", " + this.m_adjMax + ")]";
    }
}

