/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisDescriptor;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataFormat;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataLabels;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataTextPosition;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Line;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.MarkerTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.MarkerTemplateArray;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DataItem;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.AnnotationBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetPolyLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Java2DLine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.SimpleBlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.AxisSplits;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.DepthMarker;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IDataProcessor;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JGraphType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MarkerObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Scaling;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.SumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.IOrdinalAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.ITimeScaleAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.ITrendlineEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.ITrendlineEngine2;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineProperties;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineSettings;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.trendline.TrendlineType;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JChart_2D_Standard
extends JChart_2D
implements IDataProcessor {
    static final int NO_DATALABEL_COLLISION = -1;
    static final int NO_PREVIOUS_SERIES = -2;
    static final int TWOD_MARKER_FIXUP = 3;
    static final double PGSDK_MARKER_SCALING_FACTOR = 1.6;
    static final int MAX_NUM_OF_AXES = 5;
    IOrdinalAxis m_O1Axis;
    INumericAxis m_X1Axis;
    INumericAxis m_Y1Axis;
    INumericAxis m_Y2Axis;
    INumericAxis m_Z1Axis;
    INumericAxis m_Y3Axis;
    INumericAxis m_Y4Axis;
    INumericAxis m_Y5Axis;
    int m_scaling;
    int m_barThickCoord;
    int[][] ordinalCoord;
    int[][] numericXCoord;
    int[][] numericYCoord;
    boolean[][] m_dataOK;
    String[][] m_DataLabelStackedTotal;
    boolean m_bHorz;
    boolean m_bExtendToFrameEdge;
    boolean m_bIsThisAComboWithBar;
    boolean m_bMarkerDisplay;
    boolean m_bAllMarkersSameSize;
    int m_nMarkerSizeDefault;
    double[][] m_fStackedCumulativeValues;
    double[][] m_fPercentCumulativeValues;
    boolean m_bIsComboWithNonBar;
    SeriesEnumerator m_sEnumReverseForPrev;
    private int m_BLAPercentValueFormat;
    int[][] m_ordCoordsAlignedIdx;
    boolean m_bAlignMultiYBars = false;
    int m_nRepositionDataTextCollision = 0;
    boolean m_DisplayTotal;
    boolean m_bBreakLines = false;

    protected JChart_2D_Standard(Perspective perspective) {
        super(perspective);
    }

    @Override
    public void calc() {
        super.calc();
        this.calcStandard();
    }

    @Override
    public void calcForceAbsolute() {
        super.calcForceAbsolute();
        this.calcStandard();
    }

    public void calcStandard() {
        this.m_DataLabels = new DataLabels(this.m_Perspective);
        this.m_bAlignMultiYBars = this.m_Perspective.getAlignMultiYBars();
        this.m_bIsThisAComboWithBar = this.isComboWithBar();
        this.m_bIsComboWithNonBar = this.isComboWithNonBar();
        this.createAxes(false);
        this.calcAxes();
        double fBorderWidth = this.m_Perspective.getLineWidth(Identity.Frame);
        JGraphType gt = this.m_Perspective.getJGraphType();
        if (this.getFrame() != null && this.m_Perspective.getFrameDisplay() && !gt.isRadarType() && !gt.isPolar() && !gt.isFunnelType()) {
            this.getFrame().drawFrameBorders(fBorderWidth);
        }
        this.drawAxisBody();
        this.m_bBreakLines = false;
        if ((this.m_bStacked || this.m_gt.isScalingPercent()) && this.m_Perspective.getBreakStackedLines()) {
            this.m_bBreakLines = true;
        } else if (this.m_bAbsolute && this.m_Perspective.getBreakAbsoluteLines()) {
            this.m_bBreakLines = true;
        }
        if (this.m_bAbsolute) {
            this.calcDataAbsolute();
        } else if (this.m_bStacked) {
            this.calcDataStacked();
        } else if (this.m_gt.isScalingPercent()) {
            this.calcDataPercent();
        }
    }

    protected boolean anySeriesIsForcedToAbsolute() {
        boolean bSeriesForcedAbsolute = false;
        int s = 0;
        do {
            bSeriesForcedAbsolute = this.m_Perspective.getForceSeriesAbsolute(s);
        } while (++s < this.getDataView().getNumTotalSeries() && !bSeriesForcedAbsolute);
        return bSeriesForcedAbsolute;
    }

    protected void calcTimeAxisOrdinalCoords() {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        GroupsEnumerator gEnum = this.m_gEnumForward;
        this.ordinalCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        INumericAxis axisObj = this.getX1Axis();
        this.m_barThickCoord = ((ITimeScaleAxis)((Object)axisObj)).getDataUnitWidth();
        for (int sRel = 0; sRel < this.m_nSeries; ++sRel) {
            int s = sEnum.get(sRel);
            assert (s >= 0 && s < this.m_nTotalSeries);
            for (int gRel = 0; gRel < this.m_nGroups; ++gRel) {
                int g = gEnum.get(gRel);
                assert (g >= 0 && g < this.m_nTotalGroups);
                double fValue = this.getDataView().getDataAsDouble(s, g, DataItem.DI_XY_X);
                this.ordinalCoord[s][g] = (int)axisObj.getValueCoord(fValue);
            }
        }
    }

    protected void calcNumericAxisOrdinalCoords() {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        GroupsEnumerator gEnum = this.m_gEnumForward;
        INumericAxis axisObj = this.getX1Axis();
        this.ordinalCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        double axisLength = axisObj.getMaxCoord() - axisObj.getMinCoord();
        this.m_barThickCoord = (int)(axisLength / 7.0 * ((double)this.m_Perspective.getRiserWidth() / 100.0));
        for (int sRel = 0; sRel < this.m_nSeries; ++sRel) {
            int s = sEnum.get(sRel);
            assert (s >= 0 && s < this.m_nTotalSeries);
            for (int gRel = 0; gRel < this.m_nGroups; ++gRel) {
                int g = gEnum.get(gRel);
                assert (g >= 0 && g < this.m_nTotalGroups);
                double fValue = this.getDataView().getDataAsDouble(s, g, DataItem.DI_XY_X);
                this.ordinalCoord[s][g] = this.m_Perspective.getJGraphType().isBar() ? (int)axisObj.getValueCoord(fValue) - this.m_barThickCoord / 2 : (int)axisObj.getValueCoord(fValue);
            }
        }
    }

    protected void calcBarOrdinalCoords() {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        GroupsEnumerator gEnum = this.m_gEnumForward;
        int nAxisOffset = 0;
        this.ordinalCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        for (int sRel = 0; sRel < this.m_nSeries; ++sRel) {
            int s = sEnum.get(sRel);
            assert (s >= 0 && s < this.m_nTotalSeries);
            int nAxis = this.getAxisAssignment(s);
            nAxisOffset = 0;
            if (this.m_gt.isDualY() && this.m_bStacked && nAxis == 1) {
                nAxisOffset = 1;
            }
            for (int gRel = 0; gRel < this.m_nGroups; ++gRel) {
                int g = gEnum.get(gRel);
                assert (g >= 0 && g < this.m_nTotalGroups);
                this.ordinalCoord[s][g] = this.m_bAbsolute ? (int)this.m_O1Axis.getLowCoord(sRel, gRel) : (this.m_nTotalSeries > 1 ? (int)this.m_O1Axis.getLowCoord(nAxisOffset, gRel) : (int)this.m_O1Axis.getLowCoord(sRel, gRel));
            }
        }
    }

    protected void calcDataAbsolute() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        INumericAxis axisObj = null;
        double fValue = 0.0;
        boolean bUseXAxis = axisDescriptor.hasX1();
        DataFormat df = this.getDataView().getDataFormat();
        int nItems = df.getNumDataItems();
        boolean bScatter = this.m_gt.isScatter();
        boolean bBubble = this.m_gt.isBubble();
        boolean bScatterLabels = this.m_gt.isScatterWithLabel();
        String sDataTextTemplate = "";
        String[] dataItemStringArray = new String[nItems];
        this.numericYCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bUseXAxis) {
            this.numericXCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        }
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        if (bBubble && !bScatterLabels) {
            sDataTextTemplate = this.m_Perspective.getDataTextTemplateBubble();
        } else if (bScatter && !bScatterLabels) {
            sDataTextTemplate = this.m_Perspective.getDataTextTemplateScatter();
        }
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasNext()) {
                DataItem item;
                int i;
                int g = gEnum.next();
                this.m_dataOK[s][g] = true;
                boolean bDataLabelDecided = false;
                if ((bScatter || bBubble) && !bScatterLabels && this.m_DataLabels.wantDataLabel(s, g)) {
                    for (i = 0; i < nItems; ++i) {
                        item = df.getDataItem(i);
                        axisObj = this.whichAxisForSeries(s, item);
                        fValue = this.getDataValue((int)s, (int)g, (DataItem)item).value;
                        dataItemStringArray[i] = axisObj.getDataTextFormat().format(fValue);
                    }
                    this.m_DataLabels.setDataText(this.processDataTextTemplate(dataItemStringArray, sDataTextTemplate), s, g);
                    bDataLabelDecided = true;
                }
                for (i = 0; i < nItems; ++i) {
                    item = df.getDataItem(i);
                    axisObj = this.whichAxisForSeries(s, item);
                    if (item.isLabel()) {
                        if (this.getDataView().isCellNumeric(s, g, item)) {
                            this.m_DataLabels.setDataText(axisObj.getDataTextFormat().format(this.getDataValue((int)s, (int)g, (DataItem)item).value), s, g);
                        } else {
                            this.m_DataLabels.setDataText(this.getDataView().getDataAsString(s, g, item), s, g);
                        }
                    } else if (axisObj != null) {
                        DatumObj dObj = this.getDataValue(s, g, item);
                        fValue = dObj.value;
                        if (!dObj.m_bOK) {
                            this.m_dataOK[s][g] = dObj.m_bOK;
                        }
                        if (fValue <= 0.0 && this.isBadValueInLogscale(axisObj, fValue)) {
                            this.m_dataOK[s][g] = false;
                            fValue = 0.0;
                        }
                        if (this.isIgnoredOffScale(axisObj, fValue)) {
                            this.m_dataOK[s][g] = false;
                            fValue = 0.0;
                        }
                    }
                    if (item.isLabel() || axisObj == null) continue;
                    if (item.getAssocAxis() == 0) {
                        this.numericYCoord[s][g] = (int)axisObj.getValueCoord(fValue);
                    } else if (item.getAssocAxis() == 7) {
                        this.numericXCoord[s][g] = (int)axisObj.getValueCoord(fValue);
                    }
                    if (!this.m_DataLabels.wantDataLabel(s, g) || bDataLabelDecided) continue;
                    this.m_DataLabels.setDataValue(fValue, s, g);
                    this.m_DataLabels.setDataText(axisObj.getDataTextFormat().format(fValue), s, g);
                }
            }
        }
    }

    protected void calcDataPercent() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        boolean bNotifyNegativeEvent = false;
        this.numericYCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fPercentCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        while (gEnum.hasNext()) {
            double fValue;
            int s;
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            double fPosTotal = 0.0;
            double fNegTotal = 0.0;
            sEnum.reset();
            while (sEnum.hasNext()) {
                s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                DatumObj dObj = this.getDataValue(s, g, this.getDataItem());
                fValue = dObj.value;
                this.m_dataOK[s][g] = dObj.m_bOK;
                if (fValue >= 0.0) {
                    fPosTotal += fValue;
                    continue;
                }
                fNegTotal += fValue;
                if (bNotifyNegativeEvent) continue;
                bNotifyNegativeEvent = true;
            }
            fNegTotal = -fNegTotal;
            double fTotTotal = fPosTotal + fNegTotal;
            double fPosRatio = fPosTotal / fTotTotal;
            double fNegRatio = fNegTotal / fTotTotal;
            double fPosSum = 0.0;
            double fNegSum = 0.0;
            sEnum.reset();
            while (sEnum.hasNext()) {
                double fDataValue;
                s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                INumericAxis yAxisObj = this.whichAxisForSeries(s, this.getDataItem());
                if (yAxisObj == null) continue;
                DatumObj data = this.getDataValue(s, g);
                fValue = data.value;
                if (fValue >= 0.0 && fPosTotal == 0.0) {
                    this.m_fPercentCumulativeValues[s][g] = 0.0;
                    this.numericYCoord[s][g] = (int)yAxisObj.getValueCoord(0.0);
                    if (!this.m_DataLabels.wantDataLabel(s, g) || !data.m_bOK) continue;
                    this.m_DataLabels.setDataValue(0.0, s, g);
                    this.m_DataLabels.setDataText(this.getDataString(0.0, s, g, yAxisObj), s, g);
                    continue;
                }
                if (fValue >= 0.0 && fPosTotal > 0.0) {
                    this.m_fPercentCumulativeValues[s][g] = fPosRatio * (fPosSum += fValue) / fPosTotal;
                    this.numericYCoord[s][g] = (int)yAxisObj.getValueCoord(fPosRatio * fPosSum / fPosTotal);
                    if (!this.m_DataLabels.wantDataLabel(s, g) || !data.m_bOK) continue;
                    double fDataTextValue = this.getActualValue(fPosRatio, fPosSum, fPosTotal, fTotTotal, fValue);
                    this.m_DataLabels.setDataValue(fDataTextValue, s, g);
                    this.m_DataLabels.setDataText(this.getDataString(fDataTextValue, s, g, yAxisObj), s, g);
                    continue;
                }
                if (!(fValue < 0.0)) continue;
                this.m_fPercentCumulativeValues[s][g] = fDataValue = fNegRatio * (fNegSum += fValue) / fNegTotal;
                this.numericYCoord[s][g] = (int)yAxisObj.getValueCoord(fDataValue);
                if (!this.m_DataLabels.wantDataLabel(s, g) || !data.m_bOK) continue;
                double fDataTextValue = this.getActualValue(fNegRatio, fNegSum, fNegTotal, fTotTotal, fValue);
                this.m_DataLabels.setDataValue(fDataTextValue, s, g);
                this.m_DataLabels.setDataText(this.getDataString(fDataTextValue, s, g, yAxisObj), s, g);
            }
        }
    }

    protected String getDataString(double actualValue, int s, int g, IAxis axisObj) {
        String template = this.m_Perspective.getDataTextTemplate(s, g);
        Format format = null;
        format = this.m_BLAPercentValueFormat != 0 ? NumberFormat.getPercentInstance() : axisObj.getDataTextFormat();
        String resultString = format.format(actualValue);
        resultString = TextUtil.ReplaceMacro(template, "[DATA]", resultString);
        resultString = TextUtil.ReplaceMacro(resultString, "[SERIES]", this.m_Perspective.getSeriesLabel(s));
        resultString = TextUtil.ReplaceMacro(resultString, "[CATEGORY]", this.m_Perspective.getGroupLabel(g));
        return resultString;
    }

    private double getActualValue(double ratio, double sum, double posNegTotal, double total, double value) {
        double actualValue = 0.0;
        if (this.m_Perspective.getStackedDataValueSum()) {
            if (this.m_BLAPercentValueFormat == 0) {
                actualValue = sum;
            } else if (this.m_BLAPercentValueFormat == 1) {
                actualValue = ratio * sum / posNegTotal;
            }
        } else if (this.m_BLAPercentValueFormat == 0) {
            actualValue = value;
        } else if (this.m_BLAPercentValueFormat == 1) {
            actualValue = value / total;
        }
        return actualValue;
    }

    public double getPercentCumulativeValue(int nSeries, int nGroup) {
        double fValue = 0.0;
        if (this.m_fPercentCumulativeValues != null) {
            fValue = this.m_fPercentCumulativeValues[nSeries][nGroup];
        }
        return fValue;
    }

    protected void calcDataStacked() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        this.numericYCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_dataOK = new boolean[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_fStackedCumulativeValues = new double[this.m_nTotalSeries][this.m_nTotalGroups];
        boolean bDisplayStackedValueOnTop = this.m_Perspective.getDisplay(Identity.DataTextStackedTotalOnTop);
        int nLastSeriesY1 = 0;
        int nLastSeriesY2 = 0;
        if (bDisplayStackedValueOnTop) {
            nLastSeriesY1 = this.getLastSeriesForThisAxis(0);
            nLastSeriesY2 = this.getLastSeriesForThisAxis(1);
            this.m_DataLabelStackedTotal = new String[2][this.m_nTotalGroups];
        }
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            SumObj sumObj = new SumObj();
            SumObj totalObj = this.getGroupTotals(g);
            sEnum.reset();
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                DataItem dataItem = this.getDataItem();
                INumericAxis yAxisObj = this.whichAxisForSeries(s, dataItem);
                if (yAxisObj == null) continue;
                DatumObj dObj = this.getDataValue(s, g, dataItem);
                double fValue = dObj.value;
                this.m_dataOK[s][g] = dObj.m_bOK;
                if (fValue <= 0.0 && this.isBadValueInLogscale(yAxisObj, fValue)) {
                    fValue = 0.0;
                    this.m_dataOK[s][g] = false;
                }
                if (this.m_Perspective.getForceSeriesAbsolute(s)) {
                    this.m_dataOK[s][g] = false;
                }
                this.processOneStackedValue(s, g, yAxisObj, fValue, sumObj);
                int nAxis = this.getAxisAssignment(s);
                boolean bY2 = nAxis == 1;
                boolean bPos = fValue >= 0.0;
                int nRiser = this.m_depth2D.getSeriesType(s);
                this.m_fStackedCumulativeValues[s][g] = sumObj.getSum(bPos, bY2, nRiser);
                boolean bDisplayTotalOnTop = this.m_Perspective.getDisplay(Identity.DataTextStackedTotalOnTop);
                if (bDisplayTotalOnTop) {
                    boolean bLastSeriesY2;
                    boolean bLastSeriesY1 = nAxis == 0 && s == nLastSeriesY1;
                    boolean bl = bLastSeriesY2 = nAxis == 1 && s == nLastSeriesY2;
                    if (bLastSeriesY1 || bLastSeriesY2) {
                        this.calcStackedTotalOnTop(yAxisObj, bPos, bY2, s, g, nRiser, totalObj);
                    }
                }
                if (!this.m_DataLabels.wantDataLabel(s, g) || !this.m_dataOK[s][g]) continue;
                this.calcDataLabelStacked(yAxisObj, bPos, bY2, s, g, nRiser, fValue, sumObj, totalObj);
            }
        }
    }

    private int getLastSeriesForThisAxis(int nAxis) {
        int nLastSeries = 0;
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            int nAxisAssignment = this.getAxisAssignment(s);
            if (nAxis != nAxisAssignment) continue;
            nLastSeries = s;
        }
        return nLastSeries;
    }

    protected DataItem getDataItem() {
        boolean bIsTimeScaleAxis = this.m_Perspective.getUseTimeScaleAxis();
        DataItem di = DataItem.DI_GENERAL;
        if (bIsTimeScaleAxis || this.m_Perspective.getUseNumericScaleAxis() || this.m_Perspective.getUsePGSDKTimeScaleAxis()) {
            di = DataItem.DI_XY_Y;
        }
        return di;
    }

    protected SumObj getGroupTotals(int g) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        SumObj totalObj = new SumObj();
        sEnum.reset();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            INumericAxis yAxisObj = this.whichAxisForSeries(s, this.getDataItem());
            if (yAxisObj == null) continue;
            DatumObj dObj = this.getDataValue(s, g, this.getDataItem());
            double fValue = dObj.value;
            this.m_dataOK[s][g] = dObj.m_bOK;
            if (fValue <= 0.0 && this.isBadValueInLogscale(yAxisObj, fValue)) {
                fValue = 0.0;
                this.m_dataOK[s][g] = false;
            }
            if (this.m_Perspective.getForceSeriesAbsolute(s)) {
                this.m_dataOK[s][g] = false;
            }
            this.processOneStackedValue(s, g, yAxisObj, fValue, totalObj);
        }
        return totalObj;
    }

    private void calcDataLabelStacked(IAxis yAxis, boolean bPos, boolean bY2, int s, int g, int nRiser, double fValue, SumObj sumObj, SumObj totalObj) {
        double fNewSum = sumObj.getSum(bPos, bY2, nRiser);
        if (this.m_Perspective.getStackedDataValueSum()) {
            if (this.m_BLAPercentValueFormat > 0) {
                double fTotal = totalObj.getSum(bPos, bY2, nRiser);
                fNewSum /= fTotal;
            }
        } else {
            fNewSum = fValue;
        }
        this.m_DataLabels.setDataValue(fNewSum, s, g);
        this.m_DataLabels.setDataText(this.getDataString(fNewSum, s, g, yAxis), s, g);
    }

    private void calcStackedTotalOnTop(IAxis yAxis, boolean bPos, boolean bY2, int s, int g, int nRiser, SumObj totalObj) {
        int nAxis = 0;
        if (bY2) {
            nAxis = 1;
        }
        double fNewSumTotal = totalObj.getSum(bPos, bY2, nRiser);
        this.m_DataLabelStackedTotal[nAxis][g] = yAxis.getDataTextFormat().format(fNewSumTotal);
    }

    public double getStackedCumulativeValue(int nSeries, int nGroup) {
        double fValue = 0.0;
        if (this.m_fStackedCumulativeValues != null) {
            fValue = this.m_fStackedCumulativeValues[nSeries][nGroup];
        }
        return fValue;
    }

    protected void calcOrdinalCoords() {
        assert (this.m_O1Axis != null);
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.m_gEnumForward;
        this.ordinalCoord = new int[this.m_nTotalSeries][this.m_nTotalGroups];
        this.m_barThickCoord = (int)(this.m_O1Axis.getHighCoord(0, 0) - this.m_O1Axis.getLowCoord(0, 0));
        for (int gRel = 0; gRel < this.m_nGroups; ++gRel) {
            int g = gEnum.get(gRel);
            assert (g >= 0 && g < this.m_nTotalGroups);
            int nOrdCoord = (int)this.m_O1Axis.getCenterCoord(gRel);
            sEnum.reset();
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                this.ordinalCoord[s][g] = nOrdCoord;
            }
        }
    }

    protected int calcRisersPerPixel() {
        if (this.m_gt.getIntegerGraphType() != 17 && this.m_gt.getIntegerGraphType() != 24) {
            return 1;
        }
        if (this.m_bIsComboWithNonBar || this.getFrame() == null) {
            return 1;
        }
        Rectangle rFrame = this.getFrame().getBackWallBounds();
        int nPixels = this.m_bHorz ? this.m_Perspective.getVC().virtToDestHeight(rFrame.height) : this.m_Perspective.getVC().virtToDestWidth(rFrame.width);
        int nRisersPerPixel = this.m_nSeries * this.m_nGroups / nPixels;
        if (nRisersPerPixel < 1) {
            nRisersPerPixel = 1;
        }
        return nRisersPerPixel;
    }

    @Override
    protected void copyParams() {
        super.copyParams();
        this.m_BLAPercentValueFormat = this.m_Perspective.getPercentValueFormat();
        this.m_bHorz = this.m_gt.isOrientHorz();
        this.m_sEnumReverseForPrev = SeriesEnumerator.getReverseIterator(this.m_Perspective, this.getDataView());
        this.m_bExtendToFrameEdge = this.m_Perspective.getExtendToFrameEdge();
        this.m_bMarkerDisplay = this.m_Perspective.getMarkerDisplay();
        this.m_nMarkerSizeDefault = this.m_Perspective.getMarkerSizeDefault();
        this.m_nRepositionDataTextCollision = this.m_Perspective.getRepositionDataTextCollision();
    }

    public int calcAllBarOrdinalAlignedIdx() {
        this.m_ordCoordsAlignedIdx = new int[5][this.m_nTotalSeries];
        int nMultiBarAlignSeriesCount = this.calcBarOrdinalAlignedIdx(0, 0);
        int nSeriesCount = this.calcBarOrdinalAlignedIdx(1, 1);
        if (nSeriesCount > nMultiBarAlignSeriesCount) {
            nMultiBarAlignSeriesCount = nSeriesCount;
        }
        if ((nSeriesCount = this.calcBarOrdinalAlignedIdx(2, 2)) > nMultiBarAlignSeriesCount) {
            nMultiBarAlignSeriesCount = nSeriesCount;
        }
        if ((nSeriesCount = this.calcBarOrdinalAlignedIdx(3, 3)) > nMultiBarAlignSeriesCount) {
            nMultiBarAlignSeriesCount = nSeriesCount;
        }
        if ((nSeriesCount = this.calcBarOrdinalAlignedIdx(4, 4)) > nMultiBarAlignSeriesCount) {
            nMultiBarAlignSeriesCount = nSeriesCount;
        }
        return nMultiBarAlignSeriesCount;
    }

    private int calcBarOrdinalAlignedIdx(int nAxisConstant, int nAxisTemplate) {
        SeriesEnumerator sEnum = this.m_sEnumForward;
        int nBarIdx = 0;
        int nBarCount = 0;
        for (int sRel = 0; sRel < this.m_nSeries; ++sRel) {
            int s = sEnum.get(sRel);
            assert (s >= 0 && s < this.m_nTotalSeries);
            int nAxis = this.getAxisAssignment(s);
            if (nAxis != nAxisTemplate) continue;
            if (this.m_depth2D.getSeriesType(s) == 1) {
                if (this.m_depth2D.getSeriesType(nBarIdx) != 1) {
                    nBarIdx = this.findNextBarSeries(nBarIdx);
                }
                this.m_ordCoordsAlignedIdx[nAxisConstant][s] = nBarIdx++;
                ++nBarCount;
                continue;
            }
            this.m_ordCoordsAlignedIdx[nAxisConstant][s] = s;
        }
        return nBarCount;
    }

    private int findNextBarSeries(int nSeriesCount) {
        do {
            assert (++nSeriesCount <= this.m_nTotalSeries);
        } while (this.m_depth2D.getSeriesType(nSeriesCount) != 1);
        return nSeriesCount;
    }

    protected void createAxes(boolean bCalc) {
        boolean bVerticalChart;
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        AxisSplits axisSplits = new AxisSplits(this.m_Perspective);
        axisSplits.calc();
        int[] offsetArray = axisSplits.getAxisOffsets();
        int[] sizeArray = axisSplits.getAxisSizes();
        axisSplits.releaseReferences();
        axisSplits = null;
        this.m_scaling = this.m_gt.getScalingMethod();
        int ordType = this.getOrdinalType();
        this.m_Perspective.setMinimumAxisTextSizeVC(16000);
        int nSaveMode = this.m_Perspective.getAxisTextAutofitMode();
        this.m_Perspective.setAxisTextAutofitMode(0);
        if (nSaveMode != 0) {
            this.m_Perspective.setTestLabelCalc(true);
        } else {
            this.m_Perspective.setTestLabelCalc(false);
        }
        boolean bl = bVerticalChart = this.m_gt.getOrientation() == 2;
        if (axisDescriptor.hasO1()) {
            this.m_O1Axis = this.createOrdinalAxis(ordType, !bVerticalChart, bVerticalChart);
            if (this.m_bAlignMultiYBars && this.m_gt.isMultiY()) {
                int nMultiBarAlignMaxSeriesCount = this.calcAllBarOrdinalAlignedIdx();
                this.m_O1Axis.setMultiBarAlignMaxSeriesCount(nMultiBarAlignMaxSeriesCount);
            }
            if (bCalc) {
                this.calcAxis(this.m_O1Axis);
            }
        } else if (axisDescriptor.hasX1()) {
            this.m_X1Axis = this.createX1Axis(!bVerticalChart, !this.m_Perspective.getX1AxisDescending());
            if (bCalc) {
                this.calcAxis(this.m_X1Axis);
            }
        }
        this.m_Y1Axis = this.createY1Axis(bVerticalChart, !this.m_Perspective.getY1AxisDescending(), offsetArray[0], sizeArray[0]);
        if (this.m_Y1Axis != null && bCalc) {
            this.calcAxis(this.m_Y1Axis);
        }
        if (axisDescriptor.hasY2()) {
            this.m_Y2Axis = this.createY2Axis(bVerticalChart, !this.m_Perspective.getY2AxisDescending(), offsetArray[1], sizeArray[1]);
            if (bCalc) {
                this.calcAxis(this.m_Y2Axis);
            }
        }
        if (axisDescriptor.hasZ1()) {
            this.m_Z1Axis = this.createZ1Axis(!bVerticalChart, true);
            if (bCalc) {
                this.calcAxis(this.m_Z1Axis);
            }
        }
        if (axisDescriptor.hasY3()) {
            this.m_Y3Axis = this.createY3Axis(bVerticalChart, !this.m_Perspective.getY3AxisDescending(), offsetArray[2], sizeArray[2]);
            if (bCalc) {
                this.calcAxis(this.m_Y3Axis);
            }
        }
        if (axisDescriptor.hasY4()) {
            this.m_Y4Axis = this.createY4Axis(bVerticalChart, !this.m_Perspective.getY4AxisDescending(), offsetArray[3], sizeArray[3]);
            if (bCalc) {
                this.calcAxis(this.m_Y4Axis);
            }
        }
        if (axisDescriptor.hasY5()) {
            this.m_Y5Axis = this.createY5Axis(bVerticalChart, !this.m_Perspective.getY5AxisDescending(), offsetArray[4], sizeArray[4]);
            if (bCalc) {
                this.calcAxis(this.m_Y5Axis);
            }
        }
        this.m_Perspective.setAxisTextAutofitMode(nSaveMode);
        this.m_Perspective.setTestLabelCalc(false);
        if (bCalc && this.m_Perspective.getAxisTextAutofitMode() != 0) {
            if (axisDescriptor.hasO1()) {
                if (this.m_O1Axis != null) {
                    this.m_O1Axis.calc();
                }
            } else if (axisDescriptor.hasX1() && this.m_X1Axis != null) {
                this.m_X1Axis.calc();
            }
            if (this.m_Y1Axis != null) {
                this.m_Y1Axis.calc();
            }
            if (axisDescriptor.hasY2() && this.m_Y2Axis != null) {
                this.m_Y2Axis.calc();
            }
            if (axisDescriptor.hasZ1() && this.m_Z1Axis != null) {
                this.m_Z1Axis.calc();
            }
        }
    }

    protected void calcAxes() {
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        this.m_Perspective.setMinimumAxisTextSizeVC(16000);
        int nSaveMode = this.m_Perspective.getAxisTextAutofitMode();
        this.m_Perspective.setAxisTextAutofitMode(0);
        if (nSaveMode != 0) {
            this.m_Perspective.setTestLabelCalc(true);
        } else {
            this.m_Perspective.setTestLabelCalc(false);
        }
        if (axisDescriptor.hasO1()) {
            if (this.m_bForceAbsoluteDrawNonStackedInProgress) {
                this.m_O1Axis.setDisplayOnCalc(false);
            }
            this.calcAxis(this.m_O1Axis);
        } else if (axisDescriptor.hasX1()) {
            if (this.m_bForceAbsoluteDrawNonStackedInProgress) {
                this.m_X1Axis.setDisplayOnCalc(false);
            }
            this.calcAxis(this.m_X1Axis);
        }
        if (this.m_bForceAbsoluteDrawNonStackedInProgress) {
            this.m_Y1Axis.setDisplayOnCalc(false);
        }
        this.calcAxis(this.m_Y1Axis);
        if (axisDescriptor.hasY2()) {
            if (this.m_bForceAbsoluteDrawNonStackedInProgress) {
                this.m_Y2Axis.setDisplayOnCalc(false);
            }
            this.calcAxis(this.m_Y2Axis);
        }
        if (axisDescriptor.hasZ1()) {
            if (this.m_bForceAbsoluteDrawNonStackedInProgress) {
                this.m_Z1Axis.setDisplayOnCalc(false);
            }
            this.calcAxis(this.m_Z1Axis);
        }
        if (axisDescriptor.hasY3()) {
            if (this.m_bForceAbsoluteDrawNonStackedInProgress) {
                this.m_Y3Axis.setDisplayOnCalc(false);
            }
            this.calcAxis(this.m_Y3Axis);
        }
        if (axisDescriptor.hasY4()) {
            if (this.m_bForceAbsoluteDrawNonStackedInProgress) {
                this.m_Y4Axis.setDisplayOnCalc(false);
            }
            this.calcAxis(this.m_Y4Axis);
        }
        if (axisDescriptor.hasY5()) {
            if (this.m_bForceAbsoluteDrawNonStackedInProgress) {
                this.m_Y5Axis.setDisplayOnCalc(false);
            }
            this.calcAxis(this.m_Y5Axis);
        }
        this.m_Perspective.setAxisTextAutofitMode(nSaveMode);
        this.m_Perspective.setTestLabelCalc(false);
        if (this.m_Perspective.getAxisTextAutofitMode() != 0) {
            if (axisDescriptor.hasO1()) {
                if (this.m_O1Axis != null) {
                    this.m_O1Axis.calc();
                }
            } else if (axisDescriptor.hasX1() && this.m_X1Axis != null) {
                this.m_X1Axis.calc();
            }
            if (this.m_Y1Axis != null) {
                this.m_Y1Axis.calc();
            }
            if (axisDescriptor.hasY2() && this.m_Y2Axis != null) {
                this.m_Y2Axis.calc();
            }
            if (axisDescriptor.hasZ1() && this.m_Z1Axis != null) {
                this.m_Z1Axis.calc();
            }
        }
    }

    protected void createAxes() {
        this.createAxes(true);
    }

    protected void calcAxis(IAxis axis) {
        if (axis != null) {
            axis.calc();
            if (axis.getAxisTextLabelSizeVC() < this.m_Perspective.getMinimumAxisTextSizeVC()) {
                this.m_Perspective.setMinimumAxisTextSizeVC(axis.getAxisTextLabelSizeVC());
            }
        }
    }

    protected IOrdinalAxis createOrdinalAxis(int ordType, boolean bVerticalAxis, boolean bAscending) {
        return AxisFactory.create2DOrdinalAxis(this.m_Perspective, this.getDataView(), AxisTemplate.O1_AXIS, ordType, bVerticalAxis, bAscending);
    }

    protected INumericAxis createX1Axis(boolean bVerticalAxis, boolean bAscending) {
        boolean bMustIncludeZero = this.m_Perspective.getX1MustIncludeZero() && !this.m_Perspective.getX1LogScale();
        MinMaxObj x1MinMaxObj = this.findLimits(7, 1, bMustIncludeZero, null);
        boolean bIsTimeScaleAxis = this.m_Perspective.getUseTimeScaleAxis();
        if (bIsTimeScaleAxis) {
            return AxisFactory.createTimeAxis(this.m_Perspective, this.getDataView(), AxisTemplate.X1_AXIS, x1MinMaxObj, bVerticalAxis, bAscending, 0, 100);
        }
        return AxisFactory.create2DNumericAxis(this.m_Perspective, this.getDataView(), AxisTemplate.X1_AXIS, x1MinMaxObj, bVerticalAxis, bAscending, 0, 100, true);
    }

    protected INumericAxis createY1Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        boolean bMustIncludeZero = this.m_Perspective.getY1MustIncludeZero() && !this.m_Perspective.getY1LogScale();
        MinMaxObj y1MinMaxObj = this.findLimits(0, this.m_scaling, bMustIncludeZero, null);
        return AxisFactory.create2DNumericAxis(this.m_Perspective, this.getDataView(), AxisTemplate.Y1_AXIS, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize, true);
    }

    protected INumericAxis createY2Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        boolean bMustIncludeZero = this.m_Perspective.getY2MustIncludeZero() && !this.m_Perspective.getY2LogScale();
        MinMaxObj y2MinMaxObj = this.findLimits(1, this.m_scaling, bMustIncludeZero, null);
        if (this.m_nDepthRadius > 0 && this.m_nDepthAngle > 90 && !bVerticalAxis) {
            bAscending = !bAscending;
        }
        return AxisFactory.create2DNumericAxis(this.m_Perspective, this.getDataView(), AxisTemplate.Y2_AXIS, y2MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize, true);
    }

    private final INumericAxis createZ1Axis(boolean bVerticalAxis, boolean bAscending) {
        boolean bZ1LogScale = false;
        boolean bZ1MustIncludeZero = false;
        boolean bDisplayOnCalc = false;
        boolean bMustIncludeZero = bZ1MustIncludeZero && !bZ1LogScale;
        MinMaxObj z1MinMaxObj = this.findLimits(8, this.m_scaling, bMustIncludeZero, null);
        return AxisFactory.create2DNumericAxis(this.m_Perspective, this.getDataView(), AxisTemplate.Z1_AXIS, z1MinMaxObj, bVerticalAxis, bAscending, 0, 100, bDisplayOnCalc);
    }

    private final INumericAxis createY3Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        AxisTemplate template = AxisTemplate.Y3_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        return AxisFactory.create2DNumericAxis(this.m_Perspective, this.getDataView(), template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize, true);
    }

    private final INumericAxis createY4Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        AxisTemplate template = AxisTemplate.Y4_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        return AxisFactory.create2DNumericAxis(this.m_Perspective, this.getDataView(), template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize, true);
    }

    private final INumericAxis createY5Axis(boolean bVerticalAxis, boolean bAscending, int nOffset, int nSize) {
        AxisTemplate template = AxisTemplate.Y5_AXIS;
        IdentObj id = template.getAxis();
        boolean bMustIncludeZero = this.m_Perspective.getScaleMustIncludeZero(id) && !this.m_Perspective.getLogScale(id);
        MinMaxObj y1MinMaxObj = this.findLimits(template.getAxisObjID(), this.m_scaling, bMustIncludeZero, null);
        return AxisFactory.create2DNumericAxis(this.m_Perspective, this.getDataView(), template, y1MinMaxObj, bVerticalAxis, bAscending, nOffset, nSize, true);
    }

    protected void drawAxisBody() {
        if (this.m_O1Axis != null) {
            this.m_O1Axis.calcAxisBody();
        }
        if (this.m_X1Axis != null) {
            this.m_X1Axis.calcAxisBody();
        }
        if (this.m_Y1Axis != null) {
            this.m_Y1Axis.calcAxisBody();
        }
        if (this.m_Y2Axis != null) {
            this.m_Y2Axis.calcAxisBody();
        }
        if (this.m_Y3Axis != null) {
            this.m_Y3Axis.calcAxisBody();
        }
        if (this.m_Y4Axis != null) {
            this.m_Y4Axis.calcAxisBody();
        }
        if (this.m_Y5Axis != null) {
            this.m_Y5Axis.calcAxisBody();
        }
    }

    protected void drawStackedDataValueTotalOnTop() {
        boolean bY1 = false;
        boolean bY2 = false;
        int nLastSeriesY1 = this.getLastSeriesForThisAxis(0);
        int nLastSeriesY2 = this.getLastSeriesForThisAxis(1);
        if (this.m_gt.isDualY()) {
            SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                int nAxisAssignment = this.getAxisAssignment(s);
                if (nAxisAssignment == 0) {
                    bY1 = true;
                }
                if (nAxisAssignment != 1) continue;
                bY2 = true;
            }
            if (bY1) {
                this.drawStackedDataValueTotalOnTop(0, nLastSeriesY1);
            }
            if (bY2) {
                this.drawStackedDataValueTotalOnTop(1, nLastSeriesY2);
            }
        } else {
            this.drawStackedDataValueTotalOnTop(0, nLastSeriesY1);
        }
    }

    protected void drawStackedDataValueTotalOnTop(int nAxis, int nLastSeriesForThisAxis) {
        IdentObj id = Identity.DataText;
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, id);
        Vector<String> vectStrLabels = new Vector<String>(this.m_nGroups);
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            if (this.m_DataLabelStackedTotal[nAxis][g] == null) {
                vectStrLabels.add("");
                continue;
            }
            vectStrLabels.add(this.m_DataLabelStackedTotal[nAxis][g]);
        }
        Dimension dimLabelDC = TextUtil.getDimLargestWidthLabelDC(this.m_Perspective.getVC(), vectStrLabels, textStyle);
        Dimension dimLabelVC = this.m_Perspective.getVC().destToVirt(dimLabelDC);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        gEnum.reset();
        while (gEnum.hasNext()) {
            Rectangle rLabel;
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            if (this.m_DataLabelStackedTotal[nAxis][g] == null || (rLabel = this.calcDataValuePosition(nLastSeriesForThisAxis, g, 1, 4, dimLabelVC)) == null) continue;
            DrawFactory.createLabel(this.m_Perspective.getDetectiv(), id, this.m_DataLabelStackedTotal[nAxis][g], rLabel, textStyle, blackBox, null);
        }
    }

    @Override
    protected Rectangle calcDataValuePosition(int s, int g, int nDataTextPosition, int nDataTextPositionSecondary, Dimension dimLabel) {
        Rectangle rDataTextPos = null;
        int nValueCoord = this.numericYCoord[s][g];
        INumericAxis yAxisObj = this.whichAxisForSeries(s, null);
        if (yAxisObj != null) {
            int nZeroCoord = (int)yAxisObj.getValueCoord(0.0);
            boolean bDescending = yAxisObj.isDescending();
            boolean bNegValue = bDescending ? nValueCoord > nZeroCoord : nValueCoord < nZeroCoord;
            int sPrev = this.prevSeriesForAxis(s, g, yAxisObj, bNegValue);
            int nPrevCoord = 0;
            boolean bPrevCoordValid = false;
            if (sPrev != -2) {
                bPrevCoordValid = true;
                nPrevCoord = this.numericYCoord[sPrev][g];
            }
            Point ptTwoHalfDOffset = this.getFrame().getDepthOffset(1.0);
            Point ptCenterTop = this.getCoords(s, g);
            Point ptFrontOffset = this.m_depth2D.getSeriesFrontOffset(s);
            double fDataValue = this.m_Perspective.getJGraphType().getIsNumericScaleAxis() ? this.getDataValue((int)s, (int)g, (DataItem)DataItem.DI_XY_Y).value : this.getDataValue((int)s, (int)g).value;
            int nBaseCoord = this.getBaseCoord(s);
            double fStackedCumVal = this.getStackedCumulativeValue(s, g);
            double fPercentCumVal = this.getPercentCumulativeValue(s, g);
            double fAngle = this.m_Perspective.getDataTextAngle(s, g);
            double fDist = this.m_Perspective.getDataTextRadius(s, g);
            boolean bIsDateScale = yAxisObj.isDateScale();
            DataTextPosition dataTextPos = new DataTextPosition(nDataTextPosition, nDataTextPositionSecondary, this.m_Perspective.getJGraphType(), ptTwoHalfDOffset, nBaseCoord, ptCenterTop, 0, dimLabel, ptFrontOffset, fDataValue, fStackedCumVal, fPercentCumVal, this.m_bHorz, this.isAxisAscending(s), fAngle, fDist, this.m_bIsComboWithNonBar, nPrevCoord, bPrevCoordValid, bIsDateScale);
            rDataTextPos = dataTextPos.calcPosition();
        }
        return rDataTextPos;
    }

    private void drawEquationText(int seriesId, TrendlineType type, ITrendlineEngine engine) {
        IdentObj equationID = TrendlineSettings.getEquationText(seriesId, type);
        Format format = this.m_Perspective.getTrendlineSettings().getEquationFormat();
        String text = "";
        if (this.m_Perspective.getTrendlineSettings().getDisplayEquation(seriesId)) {
            text = engine.getEquationText(format);
        }
        if (this.m_Perspective.getTrendlineSettings().getDisplayCorrelation(seriesId)) {
            if (text.length() > 0) {
                text = text + " ";
            }
            text = text + engine.getCorrelationText(format);
        }
        if (text.length() == 0) {
            return;
        }
        ITextStyle textStyle = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, equationID);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, equationID);
        Rectangle rect = this.m_Perspective.getRect(equationID);
        VC vc = this.m_Perspective.getVC();
        Dimension rectDC = vc.virtToDest(rect.getSize());
        Dimension textSizeDC = textStyle.getTextSizeDC(text, textStyle.getFontSizeDC(vc), rectDC, new Dimension(0, 0), true);
        rect.setSize(vc.destToVirt(textSizeDC));
        IdentObj idBox = TrendlineSettings.getEquationTextBox(seriesId);
        AnnotationBox.calcBorderedBox(this.m_Perspective, idBox, rect, null, null);
        DrawFactory.createLabel(this.m_Perspective.getDetectiv(), equationID, text, rect, textStyle, blackBox, null);
    }

    protected void drawTrendlines() {
        TrendlineSettings settings = this.m_Perspective.getTrendlineSettings();
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            TrendlineProperties seriesOptions = settings.getSeriesOptions(s);
            for (TrendlineType type : TrendlineType.values()) {
                TrendlineType settingType = settings.getTrendlineType(s, type);
                if (settingType == TrendlineType.FIT_NONE) continue;
                this.drawTrendline(s, settingType, seriesOptions);
            }
        }
    }

    protected void drawUserLines() {
        if (!this.m_Perspective.getPDECalc()) {
            AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
            if (axisDescriptor.hasO1() && this.m_O1Axis != null) {
                this.m_O1Axis.calcUserLines();
            }
            if (axisDescriptor.hasX1() && this.m_X1Axis != null) {
                this.m_X1Axis.calcUserLines();
            }
            if (axisDescriptor.hasY1() && this.m_Y1Axis != null) {
                this.m_Y1Axis.calcUserLines();
            }
            if (axisDescriptor.hasY2() && this.m_Y2Axis != null) {
                this.m_Y2Axis.calcUserLines();
            }
            if (axisDescriptor.hasZ1() && this.m_Z1Axis != null) {
                this.m_Z1Axis.calcUserLines();
            }
        }
    }

    private void drawTrendline(int s, TrendlineType type, TrendlineProperties seriesOptions) {
        ITrendlineEngine engine = TrendlineEngineFactory.getTrendlineEngine(type, seriesOptions);
        if (engine == null) {
            return;
        }
        IdentObj id = TrendlineSettings.getLineRiser(s, type);
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, id);
        engine.setSmoothingFactor(seriesOptions.smoothFactor);
        ArrayList<Point2D> data = new ArrayList<Point2D>();
        for (int g = 0; g < this.m_nTotalGroups; ++g) {
            Point2D point = this.getDataValuesXY(s, g);
            data.add(point);
        }
        engine.processDataValues(data);
        List<Point> vcPts = engine.generateCurve(s, this);
        if (vcPts.size() > 1) {
            if (this.m_bHorz) {
                this.flipPoints(vcPts);
            }
            new DetPolyLine(this.getDrawContainer(), id, (IBlackBox)blackBox, vcPts);
            this.drawEquationText(s, type, engine);
        }
        if (engine instanceof ITrendlineEngine2) {
            vcPts = ((ITrendlineEngine2)engine).generateExtraCurve();
            if (this.m_bHorz) {
                this.flipPoints(vcPts);
            }
            if (vcPts.size() > 1) {
                new DetPolyLine(this.getDrawContainer(), id, (IBlackBox)blackBox, vcPts);
            }
        }
    }

    private void flipPoints(List<Point> vcPts) {
        for (Point point : vcPts) {
            int temp = point.y;
            point.y = point.x;
            point.x = temp;
        }
    }

    protected void drawLines(boolean bCircular) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        int g = 0;
        double fWidth = 0.0;
        boolean bCloseCircularLines = false;
        while (sEnum.hasNext()) {
            IBlackBox blackBox;
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            if (this.m_depth2D.getSeriesType(s) != 2 || !this.m_Perspective.getConnectLineMarkers(s)) continue;
            IdentObj idSeries = new IdentObj(-3, s);
            gEnum.reset();
            if (gEnum.hasNext()) {
                bCloseCircularLines = true;
            }
            int firstG = -1;
            while (gEnum.hasNext()) {
                int nNumSegments;
                g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                if (!gEnum.hasNext()) continue;
                int gNext = gEnum.peekNext();
                assert (gNext >= 0 && gNext < this.m_nTotalGroups);
                if (this.m_bAbsolute && !this.m_bBreakLines && this.m_dataOK[s][g]) {
                    while (gEnum.hasNext() && !this.m_dataOK[s][gNext]) {
                        gEnum.next();
                        gNext = gEnum.peekNext();
                    }
                    if (!gEnum.hasNext()) continue;
                }
                if (this.m_bBreakLines && (!this.m_dataOK[s][g] || !this.m_dataOK[s][gNext]) || this.m_bAbsolute && !this.m_bBreakLines && !this.m_dataOK[s][g]) continue;
                if (firstG == -1) {
                    firstG = g;
                }
                if ((blackBox = this.assignSeriesColor(s)).getFillColor() != null) {
                    blackBox.setBorderColor(blackBox.getFillColor());
                }
                Point pt1 = this.getCoords(s, g);
                Point pt2 = this.getCoords(s, gNext);
                pt1 = this.adjustToFrontForTwoHalfD(pt1, s);
                pt2 = this.adjustToFrontForTwoHalfD(pt2, s);
                fWidth = this.m_Perspective.getLineWidth(idSeries);
                boolean bDrawNormal = true;
                if (this.m_nFillMissingData != 0) {
                    boolean bFilledMissingData = this.getDataView().getDataStorage().isMissingDataFilledIn(s, g) || this.getDataView().getDataStorage().isMissingDataFilledIn(s, gNext);
                    int nNumSegments2 = this.m_Perspective.getNumMissingDataSegments();
                    if (bFilledMissingData && nNumSegments2 != 0) {
                        this.drawMissingLineData(nNumSegments2, pt1, pt2, s, g, blackBox, fWidth);
                        bDrawNormal = false;
                    }
                }
                if (this.m_Perspective.getForecast(s, g) && (nNumSegments = this.m_Perspective.getNumMissingDataSegments()) != 0) {
                    this.drawMissingLineData(nNumSegments, pt1, pt2, s, g, blackBox, fWidth);
                    bDrawNormal = false;
                }
                IdentObj idLineRiser = new IdentObj(502, s, g);
                if (!bDrawNormal || blackBox.getTransparentFillColor()) continue;
                Java2DLine line2D = new Java2DLine(this.m_Perspective);
                line2D.createLine(idLineRiser, idLineRiser, pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, fWidth);
            }
            if (!bCircular || !bCloseCircularLines || firstG == -1) continue;
            Point pt1 = this.getCoords(s, g);
            Point pt2 = this.getCoords(s, firstG);
            pt1 = this.adjustToFrontForTwoHalfD(pt1, s);
            pt2 = this.adjustToFrontForTwoHalfD(pt2, s);
            blackBox = this.assignSeriesColor(s, g);
            if (blackBox.getFillColor() != null) {
                blackBox.setBorderColor(blackBox.getFillColor());
            }
            fWidth = this.m_Perspective.getLineWidth(idSeries);
            if (blackBox.getTransparentFillColor()) continue;
            Java2DLine line2D = new Java2DLine(this.m_Perspective);
            IdentObj idLineRiser = new IdentObj(502, s, g);
            line2D.createLine(idLineRiser, idLineRiser, pt1.x, pt1.y, pt2.x, pt2.y, blackBox, null, fWidth);
        }
    }

    public void drawConnectedStepLine(IdentObj idLineRiser, IBlackBox blackBox, double fLineWidth, Point pt1, Point pt2) {
        int nBarWidth = pt2.x - pt1.x;
        int nStepWidth = nBarWidth / 2;
        Java2DLine line2D = new Java2DLine(this.m_Perspective);
        line2D.createLine(idLineRiser, idLineRiser, pt1.x, pt1.y, pt1.x + nStepWidth, pt1.y, blackBox, null, fLineWidth);
        line2D.createLine(idLineRiser, idLineRiser, pt1.x + nStepWidth, pt1.y, pt2.x - nStepWidth, pt2.y, blackBox, null, fLineWidth);
        line2D.createLine(idLineRiser, idLineRiser, pt1.x + nStepWidth, pt2.y, pt2.x, pt2.y, blackBox, null, fLineWidth);
    }

    protected Point adjustToFrontForTwoHalfD(Point ptIn, int nSeries) {
        int nXDepth = 0;
        int nYDepth = 0;
        if (this.m_nDepthRadius > 0 && this.m_depth2D.getDepthPlanes() > 0) {
            Point ptFrontOffset = this.m_depth2D.getSeriesFrontOffset(nSeries);
            nXDepth = ptFrontOffset.x;
            nYDepth = ptFrontOffset.y;
        }
        Point ptOut = new Point(ptIn.x - nXDepth, ptIn.y - nYDepth);
        return ptOut;
    }

    private void drawMissingLineData(int nNumMissingSegments, Point ptIn1, Point ptIn2, int nSeries, int nGroup, IBlackBox blackBox, double fLineWidth) {
        Line theLine = new Line(ptIn1, ptIn2);
        int nDenominator = nNumMissingSegments * 2 + 1;
        for (int nIdx = 1; nIdx < nDenominator; ++nIdx) {
            Point2D ptOne = theLine.fractionalPoint(nIdx, nDenominator);
            Point2D ptTwo = theLine.fractionalPoint(nIdx + 1, nDenominator);
            IdentObj idObj = new IdentObj(502, nSeries, nGroup);
            Java2DLine line2D = new Java2DLine(this.m_Perspective);
            line2D.createLine(idObj, idObj, (int)ptOne.getX(), (int)ptOne.getY(), (int)ptTwo.getX(), (int)ptTwo.getY(), blackBox, null, fLineWidth);
            ++nIdx;
        }
    }

    public boolean hasMarkers() {
        return this.m_bMarkerDisplay || this.m_gt.isPolar() || this.m_gt.isScatter() || this.m_gt.isBubble();
    }

    protected void drawMarkers() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        if (this.hasMarkers()) {
            while (sEnum.hasNext()) {
                int nSeriesType;
                int s = sEnum.next();
                assert (s >= 0 && s < this.m_nTotalSeries);
                if (!this.m_Perspective.getMarkerDisplay(s) || (nSeriesType = this.m_depth2D.getSeriesType(s)) != 2 && nSeriesType != 3) continue;
                MarkerTemplate markerTemplate = this.getMarkerTemplate(s);
                gEnum.reset();
                while (gEnum.hasNext()) {
                    int g = gEnum.next();
                    assert (g >= 0 && g < this.m_nTotalGroups);
                    if (!this.m_dataOK[s][g]) continue;
                    Point center = this.getCoords(s, g);
                    center = this.adjustToFrontForTwoHalfD(center, s);
                    IdentObj lineMarker = this.m_Perspective.getLineMarker(s, g);
                    IBlackBox blackBox = this.assignSeriesColor(s, g);
                    blackBox.setBorderProperties(lineMarker);
                    new MarkerObj(this.getDrawContainer(), lineMarker, markerTemplate, center, this.getBaseMarkerSize(s, g), blackBox, null, false, false, true);
                }
            }
        }
    }

    protected MarkerTemplate getMarkerTemplate(int s) {
        int nMarkerSeriesID = s % this.m_nSeriesLooping;
        IdentObj idMarkerSeries = new IdentObj(-3, nMarkerSeriesID);
        MarkerTemplate markerTemplate = this.getMarkerShape(idMarkerSeries);
        if (this.m_gt.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
            markerTemplate = MarkerTemplateArray.PRESET_CIRCLE;
        }
        return markerTemplate;
    }

    protected void drawTransparentMarkers(int nSeriesType) {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        Dimension dimMarker = this.getTransparentMarkerDimension();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            if (this.m_depth2D.getSeriesType(s) != nSeriesType) continue;
            gEnum.reset();
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g]) continue;
                IdentObj identObjLineMarker = new IdentObj(503, s, g);
                SimpleBlackBoxObj blackBoxTransparent = new SimpleBlackBoxObj(this.m_Perspective, identObjLineMarker, false);
                blackBoxTransparent.setTransparentFillColor(true);
                Point ptCenter = this.getCoords(s, g);
                new MarkerObj(this.getDrawContainer(), identObjLineMarker, markerTemplate, ptCenter, dimMarker, blackBoxTransparent, null, true, false, true);
            }
        }
    }

    private Dimension getTransparentMarkerDimension() {
        double destY;
        int nMarkerHeight;
        int nMarkerSize = this.m_Perspective.getTransparentMarkerSize();
        int nMarkerWidth = nMarkerSize == 0 ? (nMarkerHeight = this.m_Perspective.getMarkerSizeDefault()) : (nMarkerHeight = nMarkerSize);
        double destX = this.m_Perspective.getVC().virtToDestWidth((double)nMarkerWidth);
        if (destX > (destY = this.m_Perspective.getVC().virtToDestHeight((double)nMarkerHeight))) {
            nMarkerWidth = (int)((double)nMarkerWidth * destY / destX);
        } else {
            nMarkerHeight = (int)((double)nMarkerHeight * destX / destY);
        }
        Dimension dimMarker = new Dimension(nMarkerWidth, nMarkerHeight);
        return dimMarker;
    }

    protected void drawAllMarkersWithDepth() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        if (!(this.m_bMarkerDisplay || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
            return;
        }
        if (this.m_nDepthRadius <= 0) {
            throw new RuntimeException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.getFrame() == null) {
            throw new RuntimeException("Can't draw 2.5D markers without m_Frame");
        }
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            if (!this.m_Perspective.getMarkerDisplay(s)) continue;
            this.drawMarkersWithDepth(s);
        }
    }

    protected void drawMarkersWithDepth(int s) {
        int nYDepth;
        int nXDepth;
        Point ptBackOffset;
        Point ptFrontOffset;
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        Point ptFront = new Point();
        if (!(this.m_bMarkerDisplay || this.m_gt.isPolar() || this.m_gt.isRadarType() || this.m_gt.isScatter() || this.m_gt.isBubble())) {
            return;
        }
        if (this.m_nDepthRadius <= 0) {
            throw new RuntimeException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.getFrame() == null) {
            throw new RuntimeException("Can't draw 2.5D markers without m_Frame");
        }
        assert (s >= 0 && s < this.m_nTotalSeries);
        int nSeriesType = this.m_depth2D.getSeriesType(s);
        if (nSeriesType != 2 && nSeriesType != 3) {
            return;
        }
        int nMarkerSeriesID = s % this.m_nSeriesLooping;
        IdentObj idMarkerSeries = this.m_Perspective.getSeries(nMarkerSeriesID);
        MarkerTemplate markerTemplate = this.getMarkerShape(idMarkerSeries);
        if (markerTemplate.getMarkerType() == 2) {
            markerTemplate = MarkerTemplateArray.PRESET_DEPTHCIRCLE;
        }
        if (this.m_gt.isBubble() && !this.m_Perspective.getUseDefaultBubbleMarker()) {
            markerTemplate = MarkerTemplateArray.PRESET_DEPTHCIRCLE;
        }
        if (this.m_nDepthRadius > 0 && this.m_depth2D.getDepthPlanes() > 0) {
            ptFrontOffset = this.m_depth2D.getSeriesFrontOffset(s);
            ptBackOffset = new Point();
            if (this.m_Perspective.getMarkerDepth()) {
                ptBackOffset = this.m_depth2D.getSeriesBackOffset(s);
                nXDepth = ptFrontOffset.x - ptBackOffset.x;
                nYDepth = ptFrontOffset.y - ptBackOffset.y;
                nXDepth = 3 * nXDepth;
                nYDepth = 3 * nYDepth;
            } else {
                nXDepth = 0;
                nYDepth = 0;
            }
        } else {
            ptFrontOffset = new Point();
            ptBackOffset = new Point();
            nXDepth = 0;
            nYDepth = 0;
        }
        List<Polygon> vectMarker = DepthMarker.createDepthMarker(markerTemplate, nXDepth, nYDepth, this.m_nDepthAngle);
        gEnum.reset();
        while (gEnum.hasNext()) {
            int g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            if (!this.m_dataOK[s][g]) continue;
            Point ptCenter = this.getCoords(s, g);
            ptFront.x = ptCenter.x - ptFrontOffset.x;
            ptFront.y = ptCenter.y - ptFrontOffset.y;
            IBlackBox blackBox = this.assignSeriesColor(s, g);
            if (vectMarker == null) continue;
            for (int nPoly = 0; nPoly < vectMarker.size(); ++nPoly) {
                IdentObj identObjLineMarker = new IdentObj(503, s, g);
                identObjLineMarker = identObjLineMarker.changeMisc(nPoly);
                Polygon polyMarker = vectMarker.get(nPoly);
                MarkerTemplate newMarkerTemplate = new MarkerTemplate(polyMarker);
                new MarkerObj(this.getDrawContainer(), identObjLineMarker, newMarkerTemplate, ptFront, this.getBaseMarkerSize(s, g), blackBox, null, false, false, true);
            }
        }
    }

    protected Dimension getBaseMarkerSize(int s, int g) {
        double destY;
        int markerSizeY;
        int markerSizeX = markerSizeY = this.getMarkerSize(s, g);
        double destX = this.m_Perspective.getVC().virtToDestWidth((double)markerSizeX);
        if (destX > (destY = this.m_Perspective.getVC().virtToDestHeight((double)markerSizeY))) {
            markerSizeX = (int)((double)markerSizeX * destY / destX);
        } else {
            markerSizeY = (int)((double)markerSizeY * destX / destY);
        }
        return new Dimension(markerSizeX, markerSizeY);
    }

    protected void drawTransparentMarkersWithDepth(int s, int nSeriesType) {
        if (!this.m_Perspective.getMarkerDisplay(s)) {
            return;
        }
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        Point ptFront = new Point();
        if (this.m_nDepthRadius <= 0) {
            throw new RuntimeException("Can't draw 2.5D markers without positive DepthRadius");
        }
        if (this.getFrame() == null) {
            throw new RuntimeException("Can't draw 2.5D markers without m_Frame");
        }
        assert (s >= 0 && s < this.m_nTotalSeries);
        MarkerTemplate markerTemplate = MarkerTemplateArray.PRESET_SQUARE;
        Dimension dimMarker = this.getTransparentMarkerDimension();
        if (this.m_depth2D.getSeriesType(s) == nSeriesType) {
            int nYDepth;
            int nXDepth;
            Point ptBackOffset;
            Point ptFrontOffset;
            if (this.m_nDepthRadius > 0 && this.m_depth2D.getDepthPlanes() > 0) {
                ptFrontOffset = this.m_depth2D.getSeriesFrontOffset(s);
                ptBackOffset = this.m_depth2D.getSeriesBackOffset(s);
                nXDepth = ptFrontOffset.x - ptBackOffset.x;
                nYDepth = ptFrontOffset.y - ptBackOffset.y;
                nXDepth = 3 * nXDepth;
                nYDepth = 3 * nYDepth;
            } else {
                ptFrontOffset = new Point();
                ptBackOffset = new Point();
                nXDepth = 0;
                nYDepth = 0;
            }
            nYDepth = 0;
            nXDepth = 0;
            List<Polygon> vectMarker = DepthMarker.createDepthMarker(markerTemplate, nXDepth, nYDepth, this.m_nDepthAngle);
            gEnum.reset();
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                if (!this.m_dataOK[s][g]) continue;
                Point ptCenter = this.getCoords(s, g);
                ptFront.x = ptCenter.x - ptFrontOffset.x;
                ptFront.y = ptCenter.y - ptFrontOffset.y;
                if (vectMarker == null) continue;
                for (int nPoly = 0; nPoly < vectMarker.size(); ++nPoly) {
                    IdentObj identObjLineMarker = new IdentObj(503, s, g);
                    identObjLineMarker = identObjLineMarker.changeMisc(nPoly);
                    SimpleBlackBoxObj blackBoxTransparent = new SimpleBlackBoxObj(this.m_Perspective, identObjLineMarker, false);
                    blackBoxTransparent.setTransparentFillColor(true);
                    Polygon polyMarker = vectMarker.get(nPoly);
                    MarkerTemplate newMarkerTemplate = new MarkerTemplate(polyMarker);
                    new MarkerObj(this.getDrawContainer(), identObjLineMarker, newMarkerTemplate, ptFront, dimMarker, blackBoxTransparent, null, true, false, true);
                }
            }
        }
    }

    protected MinMaxObj findLimits(int nAxis, int nScaling, boolean bMustIncludeZero, MinMaxObj mmZoom) {
        MinMaxObj minMaxObj = this.findPreScaledLimits(nAxis, nScaling, bMustIncludeZero);
        if (minMaxObj == null) {
            DataFormat dataFormat = this.getDataView().getDataFormat();
            if (nScaling == 2 && this.anySeriesIsForcedToAbsolute()) {
                Scaling scaleStacked = new Scaling(this.m_Perspective, this.m_nTotalSeries, this.m_nTotalGroups, this.m_axisAssignments, this.m_depth2D, this);
                MinMaxObj minMaxObjStacked = scaleStacked.findLimits(nAxis, nScaling, bMustIncludeZero, mmZoom, dataFormat);
                Scaling scaleForcedAbsolute = new Scaling(this.m_Perspective, this.m_nTotalSeries, this.m_nTotalGroups, this.m_axisAssignments, this.m_depth2D, this);
                MinMaxObj minMaxObjAbsoluteForced = scaleForcedAbsolute.findLimits(nAxis, 6, bMustIncludeZero, mmZoom, dataFormat);
                minMaxObjStacked.testRawValueMin(minMaxObjAbsoluteForced.getAdjMin());
                minMaxObjStacked.testRawValueMax(minMaxObjAbsoluteForced.getAdjMax());
                minMaxObj = minMaxObjStacked;
            } else {
                Scaling scaleNew = new Scaling(this.m_Perspective, this.m_nTotalSeries, this.m_nTotalGroups, this.m_axisAssignments, this.m_depth2D, this);
                minMaxObj = scaleNew.findLimits(nAxis, nScaling, bMustIncludeZero, mmZoom, dataFormat);
            }
        }
        return minMaxObj;
    }

    public int getBaseCoord(int s) {
        boolean isFromZero;
        INumericAxis yAxisObj = this.whichAxisForSeries(s, null);
        boolean bl = isFromZero = this.m_Perspective.getScaleFromZero() || yAxisObj.hasNegData() && !this.m_bAbsolute;
        if (isFromZero) {
            return (int)yAxisObj.getValueCoord(0.0);
        }
        return (int)yAxisObj.getBaseCoord();
    }

    public int getDataCoord(int s, int g) {
        return this.getDataCoord(s, g, this.getDataItem(), false);
    }

    public int getDataCoord(int s, int g, DataItem item, boolean bCumulative) {
        INumericAxis axisObj = this.whichAxisForSeries(s, item);
        double val = this.getDataValue((int)s, (int)g, (DataItem)item).value;
        if (bCumulative) {
            return this.getDataCoordCum(s, g, item);
        }
        return (int)axisObj.getValueCoord(val);
    }

    public int getDataCoordCum(int s, int g, DataItem item) {
        return this.numericYCoord[s][g];
    }

    public int getMarkerSize(int s, int g) {
        return (int)((double)this.m_Perspective.getMarkerSize(s, g) * 1.6);
    }

    public MarkerTemplate getMarkerShape(IdentObj idMarkerSeries) {
        MarkerTemplate markerTemplate = this.m_Perspective.getMarkerTemplate(idMarkerSeries);
        return markerTemplate;
    }

    @Override
    public double getQuantizedDataValue(int nSeries, int nGroup, DataItem item) {
        double fValue = this.getDataValue((int)nSeries, (int)nGroup, (DataItem)item).value;
        boolean bExact = this.m_Perspective.getExactColorByHeight();
        if (!bExact) {
            List<Double> dLabels = this.m_Y1Axis.getNumericLabelsAsDouble();
            int nLabels = dLabels.size();
            assert (nLabels > 1);
            boolean bFound = false;
            for (int i = 1; i < nLabels && !bFound; ++i) {
                double fCurr;
                double fPrev = dLabels.get(i - 1);
                double fMid = (fPrev + (fCurr = dLabels.get(i).doubleValue())) / 2.0;
                if (!(fValue < fMid)) continue;
                fValue = fPrev;
                bFound = true;
            }
            if (!bFound) {
                fValue = dLabels.get(nLabels - 1);
            }
        }
        return fValue;
    }

    public INumericAxis getX1Axis() {
        return this.m_X1Axis;
    }

    public INumericAxis getY1Axis() {
        return this.m_Y1Axis;
    }

    public INumericAxis getY2Axis() {
        return this.m_Y2Axis;
    }

    public INumericAxis getY3Axis() {
        return this.m_Y3Axis;
    }

    public INumericAxis getY4Axis() {
        return this.m_Y4Axis;
    }

    public INumericAxis getY5Axis() {
        return this.m_Y5Axis;
    }

    public IOrdinalAxis getO1Axis() {
        return this.m_O1Axis;
    }

    @Override
    public void init() {
        super.init();
        this.m_O1Axis = null;
        this.m_X1Axis = null;
        this.m_Y1Axis = null;
        this.m_Y2Axis = null;
        this.m_Z1Axis = null;
    }

    protected boolean isAxisAscending(int nSeries) {
        INumericAxis axis = this.whichAxisForSeries(nSeries, this.getDataItem());
        return axis.isAscending();
    }

    public boolean isComboWithBar() {
        boolean bIsCombo = false;
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.m_Perspective.getAccess());
        while (sEnum.hasNext() && !bIsCombo) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            if (this.m_depth2D.getSeriesType(s) != 1) continue;
            bIsCombo = true;
        }
        return bIsCombo;
    }

    public boolean isComboWithNonBar() {
        boolean bIsCombo = false;
        SeriesEnumerator sEnum = SeriesEnumerator.getIterator(this.m_Perspective, this.getDataView());
        while (sEnum.hasNext() && !bIsCombo) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            if (this.m_depth2D.getSeriesType(s) == 1) continue;
            bIsCombo = true;
        }
        return bIsCombo;
    }

    protected int prevSeriesForAxis(int sCurrent, int gCurrent, int axisCurrent, boolean bNegCurrent) {
        SeriesEnumerator sEnum = this.m_sEnumReverseForPrev;
        int nPrevSeries = -2;
        int nRiserCurrent = this.m_depth2D.getSeriesType(sCurrent);
        sEnum.reset();
        while (sEnum.hasNext()) {
            int nRiserType;
            int zeroCoord;
            boolean bNegPrev;
            INumericAxis axisObj;
            int axis;
            int s = sEnum.next();
            if (s >= sCurrent || (axis = this.getAxisAssignment(s)) != axisCurrent) continue;
            switch (axis) {
                case 7: {
                    axisObj = this.m_X1Axis;
                    break;
                }
                case 0: {
                    axisObj = this.m_Y1Axis;
                    break;
                }
                case 1: {
                    axisObj = this.m_Y2Axis;
                    break;
                }
                case 2: {
                    axisObj = this.m_Y3Axis;
                    break;
                }
                case 3: {
                    axisObj = this.m_Y4Axis;
                    break;
                }
                case 4: {
                    axisObj = this.m_Y5Axis;
                    break;
                }
                case 8: {
                    axisObj = this.m_Z1Axis;
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid axis = " + axis);
                }
            }
            if ((bNegPrev = this.numericYCoord[s][gCurrent] < (zeroCoord = (int)axisObj.getValueCoord(0.0))) != bNegCurrent || (nRiserType = this.m_depth2D.getSeriesType(s)) != nRiserCurrent) continue;
            nPrevSeries = s;
            break;
        }
        return nPrevSeries;
    }

    protected int prevSeriesForAxis(int sCurrent, int gCurrent, IAxis axisObjDesired, boolean bNegValue) {
        return this.prevSeriesForAxis(sCurrent, gCurrent, axisObjDesired.getAxisObjID(), bNegValue);
    }

    protected double processOneStackedValue(int s, int g, INumericAxis yAxisObj, double fValue, SumObj sumObj) {
        boolean bPositive = fValue >= 0.0;
        boolean bY2 = yAxisObj == this.m_Y2Axis;
        int nRiser = this.m_depth2D.getSeriesType(s);
        double fNewSum = sumObj.getSum(bPositive, bY2, nRiser) + fValue;
        sumObj.setSum(bPositive, bY2, nRiser, fNewSum);
        this.numericYCoord[s][g] = (int)yAxisObj.getValueCoord(fNewSum);
        if (this.isIgnoredOffScale(yAxisObj, fNewSum)) {
            this.m_dataOK[s][g] = false;
        }
        return fNewSum;
    }

    public boolean seriesAssignedToBothAxes() {
        boolean bAssignedToY1 = false;
        boolean bAssignedToOtherY = false;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            int assignedAxis = this.getAxisAssignment(s);
            if (!(bAssignedToY1 |= assignedAxis == 0) || !(bAssignedToOtherY |= assignedAxis != 0)) continue;
        }
        return bAssignedToY1 && bAssignedToOtherY;
    }

    public void setNonDataLimits(MinMaxObj mm) {
    }

    protected INumericAxis whichAxisForSeries(int s, DataItem item) {
        INumericAxis axisObj;
        int axis = this.axisAssignedToSeries(s, item);
        switch (axis) {
            case 7: {
                axisObj = this.m_X1Axis;
                break;
            }
            case 0: {
                axisObj = this.m_Y1Axis;
                break;
            }
            case 1: {
                axisObj = this.m_Y2Axis;
                break;
            }
            case 2: {
                axisObj = this.m_Y3Axis;
                break;
            }
            case 3: {
                axisObj = this.m_Y4Axis;
                break;
            }
            case 4: {
                axisObj = this.m_Y5Axis;
                break;
            }
            case 8: {
                axisObj = this.m_Z1Axis;
                break;
            }
            default: {
                axisObj = null;
            }
        }
        return axisObj;
    }

    public int axisAssignedToSeries(int s, DataItem item) {
        int nAxis;
        if (this.m_gt.isMultiY()) {
            nAxis = this.getAxisAssignment(s);
        } else {
            nAxis = item == null ? 0 : item.getAssocAxis();
            if (nAxis == 0) {
                nAxis = this.getAxisAssignment(s);
            }
        }
        return nAxis;
    }

    protected int getOrdinalType() {
        int nOrdType = 1;
        if (this.m_bExtendToFrameEdge && !this.m_bIsThisAComboWithBar) {
            nOrdType = 6;
        } else if (this.m_gt.isRiserBar()) {
            boolean bDualAxisSpacingException = this.m_Perspective.getDualAxisStackedSpacingException();
            if (this.m_bAbsolute && bDualAxisSpacingException) {
                nOrdType = 12;
            } else if (this.m_bAbsolute) {
                nOrdType = 0;
            } else if (this.m_bStacked && this.m_gt.isDualY() && bDualAxisSpacingException) {
                nOrdType = 11;
            } else if (this.m_bStacked && this.m_gt.isDualY() && !this.m_gt.isBipolar() && this.seriesAssignedToBothAxes()) {
                nOrdType = 3;
            }
        } else if (this.m_gt.isRiserArea() || this.m_gt.isRiserMarker()) {
            nOrdType = 2;
        }
        return nOrdType;
    }

    protected abstract Point getCoords(int var1, int var2);

    protected String processDataTextTemplate(String[] dataItems, String dataTextTemplate) {
        return dataTextTemplate;
    }

    @Override
    public IAxis getAxis(int axisId) {
        AxisDescriptor axisDescriptor = this.m_gt.getAxisDescriptor();
        switch (axisId) {
            case 514: {
                return this.getO1Axis();
            }
            case 524: {
                return this.getX1Axis();
            }
            case 528: {
                return this.getY1Axis();
            }
            case 532: {
                if (!axisDescriptor.hasY2()) break;
                return this.getY2Axis();
            }
            case 685: {
                if (!axisDescriptor.hasY3()) break;
                return this.getY3Axis();
            }
            case 690: {
                if (!axisDescriptor.hasY4()) break;
                return this.getY4Axis();
            }
            case 695: {
                if (!axisDescriptor.hasY5()) break;
                return this.getY5Axis();
            }
        }
        return null;
    }

    @Override
    public Point2D getDataValuesXY(int s, int g) {
        if (this.m_gt.isStacked()) {
            double sValue = this.m_fStackedCumulativeValues[s][g];
            return new Point2D.Double(g + 1, sValue);
        }
        DatumObj dObj = this.getDataValue(s, g);
        if (!dObj.m_bOK) {
            return null;
        }
        return new Point2D.Double(g + 1, dObj.value);
    }

    @Override
    public int getXAxisMaxCoord() {
        assert (false);
        return 0;
    }

    @Override
    public int getXAxisMinCoord() {
        assert (false);
        return 0;
    }

    @Override
    public int getYAxisCoord(int seriesId, double value) {
        INumericAxis yAxis = this.whichAxisForSeries(seriesId, null);
        return (int)yAxis.getValueCoord(value);
    }

    @Override
    public boolean isYValueWithinAxis(int seriesId, double value) {
        INumericAxis yAxis = this.whichAxisForSeries(seriesId, null);
        if (value < yAxis.getMinValue()) {
            return false;
        }
        return !(value > yAxis.getMaxValue());
    }

    @Override
    public int getXAxisCoord(int seriesId, double value) {
        assert (false);
        return 0;
    }

    public int getXAxisCoord(double value) {
        assert (false);
        return 0;
    }

    @Override
    public double getXAxisValue(int coord) {
        assert (false);
        return 0.0;
    }
}

