/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PieSliceObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.AnnotationBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DrawFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextStyleObjFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.FrameObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D_Multi;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.PieFrameObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.text.Format;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JChart_2D_Pie
extends JChart_2D_Multi {
    private static final int FEELER_GAP = 200;
    private static final int STACKED_LABEL_SPACING = 500;
    private static final int STACKED_LABEL_SPACING_MIN = 300;
    private static final double THICK_SCALE = 12000.0;
    public static final boolean DEBUG_2D_PIE = false;
    private double m_fRingPct;
    private double m_fPieTilt;
    private double m_fThickness;
    private double m_fXSquashRatio;
    private double m_fYSquashRatio;
    private Format m_SliceValueLabelTextFormat;
    private boolean m_bGTHasRing;
    private boolean m_bGTProportional;
    private boolean m_bShowPieTotal;
    private boolean m_bReverseGroups;
    private int m_nThickOffset;
    private int m_nRadius;
    private int m_nSaveRadius;
    double m_fPieTotal;
    private double m_fHighestGroupTotal;
    private List<PieSliceObj> m_slices;
    private int m_nXCenter;
    private int m_nYCenter;
    int m_nPieBarSlice;
    Point m_ptTopSlice;
    Point m_ptBottomSlice;
    private ITextStyle m_textStyleSliceLabelsRight;
    private ITextStyle m_textStyleSliceLabelsLeft;
    private ITextStyle m_textStyleSliceValuesRight;
    private ITextStyle m_textStyleSliceValuesLeft;
    private int m_nStackedLabelWidthLeft = 0;
    private int m_nStackedLabelWidthRight = 0;
    private double m_fPieToLabelGap = 0.0;
    public static final int INSIDE_SLICE = 1;
    public static final int OUTSIDE_SLICE = 2;
    private int m_displayValuesFormat;
    private int m_SliceValueLabelPosition;
    private int m_SliceLabelPosition;
    private double m_minRadius;
    private Insets m_frameInsets;
    private Rectangle m_rMaxLabelsBound;
    static final double UNKNOWN_ANGLE = -7.0;
    public static final int TYPE_TOP = 1000;
    public static final int TYPE_LEFT = 2000;
    public static final int TYPE_RIGHT = 3000;
    public static final int TYPE_CRUST = 4000;
    public static final int TYPE_RING = 5000;
    private static final Rectangle EMPTY_BOUNDS = new Rectangle(0, 0, 0, 0);
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_2D_Pie(perspective);
        }
    };

    protected JChart_2D_Pie(Perspective perspective) {
        super(perspective);
    }

    @Override
    protected void processSubRect(Rectangle subRect) {
        this.m_nSaveRadius = this.m_nRadius = this.calcPieRadius(subRect);
    }

    @Override
    protected IdentObj getGroupLabelID(int series, int group) {
        return this.m_Perspective.getPieGroupLabel(series, group);
    }

    @Override
    protected IdentObj getGroupLabelBoxID(int series, int group) {
        return this.m_Perspective.getPieGroupLabelBox(series, group);
    }

    public void calcHighestGroupTotal() {
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        this.m_fHighestGroupTotal = 0.0;
        if (this.m_bGTProportional) {
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                double fThisTotal = this.getGroupTotal(g);
                if (!(fThisTotal > this.m_fHighestGroupTotal)) continue;
                this.m_fHighestGroupTotal = fThisTotal;
            }
        }
    }

    private int calcPieRadius(Rectangle rectFrame) {
        Rectangle rectPie = new Rectangle(rectFrame);
        double aspect = this.m_Perspective.getVC().getSquareAspectRatioY() / this.m_Perspective.getVC().getSquareAspectRatioX();
        this.ConstrainBoxAspect(rectPie, this.m_frameInsets.top, this.m_frameInsets.bottom, this.m_frameInsets.left, this.m_frameInsets.right, aspect);
        return (int)(Math.min(rectPie.getWidth() / this.m_fXSquashRatio, rectPie.getHeight() / this.m_fYSquashRatio) / 2.0);
    }

    @Override
    public FrameObj createFrame() {
        return new PieFrameObj(this.m_Perspective);
    }

    protected void calcLabelStrings() {
        String valueString = "";
        String labelString = "";
        for (PieSliceObj slice : this.m_slices) {
            int s = slice.seriesID;
            slice.m_textStyleInnerLabel = this.m_textStyleSliceLabelsRight;
            slice.m_textStyleOuterLabel = this.m_textStyleSliceLabelsRight;
            if (this.m_Perspective.getDisplay(this.m_Perspective.getPieSliceValueLabel(s))) {
                double displayValue;
                if (this.m_SliceValueLabelPosition == 2) {
                    slice.m_textStyleOuterLabel = this.m_textStyleSliceValuesRight;
                } else {
                    slice.m_textStyleInnerLabel = this.m_textStyleSliceValuesRight;
                }
                switch (this.m_displayValuesFormat) {
                    default: {
                        displayValue = slice.percentage;
                        break;
                    }
                    case 1: {
                        displayValue = slice.value;
                    }
                }
                valueString = this.m_SliceValueLabelTextFormat.format(displayValue);
            }
            if (this.m_Perspective.getDisplay(this.m_Perspective.getPieSliceLabel(s))) {
                if (this.m_SliceLabelPosition == 2) {
                    slice.m_textStyleOuterLabel = this.m_textStyleSliceLabelsRight;
                } else {
                    slice.m_textStyleInnerLabel = this.m_textStyleSliceLabelsRight;
                }
                labelString = this.m_Perspective.getSeriesLabel(s);
            }
            StringBuilder innerString = new StringBuilder();
            StringBuilder outerString = new StringBuilder();
            if (valueString.length() + labelString.length() > 0) {
                valueString = valueString.replace(' ', '\u00a0');
                switch (this.m_SliceLabelPosition) {
                    case 1: {
                        innerString.append(labelString);
                        if (this.m_SliceValueLabelPosition == 1) {
                            if (innerString.length() > 0) {
                                innerString.append("\n");
                            }
                            innerString.append(valueString);
                            break;
                        }
                        if (this.m_SliceValueLabelPosition != 2) break;
                        outerString.append(valueString);
                        break;
                    }
                    case 2: {
                        outerString.append(labelString);
                        if (this.m_SliceValueLabelPosition == 1) {
                            innerString.append(valueString);
                            break;
                        }
                        if (this.m_SliceValueLabelPosition != 2) break;
                        if (outerString.length() > 0) {
                            outerString.append("\n");
                        }
                        outerString.append(valueString);
                    }
                }
            }
            slice.m_strInnerLabel = innerString.toString();
            slice.m_strLabel = outerString.toString();
            slice.setLabelDimension(this.getDimSliceLabelVC(slice.m_strLabel, slice.m_textStyleOuterLabel));
            slice.setInnerLabelDimension(this.getDimSliceLabelVC(slice.m_strInnerLabel, slice.m_textStyleInnerLabel));
        }
    }

    protected Dimension getDimSliceLabelVC(String strLabel, ITextStyle textStyle) {
        Dimension dimLabelVC = new Dimension(16000, 16000);
        return this.getDimSliceLabelVC(strLabel, dimLabelVC, textStyle);
    }

    protected Dimension getDimSliceLabelVC(String strLabel, Dimension dimLabelVC, ITextStyle textStyle) {
        Dimension dimLabelDC = this.m_Perspective.getVC().virtToDest(dimLabelVC);
        double nFontSizeDC = textStyle.getFontSizeDC(this.m_Perspective.getVC());
        boolean bTextWrap = textStyle.getWordWrap();
        dimLabelDC = textStyle.getTextSizeDC(strLabel, nFontSizeDC, dimLabelDC, null, bTextWrap);
        return this.m_Perspective.getVC().destToVirt(dimLabelDC);
    }

    @Override
    protected void copyParams() {
        super.copyParams();
        this.m_bGTHasRing = this.m_gt.hasPieRing();
        this.m_bGTProportional = this.m_gt.isProportionalPieType();
        boolean bl = this.m_bGTMultiple = this.m_gt.isMultiPieType() && this.m_nGroups > 1;
        if (!this.m_bSmallDataSet && !this.m_bGTMultiple) {
            this.m_bSmallDataSet = this.m_nSeries < 899;
        }
        this.m_displayValuesFormat = this.m_Perspective.getPieValueFormat();
        this.m_SliceLabelPosition = this.m_Perspective.getPieSliceLabelPosition();
        this.m_SliceValueLabelPosition = this.m_Perspective.getPieSliceValueLabelPosition();
        this.m_fThickness = (double)this.m_Perspective.getPieDepth() / 100.0;
        this.m_bShowPieTotal = this.m_Perspective.getPieRingTotalDisplay();
        this.m_nSubChartsPerRow = this.m_Perspective.getPiesPerRow();
        this.m_fPieTilt = (double)this.m_Perspective.getPieTilt() / 90.0;
        this.m_bReverseGroups = this.m_Perspective.getReverseGroups();
        this.m_SliceValueLabelTextFormat = this.m_Perspective.getPieSliceValueLabelTextFormat();
        this.m_fRingPct = this.m_bGTHasRing ? (double)this.m_Perspective.getPieRingSize() / 100.0 : 0.0;
        this.m_rSuperFrame = this.m_Perspective.getRect(Identity.PieFrame);
        this.m_frameInsets = this.m_Perspective.getInsets(Identity.PieFrame);
        this.m_textStyleSliceLabelsRight = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, Identity.PieSliceLabel);
        this.m_textStyleSliceLabelsLeft = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, Identity.PieSliceLabel);
        this.m_textStyleSliceLabelsLeft.setHorizAlign(2);
        this.m_textStyleSliceValuesRight = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, Identity.PieSliceValueLabel);
        this.m_textStyleSliceValuesLeft = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, Identity.PieSliceValueLabel);
        this.m_textStyleSliceValuesLeft.setHorizAlign(2);
        this.calcHighestGroupTotal();
        this.m_fXSquashRatio = 1.0;
        Rectangle rDest = this.m_Perspective.getVC().getDestCoords();
        this.m_fYSquashRatio = Math.abs((double)rDest.width) / (double)rDest.height;
        this.m_fYSquashRatio -= this.m_fYSquashRatio * this.m_fPieTilt;
        if (this.m_fYSquashRatio > 1.0) {
            this.m_fXSquashRatio = 1.0 / this.m_fYSquashRatio;
            this.m_fYSquashRatio = 1.0;
        }
    }

    protected Shape createTopShape(PieSliceObj theSlice) {
        GeneralPath path = new GeneralPath();
        if (theSlice.m_arcRing != null) {
            path.append(theSlice.m_arcCrust, false);
            Arc2D temp = (Arc2D)theSlice.m_arcRing.clone();
            temp.setAngleStart(theSlice.m_arcRing.getAngleStart() + theSlice.m_arcRing.getAngleExtent());
            temp.setAngleExtent(-theSlice.m_arcRing.getAngleExtent());
            path.append(temp, true);
        } else {
            Arc2D temp = (Arc2D)theSlice.m_arcCrust.clone();
            temp.setArcType(2);
            path.append(temp, false);
        }
        if (path.getBounds().equals(EMPTY_BOUNDS)) {
            return null;
        }
        path.closePath();
        return path;
    }

    protected Shape createCrustShape(PieSliceObj theSlice) {
        GeneralPath path = new GeneralPath();
        Arc2D.Double arc = new Arc2D.Double(theSlice.m_arcCrust.getX(), theSlice.m_arcCrust.getY() - (double)this.m_nThickOffset, theSlice.m_arcCrust.getWidth(), theSlice.m_arcCrust.getHeight(), theSlice.m_arcCrust.getAngleStart() + theSlice.m_arcCrust.getAngleExtent(), -theSlice.m_arcCrust.getAngleExtent(), 0);
        path.append(arc, false);
        path.append(theSlice.m_arcCrust, true);
        if (path.getBounds().equals(EMPTY_BOUNDS)) {
            return null;
        }
        path.closePath();
        return path;
    }

    protected Shape createLeftShape(PieSliceObj theSlice) {
        GeneralPath path = new GeneralPath();
        Point2D top1 = theSlice.m_arcCrust.getStartPoint();
        Point2D top2 = theSlice.m_arcRing != null ? theSlice.m_arcRing.getStartPoint() : new Point2D.Double(theSlice.m_ptTip.x, theSlice.m_ptTip.y);
        Point2D.Double bot1 = new Point2D.Double(top1.getX(), top1.getY() - (double)this.m_nThickOffset);
        Point2D.Double bot2 = new Point2D.Double(top2.getX(), top2.getY() - (double)this.m_nThickOffset);
        path.moveTo((float)((Point2D)bot1).getX(), (float)((Point2D)bot1).getY());
        path.lineTo((float)top1.getX(), (float)top1.getY());
        path.lineTo((float)top2.getX(), (float)top2.getY());
        path.lineTo((float)((Point2D)bot2).getX(), (float)((Point2D)bot2).getY());
        path.closePath();
        return path;
    }

    protected Shape createRightShape(PieSliceObj theSlice) {
        GeneralPath path = new GeneralPath();
        Point2D top1 = theSlice.m_arcCrust.getEndPoint();
        Point2D top2 = theSlice.m_arcRing != null ? theSlice.m_arcRing.getEndPoint() : new Point2D.Double(theSlice.m_ptTip.x, theSlice.m_ptTip.y);
        Point2D.Double bot1 = new Point2D.Double(top1.getX(), top1.getY() - (double)this.m_nThickOffset);
        Point2D.Double bot2 = new Point2D.Double(top2.getX(), top2.getY() - (double)this.m_nThickOffset);
        path.moveTo((float)((Point2D)bot1).getX(), (float)((Point2D)bot1).getY());
        path.lineTo((float)top1.getX(), (float)top1.getY());
        path.lineTo((float)top2.getX(), (float)top2.getY());
        path.lineTo((float)((Point2D)bot2).getX(), (float)((Point2D)bot2).getY());
        path.closePath();
        return path;
    }

    protected Shape createRingShape(PieSliceObj theSlice) {
        GeneralPath path = new GeneralPath();
        Arc2D.Double arc = new Arc2D.Double(theSlice.m_arcRing.getX(), theSlice.m_arcRing.getY() - (double)this.m_nThickOffset, theSlice.m_arcRing.getWidth(), theSlice.m_arcRing.getHeight(), theSlice.m_arcRing.getAngleStart() + theSlice.m_arcRing.getAngleExtent(), -theSlice.m_arcRing.getAngleExtent(), 0);
        assert (((Arc2D)arc).getAngleExtent() != 0.0);
        path.append(arc, false);
        path.append(theSlice.m_arcRing, true);
        if (path.getBounds().equals(EMPTY_BOUNDS)) {
            return null;
        }
        path.closePath();
        return path;
    }

    protected PieSliceObj createSliceObj(int nCenterX, int nCenterY, int nRadius, double fStart, double fEnd, int nDetach, double fAngleDet, double fTilt, double fRing) {
        double fAngle;
        PieSliceObj theSlice = new PieSliceObj();
        MinMaxObj m_minmax_y = new MinMaxObj();
        if (fStart == 0.125) {
            fStart += 1.0E-12;
        }
        if (fStart == 0.375) {
            fStart -= 1.0E-12;
        }
        if (fStart == 0.625) {
            fStart -= 1.0E-12;
        }
        if (fStart == 0.875) {
            fStart -= 1.0E-12;
        }
        int nTipX = nCenterX;
        int nTipY = nCenterY;
        double fDist = fEnd - fStart;
        double f12OClock = -1.5707963267948966;
        theSlice.m_bSliceSplit = false;
        theSlice.m_fAngleStart = fStart - Math.floor(fStart);
        theSlice.m_fAngleEnd = fEnd - fStart == 1.0 ? fEnd - Math.floor(fEnd) + 1.0 : fEnd - Math.floor(fEnd);
        theSlice.m_fAngleAvg = fStart + fDist / 2.0;
        theSlice.m_fAngleAvg -= Math.floor(theSlice.m_fAngleAvg);
        this.calcSlicePositionAndOrient(theSlice);
        theSlice.m_nDetach = nDetach;
        if (nDetach > 0) {
            fAngle = fAngleDet == -7.0 ? f12OClock + (fStart + fDist / 2.0) * (Math.PI * 2) : fAngleDet;
            theSlice.m_fAngleDet = fAngle;
            nTipX = nCenterX + (int)(Math.cos(fAngle) * this.m_fXSquashRatio * (double)nDetach);
            nTipY = nCenterY - (int)(Math.sin(fAngle) * this.m_fYSquashRatio * (double)nDetach);
        }
        double fRadius = this.m_nRadius;
        this.m_minRadius = Math.min(this.m_minRadius, fRadius + (double)nDetach);
        theSlice.m_arcCrust = null;
        theSlice.m_arcRing = null;
        theSlice.m_ptTip = new Point(nTipX, nTipY);
        m_minmax_y.testRawValue(nTipY);
        fAngle = f12OClock + theSlice.m_fAngleAvg * (Math.PI * 2);
        this.calcFeelerPoints(theSlice, m_minmax_y, nTipX, nTipY, nRadius, fAngle, fRing);
        this.calcArcs(theSlice, m_minmax_y, nTipX, nTipY, f12OClock, fStart, fEnd, nRadius, fRing);
        theSlice.m_fHighestY = m_minmax_y.getRawMax();
        theSlice.m_fLowestY = m_minmax_y.getRawMin();
        return theSlice;
    }

    protected void calcArcs(PieSliceObj theSlice, MinMaxObj m_minmax_y, int nCenterX, int nCenterY, double f12OClock, double fStart, double fEnd, double fRadius, double fRing) {
        Rectangle2D.Double ellipseRect = new Rectangle2D.Double((double)nCenterX - fRadius * this.m_fXSquashRatio, (double)nCenterY - fRadius * this.m_fYSquashRatio, 2.0 * fRadius * this.m_fXSquashRatio, 2.0 * fRadius * this.m_fYSquashRatio);
        theSlice.m_arcCrust = new Arc2D.Double(ellipseRect, f12OClock * 57.29577951308232 + fStart * 360.0, (fEnd - fStart) * 360.0, 0);
        if (fRing > 0.0) {
            Rectangle2D.Double ringRect = new Rectangle2D.Double((double)nCenterX - fRadius * fRing * this.m_fXSquashRatio, (double)nCenterY - fRadius * fRing * this.m_fYSquashRatio, 2.0 * fRadius * fRing * this.m_fXSquashRatio, 2.0 * fRadius * fRing * this.m_fYSquashRatio);
            theSlice.m_arcRing = new Arc2D.Double(ringRect, f12OClock * 57.29577951308232 + fStart * 360.0, (fEnd - fStart) * 360.0, 0);
        }
        theSlice.m_ptCrustLeft = new Point();
        theSlice.m_ptCrustLeft.setLocation(theSlice.m_arcCrust.getStartPoint());
        theSlice.m_ptCrustRight = new Point();
        theSlice.m_ptCrustRight.setLocation(theSlice.m_arcCrust.getEndPoint());
        if (fRing > 0.0) {
            theSlice.m_ptRingLeft = new Point();
            theSlice.m_ptRingLeft.setLocation(theSlice.m_arcRing.getStartPoint());
            theSlice.m_ptRingRight = new Point();
            theSlice.m_ptRingRight.setLocation(theSlice.m_arcRing.getEndPoint());
        } else {
            theSlice.m_ptRingLeft = new Point(nCenterX, nCenterY);
            theSlice.m_ptRingRight = new Point(nCenterX, nCenterY);
        }
    }

    protected void calcFeelerPoints(PieSliceObj theSlice, MinMaxObj m_minmax_y, int nTipX, int nTipY, double fRadius, double fAngle, double fRing) {
        double fAttach = 0.0;
        int nPosX = nTipX + (int)Math.rint(Math.cos(fAngle) * this.m_fXSquashRatio * fRadius);
        int nPosY = nTipY - (int)(Math.sin(fAngle) * this.m_fYSquashRatio * fRadius);
        theSlice.m_ptFeelerAttachCenter = new Point(nPosX, nPosY);
        double fBloom = 0.25 - Math.abs(0.5 - theSlice.m_fAngleAvg);
        if (fBloom < 0.0) {
            fBloom = 0.0;
        }
        fAttach = fRadius * (1.2 + (fBloom *= 2.0) * (0.3 * this.m_fThickness + 0.5 * this.m_fPieTilt));
        nPosX = nTipX + (int)(Math.cos(fAngle) * this.m_fXSquashRatio * fAttach);
        nPosY = nTipY - (int)(Math.sin(fAngle) * this.m_fYSquashRatio * fAttach);
        theSlice.m_ptFeelerJoint = new Point(nPosX, nPosY);
        m_minmax_y.testRawValue(nPosY);
    }

    protected void calcSlicePositionAndOrient(PieSliceObj theSlice) {
        if ((theSlice.m_fAngleStart >= 0.75 || theSlice.m_fAngleStart <= 0.25) && (theSlice.m_fAngleEnd >= 0.75 || theSlice.m_fAngleEnd <= 0.25)) {
            theSlice.m_nSliceType = 10;
        } else if (theSlice.m_fAngleStart >= 0.25 && theSlice.m_fAngleStart <= 0.75 && theSlice.m_fAngleEnd >= 0.25 && theSlice.m_fAngleEnd <= 0.75) {
            theSlice.m_nSliceType = 20;
            if (theSlice.m_fAngleStart == 0.25 || theSlice.m_fAngleEnd == 0.75) {
                theSlice.m_nSliceType = 21;
            }
        } else {
            theSlice.m_nSliceType = theSlice.m_fAngleStart < 0.5 ? 1 : 2;
        }
        if (theSlice.m_fAngleEnd < theSlice.m_fAngleStart && theSlice.m_fAngleStart < 0.75) {
            theSlice.m_nSliceType = 3;
        }
        if (theSlice.m_fAngleEnd > theSlice.m_fAngleStart && theSlice.m_fAngleEnd - theSlice.m_fAngleStart > 0.5) {
            theSlice.m_nSliceType = 3;
        }
        if (theSlice.m_nSliceType != 1 && theSlice.m_nSliceType != 2 && theSlice.m_nSliceType != 3 && theSlice.m_fAngleStart < 0.5 && theSlice.m_fAngleEnd >= 0.5) {
            theSlice.m_nSliceType = 22;
        }
        theSlice.m_nSliceSide = theSlice.m_fAngleAvg > 0.0 && theSlice.m_fAngleAvg <= 0.5 ? 1 : 0;
    }

    @Override
    protected double drawSubChart(int nPieGroupRel) {
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        GroupsEnumerator gEnumRev = this.getResetGroupsEnumerator(false);
        int g = gEnum.get(nPieGroupRel);
        this.m_nXCenter = this.m_rSubFrame.x + this.m_rSubFrame.width / 2;
        this.m_nYCenter = this.m_rSubFrame.y + this.m_rSubFrame.height / 2;
        this.m_nThickOffset = (int)(this.m_fThickness * 12000.0);
        int maxThick = (int)(this.m_rSubFrame.getHeight() * 0.95);
        this.m_nThickOffset = Math.min(this.m_nThickOffset, maxThick);
        this.m_nYCenter = (int)((double)(this.m_nYCenter + this.m_nThickOffset / 2) + this.m_fYSquashRatio * this.m_fPieTilt);
        this.m_minRadius = Double.MAX_VALUE;
        this.calcMaxRect();
        this.m_slices = new ArrayList<PieSliceObj>(this.m_nTotalSeries);
        this.m_fPieTotal = this.getGroupTotal(g);
        if (this.m_fPieTotal > 0.0) {
            if (this.m_bGTProportional && this.m_fHighestGroupTotal > 0.0) {
                double fPct = this.m_fPieTotal / this.m_fHighestGroupTotal;
                this.m_nRadius = (int)((double)this.m_nSaveRadius * fPct);
            }
            this.createSliceObjects(g);
            this.calcLabelStrings();
            this.splitSpanningSlices();
            this.sortSlicesBackToFront();
            if (this.m_nThickOffset != 0) {
                this.drawBackFacingSlices();
                this.drawThresholdSlices();
                this.drawFrontFacingSlices();
                this.drawFrontMostSlice();
            }
            this.drawAllSliceTops();
            this.drawAllSliceLabels();
        }
        int gReverse = this.m_bReverseGroups ? gEnumRev.get(nPieGroupRel) : g;
        if (this.m_fPieTotal > 0.0 && this.m_bShowPieTotal && this.m_bGTHasRing) {
            this.drawRingLabel(gReverse);
        }
        if (this.m_Perspective.getDisplay(this.getGroupLabelID(-3, gReverse))) {
            this.drawPieGroupLabel(gReverse);
        }
        return this.m_fPieTotal;
    }

    protected void createSliceObjects(int g) {
        int nTotalZeroCount = 0;
        List<SeriesOrderingInfo> orderedList = this.orderSeriesForPie(g);
        double fCurrAngle = this.getPieRotation();
        for (SeriesOrderingInfo info : orderedList) {
            int s = info.nSeriesID;
            assert (s >= 0 && s < this.m_nTotalSeries);
            double fValue = this.getDataValue((int)s, (int)g).value;
            if (fValue > 0.0) {
                double fDetach = this.m_bSmallDataSet ? (double)this.m_Perspective.getPieSliceDetach(s, g) / 100.0 : 0.0;
                int nDetach = (int)(fDetach * (double)this.m_nSaveRadius);
                double fSlicePct = fValue / this.m_fPieTotal;
                double fSliceEnd = fCurrAngle + fSlicePct;
                PieSliceObj obj = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, fCurrAngle, fSliceEnd, nDetach, -7.0, this.m_fPieTilt, this.m_fRingPct);
                obj.seriesID = s;
                obj.m_nSliceIdx = this.m_slices.size();
                obj.groupID = g;
                obj.percentage = fSlicePct;
                obj.value = fValue;
                obj.m_bSliceDeleted = this.m_bSmallDataSet ? this.m_Perspective.getPieSliceDelete(s) || this.m_Perspective.getPieSliceDelete(s, g) : false;
                this.m_slices.add(obj);
                fCurrAngle = fSliceEnd;
                continue;
            }
            if (fValue != 0.0) continue;
            ++nTotalZeroCount;
        }
    }

    void splitSpanningSlices() {
        ArrayList<PieSliceObj> newSlices = new ArrayList<PieSliceObj>();
        int sliceCount = this.m_slices.size();
        for (PieSliceObj slice : this.m_slices) {
            double fStart = slice.m_fAngleStart;
            double fEnd = slice.m_fAngleEnd;
            double fCurr = fStart;
            double fNext = 2.25;
            if (fEnd < fStart) {
                fEnd += 1.0;
            }
            if (slice.m_nSliceType != 1 && slice.m_nSliceType != 2 && slice.m_nSliceType != 3) continue;
            while (fCurr < fEnd) {
                if (fCurr < 1.75) {
                    fNext = 1.75;
                }
                if (fCurr < 1.25) {
                    fNext = 1.25;
                }
                if (fCurr < 0.75) {
                    fNext = 0.75;
                }
                if (fCurr < 0.25) {
                    fNext = 0.25;
                }
                if (fNext > fEnd) {
                    fNext = fEnd;
                }
                if (Math.abs(fNext - fCurr) < 1.0E-5) {
                    fCurr = fEnd;
                    continue;
                }
                PieSliceObj splitSlice = this.createSliceObj(this.m_nXCenter, this.m_nYCenter, this.m_nRadius, fCurr, fNext, slice.m_nDetach, slice.m_fAngleDet, this.m_fPieTilt, this.m_fRingPct);
                splitSlice.m_nSliceIdx = sliceCount++;
                splitSlice.seriesID = slice.seriesID;
                splitSlice.groupID = slice.groupID;
                splitSlice.percentage = slice.percentage;
                splitSlice.value = slice.value;
                splitSlice.m_bSliceDeleted = slice.m_bSliceDeleted;
                splitSlice.m_bSliceSplit = true;
                newSlices.add(splitSlice);
                fCurr = fNext;
            }
            slice.m_nSliceType = 4;
        }
        this.m_slices.addAll(newSlices);
    }

    protected void sortSlicesBackToFront() {
        Collections.sort(this.m_slices, new Comparator<PieSliceObj>(){

            @Override
            public int compare(PieSliceObj o1, PieSliceObj o2) {
                if (o2.m_ptFeelerAttachCenter.y > JChart_2D_Pie.this.m_nYCenter) {
                    return (int)(o2.m_fHighestY - o1.m_fHighestY);
                }
                return (int)(o2.m_fLowestY - o1.m_fLowestY);
            }
        });
    }

    protected void drawAllSliceTops() {
        for (PieSliceObj slice : this.m_slices) {
            if (slice.m_bSliceDeleted || slice.m_bSliceSplit) continue;
            this.drawSliceTop(slice);
        }
    }

    protected void drawBackFacingSlices() {
        for (PieSliceObj slice : this.m_slices) {
            if (slice.m_bSliceDeleted || slice.m_nSliceType != 10) continue;
            this.drawSliceCrust(slice);
            if (this.m_bSmallDataSet) {
                if (slice.m_nSliceSide == 1) {
                    this.drawSliceLeftEdge(slice);
                    this.drawSliceRightEdge(slice);
                } else {
                    this.drawSliceRightEdge(slice);
                    this.drawSliceLeftEdge(slice);
                }
            }
            this.drawSliceRing(slice);
        }
    }

    protected void drawThresholdSlices() {
        for (PieSliceObj slice : this.m_slices) {
            if (slice.m_bSliceDeleted || slice.m_nSliceType != 21) continue;
            this.drawSliceRing(slice);
            if (this.m_bSmallDataSet) {
                if (slice.m_nSliceSide == 1) {
                    this.drawSliceLeftEdge(slice);
                    this.drawSliceRightEdge(slice);
                } else {
                    this.drawSliceRightEdge(slice);
                    this.drawSliceLeftEdge(slice);
                }
            }
            this.drawSliceCrust(slice);
        }
    }

    protected void drawFrontFacingSlices() {
        for (PieSliceObj slice : this.m_slices) {
            if (slice.m_bSliceDeleted || slice.m_nSliceType != 20) continue;
            this.drawSliceRing(slice);
            if (this.m_bSmallDataSet) {
                if (slice.m_nSliceSide == 1) {
                    this.drawSliceLeftEdge(slice);
                    this.drawSliceRightEdge(slice);
                } else {
                    this.drawSliceRightEdge(slice);
                    this.drawSliceLeftEdge(slice);
                }
            }
            this.drawSliceCrust(slice);
        }
    }

    protected void drawFrontMostSlice() {
        for (PieSliceObj slice : this.m_slices) {
            if (slice.m_bSliceDeleted || slice.m_nSliceType != 22) continue;
            this.drawSliceRing(slice);
            if (this.m_bSmallDataSet) {
                this.drawSliceLeftEdge(slice);
                this.drawSliceRightEdge(slice);
            }
            this.drawSliceCrust(slice);
        }
    }

    protected void drawPieGroupLabel(int nPieGroup) {
        int nLowestY = 0;
        nLowestY = this.getPieBottom() - (int)(1.25 * (double)this.m_nGroupLabelHeight);
        int nLabelSize = this.getTitleWidth();
        Rectangle rGroupLabel = new Rectangle(this.m_nXCenter - nLabelSize / 2, nLowestY, nLabelSize, this.m_nGroupLabelHeight);
        this.drawGroupLabel(nPieGroup, rGroupLabel);
    }

    private int getPieTop() {
        return this.m_nYCenter + (int)((double)this.m_nRadius * this.m_fYSquashRatio);
    }

    private int getPieBottom() {
        return this.m_nYCenter - (int)((double)this.m_nRadius * this.m_fYSquashRatio) - this.m_nThickOffset;
    }

    protected void drawRingLabel(int nPieGroup) {
        Format format = this.m_Perspective.getPieRingTotalTextFormat();
        double fLabelSize = (double)this.m_nRadius * 1.5;
        int nLabelSize = (int)fLabelSize;
        Dimension labelDimVC = new Dimension(nLabelSize, nLabelSize);
        double fDataTextValue = this.m_Perspective.getPieRingTotalIsPercent() ? 1.0 : this.m_fPieTotal;
        String str = format.format(fDataTextValue);
        IdentObj id = Identity.PieRingLabel;
        BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        ITextStyle textStyleObj = TextStyleObjFactory.newTextStyleObj(this.m_Perspective, id);
        labelDimVC = TextUtil.getTextDimensionVC(this.m_Perspective, id, str);
        Rectangle rRingLabelVC = new Rectangle(this.m_nXCenter - labelDimVC.width / 2, this.m_nYCenter - labelDimVC.height / 2, labelDimVC.width, labelDimVC.height);
        id = new IdentObj(id.getObjectID(), -3, nPieGroup);
        DrawFactory.createLabel(this.m_Perspective.getDetectiv(), id, str, rRingLabelVC, textStyleObj, blackBoxLabel, null);
    }

    protected void drawAllSliceLabels() {
        if (this.m_SliceValueLabelPosition == 2 || this.m_SliceLabelPosition == 2) {
            this.calcStackedLabelsAndFeelers(2);
        }
        for (PieSliceObj slice : this.m_slices) {
            if (slice.m_bSliceDeleted || slice.m_bSliceSplit) continue;
            this.drawSliceLabel(slice);
        }
    }

    protected void drawSliceLabel(PieSliceObj theSlice) {
        Rectangle rLabel = null;
        boolean bDisplaySliceLabel = this.m_Perspective.getDisplay(this.m_Perspective.getPieSliceLabel(theSlice.seriesID));
        boolean bDisplaySliceValueLabel = this.m_Perspective.getDisplay(this.m_Perspective.getPieSliceValueLabel(theSlice.seriesID));
        if ((this.m_SliceLabelPosition == 2 && bDisplaySliceLabel || this.m_SliceValueLabelPosition == 2 && bDisplaySliceValueLabel) && theSlice.m_bShowStackedLabel) {
            int boxID;
            int textID;
            rLabel = this.m_Perspective.getVC().vcCombineKeepDCDimension(theSlice.getLabelRect().getLocation(), theSlice.getLabelDimension());
            if (bDisplaySliceLabel && this.m_SliceLabelPosition == 2) {
                textID = 539;
                boxID = 651;
            } else {
                textID = 823;
                boxID = 824;
            }
            this.createSliceDetNodes(theSlice, rLabel, theSlice.m_strLabel, 2, textID, boxID);
        }
        if (this.m_SliceLabelPosition == 1 && bDisplaySliceLabel || this.m_SliceValueLabelPosition == 1 && bDisplaySliceValueLabel) {
            int boxID;
            int textID;
            int nLabelWidth = theSlice.getInnerLabelWidth();
            int nLabelHeight = theSlice.getInnerLabelHeight();
            rLabel = new Rectangle((int)((double)theSlice.m_ptTip.x + (double)(theSlice.m_ptFeelerAttachCenter.x - theSlice.m_ptTip.x) / 1.5 - (double)(nLabelWidth / 2)), (int)((double)theSlice.m_ptTip.y + (double)(theSlice.m_ptFeelerAttachCenter.y - theSlice.m_ptTip.y) / 1.5 - (double)(nLabelHeight / 2)), nLabelWidth, nLabelHeight);
            if (bDisplaySliceLabel && this.m_SliceLabelPosition == 1) {
                textID = 539;
                boxID = 651;
            } else {
                textID = 823;
                boxID = 824;
            }
            this.createSliceDetNodes(theSlice, rLabel, theSlice.m_strInnerLabel, 1, textID, boxID);
        }
    }

    private void createSliceDetNodes(PieSliceObj theSlice, Rectangle rLabel, String textString, int side, int labelId, int backgroundRectId) {
        IdentObj idBackground = new IdentObj(backgroundRectId, theSlice.seriesID, theSlice.groupID);
        AnnotationBox.calcBorderedBox(this.m_Perspective, idBackground, rLabel, true);
        IdentObj id = new IdentObj(labelId, theSlice.seriesID, theSlice.groupID);
        BlackBoxObj blackBoxLabel = new BlackBoxObj(this.m_Perspective, id);
        id = id.changeMisc(side);
        if (labelId == 823) {
            DrawFactory.createLabel(this.m_Perspective.getDetectiv(), id, textString, rLabel, theSlice.m_nLabelSide == 0 ? this.m_textStyleSliceValuesLeft : this.m_textStyleSliceValuesRight, blackBoxLabel, null);
        } else {
            DrawFactory.createLabel(this.m_Perspective.getDetectiv(), id, textString, rLabel, theSlice.m_nLabelSide == 0 ? this.m_textStyleSliceLabelsLeft : this.m_textStyleSliceLabelsRight, blackBoxLabel, null);
        }
    }

    protected double calcFeelerElbowRadius(IdentObj idFeeler) {
        int vcWidth = this.m_Perspective.getVC().destToVirtWidth(this.m_Perspective.getLineWidth(idFeeler));
        return (double)vcWidth * 6.0;
    }

    protected Point2D interpolate(Point2D point1, Point2D point2, double dist) {
        double dx = point2.getX() - point1.getX();
        double dy = point2.getY() - point1.getY();
        double dist12 = Math.sqrt(dx * dx + dy * dy);
        if (dist >= 0.0) {
            if (dist > dist12) {
                return point2;
            }
            return new Point2D.Double(point1.getX() + dx * (dist / dist12), point1.getY() + dy * (dist / dist12));
        }
        if (Math.abs(dist) > dist12) {
            return point1;
        }
        return new Point2D.Double(point2.getX() + dx * (dist / dist12), point2.getY() + dy * (dist / dist12));
    }

    protected Point2D getIntercept(PieSliceObj slice) {
        Point center = slice.m_ptFeelerAttachCenter;
        Point joint = slice.m_ptFeelerJoint;
        Point labelPt = this.getLabelAnchorPoint(slice);
        double dx1 = ((Point2D)joint).getX() - ((Point2D)center).getX();
        double dy1 = ((Point2D)joint).getY() - ((Point2D)center).getY();
        double dy2 = ((Point2D)labelPt).getY() - ((Point2D)center).getY();
        if (dy1 == 0.0 || dy1 >= 0.0 && dy2 < 0.0 || dy1 < 0.0 && dy2 >= 0.0) {
            return null;
        }
        double dx2 = dx1 * dy2 / dy1;
        Point newPt = new Point((int)(((Point2D)center).getX() + dx2), (int)(((Point2D)center).getY() + dy2));
        if (slice.m_nLabelSide == 1 && ((Point2D)newPt).getX() > ((Point2D)labelPt).getX() || slice.m_nLabelSide == 0 && ((Point2D)newPt).getX() < ((Point2D)labelPt).getX()) {
            return null;
        }
        return newPt;
    }

    protected void drawOneFeeler(PieSliceObj slice, Shape shape, IdentObj idFeeler) {
        BlackBoxObj blackBox = new BlackBoxObj(this.m_Perspective, idFeeler);
        blackBox.setTransparentFillColor(true);
        DrawFactory.createShape(this.getDrawContainer(), idFeeler, shape, blackBox);
    }

    protected boolean calcOneJointFeeler(PieSliceObj slice) {
        IdentObj idFeeler = this.m_Perspective.getPieFeelerLine(slice.seriesID);
        double round = this.calcFeelerElbowRadius(idFeeler);
        Point center = slice.m_ptFeelerAttachCenter;
        Point lblPt = this.getLabelAnchorPoint(slice);
        Point2D joint = this.getIntercept(slice);
        if (joint != null) {
            GeneralPath path = new GeneralPath();
            path.moveTo((float)((Point2D)center).getX(), (float)((Point2D)center).getY());
            Point2D elbowStart = this.interpolate(center, joint, -round);
            path.lineTo((float)elbowStart.getX(), (float)elbowStart.getY());
            QuadCurve2D.Double elbow = new QuadCurve2D.Double();
            elbow.setCurve(elbowStart, joint, this.interpolate(joint, lblPt, round));
            path.append(elbow, true);
            path.lineTo((float)((Point2D)lblPt).getX(), (float)((Point2D)lblPt).getY());
            this.drawOneFeeler(slice, path, idFeeler);
            return true;
        }
        return false;
    }

    protected void calcTwoJointFeeler(PieSliceObj slice) {
        IdentObj idFeeler = this.m_Perspective.getPieFeelerLine(slice.seriesID);
        double xGap = this.m_fPieToLabelGap / 4.0;
        double round = this.calcFeelerElbowRadius(idFeeler);
        boolean left = slice.m_nLabelSide == 0;
        boolean right = slice.m_nLabelSide == 1;
        boolean skipInnerJoint = false;
        Point center = slice.m_ptFeelerAttachCenter;
        Point lblPt = this.getLabelAnchorPoint(slice);
        int xDir = left ? -1 : 1;
        Point2D.Double point1 = new Point2D.Double(((Point2D)lblPt).getX() - (double)xDir * (this.m_fPieToLabelGap - xGap), ((Point2D)center).getY());
        Point2D.Double point2 = new Point2D.Double(((Point2D)lblPt).getX() - (double)xDir * xGap, ((Point2D)lblPt).getY());
        Point2D.Double midPoint = new Point2D.Double((((Point2D)point1).getX() + ((Point2D)point2).getX()) / 2.0, (((Point2D)point1).getY() + ((Point2D)point2).getY()) / 2.0);
        if (left && ((Point2D)center).getX() < ((Point2D)point2).getX() || right && ((Point2D)center).getX() > ((Point2D)point2).getX()) {
            this.drawOneFeeler(slice, new Line2D.Double(center, lblPt), idFeeler);
            return;
        }
        if (left && ((Point2D)center).getX() < ((Point2D)point1).getX() || right && ((Point2D)center).getX() > ((Point2D)point1).getX()) {
            skipInnerJoint = true;
            midPoint = new Point2D.Double((((Point2D)center).getX() + ((Point2D)point2).getX()) / 2.0, (((Point2D)center).getY() + ((Point2D)point2).getY()) / 2.0);
        }
        GeneralPath path = new GeneralPath();
        path.moveTo((float)((Point2D)center).getX(), (float)((Point2D)center).getY());
        if (!skipInnerJoint) {
            Point2D elbow1Start = this.interpolate(center, point1, -round);
            path.lineTo((float)elbow1Start.getX(), (float)elbow1Start.getY());
            QuadCurve2D.Double elbow1 = new QuadCurve2D.Double();
            elbow1.setCurve(elbow1Start, point1, this.interpolate(point1, midPoint, round));
            path.append(elbow1, true);
        }
        Point2D elbow2Start = this.interpolate(midPoint, point2, -round);
        path.lineTo((float)elbow2Start.getX(), (float)elbow2Start.getY());
        QuadCurve2D.Double elbow2 = new QuadCurve2D.Double();
        elbow2.setCurve(elbow2Start, point2, this.interpolate(point2, lblPt, round));
        path.append(elbow2, true);
        path.lineTo((float)((Point2D)lblPt).getX(), (float)((Point2D)lblPt).getY());
        this.drawOneFeeler(slice, path, idFeeler);
    }

    protected void calcStackedFeelers(List<PieSliceObj> slices) {
        for (PieSliceObj slice : slices) {
            if (!this.m_Perspective.getDisplay(this.m_Perspective.getPieFeelerLine(slice.seriesID)) || this.calcOneJointFeeler(slice)) continue;
            this.calcTwoJointFeeler(slice);
        }
    }

    protected void calcMaxRect() {
        this.m_rMaxLabelsBound = this.m_rSubFrame;
        if (this.m_rAvailableSpace != null) {
            if (!this.m_bGTMultiple) {
                this.m_rMaxLabelsBound = this.m_rAvailableSpace;
            } else {
                if (this.m_nRows == 1) {
                    this.m_rMaxLabelsBound.y = this.m_rAvailableSpace.y;
                    this.m_rMaxLabelsBound.height = this.m_rAvailableSpace.height;
                }
                if (this.m_nCols == 1) {
                    this.m_rMaxLabelsBound.x = this.m_rAvailableSpace.x;
                    this.m_rMaxLabelsBound.width = this.m_rAvailableSpace.width;
                }
            }
        }
    }

    protected void calcStackedLabelWidths(int longLeftLabel, int longRightLabel) {
        this.m_fPieToLabelGap = this.m_minRadius * this.m_fXSquashRatio * 0.25;
        double frameBasedWidth = (double)this.m_rMaxLabelsBound.width * 0.1;
        double labelRadius = this.m_minRadius * this.m_fXSquashRatio + this.m_fPieToLabelGap + 200.0;
        Dimension dim = this.getDimSliceLabelVC("Abracadabra", this.m_textStyleSliceLabelsRight);
        double minAcceptableWidth = Math.min(frameBasedWidth, dim.getWidth());
        double minAcceptableLeft = Math.min(minAcceptableWidth, (double)longLeftLabel);
        double minAcceptableRight = Math.min(minAcceptableWidth, (double)longRightLabel);
        this.m_nStackedLabelWidthLeft = (int)Math.max(minAcceptableLeft, (double)this.m_nXCenter - labelRadius - this.m_rMaxLabelsBound.getMinX());
        this.m_nStackedLabelWidthRight = (int)Math.max(minAcceptableRight, this.m_rMaxLabelsBound.getMaxX() - labelRadius - (double)this.m_nXCenter);
    }

    private static double properAngle(double angle) {
        if (angle >= 0.0 && angle < 1.0) {
            return angle;
        }
        return angle - Math.floor(angle);
    }

    private int getLabelSide(PieSliceObj slice, int favorSide) {
        double angleAvg = JChart_2D_Pie.properAngle(slice.m_fAngleAvg);
        if (favorSide == 2) {
            if (angleAvg >= 0.0 && angleAvg < 0.5) {
                return 1;
            }
            return 0;
        }
        double angle1 = JChart_2D_Pie.properAngle(slice.m_fAngleStart);
        double angle2 = JChart_2D_Pie.properAngle(slice.m_fAngleEnd);
        if (favorSide == 1) {
            if ((angle1 <= 0.5 || angle2 <= 0.5) && (angleAvg > 0.9 || angleAvg < 0.6)) {
                return 1;
            }
            return 0;
        }
        if ((angle1 == 0.0 || angle2 == 0.0 || angle1 >= 0.5 || angle2 >= 0.5) && (angleAvg < 0.1 || angleAvg > 0.4)) {
            return 0;
        }
        return 1;
    }

    protected Point getLabelAnchorPoint(PieSliceObj slice) {
        Rectangle r = slice.getLabelRect();
        if (slice.m_nLabelSide == 0) {
            return new Point((int)r.getMaxX() + 200, (int)r.getCenterY());
        }
        return new Point((int)r.getMinX() - 200, (int)r.getCenterY());
    }

    protected boolean hasOverlap(double max1, double min1, double max2, double min2) {
        return !(min1 > max2) && !(min2 > max1);
    }

    protected void setLabelRect(PieSliceObj slice, int yVal) {
        int height = slice.getLabelHeight();
        int width = slice.getLabelWidth();
        int xLeft = slice.m_nLabelSide == 0 ? Math.max(this.m_rMaxLabelsBound.x, this.m_rMaxLabelsBound.x + this.m_nStackedLabelWidthLeft - width) : (int)Math.min(this.m_rMaxLabelsBound.getMaxX() - (double)this.m_nStackedLabelWidthRight, this.m_rMaxLabelsBound.getMaxX() - (double)width);
        if (height > this.m_rMaxLabelsBound.height) {
            slice.setLabelRect(new Rectangle(xLeft, this.m_rMaxLabelsBound.y - this.m_rMaxLabelsBound.height, width, this.m_rMaxLabelsBound.height));
        } else {
            slice.setLabelRect(new Rectangle(xLeft, yVal - height, width, height));
        }
        slice.m_bShowStackedLabel = true;
    }

    protected void setLabelRects(List<PieSliceObj> stack, double yStart, double gap) {
        double y = yStart;
        for (PieSliceObj s : stack) {
            this.setLabelRect(s, (int)y);
            y -= gap + (double)s.getLabelHeight();
        }
    }

    protected void distribute(List<PieSliceObj> stack, int heightLeft, int maxLabelWidth) {
        double avgGap = (double)heightLeft / (double)(stack.size() + 1);
        if (avgGap < 1000.0) {
            double yStart = this.m_rMaxLabelsBound.getMaxY() - avgGap;
            this.setLabelRects(stack, yStart, avgGap);
            return;
        }
        if (stack.size() == 1 && stack.get(0).getLabelWidth() > maxLabelWidth) {
            PieSliceObj s = stack.get(0);
            if (s.m_ptFeelerAttachCenter.y >= this.m_nYCenter) {
                this.setLabelRect(s, Math.min((int)this.m_rMaxLabelsBound.getMaxY(), this.getPieTop() + s.getLabelHeight()));
            } else {
                this.setLabelRect(s, Math.max((int)this.m_rMaxLabelsBound.getMinY() + s.getLabelHeight(), this.getPieBottom()));
            }
            return;
        }
        ClumpList clumpList = new ClumpList(stack);
        clumpList.calc();
    }

    protected int chopStack(List<PieSliceObj> stack, int labelWidth) {
        Collections.sort(stack, new PieSliceObj.ImportanceComparator());
        int height = 0;
        int nFit = 0;
        for (PieSliceObj s : stack) {
            Dimension dim = this.getDimSliceLabelVC(s.m_strLabel, new Dimension(labelWidth, Integer.MAX_VALUE), s.m_textStyleOuterLabel);
            int testHeight = height + dim.height + (nFit > 0 ? 300 : 0);
            if (testHeight >= this.m_rMaxLabelsBound.height && nFit != 0) break;
            height = testHeight;
            s.setLabelDimension(dim);
            ++nFit;
        }
        if (nFit < stack.size()) {
            stack.subList(nFit, stack.size()).clear();
        }
        return Math.max(0, this.m_rMaxLabelsBound.height - (height -= nFit * 300));
    }

    protected void splitSlicesLeftRight(List<PieSliceObj> left, List<PieSliceObj> right, int favorSide) {
        for (PieSliceObj slice : this.m_slices) {
            slice.m_bShowStackedLabel = false;
            if (slice.m_bSliceDeleted || slice.m_bSliceSplit || slice.m_strLabel == null || slice.m_strLabel.length() == 0) continue;
            if (this.getLabelSide(slice, favorSide) == 0) {
                left.add(slice);
                slice.m_nLabelSide = 0;
                continue;
            }
            right.add(slice);
            slice.m_nLabelSide = 1;
        }
    }

    protected int calcMaxLabelWidth(List<PieSliceObj> slices) {
        int maxWidth = 0;
        for (PieSliceObj s : slices) {
            Dimension dim = this.getDimSliceLabelVC(s.m_strLabel, s.m_textStyleOuterLabel);
            maxWidth = Math.max(maxWidth, dim.width);
        }
        return maxWidth;
    }

    protected void calcStackedLabelsAndFeelers(int favorSide) {
        ArrayList<PieSliceObj> left = new ArrayList<PieSliceObj>();
        ArrayList<PieSliceObj> right = new ArrayList<PieSliceObj>();
        this.splitSlicesLeftRight(left, right, favorSide);
        this.calcStackedLabelWidths(this.calcMaxLabelWidth(left), this.calcMaxLabelWidth(right));
        int origLeftSize = left.size();
        int origRightSize = right.size();
        int unusedLeftHeight = this.chopStack(left, this.m_nStackedLabelWidthLeft);
        int unusedRightHeight = this.chopStack(right, this.m_nStackedLabelWidthRight);
        this.calcStackedLabelWidths(this.calcMaxLabelWidth(left), this.calcMaxLabelWidth(right));
        if (favorSide == 2 && left.size() < origLeftSize && origRightSize == right.size()) {
            this.calcStackedLabelsAndFeelers(1);
            return;
        }
        if (favorSide == 2 && right.size() < origRightSize && origLeftSize == left.size()) {
            this.calcStackedLabelsAndFeelers(0);
            return;
        }
        Collections.sort(left, new PieSliceObj.HeightComparator());
        this.distribute(left, unusedLeftHeight, this.m_nStackedLabelWidthLeft);
        Collections.sort(right, new PieSliceObj.HeightComparator());
        this.distribute(right, unusedRightHeight, this.m_nStackedLabelWidthRight);
        this.calcStackedFeelers(left);
        this.calcStackedFeelers(right);
    }

    protected void drawSliceCrust(PieSliceObj theSlice) {
        int nObjectID = this.getSliceObjectID(543);
        int s = theSlice.seriesID;
        IdentObj id = new IdentObj(nObjectID, s, theSlice.groupID);
        IBlackBox blackBox = this.assignSeriesColor(s, theSlice.groupID);
        Rectangle r = theSlice.m_arcCrust.getBounds();
        r.grow(0, this.m_nThickOffset / 2);
        r.setLocation(r.x, r.y - this.m_nThickOffset / 2);
        blackBox.setAnchorRect(this.m_Perspective.getVC().virtToDest(r));
        Shape crustShape = this.createCrustShape(theSlice);
        id = id.changeMisc(4000 + theSlice.m_nSliceIdx);
        double fIntensity = 0.8;
        if (crustShape != null) {
            DrawFactory.createShape(this.getDrawContainer(), id, crustShape, blackBox, null, fIntensity);
        }
    }

    protected void drawSliceLeftEdge(PieSliceObj theSlice) {
        double fIntensity = 0.6;
        int nObjectID = this.getSliceObjectID(543);
        int s = theSlice.seriesID;
        IdentObj id = new IdentObj(nObjectID, s, theSlice.groupID);
        IBlackBox blackBox = this.assignSeriesColor(s, theSlice.groupID);
        Shape shape = this.createLeftShape(theSlice);
        id = id.changeMisc(2000 + theSlice.m_nSliceIdx);
        if (shape != null) {
            DrawFactory.createShape(this.getDrawContainer(), id, shape, blackBox, null, fIntensity);
        }
    }

    protected void drawSliceRightEdge(PieSliceObj theSlice) {
        double fIntensity = 0.6;
        int nObjectID = this.getSliceObjectID(543);
        int s = theSlice.seriesID;
        IdentObj id = new IdentObj(nObjectID, s, theSlice.groupID);
        IBlackBox blackBox = this.assignSeriesColor(s, theSlice.groupID);
        Shape shape = this.createRightShape(theSlice);
        id = id.changeMisc(3000 + theSlice.m_nSliceIdx);
        if (shape != null) {
            DrawFactory.createShape(this.getDrawContainer(), id, shape, blackBox, null, fIntensity);
        }
    }

    protected void drawSliceRing(PieSliceObj theSlice) {
        if (this.m_fRingPct > 0.0) {
            double fIntensity = 0.6;
            int nObjectID = this.getSliceObjectID(543);
            int s = theSlice.seriesID;
            IdentObj id = new IdentObj(nObjectID, s, theSlice.groupID);
            IBlackBox blackBox = this.assignSeriesColor(s, theSlice.groupID);
            Rectangle r = theSlice.m_arcRing.getBounds();
            r.grow(0, this.m_nThickOffset / 2);
            r.setLocation(r.x, r.y - this.m_nThickOffset / 2);
            blackBox.setAnchorRect(this.m_Perspective.getVC().virtToDest(r));
            Shape ringShape = this.createRingShape(theSlice);
            id = id.changeMisc(5000 + theSlice.m_nSliceIdx);
            if (ringShape != null) {
                DrawFactory.createShape(this.getDrawContainer(), id, ringShape, blackBox, null, fIntensity);
            }
        }
    }

    protected void drawSliceTop(PieSliceObj theSlice) {
        int nObjectID = this.getSliceObjectID(542);
        int s = theSlice.seriesID;
        IdentObj id = new IdentObj(nObjectID, s, theSlice.groupID);
        IBlackBox blackBox = this.assignSeriesColor(s, theSlice.groupID);
        blackBox.setAnchorRect(this.m_Perspective.getVC().virtToDest(theSlice.m_arcCrust.getBounds()));
        Shape topShape = this.createTopShape(theSlice);
        id = id.changeMisc(1000 + theSlice.m_nSliceIdx);
        if (topShape != null) {
            DrawFactory.createShape(this.getDrawContainer(), id, topShape, blackBox);
        }
    }

    @Override
    public double getGroupTotal(int g) {
        double fGroupTotal = 0.0;
        int nTotalZeroCount = 0;
        int nTotalNegativeCount = 0;
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            double fValue = this.getDataValue((int)s, (int)g).value;
            if (fValue > 0.0) {
                fGroupTotal += fValue;
                continue;
            }
            if (fValue == 0.0) {
                ++nTotalZeroCount;
                continue;
            }
            if (!(fValue < 0.0)) continue;
            ++nTotalNegativeCount;
        }
        return fGroupTotal;
    }

    public double getSumTotal() {
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = GroupsEnumerator.getIterator(this.m_Perspective, this.getDataView());
        double fPosSum = 0.0;
        while (sEnum.hasNext()) {
            int s = sEnum.next();
            assert (s >= 0 && s < this.m_nTotalSeries);
            gEnum.reset();
            while (gEnum.hasNext()) {
                int g = gEnum.next();
                assert (g >= 0 && g < this.m_nTotalGroups);
                double fValue = this.getDataValue((int)s, (int)g).value;
                if (!(fValue > 0.0)) continue;
                fPosSum += fValue;
            }
        }
        return fPosSum;
    }

    protected double getPieRotation() {
        double fPieRotAngle = (double)this.m_Perspective.getPieRotate() / 360.0;
        return fPieRotAngle;
    }

    public Rectangle getIndividualPieRect() {
        return this.m_rSubFrame;
    }

    public int getTitleWidth() {
        return (int)((double)this.getIndividualPieRect().width / 1.2);
    }

    protected int getSliceObjectID(int nDefaultID) {
        return nDefaultID;
    }

    protected boolean isPieBarSliceOK() {
        return false;
    }

    private List<SeriesOrderingInfo> sortSeries(int nGroup) {
        ArrayList<SeriesOrderingInfo> sortedSeries = new ArrayList<SeriesOrderingInfo>();
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        while (sEnum.hasNext()) {
            int nSeries = sEnum.next();
            double fValue = this.getDataValue((int)nSeries, (int)nGroup).value;
            SeriesOrderingInfo info = new SeriesOrderingInfo();
            info.nSeriesID = nSeries;
            info.fSlicePct = fValue / this.m_fPieTotal;
            sortedSeries.add(info);
        }
        return sortedSeries;
    }

    private List<SeriesOrderingInfo> orderSeriesForPie(int nGroup) {
        List<SeriesOrderingInfo> sortedList = this.sortSeries(nGroup);
        return sortedList;
    }

    @Override
    public Format getTextFormat() {
        return this.m_SliceValueLabelTextFormat;
    }

    protected class Clump {
        public double max = 0.0;
        public double min = 0.0;
        public List<PieSliceObj> slices = new ArrayList<PieSliceObj>();

        public Clump(PieSliceObj s) {
            this.slices.add(s);
            this.calc();
        }

        protected void calc() {
            double targetY = 0.0;
            double totalHeight = 0.0;
            for (PieSliceObj s : this.slices) {
                targetY += (double)s.m_ptFeelerJoint.y;
                totalHeight += (double)(s.getLabelHeight() + 500);
            }
            this.max = (targetY /= (double)this.slices.size()) + totalHeight / 2.0;
            this.min = targetY - totalHeight / 2.0;
            if (this.max > JChart_2D_Pie.this.m_rMaxLabelsBound.getMaxY()) {
                this.min -= this.max - JChart_2D_Pie.this.m_rMaxLabelsBound.getMaxY();
                this.max = JChart_2D_Pie.this.m_rMaxLabelsBound.getMaxY();
            }
            if (this.min < JChart_2D_Pie.this.m_rMaxLabelsBound.getMinY()) {
                this.max += JChart_2D_Pie.this.m_rMaxLabelsBound.getMinY() - this.min;
                this.min = JChart_2D_Pie.this.m_rMaxLabelsBound.getMinY();
            }
        }

        public void mergeWith(Clump other) {
            this.slices.addAll(other.slices);
            Collections.sort(this.slices, new PieSliceObj.HeightComparator());
            this.calc();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ClumpList {
        public List<Clump> clumps = new ArrayList<Clump>();

        public ClumpList(List<PieSliceObj> slices) {
            for (PieSliceObj s : slices) {
                this.clumps.add(new Clump(s));
            }
        }

        protected void mergeOverlapping() {
            Clump prevClump = null;
            ArrayList<Clump> newClumps = new ArrayList<Clump>();
            boolean isFinished = true;
            for (Clump clump : this.clumps) {
                if (prevClump != null && JChart_2D_Pie.this.hasOverlap(prevClump.max, prevClump.min, clump.max, clump.min)) {
                    prevClump.mergeWith(clump);
                    isFinished = false;
                    continue;
                }
                if (prevClump != null) {
                    newClumps.add(prevClump);
                }
                prevClump = clump;
            }
            if (prevClump != null) {
                newClumps.add(prevClump);
            }
            this.clumps = newClumps;
            if (!isFinished) {
                this.mergeOverlapping();
            }
        }

        public void calc() {
            this.mergeOverlapping();
            for (Clump clump : this.clumps) {
                JChart_2D_Pie.this.setLabelRects(clump.slices, clump.max - 250.0, 500.0);
            }
        }
    }

    class SeriesOrderingInfo {
        int nSeriesID;
        double fSlicePct;

        SeriesOrderingInfo() {
        }
    }
}

