/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.common.gauges.GaugeFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.common.gauges.IGauge;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.AxisTemplate;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.GroupsEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.PerspectiveBase;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.SeriesEnumerator;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.data.DatumObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.TextUtil;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngine;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.IChartEngineFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.JChart_2D;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.MinMaxObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.Scaling;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.SubFrameObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.AxisFactory;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.engine.axis.INumericAxis;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.IStandardDraw;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.StandardDrawPFJ;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.Identity;
import java.awt.Dimension;
import java.awt.Rectangle;

class JChart_2D_Gauge
extends JChart_2D {
    private IGauge[] m_Gauges = null;
    private IStandardDraw m_StdDraw = null;
    public static final IChartEngineFactory engineFactory = new IChartEngineFactory(){

        public IChartEngine createChartEngine(Perspective perspective) {
            return new JChart_2D_Gauge(perspective);
        }
    };

    private JChart_2D_Gauge(Perspective perspective) {
        super(perspective);
    }

    public void calc() {
        int g;
        super.calc();
        boolean bWantOffScreen = !PerspectiveBase.isHeadless();
        this.m_StdDraw = new StandardDrawPFJ(bWantOffScreen, this.m_Perspective);
        this.m_Gauges = new IGauge[this.m_nGroups];
        int type = 1;
        for (int g2 = 0; g2 < this.m_nGroups; ++g2) {
            this.m_Gauges[g2] = this.makeGauge(type);
        }
        Scaling scaleNew = new Scaling(this.m_Perspective, this.m_nTotalSeries, this.m_nTotalGroups, this.m_axisAssignments, this.m_depth2D, this);
        MinMaxObj minMaxObj = scaleNew.findLimits(0, 1, this.m_Perspective.getY1MustIncludeZero(), null, this.getDataView().getDataFormat());
        boolean isAscending = !this.m_Perspective.getY1AxisDescending();
        int axisSide = this.m_Perspective.getY1AxisSide();
        INumericAxis axis2DObj = AxisFactory.create2DNumericAxis(this.m_Perspective, this.m_Perspective.getAccess(), AxisTemplate.Y1_AXIS, minMaxObj, false, isAscending, axisSide, 100, true);
        double max = axis2DObj.getMaxValue();
        double min = axis2DObj.getMinValue();
        double step = axis2DObj.getStepValue();
        SeriesEnumerator sEnum = this.getResetSeriesEnumerator();
        GroupsEnumerator gEnum = this.getResetGroupsEnumerator();
        Rectangle rGauge = this.m_Perspective.getRect(Identity.Frame);
        SubFrameObj subFrameObj = JChart_2D_Gauge.divideIntoSubFrames(rGauge, this.m_nGroups, this.m_Perspective.getPiesPerRow());
        Dimension maxGroupLabelDimDC = new Dimension(0, 0);
        while (gEnum.hasNext()) {
            g = gEnum.next();
            Rectangle rSubFrame = JChart_2D_Gauge.placeRect(rGauge, subFrameObj, g);
            Dimension textDimDC = TextUtil.getTextDimensionDC(this.m_Perspective, this.m_Perspective.getGaugeTitle(), this.m_Perspective.getGroupLabel(g), rSubFrame.getSize());
            maxGroupLabelDimDC.width = Math.max(textDimDC.width, maxGroupLabelDimDC.width);
            maxGroupLabelDimDC.height = Math.max(textDimDC.height, maxGroupLabelDimDC.height);
        }
        gEnum.reset();
        while (gEnum.hasNext()) {
            g = gEnum.next();
            assert (g >= 0 && g < this.m_nTotalGroups);
            int gRel = gEnum.getRelative(g);
            IGauge gauge = this.m_Gauges[gRel];
            gauge.setNumSeries(sEnum.size());
            sEnum.reset();
            while (sEnum.hasNext()) {
                int s = sEnum.next();
                DatumObj dObj = this.getDataValue(s, g);
                double datavalue = dObj.m_bOK ? dObj.value : Double.NaN;
                gauge.setValue(datavalue, s);
            }
            String name = this.m_Perspective.getGroupLabel(g);
            if (this.m_StdDraw instanceof StandardDrawPFJ) {
                ((StandardDrawPFJ)this.m_StdDraw).setGroupID(g);
            }
            gauge.setTitle(name);
            gauge.setTitleBoundingBoxDimensionDC(maxGroupLabelDimDC);
            gauge.setScaleMin(min);
            gauge.setScaleMax(max);
            gauge.setScaleStep(step);
            gauge.setAutoScaleStep(false);
            IdentObj[] bands = new IdentObj[]{this.m_Perspective.getGaugeBand1(), this.m_Perspective.getGaugeBand2(), this.m_Perspective.getGaugeBand3(), this.m_Perspective.getGaugeBand4(), this.m_Perspective.getGaugeBand5()};
            for (int i = 0; i < bands.length; ++i) {
                gauge.setQualityBandMinMax(i, this.m_Perspective.getGaugeBandMin(bands[i]), this.m_Perspective.getGaugeBandMax(bands[i]));
            }
            gauge.setTitlePosition(this.m_Perspective.getGaugeTitlePosition());
            Rectangle rSubFrame = JChart_2D_Gauge.placeRect(rGauge, subFrameObj, gRel);
            gauge.calc(rSubFrame);
        }
    }

    private IGauge makeGauge(int type) throws IllegalArgumentException {
        IGauge gauge = GaugeFactory.createFullCircularGauge(this.m_Perspective.getGaugeLook(), this.m_StdDraw);
        return gauge;
    }

    public static SubFrameObj divideIntoSubFrames(Rectangle rGauge, int nGroups, int pprSetting) {
        int nNumRowsY;
        int nNumColsX = pprSetting;
        if (nNumColsX == 0) {
            nNumColsX = (int)Math.sqrt(nGroups);
            if (rGauge.width < (int)((double)rGauge.height * 0.2) && nNumColsX > 1) {
                --nNumColsX;
            }
            if (rGauge.width < (int)((double)rGauge.height * 0.4) && nNumColsX > 1) {
                --nNumColsX;
            }
            if (rGauge.width > (int)((double)rGauge.height * 1.1)) {
                ++nNumColsX;
            }
            if (rGauge.width > (int)((double)rGauge.height * 2.3)) {
                ++nNumColsX;
            }
            if (nNumColsX < 1) {
                nNumColsX = 1;
            }
        }
        if (nNumColsX > nGroups) {
            nNumRowsY = 1;
            nNumColsX = nGroups;
        } else {
            nNumRowsY = (nGroups - 1) / nNumColsX + 1;
        }
        if (nNumColsX == 0 || nNumRowsY == 0) {
            return new SubFrameObj(rGauge.getSize(), Math.max(1, nNumRowsY), Math.max(1, nNumColsX));
        }
        Dimension subFrameDim = new Dimension(rGauge.width / nNumColsX, rGauge.height / nNumRowsY);
        return new SubFrameObj(subFrameDim, nNumRowsY, nNumColsX);
    }

    public static Rectangle placeRect(Rectangle rGauge, SubFrameObj sfo, int g) {
        Rectangle r = new Rectangle(rGauge.x, rGauge.y, rGauge.width, rGauge.height);
        if (sfo.m_nNumCols > 1) {
            r.width /= sfo.m_nNumCols;
            r.x += g % sfo.m_nNumCols * r.width;
        }
        if (sfo.m_nNumRows > 1) {
            r.height /= sfo.m_nNumRows;
            int row = g / sfo.m_nNumCols;
            r.y += (sfo.m_nNumRows - row - 1) * r.height;
        }
        return r;
    }
}

