/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.common.metafile.MetafileParserRegistry;
import com.businessobjects.visualization.pfjgraphics.rendering.common.metafile.MetafileRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillObj;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.FillSfxObj;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class FillTextureObj
extends FillSfxObj {
    public static final int DISPLAY_TILE = 0;
    public static final int DISPLAY_STRETCH = 1;
    public static final int PGSDK_SCALE2FIT = 2;
    public static final int FLIP_NORMAL = 0;
    public static final int FLIP_VERTICAL = 1;
    public static final int FLIP_HORIZONTAL = 2;
    public static final int FLIP_BOTH = 3;
    public static final int ROTATION_NONE = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private int m_nTilingMode;
    private int m_nFlippingMode;
    private int m_nRotation;
    private transient Image m_Texture;
    private transient MetafileRenderer m_Metafile;
    private Color m_colorBackground;

    FillTextureObj() {
        this.m_nTilingMode = 0;
        this.m_nFlippingMode = 0;
        this.m_nRotation = 0;
        this.m_Texture = null;
        this.m_colorBackground = null;
    }

    FillTextureObj(Image texture, int nTilingMode, int nFlippingMode, int nRotation) {
        this.m_nTilingMode = nTilingMode;
        this.m_nFlippingMode = nFlippingMode;
        this.m_nRotation = nRotation;
        this.m_Texture = texture;
        this.m_colorBackground = null;
    }

    FillTextureObj(Image texture, int nTilingMode, int nFlippingMode, int nRotation, Color aColor) {
        this.m_nTilingMode = nTilingMode;
        this.m_nFlippingMode = nFlippingMode;
        this.m_nRotation = nRotation;
        this.m_Texture = texture;
        this.m_colorBackground = aColor;
    }

    public FillTextureObj(byte[] metafileData, int nFlippingMode) {
        try {
            this.m_Metafile = MetafileParserRegistry.getMetafileParser().parse(metafileData);
        }
        catch (Exception e) {
            this.m_Metafile = null;
        }
        this.m_nFlippingMode = nFlippingMode;
    }

    public Image getTexture() {
        return this.m_Texture;
    }

    public void copy(FillObj fo) {
        this.m_nTilingMode = ((FillTextureObj)fo).m_nTilingMode;
        this.m_nFlippingMode = ((FillTextureObj)fo).m_nFlippingMode;
        this.m_nRotation = ((FillTextureObj)fo).m_nRotation;
        this.m_Texture = ((FillTextureObj)fo).m_Texture;
        this.m_colorBackground = ((FillTextureObj)fo).m_colorBackground;
        this.m_Metafile = ((FillTextureObj)fo).m_Metafile;
    }

    public boolean equals(Object obj) {
        boolean bEqual;
        if (obj instanceof FillTextureObj) {
            FillTextureObj fto = (FillTextureObj)obj;
            boolean bl = bEqual = this.m_nTilingMode == fto.m_nTilingMode && this.m_nFlippingMode == fto.m_nFlippingMode && this.m_nRotation == fto.m_nRotation;
            if (bEqual) {
                if (this.m_Texture == null != (fto.m_Texture == null)) {
                    bEqual = false;
                }
                if (this.m_Texture != null && fto.m_Texture != null && !this.m_Texture.equals(fto.m_Texture)) {
                    bEqual = false;
                }
            }
        } else {
            bEqual = false;
        }
        return bEqual;
    }

    protected void fillSfxRect(Graphics2D g, int x, int y, int width, int height) {
        boolean bImageReady = false;
        if (this.m_Metafile != null) {
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            int xFlip = this.m_nFlippingMode == 2 || this.m_nFlippingMode == 3 ? -1 : 1;
            int yFlip = this.m_nFlippingMode == 1 || this.m_nFlippingMode == 3 ? -1 : 1;
            g.translate(xFlip == -1 ? width : 0, yFlip == -1 ? height : 0);
            g.scale(xFlip, yFlip);
            this.m_Metafile.render(g, new Rectangle(x, y, width, height));
            return;
        }
        int imgHeight = this.m_Texture.getHeight(null);
        int imgWidth = this.m_Texture.getWidth(null);
        if (this.m_nTilingMode == 0) {
            for (int i = 0; i < width; i += imgWidth) {
                int j = 0;
                block1: while (j < height) {
                    for (int l = 0; l < 10000; ++l) {
                        if (this.m_nFlippingMode == 0) {
                            bImageReady = g.drawImage(this.m_Texture, i, j, imgWidth, imgHeight, this.m_colorBackground, null);
                        } else if (this.m_nFlippingMode == 1) {
                            bImageReady = g.drawImage(this.m_Texture, i, j, i + imgWidth, j + imgHeight, 0, imgHeight, imgWidth, 0, this.m_colorBackground, null);
                        } else if (this.m_nFlippingMode == 2) {
                            bImageReady = g.drawImage(this.m_Texture, i, j, i + imgWidth, j + imgHeight, imgHeight, 0, 0, imgWidth, this.m_colorBackground, null);
                        } else if (this.m_nFlippingMode == 3) {
                            bImageReady = g.drawImage(this.m_Texture, i, j, i + imgWidth, j + imgHeight, imgWidth, imgHeight, 0, 0, this.m_colorBackground, null);
                        }
                        if (!bImageReady) continue;
                        j += imgHeight;
                        continue block1;
                    }
                }
            }
        } else {
            boolean b = false;
            do {
                if (this.m_nFlippingMode == 0) {
                    b = g.drawImage(this.m_Texture, x, y, width, height, this.m_colorBackground, null);
                    continue;
                }
                if (this.m_nFlippingMode == 1) {
                    b = g.drawImage(this.m_Texture, x, y, x + width, y + height, y, y + imgHeight, x + imgWidth, x, this.m_colorBackground, null);
                    continue;
                }
                if (this.m_nFlippingMode == 2) {
                    b = g.drawImage(this.m_Texture, x, y, x + width, y + height, y + imgHeight, y, x, x + imgWidth, this.m_colorBackground, null);
                    continue;
                }
                if (this.m_nFlippingMode != 3) continue;
                b = g.drawImage(this.m_Texture, x, y, x + width, y + height, x + imgWidth, y + imgHeight, x, y, this.m_colorBackground, null);
            } while (!b);
        }
    }
}

