/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.BlackBoxRenderer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetLabel;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetOval;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetPolygon;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetRect;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.DetShape;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawObject;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ITextStyle;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;

public final class DrawFactory {
    private DrawFactory() {
    }

    public static IDrawObject createLabel(IDrawContainer container, IdentObj idLabelIndex, String strText, Rectangle labelVC, ITextStyle ts, IBlackBox bb) {
        return new DetLabel(container, idLabelIndex, strText, labelVC, ts, bb, null);
    }

    public static IDrawObject createLabel(IDrawContainer container, IdentObj id, String szText, Rectangle rBoundsVC, ITextStyle textStyle, IBlackBox blackBox, Rectangle rClipVC) {
        return new DetLabel(container, id, szText, rBoundsVC, textStyle, blackBox, rClipVC);
    }

    public static IDrawObject createOval(IDrawContainer container, IdentObj id, int x, int y, int width, int height, IBlackBox box, Rectangle bounds, boolean bNoFill, double lineWidth) {
        return new DetOval(container, id, x, y, width, height, box, bounds, bNoFill, lineWidth);
    }

    public static IDrawObject createOval(IDrawContainer container, IdentObj id, int x, int y, int width, int height, IBlackBox blackBox, Rectangle clipRect, boolean bNoFill) {
        return new DetOval(container, id, x, y, width, height, blackBox, clipRect, bNoFill);
    }

    public static IDrawObject createOval(IDrawContainer container, IdentObj id, Rectangle r, IBlackBox blackBox, Rectangle clipRect) {
        return new DetOval(container, id, r, blackBox, clipRect);
    }

    public static IDrawObject createOval(IDrawContainer container, IdentObj id, int x, int y, int width, int height, IBlackBox blackBox) {
        return new DetOval(container, id, x, y, width, height, blackBox);
    }

    public static IDrawObject createShape(IDrawContainer container, IdentObj id, Shape shapeVC, IBlackBox blackBox) {
        return new DetShape(container, id, shapeVC, blackBox, null);
    }

    public static IDrawObject createShape(IDrawContainer container, IdentObj id, Shape shapeVC, IBlackBox blackBox, Rectangle clipRect, double fIntensity) {
        return new DetShape(container, id, shapeVC, blackBox, clipRect, fIntensity);
    }

    public static IDrawObject createShape(IDrawContainer container, IdentObj id, Shape shapeVC, IBlackBox blackBox, Rectangle clipRect, BlackBoxRenderer renderer) {
        return new DetShape(container, id, shapeVC, blackBox, clipRect, renderer);
    }

    public static IDrawObject createPolygon(IDrawContainer container, IdentObj id, Polygon poly, IBlackBox blackBox, Rectangle clipRect) {
        return new DetPolygon(container, id, poly, blackBox, clipRect);
    }

    public static IDrawObject createPolygon(IDrawContainer container, IdentObj id, Polygon poly, IBlackBox blackBox, Rectangle clipRect, double fIntensity) {
        return new DetPolygon(container, id, poly, blackBox, clipRect, fIntensity);
    }

    public static IDrawObject createPolygon(IDrawContainer container, IdentObj id, Polygon poly, IBlackBox blackBox, double fIntensity) {
        return new DetPolygon(container, id, poly, blackBox, fIntensity);
    }

    public static IDrawObject createRectangle(IDrawContainer container, IdentObj id, IBlackBox blackBox, int x, int y, int width, int height) {
        return new DetRect(container, id, x, y, width, height, blackBox);
    }

    public static IDrawObject createRectangle(IDrawContainer container, IdentObj id, IBlackBox blackBox, int x, int y, int width, int height, boolean bDotted) {
        return new DetRect(container, id, x, y, width, height, blackBox, bDotted);
    }

    public static IDrawObject createRectangle(IDrawContainer container, IdentObj id, Rectangle r, IBlackBox blackBox, Rectangle clipRect) {
        return new DetRect(container, id, r, blackBox, clipRect);
    }

    public static IDrawObject createRectangle(IDrawContainer container, IdentObj id, int x, int y, int width, int height, IBlackBox blackBox, Rectangle clipRect) {
        return new DetRect(container, id, x, y, width, height, blackBox, clipRect);
    }
}

