/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.Perspective;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.VC;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.Detectiv;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.ExceptionalRiser;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IBlackBox;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawContainer;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.draw.IDrawObject;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public abstract class DetObj
implements IDrawObject {
    static final int SLOPE_THICKNESS = 5;
    private IdentObj objId;
    IBlackBox blackBox;
    final Rectangle clipRect;

    protected DetObj(IDrawContainer container, IdentObj id, IBlackBox blackBox, Rectangle clipRect) {
        assert (container != null);
        this.objId = id;
        this.blackBox = blackBox;
        this.clipRect = clipRect;
        Perspective persp = ((Detectiv)container).getPerspective();
        if (ExceptionalRiser.isExceptionalObject(persp, id)) {
            this.blackBox = ExceptionalRiser.createExceptionBlackBox(persp, id, blackBox);
            this.objId = ExceptionalRiser.createExceptionIdentObj(persp, id);
        }
        if (this.blackBox != null && this.objId != null) {
            this.blackBox.setRenderingTweaks(this.objId);
        }
        container.add(this);
    }

    protected DetObj(IDrawContainer container, IdentObj id, IBlackBox blackBox) {
        this(container, id, blackBox, null);
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        DetObj otherObject = (DetObj)obj;
        return this.objId.equals(otherObject.objId);
    }

    public int hashCode() {
        return this.objId.hashCode();
    }

    public IdentObj getIdentID() {
        return this.objId;
    }

    public void paint(Graphics2D g, VC vc) {
        this.paintIt(g, vc);
    }

    abstract void hilite(Graphics2D var1, VC var2);

    protected abstract void paintIt(Graphics2D var1, VC var2);
}

