/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.IAutoScale;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.charting.engine.MinMaxStep;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.GFP;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.math.MinMax;

public class AutoScaleBase
implements IAutoScale {
    public static final double AUTO_SPREAD_FACTOR = 1.05;
    protected boolean m_bAutoScaleMin;
    protected boolean m_bAutoScaleMax;
    protected boolean m_bAutoScaleStep;
    protected double m_dManualStep;
    protected boolean m_bLog;
    protected double m_dLogBase;

    public AutoScaleBase(boolean bAutoScaleMin, boolean bAutoScaleMax, boolean bAutoScaleStep, double dManualStep) {
        this.m_bAutoScaleMin = bAutoScaleMin;
        this.m_bAutoScaleMax = bAutoScaleMax;
        this.m_bAutoScaleStep = bAutoScaleStep;
        this.m_dManualStep = dManualStep;
        this.m_bLog = false;
        this.m_dLogBase = 10.0;
    }

    public AutoScaleBase(boolean bAutoScaleMin, boolean bAutoScaleMax, boolean bAutoScaleStep, double dManualStep, boolean bLog, double dLogBase) {
        this.m_bAutoScaleMin = bAutoScaleMin;
        this.m_bAutoScaleMax = bAutoScaleMax;
        this.m_bAutoScaleStep = bAutoScaleStep;
        this.m_dManualStep = dManualStep;
        this.m_bLog = bLog;
        this.m_dLogBase = dLogBase;
    }

    public MinMaxStep findNiceLimits(MinMax mmRaw) {
        double dMax;
        if (mmRaw == null || !mmRaw.isValid()) {
            if (this.m_bLog) {
                return new MinMaxStep(1.0, 10.0, Math.sqrt(10.0));
            }
            return new MinMaxStep(0.0, 50.0, 10.0);
        }
        double dMin = mmRaw.getMin();
        if (dMin == (dMax = mmRaw.getMax())) {
            if (dMin == 0.0) {
                dMax = 1.0;
            } else {
                dMin /= 1.05;
                dMax *= 1.05;
            }
        }
        if (!(this.m_bAutoScaleMin || this.m_bAutoScaleMax || this.m_bAutoScaleStep)) {
            return new MinMaxStep(mmRaw, this.m_dManualStep);
        }
        double dNiceStep = this.m_dManualStep;
        if (this.m_bAutoScaleStep) {
            double dSpread = dMax - dMin;
            double dMultiplier = this.calcMultiplier(dSpread);
            int nFirst2Digits = (int)(dSpread / dMultiplier) - 1;
            int nScaleFactor = this.chooseScalingFactor(nFirst2Digits);
            dNiceStep = (double)nScaleFactor * dMultiplier;
        }
        double dNiceMin = dMin;
        double dNiceMax = dMax;
        if (this.m_bAutoScaleMin) {
            dNiceMin = Math.floor(dMin / dNiceStep) * dNiceStep;
        }
        if (this.m_bAutoScaleMax) {
            dNiceMax = Math.ceil(dMax / dNiceStep) * dNiceStep;
        }
        return new MinMaxStep(dNiceMin, dNiceMax, dNiceStep);
    }

    protected double calcMultiplier(double dSpread) {
        long nCommonLogSpread;
        double dCommonLogSpread = Math.log(dSpread) / Math.log(10.0);
        double dMultiplier = GFP.equal(dCommonLogSpread, nCommonLogSpread = Math.round(dCommonLogSpread)) ? Math.pow(10.0, (double)nCommonLogSpread - 2.0) : Math.pow(10.0, Math.floor(dCommonLogSpread) - 1.0);
        return dMultiplier;
    }

    protected int chooseScalingFactor(int nFirst2Digits) {
        assert (nFirst2Digits >= 1 && nFirst2Digits <= 99);
        int nScaleFactor = nFirst2Digits >= 9 && nFirst2Digits <= 19 ? 2 : (nFirst2Digits >= 20 && nFirst2Digits <= 39 ? 5 : (nFirst2Digits >= 40 && nFirst2Digits <= 74 ? 10 : (nFirst2Digits >= 75 && nFirst2Digits <= 99 ? 20 : 1)));
        return nScaleFactor;
    }
}

