/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.DataIterator;

abstract class DataEnumerator
implements DataIterator {
    private int[] indexArray;
    private int curPosition;

    DataEnumerator(int[] indexArray) {
        this.indexArray = indexArray;
        this.curPosition = 0;
    }

    DataEnumerator(DataEnumerator other) {
        this.indexArray = other.indexArray;
        this.curPosition = other.curPosition;
    }

    public int getLast() {
        return this.get(this.indexArray.length - 1);
    }

    public int size() {
        return this.indexArray.length;
    }

    public int getRelative(int absolute) {
        for (int i = 0; i < this.indexArray.length; ++i) {
            if (this.indexArray[i] != absolute) continue;
            return i;
        }
        return -1;
    }

    public boolean hasNext() {
        return this.curPosition < this.indexArray.length;
    }

    public int next() {
        return this.indexArray[this.curPosition++];
    }

    public int get(int index) {
        if (index < 0 || index >= this.indexArray.length) {
            return -1;
        }
        return this.indexArray[index];
    }

    public int peekNext() {
        return this.get(this.curPosition);
    }

    public int peekAfter(int absolute) {
        int index = this.getRelative(absolute);
        int sNext = -1;
        if (index >= 0) {
            sNext = this.get(index + 1);
        }
        return sNext;
    }

    public int peekBefore(int absolute) {
        int index = this.getRelative(absolute);
        int sNext = -1;
        if (index >= 1) {
            sNext = this.get(index - 1);
        }
        return sNext;
    }

    public void reset() {
        this.curPosition = 0;
    }
}

