/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.pfj;

import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.IdentObj;

public class AxisTemplate {
    public static final int kNOSKIP = 0;
    public static final int kAUTOSKIP = 1;
    public static final int kMANUALSKIP = 2;
    public static final int ID_NOAXIS = -1;
    public static final int ID_Y1 = 0;
    public static final int ID_Y2 = 1;
    public static final int ID_Y3 = 2;
    public static final int ID_Y4 = 3;
    public static final int ID_Y5 = 4;
    public static final int ID_O1 = 5;
    public static final int ID_O2 = 6;
    public static final int ID_X1 = 7;
    public static final int ID_Z1 = 8;
    private int m_nObjId;
    private IdentObj m_axis;
    private IdentObj m_body;
    private IdentObj m_label;
    private IdentObj m_labelBox;
    private IdentObj m_majorGrid;
    private IdentObj m_minorGrid;
    private IdentObj m_majorTick;
    private IdentObj m_minorTick;
    private IdentObj m_zeroLine;
    private IdentObj m_title;
    private IdentObj m_titleBox;
    private String m_displayString;
    public static final AxisTemplate O1_AXIS = new AxisTemplate(5, 2001, 513, 514, 646, 515, 516, 761, 762, -3, 8, 49, "O1 Axis");
    public static final AxisTemplate O2_AXIS = new AxisTemplate(6, 2002, 517, 518, 647, 519, 520, 763, 764, -3, 9, 50, "O2 Axis");
    public static final AxisTemplate X1_AXIS = new AxisTemplate(7, 2003, 523, 524, 648, 525, 526, 765, 766, 535, 10, 51, "X Axis");
    public static final AxisTemplate Y1_AXIS = new AxisTemplate(0, 2004, 527, 528, 649, 529, 530, 767, 768, 536, 6, 47, "Y1 Axis");
    public static final AxisTemplate Y2_AXIS = new AxisTemplate(1, 2005, 531, 532, 650, 533, 534, 769, 770, 537, 7, 48, "Y2 Axis");
    public static final AxisTemplate Z1_AXIS = new AxisTemplate(8, 2006, 567, 568, 818, 569, 570, 771, 772, 571, 11, 52, "Z Axis");
    public static final AxisTemplate Y3_AXIS = new AxisTemplate(2, 2012, 684, 685, 815, 686, 687, 773, 774, 688, 67, 68, "Y3 Axis");
    public static final AxisTemplate Y4_AXIS = new AxisTemplate(3, 2013, 689, 690, 816, 691, 692, 775, 776, 693, 69, 70, "Y4 Axis");
    public static final AxisTemplate Y5_AXIS = new AxisTemplate(4, 2014, 694, 695, 817, 696, 697, 777, 778, 698, 71, 72, "Y5 Axis");

    private AxisTemplate(int nId, int nAxis, int nBody, int nLabel, int nLabelBox, int nMajor, int nMinor, int nMajorTick, int nMinorTick, int nZero, int nTitle, int nTitleBox, String displayString) {
        this.m_nObjId = nId;
        this.m_axis = new IdentObj(nAxis);
        this.m_body = new IdentObj(nBody);
        this.m_displayString = displayString;
        this.m_label = nLabel == 514 ? new IdentObj(nLabel, -3, 0) : (nLabel == 518 ? new IdentObj(nLabel, 0, -3) : new IdentObj(nLabel));
        this.m_labelBox = new IdentObj(nLabelBox);
        this.m_majorGrid = new IdentObj(nMajor);
        this.m_minorGrid = new IdentObj(nMinor);
        this.m_majorTick = new IdentObj(nMajorTick);
        this.m_minorTick = new IdentObj(nMinorTick);
        this.m_zeroLine = new IdentObj(nZero);
        this.m_title = new IdentObj(nTitle);
        this.m_titleBox = new IdentObj(nTitleBox);
    }

    public final IdentObj getAxis() {
        return this.m_axis;
    }

    public int getAxisObjID() {
        return this.m_nObjId;
    }

    public final IdentObj getBody() {
        return this.m_body;
    }

    public final IdentObj getLabel() {
        return this.m_label;
    }

    public final IdentObj getLabelBox() {
        return this.m_labelBox;
    }

    public final IdentObj getMajor() {
        return this.m_majorGrid;
    }

    public final IdentObj getMinor() {
        return this.m_minorGrid;
    }

    public final IdentObj getMajorTick() {
        return this.m_majorTick;
    }

    public final IdentObj getMinorTick() {
        return this.m_minorTick;
    }

    public final IdentObj getTitle() {
        return this.m_title;
    }

    public final IdentObj getTitleBox() {
        return this.m_titleBox;
    }

    public final IdentObj getZeroLine() {
        return this.m_zeroLine;
    }

    public String getDisplayString() {
        return this.m_displayString;
    }

    public final boolean isNumeric() {
        return this.m_body.getObjectID() != 513 && this.m_body.getObjectID() != 517;
    }

    public static boolean isSameType(int assocAxis, int axis) {
        boolean bSameType = assocAxis == axis;
        bSameType |= assocAxis == 0 && axis == 1;
        bSameType |= assocAxis == 1 && axis == 0;
        bSameType |= assocAxis == 5 && axis == 6;
        bSameType |= assocAxis == 6 && axis == 5;
        switch (axis) {
            case 2: 
            case 3: 
            case 4: {
                bSameType = true;
            }
        }
        return bSameType;
    }
}

