/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.common.math;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueListFactory {
    public static final int STEP_FROM_QUANTIZED_BOTTOM = 0;
    public static final int STEP_FROM_BOTTOM = 1;
    public static final int STEP_FROM_TOP = 2;
    public static final int DEFAULT_STEP_ORIGIN = 0;

    private ValueListFactory() {
    }

    public static List<Double> makeValueList(double dMin, double dMax, double dMajorStep, double dMinorStep, int nStepOrigin, boolean bCalcMajor) throws IllegalArgumentException {
        if (dMajorStep <= 0.0 || dMinorStep <= 0.0) {
            throw new IllegalArgumentException("ValueListFactory.makeValueList: dStep must be > 0");
        }
        if (dMax < dMin) {
            throw new IllegalArgumentException("ValueListFactory.makeValueList: dMax must be >= dMin");
        }
        ArrayList<Double> valuesList = new ArrayList<Double>();
        switch (nStepOrigin) {
            case 0: {
                throw new RuntimeException("Not implemented correctly!! Fixme if you plan to use it.");
            }
            case 1: {
                for (double majorValue = dMin; majorValue <= dMax; majorValue += dMajorStep) {
                    if (bCalcMajor) {
                        valuesList.add(new Double(majorValue));
                        continue;
                    }
                    for (double minorValue = majorValue + dMinorStep; minorValue < majorValue + dMajorStep && minorValue < dMax; minorValue += dMinorStep) {
                        valuesList.add(new Double(minorValue));
                    }
                }
                break;
            }
            case 2: {
                throw new RuntimeException("Not implemented correctly!! Fixme if you plan to use it.");
            }
            default: {
                throw new IllegalArgumentException("ValueListFactory.makeValueList: unknown nStepOrigin = " + nStepOrigin);
            }
        }
        if (!valuesList.contains(new Double(dMax)) && bCalcMajor) {
            valuesList.add(new Double(dMax));
        }
        return valuesList;
    }
}

