/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.pfjgraphics.rendering.common.gauges;

import com.businessobjects.visualization.pfjgraphics.rendering.common.CheckParam;
import com.businessobjects.visualization.pfjgraphics.rendering.common.gauges.GaugeCircularBase;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.IStandardDraw;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.graphics.IStandardLook;
import com.businessobjects.visualization.pfjgraphics.rendering.pfj.properties.ObjectID;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Polygon;

class GaugeHalfCircle
extends GaugeCircularBase {
    protected GaugeHalfCircle(IStandardDraw stdDraw, IStandardLook stdLook, Object logger) {
        super(stdDraw, stdLook, null);
    }

    protected void initLook() {
        super.initLook();
        String[] bandObjects = new String[]{"GaugeBand1", "GaugeBand2", "GaugeBand3", "GaugeBand4", "GaugeBand5"};
        Object fillColorAttr = this.m_StdLook.getAttr("FillColor");
        Object borderColorAttr = this.m_StdLook.getAttr("BorderColor");
        for (int i = 0; i < bandObjects.length; ++i) {
            ObjectID bandObject = this.m_StdLook.getObjectID(bandObjects[i]);
            Object fillColorValue = this.m_StdLook.getAttrValue(bandObject, fillColorAttr);
            this.m_StdLook.setAttrValue(bandObject, borderColorAttr, fillColorValue);
        }
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeScaleArea"), this.m_StdLook.getAttr("Gauge.RelThickness"), new Double(0.25));
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeScaleArea"), this.m_StdLook.getAttr("Gauge.StartAngle"), new Double(150.0));
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeScaleArea"), this.m_StdLook.getAttr("Gauge.StopAngle"), new Double(30.0));
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeMinorGrid"), this.m_StdLook.getAttr("Gauge.RelTickLen"), new Double(0.05));
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeMajorGrid"), this.m_StdLook.getAttr("Gauge.RelTickLen"), new Double(0.09));
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeScaleArea"), this.m_StdLook.getAttr("Gauge.RelInnerRadius"), new Double(0.4));
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeGlass"), this.m_StdLook.getAttr("FillAlpha"), new Double(0.7));
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeGlass"), this.m_StdLook.getAttr("Visible"), Boolean.FALSE);
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeNeedle"), this.m_StdLook.getAttr("Shadow"), Boolean.TRUE);
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeNeedle"), this.m_StdLook.getAttr("Gauge.NeedleStyle"), new Integer(5));
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeArea"), this.m_StdLook.getAttr("Gauge.BackgroundStyle"), new Integer(1));
        this.m_StdLook.setAttrValue(this.m_StdLook.getObjectID("GaugeTrendPoint"), this.m_StdLook.getAttr("Visible"), Boolean.FALSE);
    }

    protected double getRelLabelPos() {
        return 0.76;
    }

    protected Point calcLabelPos(Point ptLabel, double dAngle, Dimension textDim, boolean bLabelIn) {
        Point ptText = new Point();
        ptText.x = ptLabel.x - textDim.width / 2;
        ptText.y = ptLabel.y - textDim.height / 2;
        return ptText;
    }

    protected GaugeCircularBase.ColorPolygon getNeedleColorPolygon(int nPolygon) {
        Integer nNeedleStyleObj = (Integer)this.m_StdLook.getAttrValue(this.m_StdLook.getObjectID("GaugeNeedle"), this.m_StdLook.getAttr("Gauge.NeedleStyle"));
        switch (nNeedleStyleObj) {
            case 0: {
                return this.getNeedleStyle0(nPolygon);
            }
            case 1: {
                return this.getNeedleStyle1(nPolygon);
            }
            case 2: {
                return this.getNeedleStyle2(nPolygon);
            }
            case 3: {
                return this.getNeedleStyle3(nPolygon);
            }
            case 4: {
                return this.getNeedleStyle4(nPolygon);
            }
            case 5: {
                return this.getNeedleStyle5(nPolygon);
            }
        }
        throw new RuntimeException("Invalid needle style " + nNeedleStyleObj);
    }

    protected Boolean getDropShadowObj(int nNeedleStyle) {
        switch (nNeedleStyle) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return null;
            }
            case 3: 
            case 5: {
                return Boolean.FALSE;
            }
        }
        throw new RuntimeException("Invalid needle style " + nNeedleStyle);
    }

    protected double getCenterCircleThickness(int nNeedleStyle) {
        switch (nNeedleStyle) {
            case 0: {
                return 0.04;
            }
            case 1: {
                return 0.07;
            }
            case 2: {
                return 0.05;
            }
            case 3: {
                return 0.05;
            }
            case 4: {
                return 0.07;
            }
            case 5: {
                return 0.04;
            }
        }
        throw new RuntimeException("Invalid needle style " + nNeedleStyle);
    }

    protected Color getCenterCircleColor(int nNeedleStyle) {
        switch (nNeedleStyle) {
            case 0: {
                return Color.black;
            }
            case 1: {
                return new Color(247, 156, 15);
            }
            case 2: {
                return Color.black;
            }
            case 3: {
                return Color.black;
            }
            case 4: {
                return Color.black;
            }
            case 5: {
                return Color.black;
            }
        }
        throw new RuntimeException("Invalid needle style " + nNeedleStyle);
    }

    protected Dimension getMetaSize() {
        return new Dimension(16000, 16000);
    }

    protected Point getCenter() {
        CheckParam.checkRectangle(this.m_rGauge);
        return new Point(this.m_rGauge.x + this.m_rGauge.width / 2, this.m_rGauge.y + this.m_rGauge.height / 2);
    }

    protected double getRadius() {
        CheckParam.checkRectangle(this.m_rGauge);
        return (double)this.m_rGauge.width / 2.0;
    }

    protected Polygon getGlassHilitePolygonStyle_1() {
        int[] xPoints = new int[]{5473, 5468, 5463, 5459, 5455, 5452, 5450, 5448, 5448, 5448, 5450, 5452, 5456, 5461, 5467, 5474, 5481, 5490, 5500, 5511, 5523, 5536, 5549, 5564, 5580, 5409, 5241, 5076, 4914, 4755, 4599, 4446, 4296, 4149, 4007, 3867, 3731, 3599, 3470, 3345, 3225, 3108, 2995, 2886, 2781, 2681, 2585, 2494, 2407, 2324, 2247, 2174, 2106, 2043, 1985, 1932, 1884, 1955, 2027, 2099, 2172, 2246, 2320, 2395, 2470, 2546, 2622, 2699, 2777, 2855, 2934, 3013, 3093, 3173, 3254, 3335, 3417, 3499, 3582, 3665, 3749, 3833, 3917, 4002, 4088, 4174, 4260, 4346, 4434, 4485, 4539, 4566, 4594, 4623, 4652, 4681, 4711, 4741, 4772, 4834, 4899, 4965, 5032, 5102, 5173, 5246, 5320, 5396, 5473};
        int[] yPoints = new int[]{3200, 3147, 3093, 3039, 2985, 2930, 2876, 2822, 2767, 2702, 2637, 2572, 2507, 2443, 2379, 2315, 2251, 2188, 2124, 2061, 1998, 1936, 1873, 1811, 1749, 1814, 1883, 1955, 2031, 2110, 2191, 2277, 2365, 2456, 2550, 2647, 2747, 2849, 2954, 3062, 3173, 3286, 3401, 3519, 3639, 3762, 3886, 4013, 4142, 4273, 4406, 4541, 4677, 4816, 4956, 5098, 5241, 5205, 5169, 5133, 5099, 5065, 5032, 4999, 4967, 4936, 4905, 4876, 4846, 4818, 4790, 4764, 4737, 4712, 4687, 4663, 4640, 4618, 4596, 4575, 4555, 4536, 4517, 4499, 4482, 4466, 4451, 4437, 4423, 4340, 4258, 4217, 4176, 4136, 4096, 4056, 4016, 3976, 3937, 3859, 3782, 3706, 3631, 3557, 3483, 3411, 3340, 3270, 3200};
        int nPoints = 109;
        return new Polygon(xPoints, yPoints, 109);
    }

    protected Polygon getGlassHilitePolygonStyle_2_1() {
        int[] xPoints = new int[]{4923, 4923, 4896, 4896, 4896, 4923, 4976, 5056, 5056, 4655, 4280, 3933, 3585, 3237, 2943, 2622, 2354, 2086, 1846, 1632, 1418, 1230, 1070, 936, 829, 829, 1150, 1498, 1846, 2193, 2568, 2943, 3344, 3745, 3745, 3986, 4254, 4575, 4923, 4923};
        int[] yPoints = new int[]{3264, 3264, 2622, 2622, 2220, 1846, 1471, 1096, 1096, 1284, 1498, 1765, 2006, 2301, 2595, 2916, 3237, 3585, 3933, 4307, 4682, 5083, 5511, 5913, 6341, 6341, 6127, 5939, 5752, 5591, 5458, 5324, 5217, 5110, 5110, 4628, 4147, 3692, 3264, 3264};
        int nPoints = 40;
        return new Polygon(xPoints, yPoints, 40);
    }

    protected Polygon getGlassHilitePolygonStyle_2_2() {
        int[] xPoints = new int[]{11585, 11585, 11585, 11585, 11585, 11505, 11505, 11959, 12414, 12816, 13163, 13458, 13725, 13939, 14100, 14100, 13698, 13244, 12789, 12307, 12307, 12147, 11986, 11799, 11585, 11585};
        int[] yPoints = new int[]{12816, 12816, 13217, 13217, 13698, 14153, 14153, 13913, 13591, 13244, 12842, 12414, 11933, 11451, 10916, 10916, 11183, 11397, 11558, 11692, 11692, 11986, 12280, 12548, 12816, 12816};
        int nPoints = 26;
        return new Polygon(xPoints, yPoints, 26);
    }

    private GaugeCircularBase.ColorPolygon getNeedleStyle0(int nPolygon) {
        switch (nPolygon) {
            case 0: {
                int[] xPoints = new int[]{700, 8000, 8000, 700};
                int[] yPoints = new int[]{8100, 8100, 7900, 7900};
                int nPoints = 4;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 4);
                colorPoly.m_BorderColor = Color.black;
                colorPoly.m_FillColor = Color.black;
                return colorPoly;
            }
        }
        this.logUnknownPolyForStyle(nPolygon, " for needle style ", 0);
        return null;
    }

    private GaugeCircularBase.ColorPolygon getNeedleStyle1(int nPolygon) {
        switch (nPolygon) {
            case 0: {
                int[] xPoints = new int[]{1364, 7598, 7598, 1364, 1364};
                int[] yPoints = new int[]{8401, 8401, 8000, 8000, 8401};
                int nPoints = 5;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 5);
                colorPoly.m_BorderColor = new Color(246, 122, 17);
                colorPoly.m_FillColor = new Color(246, 122, 17);
                return colorPoly;
            }
            case 1: {
                int[] xPoints = new int[]{187, 1364, 1364, 187};
                int[] yPoints = new int[]{8000, 8401, 8000, 8000};
                int nPoints = 4;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 4);
                colorPoly.m_BorderColor = new Color(246, 122, 17);
                colorPoly.m_FillColor = new Color(247, 156, 15);
                return colorPoly;
            }
            case 2: {
                int[] xPoints = new int[]{1364, 1364, 7598, 7598, 1364};
                int[] yPoints = new int[]{7598, 8000, 8000, 7598, 7598};
                int nPoints = 5;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 5);
                colorPoly.m_BorderColor = new Color(246, 122, 17);
                colorPoly.m_FillColor = new Color(247, 156, 15);
                return colorPoly;
            }
            case 3: {
                int[] xPoints = new int[]{1364, 187, 1364, 1364};
                int[] yPoints = new int[]{7598, 8000, 8000, 7598};
                int nPoints = 4;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 4);
                colorPoly.m_BorderColor = new Color(246, 122, 17);
                colorPoly.m_FillColor = new Color(248, 230, 22);
                return colorPoly;
            }
        }
        this.logUnknownPolyForStyle(nPolygon, " for needle style ", 1);
        return null;
    }

    private GaugeCircularBase.ColorPolygon getNeedleStyle2(int nPolygon) {
        switch (nPolygon) {
            case 0: {
                int[] xPoints = new int[]{695, 1391, 8000, 8000, 1391, 695};
                int[] yPoints = new int[]{8000, 8374, 8160, 7866, 7625, 8000};
                int nPoints = 6;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 6);
                colorPoly.m_BorderColor = new Color(54, 54, 54);
                colorPoly.m_FillColor = new Color(54, 54, 54);
                return colorPoly;
            }
            case 1: {
                int[] xPoints = new int[]{1391, 1391, 775, 775, 1391, 1391, 6474, 6474, 6474, 1391, 1391};
                int[] yPoints = new int[]{7678, 7678, 8000, 8000, 8321, 8321, 8160, 7839, 7839, 7678, 7678};
                int nPoints = 11;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 11);
                colorPoly.m_BorderColor = Color.black;
                colorPoly.m_FillColor = Color.white;
                return colorPoly;
            }
        }
        this.logUnknownPolyForStyle(nPolygon, " for needle style ", 2);
        return null;
    }

    private GaugeCircularBase.ColorPolygon getNeedleStyle3(int nPolygon) {
        switch (nPolygon) {
            case 0: {
                int[] xPoints = new int[]{3832, 3108, 3108, 3832, 3832, 7798, 7798, 3832};
                int[] yPoints = new int[]{7718, 7959, 8040, 8281, 8281, 8281, 7718, 7718};
                int nPoints = 8;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 8);
                colorPoly.m_BorderColor = Color.white;
                colorPoly.m_FillColor = Color.white;
                return colorPoly;
            }
            case 1: {
                int[] xPoints = new int[]{3832, 3108, 1929, 1929, 3108, 3832, 3832, 7798, 7798, 3832, 7504, 3832, 3591, 3323, 3323, 3591, 3832, 7504, 7504};
                int[] yPoints = new int[]{7718, 7959, 7959, 8040, 8040, 8281, 8281, 8281, 7718, 7718, 8201, 8201, 8120, 8040, 7959, 7879, 7798, 7798, 8201};
                int nPoints = 19;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 19);
                colorPoly.m_BorderColor = new Color(22, 9, 99);
                colorPoly.m_FillColor = new Color(22, 9, 99);
                return colorPoly;
            }
        }
        this.logUnknownPolyForStyle(nPolygon, " for needle style ", 3);
        return null;
    }

    private GaugeCircularBase.ColorPolygon getNeedleStyle4(int nPolygon) {
        switch (nPolygon) {
            case 0: {
                int[] xPoints = new int[]{2385, 1447, 1447, 2385, 2385, 7745, 7745, 2385};
                int[] yPoints = new int[]{7611, 7932, 8067, 8388, 8388, 8388, 7611, 7611};
                int nPoints = 8;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 8);
                colorPoly.m_BorderColor = Color.black;
                colorPoly.m_FillColor = Color.black;
                return colorPoly;
            }
            case 1: {
                int[] xPoints = new int[]{2385, 1768, 1768, 2385, 2385, 7343, 7343, 2385};
                int[] yPoints = new int[]{7745, 7959, 8040, 8254, 8254, 8254, 7745, 7745};
                int nPoints = 8;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 8);
                colorPoly.m_BorderColor = new Color(173, 173, 173);
                colorPoly.m_FillColor = new Color(173, 173, 173);
                return colorPoly;
            }
            case 2: {
                int[] xPoints = new int[]{2465, 2465, 1661, 1661, 2465, 2465};
                int[] yPoints = new int[]{8254, 7745, 7959, 8040, 8254, 8254};
                int nPoints = 6;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 6);
                colorPoly.m_BorderColor = Color.white;
                colorPoly.m_FillColor = Color.white;
                return colorPoly;
            }
        }
        this.logUnknownPolyForStyle(nPolygon, " for needle style ", 4);
        return null;
    }

    private GaugeCircularBase.ColorPolygon getNeedleStyle5(int nPolygon) {
        switch (nPolygon) {
            case 0: {
                int[] xPoints = new int[]{700, 8000, 8000};
                int[] yPoints = new int[]{8100, 8100, 7900};
                int nPoints = 3;
                GaugeCircularBase.ColorPolygon colorPoly = new GaugeCircularBase.ColorPolygon();
                colorPoly.m_Polygon = new Polygon(xPoints, yPoints, 3);
                colorPoly.m_BorderColor = Color.black;
                colorPoly.m_FillColor = Color.black;
                return colorPoly;
            }
        }
        this.logUnknownPolyForStyle(nPolygon, " for needle style ", 5);
        return null;
    }

    private void logUnknownPolyForStyle(int nPolygon, String msg, int nStyle) {
    }
}

