/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.util.xml;

import com.businessobjects.visualization.internal.util.Cmp;
import com.businessobjects.visualization.util.xml.XmlEventType;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.util.xml.XmlValidationException;

public final class XmlReaderState {
    private final XmlReader reader;
    private final String elementName;
    private final int depth;

    public XmlReaderState(XmlReader reader) throws XmlValidationException {
        reader.require(XmlEventType.START_ELEMENT, null, null);
        this.reader = reader;
        this.elementName = reader.getName();
        this.depth = reader.getDepth();
    }

    public boolean isAtEndElement() {
        return this.reader.getDepth() == this.depth && this.reader.getEventType() == XmlEventType.END_ELEMENT && Cmp.equalsByReference(this.elementName, this.reader.getName());
    }

    public boolean isInChild() {
        return this.reader.getDepth() > this.depth;
    }

    public boolean isInElementOrChild() {
        return this.reader.getDepth() >= this.depth;
    }

    public boolean next() throws XmlException {
        if (!this.isInElementOrChild()) {
            return false;
        }
        this.reader.next();
        return this.isInChild();
    }
}

