/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.VisualizationEngine;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuRGBA;
import com.businessobjects.visualization.graphic.VisuTextureType;
import com.businessobjects.visualization.graphic.resource.GraphicResource;
import com.businessobjects.visualization.graphic.resource.GraphicResourceType;
import org.json.JSONException;
import org.json.JSONObject;

public class VisuTexture
extends VisuObject {
    private static final int[] PARAMSIZE = new int[]{2, 3};
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$graphic$VisuTexture == null ? (class$com$businessobjects$visualization$graphic$VisuTexture = VisuTexture.class$("com.businessobjects.visualization.graphic.VisuTexture")) : class$com$businessobjects$visualization$graphic$VisuTexture));
    private static VisuObjectType type = VisuObjectType.TEXTURE;
    private String resourceId_;
    private VisuTextureType textureType_;
    private VisuRGBA bgColor_ = new VisuRGBA(255, 255, 255, 0);
    static /* synthetic */ Class class$com$businessobjects$visualization$graphic$VisuTexture;

    public VisuTexture(String resourceId, VisuTextureType type) {
        this.resourceId_ = resourceId;
        this.textureType_ = type;
        this.checkRessources();
    }

    public VisuTexture(String resourceId, VisuTextureType type, VisuRGBA bgColor) {
        this(resourceId, type);
        this.bgColor_ = bgColor;
    }

    public VisuTexture(String xmlValue) {
        this.setXmlValue(xmlValue);
    }

    public String toString() {
        String s = "resource:" + this.resourceId_ + " type:" + this.textureType_ + " bgColor:" + this.bgColor_;
        return s;
    }

    public VisuObjectType getType() {
        return type;
    }

    public String getResourceId() {
        return this.resourceId_;
    }

    public GraphicResourceType getGraphicResourceType() {
        return GraphicResourceType.TEXTURE;
    }

    public VisuTextureType getTextureType() {
        return this.textureType_;
    }

    public VisuRGBA getBgColor() {
        return this.bgColor_;
    }

    protected void setXmlValue(String xmlValue) {
        this.setXmlValue(VisuTexture.stringToArray(xmlValue));
    }

    protected void setXmlValue(String[] values) {
        this.checkParams(values, PARAMSIZE);
        this.resourceId_ = values[0];
        this.textureType_ = VisuTextureType.fromString(values[1]);
        if (values.length == 3) {
            this.bgColor_ = new VisuRGBA(values[2]);
        }
    }

    protected String getXmlValue() {
        String xmlValue = this.resourceId_ + ";" + this.textureType_.value() + ";[" + this.bgColor_.getXmlValue() + "]";
        return xmlValue;
    }

    protected Object clone() {
        VisuTexture vt = (VisuTexture)super.clone();
        vt.textureType_ = this.textureType_;
        vt.bgColor_ = (VisuRGBA)this.bgColor_.clone();
        return vt;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof VisuTexture) {
            VisuTexture vt = (VisuTexture)obj;
            if (vt.resourceId_.equals(this.resourceId_) && vt.textureType_ == this.textureType_ && vt.bgColor_.equals(this.bgColor_)) {
                result = true;
            }
        }
        return result;
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected JSONObject getJSONObject() {
        try {
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("type", new Integer(type.value()));
            jsonObj.put("resource id", this.resourceId_);
            jsonObj.put("texture type", new Integer(this.textureType_.value()));
            jsonObj.put("bgcolor", this.bgColor_.getJSONObject());
            return jsonObj;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    VisuTexture(JSONObject jobj) {
        try {
            this.resourceId_ = jobj.getString("resource id");
            this.textureType_ = VisuTextureType.fromInt(jobj.getInt("texture type"));
            JSONObject bgcolorJson = jobj.getJSONObject("bgcolor");
            this.bgColor_ = (VisuRGBA)VisuObject.createFromJSON(bgcolorJson.toString());
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    private void checkRessources() {
        GraphicResource resource = VisualizationEngine.getInstance().getResources().getResource(GraphicResourceType.TEXTURE, this.resourceId_);
        if (null == resource) {
            LOGGER.warn((Object)("Missing ressource " + this.resourceId_ + " for GraphicResourceImage. Fill the correct resourceIb"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

