/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuColor;
import com.businessobjects.visualization.graphic.VisuColorZones;
import com.businessobjects.visualization.graphic.VisuDouble;
import com.businessobjects.visualization.graphic.VisuDynamicNode;
import com.businessobjects.visualization.graphic.VisuFont;
import com.businessobjects.visualization.graphic.VisuFormula;
import com.businessobjects.visualization.graphic.VisuGradient;
import com.businessobjects.visualization.graphic.VisuInteger;
import com.businessobjects.visualization.graphic.VisuObjectReference;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuRGBA;
import com.businessobjects.visualization.graphic.VisuState;
import com.businessobjects.visualization.graphic.VisuString;
import com.businessobjects.visualization.graphic.VisuTexture;
import com.businessobjects.visualization.graphic.VisuValueType;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class VisuObject
implements Cloneable {
    private VisuValueType visuValueType_ = VisuValueType.NONE;

    void setVisuValueType(VisuValueType visuValueType) {
        this.visuValueType_ = visuValueType;
    }

    protected abstract void setXmlValue(String var1);

    protected abstract String getXmlValue();

    public String toJSON() {
        JSONObject jobj = this.getJSONObject();
        return jobj != null ? jobj.toString() : null;
    }

    protected abstract JSONObject getJSONObject();

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new VisualizationInternalException(e);
        }
    }

    protected boolean checkValidity(Object param) {
        return true;
    }

    protected VisuObject cloneAsPartial(VisuObject defaultValue) {
        throw new VisualizationRuntimeException("VIZ_00053_ERR_NOT_SUPPORTED_FOR_TH");
    }

    protected boolean isPartial() {
        return false;
    }

    public abstract String toString();

    public abstract VisuObjectType getType();

    public abstract boolean equals(Object var1);

    public int hashCode() {
        return super.hashCode();
    }

    public VisuValueType getValueType() {
        return this.visuValueType_;
    }

    final void checkParams(String[] params, int size) {
        if (params == null) {
            throw new VisualizationRuntimeException("VIZ_00031_ERR_VISUOBJECT__PARAMS_A");
        }
        if (params.length != size) {
            throw new VisualizationRuntimeException("VIZ_00009_ERR_VISUOBJECT_CAN_NOT_B", new Object[]{String.valueOf(params.length)});
        }
    }

    final void checkParams(String[] params, int[] sizes) {
        if (params == null) {
            throw new VisualizationRuntimeException("VIZ_00031_ERR_VISUOBJECT__PARAMS_A");
        }
        boolean valid = false;
        for (int i = 0; i < sizes.length; ++i) {
            if (params.length != sizes[i]) continue;
            valid = true;
        }
        if (!valid) {
            throw new VisualizationRuntimeException("VIZ_00009_ERR_VISUOBJECT_CAN_NOT_B", new Object[]{String.valueOf(params.length)});
        }
    }

    final VisuObject cloneAs(VisuValueType b) {
        VisuObject result = (VisuObject)this.clone();
        result.visuValueType_ = b;
        return result;
    }

    public static VisuObject create(int type, String xmlvalue) {
        VisuObject result = null;
        switch (type) {
            case 0: {
                result = new VisuBool(xmlvalue);
                break;
            }
            case 1: {
                result = new VisuInteger(xmlvalue);
                break;
            }
            case 2: {
                result = new VisuDouble(xmlvalue);
                break;
            }
            case 3: {
                result = new VisuString(xmlvalue);
                break;
            }
            case 4: {
                result = new VisuFont(xmlvalue);
                break;
            }
            case 5: {
                result = new VisuColor(xmlvalue);
                break;
            }
            case 7: {
                result = new VisuFormula(xmlvalue);
                break;
            }
            case 8: {
                result = new VisuTexture(xmlvalue);
                break;
            }
            case 6: {
                result = new VisuState(xmlvalue);
                break;
            }
            case 9: {
                result = new VisuRGBA(xmlvalue);
                break;
            }
            case 10: {
                result = new VisuGradient(xmlvalue);
                break;
            }
            case 11: {
                result = new VisuObjectReference(xmlvalue);
                break;
            }
            case 12: {
                result = new VisuDynamicNode(xmlvalue);
                break;
            }
            case 13: {
                result = new VisuColorZones(xmlvalue);
                break;
            }
            default: {
                throw new VisualizationRuntimeException("VIZ_00127_ERR_UNEXPECTED_VISUOBJEC", new Object[]{new Integer(type)});
            }
        }
        return result;
    }

    public static VisuObject createFromJSON(String jsonString) {
        try {
            JSONObject jobj = new JSONObject(jsonString);
            int type = jobj.getInt("type");
            VisuObject result = null;
            switch (type) {
                case 0: {
                    result = new VisuBool(jobj);
                    break;
                }
                case 1: {
                    result = new VisuInteger(jobj);
                    break;
                }
                case 2: {
                    result = new VisuDouble(jobj);
                    break;
                }
                case 3: {
                    result = new VisuString(jobj);
                    break;
                }
                case 4: {
                    result = new VisuFont(jobj);
                    break;
                }
                case 5: {
                    result = new VisuColor(jobj);
                    break;
                }
                case 7: {
                    result = new VisuFormula(jobj);
                    break;
                }
                case 8: {
                    result = new VisuTexture(jobj);
                    break;
                }
                case 6: {
                    result = new VisuState(jobj);
                    break;
                }
                case 9: {
                    result = new VisuRGBA(jobj);
                    break;
                }
                case 10: {
                    result = new VisuGradient(jobj);
                    break;
                }
                case 11: {
                    result = new VisuObjectReference(jobj);
                    break;
                }
                case 13: {
                    result = new VisuColorZones(jobj);
                    break;
                }
                default: {
                    throw new VisualizationInternalException("Unexpected VisuObjecttype :" + type);
                }
            }
            return result;
        }
        catch (JSONException jex) {
            throw new VisualizationInternalException(jex);
        }
    }

    static VisuObject create(int type) {
        VisuObject result = null;
        switch (type) {
            case 0: {
                result = VisuBool.FALSE;
                break;
            }
            case 1: {
                result = new VisuInteger(0);
                break;
            }
            case 2: {
                result = new VisuDouble(0.0);
                break;
            }
            case 3: {
                result = new VisuString("");
                break;
            }
            case 4: {
                result = new VisuFont("Arial", 10.0, 0, new VisuRGBA(255, 255, 255, 0));
                break;
            }
            case 5: {
                result = new VisuColor(new VisuRGBA(255, 255, 255, 0));
                break;
            }
            case 7: {
                result = null;
                break;
            }
            case 8: {
                result = null;
                break;
            }
            case 6: {
                result = null;
                break;
            }
            case 9: {
                result = new VisuRGBA(255, 255, 255, 0);
                break;
            }
            case 10: {
                result = new VisuGradient(new VisuRGBA(255, 255, 255, 0), new VisuRGBA(0, 0, 0, 0));
                break;
            }
            case 12: {
                result = new VisuDynamicNode(0);
                break;
            }
            case 13: {
                result = new VisuColorZones(true, new double[]{0.0, 33.0, 67.0, 100.0}, new VisuColor[]{VisuColor.RED, VisuColor.BLACK, VisuColor.GREEN});
                break;
            }
            default: {
                throw new VisualizationRuntimeException("VIZ_00127_ERR_UNEXPECTED_VISUOBJEC", new Object[]{new Integer(type)});
            }
        }
        if (result != null) {
            result.visuValueType_ = VisuValueType.DEFAULT;
        }
        return result;
    }

    static String[] stringToArray(String stringValue) {
        if (stringValue == null) {
            throw new NullPointerException("stringValue");
        }
        if (stringValue.length() == 0) {
            return null;
        }
        int crochetCounter = 0;
        char del = ';';
        char crochetStart = '[';
        char crochetEnd = ']';
        String[] result = null;
        ArrayList<String> list = new ArrayList<String>();
        int max = stringValue.length();
        int istart = 0;
        int idel = -1;
        int ibo = -1;
        int ibc = -1;
        if (stringValue.charAt(0) == del || stringValue.charAt(max - 1) == del) {
            throw new VisualizationInternalException("invalid string first and last char can not be semi colon:" + stringValue);
        }
        for (int i = 0; i < max; ++i) {
            String sub;
            char car = stringValue.charAt(i);
            if (car == crochetStart) {
                if (crochetCounter == 0) {
                    ibo = i;
                }
                ++crochetCounter;
            } else if (car == crochetEnd) {
                if (--crochetCounter == 0) {
                    ibc = i;
                }
            } else if (car == del && crochetCounter == 0) {
                idel = i;
                sub = null;
                sub = ibo == istart && idel == ibc + 1 ? stringValue.substring(ibo + 1, ibc) : stringValue.substring(istart, idel);
                list.add(sub);
                istart = idel + 1;
            }
            if (i != max - 1) continue;
            if (crochetCounter != 0) {
                throw new VisualizationInternalException("square bracket counter should be zero:" + stringValue);
            }
            sub = null;
            sub = ibo == istart && max == ibc + 1 ? stringValue.substring(ibo + 1, ibc) : stringValue.substring(istart, max);
            list.add(sub);
        }
        result = new String[list.size()];
        list.toArray(result);
        return result;
    }
}

