/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuValueType;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLDefaultValue;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLDefaultValues;
import java.util.HashMap;
import java.util.Iterator;

class VisuDefaultValues
implements IXMLDelegator {
    private HashMap defaultValue_ = new HashMap();

    VisuDefaultValues() {
    }

    public void setValue(VisuObject vo) {
        if (vo == null) {
            throw new VisualizationRuntimeException("VIZ_00049_ERR_VISUOBJECT_IS_NULL");
        }
        if (vo.isPartial()) {
            throw new VisualizationRuntimeException("VIZ_00050_ERR_DEFAULTVALUE_HAVE_TO");
        }
        VisuObjectType vot = vo.getType();
        VisuObject newVo = vo.cloneAs(VisuValueType.DEFAULT);
        this.defaultValue_.put(vot, newVo);
    }

    public VisuObject getValue(VisuObjectType vot) {
        VisuObject vo = (VisuObject)this.defaultValue_.get(vot);
        if (vo == null) {
            vo = VisuObject.create(vot.value());
            this.defaultValue_.put(vot, vo);
        }
        return vo;
    }

    public VisuObject getValueFromPartial(VisuObject vo) {
        VisuObject result = null;
        if (vo == null) {
            throw new VisualizationRuntimeException("VIZ_00049_ERR_VISUOBJECT_IS_NULL");
        }
        if (!vo.isPartial()) {
            throw new VisualizationRuntimeException("VIZ_00051_ERR_VISUOBJECT_HAVE_TO_B");
        }
        VisuObject voDefault = this.getValue(vo.getType());
        result = vo.cloneAsPartial(voDefault);
        return result;
    }

    public Object getXMLDelegate() {
        XMLDefaultValues xdvs = new XMLDefaultValues();
        Iterator iter = this.defaultValue_.values().iterator();
        while (iter.hasNext()) {
            VisuObject vo = (VisuObject)iter.next();
            if (vo == null) continue;
            XMLDefaultValue xdv = new XMLDefaultValue();
            xdv.m_a_type = vo.getType().value();
            xdv.m_a_value = vo.getXmlValue();
            xdvs.m_list_DefaultValue.add(xdv);
        }
        return xdvs;
    }

    void init(XMLDefaultValues defaultValues) {
        if (defaultValues != null && defaultValues.m_list_DefaultValue != null) {
            for (int i = 0; i < defaultValues.m_list_DefaultValue.size(); ++i) {
                XMLDefaultValue xdv = (XMLDefaultValue)defaultValues.m_list_DefaultValue.get(i);
                VisuObject vo = VisuObject.create(xdv.m_a_type, xdv.m_a_value);
                this.setValue(vo);
            }
        }
    }
}

