/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;

public final class VisuColorType {
    public static final int I_ARGB = 0;
    public static final int I_GRADIENT = 1;
    public static final int I_TEXTURE = 2;
    public static final int I_TRANSPARENCY = 3;
    private static final String[] SVALUES = new String[]{"ARGB", "GRADIENT", "TEXTURE", "TRANSPARENCY"};
    public static final VisuColorType RGBA = new VisuColorType(0);
    public static final VisuColorType GRADIENT = new VisuColorType(1);
    public static final VisuColorType TEXTURE = new VisuColorType(2);
    public static final VisuColorType TRANSPARENCY = new VisuColorType(3);
    private final int val_;

    private VisuColorType(int value) {
        this.val_ = value;
    }

    public int value() {
        return this.val_;
    }

    public String toString() {
        return SVALUES[this.val_];
    }

    static VisuColorType fromString(String string) {
        int type = 0;
        try {
            type = Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            throw new VisualizationRuntimeException("VIZ_00118_ERR_INVALID_STRING_TO_IN", new Object[]{string});
        }
        return VisuColorType.fromInt(type);
    }

    static VisuColorType fromInt(int type) {
        VisuColorType colorType = null;
        switch (type) {
            case 0: {
                colorType = RGBA;
                break;
            }
            case 1: {
                colorType = GRADIENT;
                break;
            }
            case 2: {
                colorType = TEXTURE;
                break;
            }
            case 3: {
                colorType = TRANSPARENCY;
                break;
            }
            default: {
                throw new VisualizationRuntimeException("VIZ_00119_ERR_INVALID_TYPE_TO_INIT", new Object[]{new Integer(type)});
            }
        }
        return colorType;
    }
}

