/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.visualization.graphic.IProperty;
import com.businessobjects.visualization.graphic.Property;
import com.businessobjects.visualization.graphic.PropertyDef;
import com.businessobjects.visualization.graphic.PropertyDefVisibilityType;
import com.businessobjects.visualization.graphic.SettingsTree;
import com.businessobjects.visualization.graphic.VisuBool;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuState;

public class PropertyTree
extends SettingsTree {
    private Property property_;

    PropertyTree(Property property, SettingsTree parent, PropertyDefVisibilityType visibility) {
        super(property.getPropertyDef(), parent, property.getPropertyValue(), visibility);
        this.property_ = property;
        this.updateChilds();
    }

    public void update() {
        this.updateValue(this.property_.getPropertyValue());
        this.cleanChilds();
        this.updateChilds();
    }

    private void updateChilds() {
        VisuObject val = this.getValue();
        IProperty[] props = null;
        if (val.getType() == VisuObjectType.STATE) {
            VisuState vs = (VisuState)val;
            PropertyDef[] subProps = ((PropertyDef)this.getDefinition()).getProperties(vs.getId());
            props = new IProperty[subProps.length];
            for (int i = 0; i < subProps.length; ++i) {
                props[i] = this.property_.getProperty(subProps[i].getId());
            }
        } else if (val.getType() == VisuObjectType.BOOL) {
            VisuBool vb = (VisuBool)val;
            if (vb.equals(VisuBool.TRUE)) {
                props = this.property_.getProperties();
            }
        } else {
            props = this.property_.getProperties();
        }
        this.addChild(props, this.getVisibility());
    }

    private void addChild(IProperty[] properties, PropertyDefVisibilityType visibility) {
        if (properties == null) {
            return;
        }
        for (int i = 0; i < properties.length; ++i) {
            IProperty property = properties[i];
            if (!property.getPropertyDef().containsChildWithVisibility(visibility) && property.getPropertyDef().getVisibility() != visibility) continue;
            PropertyTree child = new PropertyTree((Property)property, this, visibility);
            this.getChildVector().add(child);
        }
    }

    public IProperty getProperty() {
        return this.property_;
    }
}

