/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.IXMLDelegator;
import com.businessobjects.visualization.common.internal.VisuVersion;
import com.businessobjects.visualization.graphic.Graphic;
import com.businessobjects.visualization.graphic.IGraphicDefNode;
import com.businessobjects.visualization.graphic.IGraphicNode;
import com.businessobjects.visualization.graphic.IProperty;
import com.businessobjects.visualization.graphic.PropertyDef;
import com.businessobjects.visualization.graphic.PropertyDefVisibilityType;
import com.businessobjects.visualization.graphic.PropertyState;
import com.businessobjects.visualization.graphic.PropertyTree;
import com.businessobjects.visualization.graphic.Region;
import com.businessobjects.visualization.graphic.RegionPropertyBase;
import com.businessobjects.visualization.graphic.SettingsTree;
import com.businessobjects.visualization.graphic.VisuDynamicNode;
import com.businessobjects.visualization.graphic.VisuObject;
import com.businessobjects.visualization.graphic.VisuObjectReference;
import com.businessobjects.visualization.graphic.VisuObjectType;
import com.businessobjects.visualization.graphic.VisuSerializationMode;
import com.businessobjects.visualization.graphic.VisuTemplate;
import com.businessobjects.visualization.graphic.VisuTemplateType;
import com.businessobjects.visualization.graphic.VisuValueType;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLGraphic;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLProperty;
import com.businessobjects.visualization.graphic.xml.settings.generated.XMLRegion;
import com.businessobjects.visualization.util.xml.XmlException;
import com.businessobjects.visualization.util.xml.XmlReader;
import com.businessobjects.visualization.util.xml.XmlWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;

public class Property
extends RegionPropertyBase
implements IXMLDelegator,
IProperty {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$graphic$Property == null ? (class$com$businessobjects$visualization$graphic$Property = Property.class$("com.businessobjects.visualization.graphic.Property")) : class$com$businessobjects$visualization$graphic$Property));
    static /* synthetic */ Class class$com$businessobjects$visualization$graphic$Property;

    Property(IGraphicNode parent, PropertyDef pdef, int index, Graphic graphic) {
        super(graphic, parent, pdef, index);
        this.initChildrenMap(null, pdef.getProperties());
        VisuObject defVal = pdef.getDefaultValue();
        if (defVal == null || defVal.checkValidity(pdef.getParameter())) {
            this.setValue(defVal);
        }
        this.initProperties();
    }

    public void setPropertyValue(VisuObject value) {
        if (this.getPropertyDef().getVisibility() == PropertyDefVisibilityType.READONLY) {
            LOGGER.info((Object)("Property:" + this.getPropertyDef().getId() + " is read only, value can not be set"));
            return;
        }
        if (value == null || value.getType() == VisuObjectType.REFERENCE) {
            this.setValue(value);
            this.updateDynamicProperty();
            this.notifyPropertyChange(null, this.getPropertyDef(), this.getPropertyValue());
        } else if (value.getType() == this.getPropertyDef().getType()) {
            Object param = this.getPropertyDef().getParameter();
            value.checkValidity(param);
            VisuObject value2save = value;
            if (value.getValueType() != VisuValueType.NONE) {
                value2save = value.cloneAs(VisuValueType.NONE);
            }
            VisuObject previousValue = this.getInternalValue();
            this.setValue(value2save);
            this.updateDynamicProperty();
            if (!value2save.equals(previousValue)) {
                this.notifyPropertyChange(null, this.getPropertyDef(), value2save);
            }
        } else {
            throw new VisualizationInternalException("Invalid VisuObject type " + value.getType() + " PropertyId:" + this.getId());
        }
    }

    private void updateDynamicProperty() {
        if (this.getPropertyDef().getType() == VisuObjectType.DYNAMICNODE) {
            ArrayList stateList = this.getPropertyDef().getStateList();
            if (stateList.size() != 2) {
                throw new VisualizationInternalException("Invalid Dynamic property : statelist size is not 2 for property:" + this.getPropertyDef());
            }
            VisuDynamicNode vdn = (VisuDynamicNode)this.getPropertyValue();
            if (vdn.intValue() < 0) {
                this.removeAllElements();
            } else {
                PropertyState ps = (PropertyState)stateList.get(0);
                PropertyDef[] mandatoryList = this.getPropertyDef().getProperties(ps.getId());
                for (int i = 0; i < mandatoryList.length; ++i) {
                    if (this.getChildrenWithDef(mandatoryList[i]).size() != 0) continue;
                    this.addProperty(mandatoryList[i], 0);
                }
                ps = (PropertyState)stateList.get(1);
                PropertyDef[] optionalList = this.getPropertyDef().getProperties(ps.getId());
                int nbOptionElt = vdn.intValue() <= 0 ? 0 : vdn.intValue();
                for (int j = 0; j < optionalList.length; ++j) {
                    int i;
                    ArrayList list = this.getChildrenWithDef(optionalList[j]);
                    int currentSize = list.size();
                    if (currentSize > nbOptionElt) {
                        int size2Supp = currentSize - nbOptionElt;
                        for (i = 0; i < size2Supp; ++i) {
                            this.removeElement(optionalList[j], currentSize - i);
                        }
                        continue;
                    }
                    if (currentSize >= nbOptionElt) continue;
                    int size2Add = nbOptionElt - currentSize;
                    for (i = 1; i <= size2Add; ++i) {
                        this.addChild(optionalList[j], currentSize + i);
                    }
                }
            }
        }
    }

    public final VisuObject getPropertyValue() {
        VisuObject vo = this.getInternalValue();
        if (vo == null) {
            PropertyDef pdef = this.getPropertyDef();
            VisuObjectType vot = pdef.getType();
            vo = this.getGraphic().getObjectManager().getDefaultValue(vot);
            if (vo == null) {
                vo = pdef.getDefaultValue();
            }
            if (vo == null) {
                vo = pdef.getValidValue();
            }
        } else if (vo.getType() == VisuObjectType.REFERENCE) {
            VisuObjectReference vr = (VisuObjectReference)vo;
            vo = this.getGraphic().getObjectManager().getCustomValue(vr.getKey(), vr.getReferenceType());
        } else if (vo.isPartial()) {
            vo = this.getGraphic().getObjectManager().getValueFromPartial(vo);
        }
        return vo;
    }

    public SettingsTree getTree(PropertyDefVisibilityType visibility) {
        PropertyTree result = null;
        if (this.getPropertyDef().getVisibility() == visibility || this.getPropertyDef().containsChildWithVisibility(visibility)) {
            result = new PropertyTree(this, this.getParent().getTree(visibility), visibility);
        }
        return result;
    }

    public Object getXMLDelegate() {
        return this.getXMLDelegate(VisuSerializationMode.SERIALIZATION);
    }

    public XMLProperty getXMLDelegate(VisuSerializationMode mode) {
        XMLProperty xp = new XMLProperty();
        xp.m_a_Id = this.getDef().getId();
        xp.m_a_Index = this.getIndex();
        xp.m_a_Type = this.getPropertyDef().getType().value();
        VisuObject vo = this.getInternalValue();
        xp.m_Value = vo == null ? null : vo.getXmlValue();
        Iterator iter = this.getChildren(IGraphicDefNode.GraphicDefNodeType.PROPERTY).iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            xp.m_list_Property.add(property.getXMLDelegate(mode));
        }
        return xp;
    }

    public void getXMLDelegateEX(ArrayList propertiesList) {
        XMLProperty xp = new XMLProperty();
        xp.m_a_Id = this.getDef().getId();
        xp.m_a_Index = this.getIndex();
        xp.m_a_Type = this.getPropertyDef().getType().value();
        VisuObject vo = this.getInternalValue();
        xp.m_Value = vo == null ? null : vo.getXmlValue();
        propertiesList.add(xp);
        Iterator iter = this.getChildren(IGraphicDefNode.GraphicDefNodeType.PROPERTY).iterator();
        while (iter.hasNext()) {
            Property property = (Property)iter.next();
            property.getXMLDelegateEX(propertiesList);
        }
    }

    public void initFromTemplate(Reader reader) {
        try {
            XmlReader xr = new XmlReader(reader);
            VisuTemplate vt = new VisuTemplate();
            vt.unmarshall(xr);
            this.initFromTemplate(vt);
        }
        catch (XmlException xe) {
            throw new VisualizationInternalException(xe);
        }
    }

    public void initFromTemplate(VisuTemplate visuTemplate) {
        if (visuTemplate == null) {
            throw new VisualizationRuntimeException("VIZ_00034_ERR_TEMPLATE_IS_NULL");
        }
        if (visuTemplate.getType() != VisuTemplateType.PROPERTY) {
            throw new VisualizationRuntimeException("VIZ_00092_ERR_INVALID_TEMPLATE_TYP", new Object[]{visuTemplate.getType()});
        }
        if (visuTemplate.getXmlGraphic() == null || visuTemplate.getXmlGraphic().m_list_Region == null || visuTemplate.getXmlGraphic().m_list_Region.size() != 1 || ((XMLRegion)visuTemplate.getXmlGraphic().m_list_Region.get((int)0)).m_list_Property == null || ((XMLRegion)visuTemplate.getXmlGraphic().m_list_Region.get((int)0)).m_list_Property.size() != 1) {
            throw new VisualizationRuntimeException("VIZ_00039_ERR_INVALID_VISUTEMPLATE");
        }
        XMLProperty xp = (XMLProperty)((XMLRegion)visuTemplate.getXmlGraphic().m_list_Region.get((int)0)).m_list_Property.get(0);
        this.init(xp, VisuSerializationMode.TEMPLATE, visuTemplate.getVersion());
    }

    public void notifyPropertyChange(Region region, PropertyDef pdef, VisuObject vo) {
        this.getParent().notifyPropertyChange(region, pdef, vo);
    }

    public void saveAsTemplate(Writer writer) {
        try {
            VisuTemplate vt = this.saveAsTemplate("", "");
            XmlWriter xw = new XmlWriter(writer, Charset.forName("UTF-8"));
            vt.marshall(xw);
        }
        catch (XmlException xe) {
            throw new VisualizationInternalException(xe);
        }
    }

    public VisuTemplate saveAsTemplate(String id, String name) {
        XMLGraphic xg = new XMLGraphic();
        XMLRegion xr = new XMLRegion();
        XMLProperty xp = new XMLProperty();
        xp = this.getXMLDelegate(VisuSerializationMode.TEMPLATE);
        xg.m_list_Region.add(xr);
        xr.m_list_Property.add(xp);
        VisuTemplate vt = new VisuTemplate(id, name, this.getGraphic().getVisuVersionManager().getCurrentVersion(), VisuTemplateType.PROPERTY, xg);
        return vt;
    }

    public PropertyDef getPropertyDef() {
        return (PropertyDef)this.getDef();
    }

    private void initProperties() {
        if (this.getPropertyDef().getType() == VisuObjectType.DYNAMICNODE) {
            this.updateDynamicProperty();
        } else {
            PropertyDef[] list = this.getPropertyDef().getProperties();
            for (int i = 0; i < list.length; ++i) {
                this.addProperty(list[i], -1);
            }
        }
    }

    void init(XMLProperty xp, VisuSerializationMode mode, VisuVersion serializedVersion) {
        VisuObjectType typeDef = this.getPropertyDef().getType();
        if (typeDef.value() == xp.m_a_Type) {
            if (xp.m_Value == null) {
                this.setPropertyValue(null);
            } else {
                VisuObject vo = VisuObject.create(xp.m_a_Type, xp.m_Value);
                this.setPropertyValue(vo);
            }
        } else if (mode == VisuSerializationMode.FULLCHECK) {
            throw new VisualizationInternalException("unexpected type :" + typeDef + " for prop id:" + this.getId());
        }
        Iterator iter = xp.m_list_Property.iterator();
        while (iter.hasNext()) {
            XMLProperty nestedXp = (XMLProperty)iter.next();
            String currentId = this.getGraphic().getVisuVersionManager().getCurrentPropertyId(serializedVersion.getXmlVersion(), this.getDef().getRootParent().getRootParent().getUid(), this.getDef().getRootParent().getId(), nestedXp.m_a_Id);
            Property property = (Property)this.getNode(currentId, nestedXp.m_a_Index, IGraphicDefNode.GraphicDefNodeType.PROPERTY);
            if (property != null) {
                boolean exclude = false;
                if (mode == VisuSerializationMode.TEMPLATE && exclude) continue;
                property.init(nestedXp, mode, serializedVersion);
                continue;
            }
            if (mode != VisuSerializationMode.FULLCHECK) continue;
            throw new VisualizationInternalException("unexpected property id :" + currentId);
        }
    }

    public void restoreDefaultSettings() {
        this.setPropertyValue(this.getPropertyDef().getDefaultValue());
        ArrayList properties = this.getChildren(IGraphicDefNode.GraphicDefNodeType.PROPERTY);
        Iterator iter = properties.iterator();
        while (iter.hasNext()) {
            Property base = (Property)iter.next();
            base.restoreDefaultSettings();
        }
    }

    public IProperty getChild(PropertyDef pdef, int index) {
        return (Property)super.getChild(pdef, index);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

