/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.graphic;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.VisualizationEngine;
import com.businessobjects.visualization.common.exceptions.VisualizationInternalException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.graphic.VisuColor;
import com.businessobjects.visualization.graphic.resource.GraphicResource;
import com.businessobjects.visualization.graphic.resource.GraphicResourcePalette;
import com.businessobjects.visualization.graphic.resource.GraphicResourceType;

public class Palette
implements Cloneable {
    public static final int MAXSIZE = 256;
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$graphic$Palette == null ? (class$com$businessobjects$visualization$graphic$Palette = Palette.class$("com.businessobjects.visualization.graphic.Palette")) : class$com$businessobjects$visualization$graphic$Palette));
    static final Palette DEFAULT_PALETTE = new Palette("[0;[58;101;152;0]];[0;[239;162;82;0]];[0;[0;148;112;0]];[0;[221;88;31;0]];[0;[162;45;98;0]];[0;[254;206;96;0]];[0;[39;117;139;0]];[0;[218;112;98;0]];[0;[68;119;17;0]];[0;[200;39;89;0]];[0;[93;7;156;0]];[0;[227;214;60;0]];[0;[218;164;200;0]];[0;[51;129;204;0]];[0;[241;194;131;0]];[0;[164;119;52;0]];[0;[146;186;227;0]];[0;[182;61;50;0]];[0;[52;206;145;0]];[0;[255;122;89;0]];[0;[192;89;160;0]];[0;[131;241;160;0]];[0;[56;179;184;0]];[0;[236;178;137;0]];[0;[165;67;56;0]];[0;[146;209;227;0]];[0;[134;27;54;0]];[0;[161;187;98;0]];[0;[236;137;168;0]];[0;[143;60;204;0]];[0;[193;236;116;0]];[0;[183;164;212;0]]");
    private int freeIndex_;
    private String resourceId_ = null;
    private VisuColor[] colorList_ = new VisuColor[256];
    static /* synthetic */ Class class$com$businessobjects$visualization$graphic$Palette;

    public Palette() {
    }

    public Palette(GraphicResourceType type, String resourceId) {
        if (type != GraphicResourceType.PALETTE) {
            throw new VisualizationRuntimeException("VIZ_00122_ERR_INVALID_DEFAULTVALUE", new Object[]{type});
        }
        this.setResourceId(resourceId);
    }

    public Palette(String xmlValue) {
        this.setXmlValue(xmlValue);
    }

    public int getSize() {
        return this.freeIndex_;
    }

    public String toString() {
        String s = "Palette of 256 colors";
        return s;
    }

    public VisuColor getColor(int index) {
        VisuColor vc = null;
        if (index >= 0) {
            vc = (VisuColor)this.colorList_[index % this.freeIndex_].clone();
        }
        return vc;
    }

    public int addColor(VisuColor color) {
        if (color == null) {
            throw new VisualizationRuntimeException("VIZ_00040_ERR_VISUCOLOR_IS_NULL");
        }
        if (this.freeIndex_ >= 256) {
            throw new VisualizationRuntimeException("VIZ_00041_ERR_PALETTE_IS_FULL");
        }
        this.colorList_[this.freeIndex_] = (VisuColor)color.clone();
        int result = this.freeIndex_++;
        return result;
    }

    public void setColor(int index, VisuColor color) {
        if (color == null) {
            throw new VisualizationRuntimeException("VIZ_00040_ERR_VISUCOLOR_IS_NULL");
        }
        if (index >= this.freeIndex_) {
            throw new VisualizationRuntimeException("VIZ_00097_ERR_INVALID_PALETTE_INDE", new Object[]{new Integer(index)});
        }
        this.colorList_[index] = (VisuColor)color.clone();
    }

    public void setResourceId(String resourceId) {
        this.resourceId_ = resourceId;
        GraphicResource resource = VisualizationEngine.getInstance().getResources().getResource(GraphicResourceType.PALETTE, resourceId);
        if (resource != null) {
            Palette palette = ((GraphicResourcePalette)resource).getPalette();
            for (int i = 0; i < 256; ++i) {
                this.addColor(palette.getColor(i));
            }
        } else {
            LOGGER.warn((Object)("Missing ressource " + resourceId + " for GraphicResourcePalette. Using default palette."));
            for (int i = 0; i < 256; ++i) {
                this.addColor(DEFAULT_PALETTE.getColor(i));
            }
        }
    }

    protected void setXmlValue(String xmlValue) {
        this.setXmlValue(VisuColor.stringToArray(xmlValue));
    }

    protected String getXmlValue() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.freeIndex_; ++i) {
            sb.append("[");
            VisuColor vc = this.colorList_[i];
            sb.append(vc.getXmlValue());
            sb.append("]");
            if (i == this.freeIndex_ - 1) continue;
            sb.append(";");
        }
        return sb.toString();
    }

    protected Object clone() {
        Palette clone = null;
        try {
            clone = (Palette)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new VisualizationInternalException(e);
        }
        clone.colorList_ = new VisuColor[256];
        for (int i = 0; i < this.freeIndex_; ++i) {
            VisuColor vcClone;
            clone.colorList_[i] = vcClone = (VisuColor)this.colorList_[i].clone();
        }
        return clone;
    }

    private void setXmlValue(String[] values) {
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                VisuColor vc = new VisuColor(values[i]);
                this.addColor(vc);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

