/*
 * Decompiled with CFR 0.152.
 */
package com.businessobjects.visualization.feed;

import com.businessobjects.foundation.logging.ILogger;
import com.businessobjects.foundation.logging.LoggerManager;
import com.businessobjects.visualization.common.exceptions.NotImplementedException;
import com.businessobjects.visualization.common.exceptions.VisualizationRuntimeException;
import com.businessobjects.visualization.common.internal.SerializationHelper;
import com.businessobjects.visualization.dataexchange.definition.AnalysisAxis;
import com.businessobjects.visualization.dataexchange.definition.DataContainer;
import com.businessobjects.visualization.dataexchange.definition.DataDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DatasetDescriptor;
import com.businessobjects.visualization.dataexchange.definition.DimensionLabels;
import com.businessobjects.visualization.dataexchange.definition.FilterInfo;
import com.businessobjects.visualization.dataexchange.definition.MeasureValues;
import com.businessobjects.visualization.dataexchange.definition.MeasureValuesGroup;
import com.businessobjects.visualization.dataexchange.definition.SortInfo;
import com.businessobjects.visualization.feed.DataFeed;
import com.businessobjects.visualization.feed.Feed;
import com.businessobjects.visualization.feed.IFeedMediator;
import com.businessobjects.visualization.feed.definition.DataContainerType;
import com.businessobjects.visualization.feed.definition.DataFeedDefinition;
import com.businessobjects.visualization.feed.definition.FeedDef;
import com.businessobjects.visualization.feed.generated.XMLDataFeed;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;

public class Feeder
implements IFeedMediator {
    private static final ILogger LOGGER = LoggerManager.getLogger((Class)(class$com$businessobjects$visualization$feed$Feeder == null ? (class$com$businessobjects$visualization$feed$Feeder = Feeder.class$("com.businessobjects.visualization.feed.Feeder")) : class$com$businessobjects$visualization$feed$Feeder));
    private DataFeedDefinition dataFeedDef_;
    private DataFeed currentFeed_;
    private DataDescriptor currentDataDescriptor_;
    private IFeedMediator publicMediator_;
    private ArrayList unfeededDataContainers_;
    static /* synthetic */ Class class$com$businessobjects$visualization$feed$Feeder;

    public Feeder(DataFeedDefinition dataDef, IFeedMediator mediator) {
        this.dataFeedDef_ = dataDef;
        this.currentFeed_ = new DataFeed(this, dataDef);
        this.currentDataDescriptor_ = null;
        this.publicMediator_ = mediator;
    }

    public Feeder(DataFeedDefinition dataDef, DataDescriptor dd, IFeedMediator mediator, XMLDataFeed xmlDataFeedDefinition, SerializationHelper sh) {
        this(dataDef, mediator);
        this.currentFeed_ = new DataFeed(this, dataDef, dd, xmlDataFeedDefinition, sh);
        this.currentDataDescriptor_ = dd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feed attach(String feedDefId, DataContainer dc) {
        Feed feed = null;
        try {
            this.currentFeed_.setMediator(new BouchonMediator(this.publicMediator_));
            feed = this.currentFeed_.attach(feedDefId, dc);
            this.syncDescriptor();
        }
        finally {
            this.currentFeed_.setMediator(this);
        }
        if (feed != null) {
            this.notifyFeedAdded(feed);
        }
        return feed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Feed detach(String feedDefId, DataContainer dc) {
        Feed feed = null;
        try {
            this.currentFeed_.setMediator(new BouchonMediator(this.publicMediator_));
            feed = this.currentFeed_.detach(feedDefId, dc);
            this.syncDescriptor();
        }
        finally {
            this.currentFeed_.setMediator(this);
        }
        if (feed != null && feed.getDataContainers().length == 0) {
            this.notifyFeedRemoved(feed);
        }
        return feed;
    }

    private DataDescriptor normalize(DataFeed dataFeed, DataDescriptor originDataDescriptor, boolean useOrigin) {
        if (dataFeed == null) {
            return null;
        }
        DatasetDescriptor currentDataset = new DatasetDescriptor();
        TreeMap<String, AnalysisAxis> axesTable = new TreeMap<String, AnalysisAxis>();
        TreeMap<String, MeasureValuesGroup> measureGroupsTable = new TreeMap<String, MeasureValuesGroup>();
        DataDescriptor dd = new DataDescriptor();
        Iterator feedIter = dataFeed.getFeedsIterator();
        int origNbMvg = 0;
        if (useOrigin && originDataDescriptor != null) {
            origNbMvg = originDataDescriptor.getDatasetDescriptor().getValueGroupList().length;
        }
        while (feedIter.hasNext()) {
            Feed feed = (Feed)feedIter.next();
            DataContainer[] dcList = feed.getAllNestedDataContainers();
            for (int i = 0; i < dcList.length; ++i) {
                if (dcList[i].equals(DimensionLabels.MEASURENAMES_DIMENSION)) continue;
                if (dcList[i] instanceof DimensionLabels) {
                    AnalysisAxis currentAxis = null;
                    String axisID = feed.getFeedDef().getStructureId(DataContainerType.DIMENSIONSHIERARCHY);
                    if (axisID.equals("")) {
                        axisID = "ZZ";
                    }
                    if (!axesTable.containsKey(axisID)) {
                        currentAxis = new AnalysisAxis();
                        axesTable.put(axisID, currentAxis);
                    } else {
                        currentAxis = (AnalysisAxis)axesTable.get(axisID);
                    }
                    currentAxis.addDimensionLabels((DimensionLabels)dcList[i]);
                    continue;
                }
                MeasureValuesGroup currentMvg = null;
                String measureGroupID = feed.getFeedDef().getStructureId(DataContainerType.MEASUREVALUES);
                if (measureGroupID.equals("")) {
                    measureGroupID = "ZZ";
                }
                if (!measureGroupsTable.containsKey(measureGroupID)) {
                    currentMvg = new MeasureValuesGroup();
                    measureGroupsTable.put(measureGroupID, currentMvg);
                } else if (origNbMvg > 0 && measureGroupID.equals("ZZ") && measureGroupsTable.size() < origNbMvg) {
                    currentMvg = new MeasureValuesGroup();
                    measureGroupsTable.put(measureGroupID + i, currentMvg);
                } else {
                    currentMvg = (MeasureValuesGroup)measureGroupsTable.get(measureGroupID);
                }
                currentMvg.addMeasureValues((MeasureValues)dcList[i]);
            }
        }
        Iterator axesIterator = axesTable.keySet().iterator();
        while (axesIterator.hasNext()) {
            currentDataset.addAxis((AnalysisAxis)axesTable.get(axesIterator.next()));
        }
        Iterator mvgIterator = measureGroupsTable.keySet().iterator();
        while (mvgIterator.hasNext()) {
            int currentNbMvg;
            String measureGroupID = (String)mvgIterator.next();
            boolean bMergedGroups = false;
            if (measureGroupID.equals("ZZ") && (currentNbMvg = currentDataset.getValueGroupList().length) > 0 && (origNbMvg == 0 || origNbMvg > 0 && origNbMvg == currentNbMvg)) {
                bMergedGroups = true;
                MeasureValues[] notDefinedList = ((MeasureValuesGroup)measureGroupsTable.get(measureGroupID)).getMeasureValuesList();
                for (int i = 0; i < notDefinedList.length; ++i) {
                    currentDataset.getValueGroupList()[currentNbMvg - 1].addMeasureValues(notDefinedList[i]);
                }
            }
            if (bMergedGroups) continue;
            currentDataset.addValueGroup((MeasureValuesGroup)measureGroupsTable.get(measureGroupID));
        }
        dd.setDatasetDescriptor(currentDataset);
        if (originDataDescriptor != null) {
            Iterator iter = originDataDescriptor.getDatasetDescriptor().getSortInfoListIterator();
            while (iter.hasNext()) {
                dd.getDatasetDescriptor().addSortInfo((SortInfo)iter.next());
            }
            iter = originDataDescriptor.getDatasetDescriptor().getFilterInfoListIterator();
            while (iter.hasNext()) {
                dd.getDatasetDescriptor().addFilterInfo((FilterInfo)iter.next());
            }
        }
        return dd;
    }

    private void syncDescriptor() {
        if (this.currentFeed_ == null) {
            return;
        }
        DataDescriptor newDD = this.normalize(this.currentFeed_, this.currentDataDescriptor_, false);
        if (!newDD.equals(this.currentDataDescriptor_)) {
            this.currentDataDescriptor_ = newDD;
            this.publicMediator_.notifyDataDescriptorUpdated();
        }
    }

    public DataFeedDefinition getDataFeedDefinition() {
        return this.dataFeedDef_;
    }

    public DataFeed getCurrentDataFeed() {
        return this.currentFeed_;
    }

    public DataDescriptor getCurrentDataDescriptor() {
        return this.currentDataDescriptor_;
    }

    public void setDataDescriptor(DataDescriptor dd) {
        this.currentDataDescriptor_ = dd;
        this.unfeededDataContainers_ = this.currentFeed_.init(dd);
    }

    public boolean hasMinimumFeeds() {
        if (this.currentFeed_ == null || this.dataFeedDef_ == null) {
            return false;
        }
        FeedDef[] feedDefList = this.dataFeedDef_.getFullFeedDefList(false);
        for (int i = 0; i < feedDefList.length; ++i) {
            if (feedDefList[i].getMin() <= 0) continue;
            Feed[] feedList = this.currentFeed_.findByDefId(feedDefList[i].getId());
            if (feedList.length < feedDefList[i].getMin()) {
                return false;
            }
            int nCountDims = 0;
            int nCountMesNames = 0;
            int nCountMes = 0;
            for (int j = 0; j < feedList.length; ++j) {
                if (feedList[j].getDataContainerTypeName() == DataContainerType.DIMENSIONSHIERARCHY) {
                    ++nCountDims;
                    continue;
                }
                if (feedList[j].getDataContainerTypeName() == DataContainerType.MEASURENAMESDIMENSION) {
                    ++nCountMesNames;
                    continue;
                }
                ++nCountMes;
            }
            if (feedDefList[i].getMin(DataContainerType.DIMENSIONSHIERARCHY) > nCountDims) {
                return false;
            }
            if (feedDefList[i].getMin(DataContainerType.MEASURENAMESDIMENSION) > nCountMesNames) {
                return false;
            }
            if (feedDefList[i].getMin(DataContainerType.MEASUREVALUES) <= nCountMes) continue;
            return false;
        }
        return true;
    }

    public boolean hasExpectedFeeds() {
        if (this.currentFeed_ == null || this.dataFeedDef_ == null) {
            return false;
        }
        FeedDef[] feedDefList = this.dataFeedDef_.getFullFeedDefList(false);
        for (int i = 0; i < feedDefList.length; ++i) {
            Feed[] feedList;
            if (this.publicMediator_.getMinOccurence(feedDefList[i]) <= 0 || (feedList = this.currentFeed_.findByDefId(feedDefList[i].getId())).length >= this.publicMediator_.getMinOccurence(feedDefList[i])) continue;
            return false;
        }
        return true;
    }

    public static DataFeedDefinition[] getBestDataFeedDefinition(DataFeedDefinition[] dataSpecs, DataDescriptor dd) {
        throw new NotImplementedException();
    }

    public static DataFeed getDefaultDataFeedDefiniton(DataFeedDefinition dataSpec, DataDescriptor dd) {
        throw new NotImplementedException();
    }

    public static DataFeed changeGraph(DataFeedDefinition[] dataSpecs, DataFeedDefinition sourceSpec, DataFeedDefinition targetSpec, DataFeed sourceDataFeedDefiniton, DataDescriptor dd) {
        throw new NotImplementedException();
    }

    public void notifyFeedAdded(Feed feed) {
        this.publicMediator_.notifyFeedAdded(feed);
    }

    public void notifyFeedRemoved(Feed feed) {
        this.publicMediator_.notifyFeedRemoved(feed);
    }

    public void notifyFeedUpdated(Feed feed) {
        throw new NotImplementedException();
    }

    public void notifyDataDescriptorUpdated() {
        throw new NotImplementedException();
    }

    public boolean checkRestrictions(int nFeedCount, String feedDefId) {
        return this.publicMediator_.checkRestrictions(nFeedCount, feedDefId);
    }

    private boolean checkPreservesData(DataFeed feed) {
        HashMap<String, Integer> structCheckMap = new HashMap<String, Integer>();
        Feed[] feedList = feed.getFullFeedList(true);
        for (int i = 0; i < feedList.length; ++i) {
            DataContainer[] dcList = feedList[i].getDataContainers();
            for (int j = 0; j < dcList.length; ++j) {
                String structId = "";
                int structIndex = 0;
                if (dcList[j] instanceof DimensionLabels && !dcList[j].equals(DimensionLabels.MEASURENAMES_DIMENSION)) {
                    structId = feedList[i].getFeedDef().getStructureId(DataContainerType.DIMENSIONSHIERARCHY);
                    structIndex = this.currentDataDescriptor_.getDatasetDescriptor().getAxisIndex((DimensionLabels)dcList[j]);
                }
                if (structId.equals("")) continue;
                if (structCheckMap.containsKey(structId)) {
                    int checkStructId = (Integer)structCheckMap.get(structId);
                    if (checkStructId == structIndex) continue;
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug((Object)("checkPreservesData returns false, found(strucId:" + structId + ") =" + checkStructId + " instead of " + structIndex));
                    }
                    return false;
                }
                structCheckMap.put(structId, new Integer(structIndex));
            }
        }
        return true;
    }

    public void changeDefinition(DataFeedDefinition newDfs, boolean bPreserveData) {
        DataFeed newFeed = new DataFeed(new BouchonMediator(this.publicMediator_), newDfs);
        this.unfeededDataContainers_ = newFeed.init(this.currentDataDescriptor_);
        boolean bDataChanged = false;
        if (bPreserveData) {
            if (!this.checkPreservesData(newFeed)) {
                throw new VisualizationRuntimeException("VIZ_00084_ERR_CANNOT_FIND_FEED_TRA");
            }
        } else {
            DataDescriptor newDD = this.normalize(newFeed, this.currentDataDescriptor_, false);
            if (!newDD.equals(this.currentDataDescriptor_)) {
                bDataChanged = this.unfeededDataContainers_.size() <= 0 || !newDD.subsetOf(this.currentDataDescriptor_);
            }
            this.currentDataDescriptor_ = newDD;
        }
        newFeed.setMediator(this);
        this.currentFeed_ = newFeed;
        this.dataFeedDef_ = newDfs;
        if (bDataChanged) {
            this.publicMediator_.notifyDataDescriptorUpdated();
        }
    }

    public ArrayList getUnfeededDataContainers() {
        return this.unfeededDataContainers_;
    }

    public boolean hasUnfeededDataContainers() {
        if (this.unfeededDataContainers_ == null) {
            return false;
        }
        return this.unfeededDataContainers_.size() > 0;
    }

    public int getMaxOccurence(FeedDef feed) {
        return this.publicMediator_.getMaxOccurence(feed);
    }

    public int getMinOccurence(FeedDef feed) {
        return this.publicMediator_.getMinOccurence(feed);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class BouchonMediator
    implements IFeedMediator {
        private final IFeedMediator realMediator_;

        public BouchonMediator(IFeedMediator realMediator) {
            this.realMediator_ = realMediator;
        }

        public void notifyFeedAdded(Feed feed) {
        }

        public void notifyFeedRemoved(Feed feed) {
        }

        public void notifyFeedUpdated(Feed feed) {
        }

        public void notifyDataDescriptorUpdated() {
        }

        public boolean checkRestrictions(int nFeedCount, String feedDefId) {
            return this.realMediator_.checkRestrictions(nFeedCount, feedDefId);
        }

        public int getMaxOccurence(FeedDef feed) {
            return this.realMediator_.getMaxOccurence(feed);
        }

        public int getMinOccurence(FeedDef feed) {
            return this.realMediator_.getMinOccurence(feed);
        }
    }
}

